/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.lambdaexpression;

import com.sun.ts.tests.el.common.util.ELTestUtil;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.LambdaExpression;
import jakarta.el.StandardELContext;
import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void invokeNPETest() throws Exception {
        ArrayList<String> params = new ArrayList<String>();
        params.add("one");
        LambdaExpression le = new LambdaExpression(params, null);
        ELTestUtil.checkForNPE(le, "invoke", new Class[]{ELContext.class, Object[].class}, new Object[]{null, new Object[]{"one"}});
    }

    @Test
    public void invokeELETest() throws Exception {
        StringBuffer buff = new StringBuffer();
        boolean pass = false;
        ArrayList<String> params = new ArrayList<String>();
        params.add("one");
        LambdaExpression le = new LambdaExpression(params, null);
        try {
            le.invoke((ELContext)new StandardELContext(ExpressionFactory.newInstance()), new Object[0]);
            buff.append("Test FAILED No Exception thrown!" + ELTestUtil.NL + "Expected an ELException to be thrown!");
        }
        catch (ELException ele) {
            logger.log(System.Logger.Level.INFO, "Test PASSED");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Test FAILED" + ELTestUtil.NL + "Expected: ELException" + ELTestUtil.NL + "Received: " + e.getClass().getSimpleName());
        }
        if (!pass) {
            throw new Exception("Test FAILED");
        }
    }
}

