/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.common.elcontext;

import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.util.ResolverType;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.FunctionMapper;
import jakarta.el.VariableMapper;

public class SimpleELContext
extends ELContext {
    private static final System.Logger logger = System.getLogger(SimpleELContext.class.getName());
    private static final String NLINE = System.getProperty("line.separator");
    private final CompositeELResolver compResolver;
    private ELResolver myResolver;
    private VariableELResolver varResolver;

    public SimpleELContext() {
        this.compResolver = new CompositeELResolver();
    }

    public SimpleELContext(ResolverType resolverType) {
        this.myResolver = this.getMyResolver(resolverType);
        this.compResolver = new CompositeELResolver();
    }

    public ELResolver getELResolver() {
        if (this.myResolver == null) {
            this.varResolver = new VariableELResolver();
            this.compResolver.add((ELResolver)this.varResolver);
        } else {
            this.varResolver = this.myResolver instanceof VariableELResolver ? (VariableELResolver)this.myResolver : null;
            this.compResolver.add(this.myResolver);
        }
        CompositeELResolver elResolver = this.compResolver;
        return elResolver;
    }

    public ELContext getELContext() {
        return this;
    }

    public VariableMapper getVariableMapper() {
        return null;
    }

    public FunctionMapper getFunctionMapper() {
        return null;
    }

    public void cleanup() {
        if (this.varResolver != null) {
            this.varResolver.cleanup();
        }
    }

    private ELResolver getMyResolver(ResolverType enumResolver) {
        switch (enumResolver) {
            case EMPLOYEE_ELRESOLVER: {
                this.myResolver = new EmployeeELResolver();
                logger.log(System.Logger.Level.TRACE, "Setting ELResolver == EmployeeELResolver");
                break;
            }
            case VARIABLE_ELRESOLVER: {
                this.myResolver = new VariableELResolver();
                logger.log(System.Logger.Level.TRACE, "Setting ELResolver == VariableELResolver");
                break;
            }
            case VECT_ELRESOLVER: {
                this.myResolver = new VectELResolver();
                logger.log(System.Logger.Level.TRACE, "Setting ELResolver == VectELResolver");
                break;
            }
            default: {
                logger.log(System.Logger.Level.TRACE, "Unknown ELResolver! " + enumResolver + " trying to use default" + NLINE + "Setting ELResolver == VariableELResolver");
            }
        }
        return this.myResolver;
    }

    public static enum Resolver {
        EmployeeELResolver,
        VariableELResolver,
        VectELResolver;

    }
}

