/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.operatorprecedence;

import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.util.ExprEval;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private static final String[] MODOPER = new String[]{"%", "mod"};
    private static final String[] DIVOPER = new String[]{"/", "div"};
    private static final String[] ANDOPER = new String[]{"&&", "and"};
    private static final String[] OROPER = new String[]{"||", "or"};
    private final boolean[] deferred = new boolean[]{true, false};

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elMultiPreBinaryTest() throws Exception {
        this.testOrderPrecedence("{1 + 5 * 2}", 11L);
        this.testOrderPrecedence("{1 - 5 * 2}", -9L);
    }

    @Test
    public void elDivPreBinaryTest() throws Exception {
        for (String s : DIVOPER) {
            this.testOrderPrecedence("{1 + 4 " + s + " 2}", 3.0);
            this.testOrderPrecedence("{1 - 4 " + s + " 2}", -1.0);
        }
    }

    @Test
    public void elModPreBinaryTest() throws Exception {
        for (String s : MODOPER) {
            this.testOrderPrecedence("{1 + 7 " + s + " 2}", 2L);
            this.testOrderPrecedence("{1 - 7 " + s + " 2}", 0L);
        }
    }

    @Test
    public void elMultiPreRelationalTest() throws Exception {
        this.testOrderPrecedence("{6 > 5 * 2}", false);
        this.testOrderPrecedence("{3 * 2 < 8}", true);
        this.testOrderPrecedence("{6 >= 5 * 2}", false);
        this.testOrderPrecedence("{6 * 2 <= 12}", true);
        this.testOrderPrecedence("{5 * 1 gt 6}", false);
        this.testOrderPrecedence("{6 lt 5 * 2}", true);
        this.testOrderPrecedence("{5 * 1 ge 6}", false);
        this.testOrderPrecedence("{6 le 5 * 2}", true);
        this.testOrderPrecedence("{5 == 5 * 2}", false);
        this.testOrderPrecedence("{5 * 2 != 10}", false);
        this.testOrderPrecedence("{10 eq 5 * 2}", true);
        this.testOrderPrecedence("{15 * 1 ne 1}", true);
    }

    @Test
    public void elDivPreRelationalTest() throws Exception {
        for (String s : DIVOPER) {
            this.testOrderPrecedence("{3 > 4  " + s + " 2}", true);
            this.testOrderPrecedence("{12 " + s + " 2 < 5}", false);
            this.testOrderPrecedence("{4 >= 6 " + s + " 24}", true);
            this.testOrderPrecedence("{16 " + s + " 2 <= 5}", false);
            this.testOrderPrecedence("{6 gt 5 " + s + " 2}", true);
            this.testOrderPrecedence("{12 " + s + " 1 lt 5}", false);
            this.testOrderPrecedence("{6 ge 5 " + s + " 2}", true);
            this.testOrderPrecedence("{50 " + s + " 2 le 5}", false);
            this.testOrderPrecedence("{1 == 2 " + s + " 2}", true);
            this.testOrderPrecedence("{10 " + s + " 5 != 5}", true);
            this.testOrderPrecedence("{5 eq 5 " + s + " 2}", false);
            this.testOrderPrecedence("{2 ne 4 " + s + " 2}", false);
        }
    }

    @Test
    public void elModPreRelationalTest() throws Exception {
        for (String s : MODOPER) {
            this.testOrderPrecedence("{4 " + s + " 15 > 1}", true);
            this.testOrderPrecedence("{5 < 6 " + s + " 2}", false);
            this.testOrderPrecedence("{6 " + s + " 29 >= 5}", true);
            this.testOrderPrecedence("{6 <= 5 " + s + " 2}", false);
            this.testOrderPrecedence("{3 " + s + " 8 gt 1}", true);
            this.testOrderPrecedence("{6 lt 5 " + s + " 2}", false);
            this.testOrderPrecedence("{8 " + s + " 5 ge 2}", true);
            this.testOrderPrecedence("{6 le 5 " + s + " 2}", false);
            this.testOrderPrecedence("{3 " + s + " 2 == 1}", true);
            this.testOrderPrecedence("{5 != 5 " + s + " 2}", true);
            this.testOrderPrecedence("{6 " + s + " 2 eq 5}", false);
            this.testOrderPrecedence("{2 ne 5 " + s + " 3}", false);
        }
    }

    @Test
    public void elMultiEqualPreAndTest() throws Exception {
        for (String a : ANDOPER) {
            this.testOrderPrecedence("{10 == 5 * 2 " + a + " 6 * 2 == 15}", false);
            this.testOrderPrecedence("{10 == 5 * 2 " + a + " 6 * 2 == 12}", true);
        }
    }

    @Test
    public void elDivEqualPreAndTest() throws Exception {
        for (String d : DIVOPER) {
            for (String a : ANDOPER) {
                this.testOrderPrecedence("{12 " + d + " 2 == 6 " + a + " 10 " + d + " 2  == 5}", true);
                this.testOrderPrecedence("{12 " + d + " 3 == 6 " + a + " 10 " + d + " 2  == 5}", false);
            }
        }
    }

    @Test
    public void elModEqualPreAndTest() throws Exception {
        for (String m : MODOPER) {
            for (String a : ANDOPER) {
                this.testOrderPrecedence("{15 " + m + " 4 == 3 " + a + " 3 " + m + " 3 == 0}", true);
                this.testOrderPrecedence("{15 " + m + " 3 == 3 " + a + " 3 " + m + " 3 == 0}", false);
            }
        }
    }

    @Test
    public void elMultiEqualOrCondTest() throws Exception {
        for (String o : OROPER) {
            this.testOrderPrecedence("{10 == 5 * 2 " + o + " 6 * 2 == 15}", true);
            this.testOrderPrecedence("{10 == 5 * 5 " + o + " 6 * 2 == 12}", true);
            this.testOrderPrecedence("{10 == 5 * 5 " + o + " 6 * 6 == 12}", false);
        }
    }

    @Test
    public void elDivEqualPreOrTest() throws Exception {
        for (String d : DIVOPER) {
            for (String o : OROPER) {
                this.testOrderPrecedence("{12 " + d + " 2 == 6 " + o + " 10 " + d + " 5  == 5}", true);
                this.testOrderPrecedence("{12 " + d + " 3 == 6 " + o + " 10 " + d + " 2  == 5}", true);
                this.testOrderPrecedence("{12 " + d + " 3 == 6 " + o + " 10 " + d + " 5  == 5}", false);
            }
        }
    }

    @Test
    public void elModEqualPreOrTest() throws Exception {
        for (String m : MODOPER) {
            for (String o : OROPER) {
                this.testOrderPrecedence("{15 " + m + " 4 == 3 " + o + " 4 " + m + " 3 == 0}", true);
                this.testOrderPrecedence("{15 " + m + " 3 == 3 " + o + " 3 " + m + " 3 == 0}", true);
                this.testOrderPrecedence("{15 " + m + " 3 == 3 " + o + " 8 " + m + " 3 == 0}", false);
            }
        }
    }

    @Test
    public void elMultiEqualPreCondTest() throws Exception {
        this.testOrderPrecedence("{5 * 2 == 10 ? false : true}", false);
        this.testOrderPrecedence("{5 * 5 == 10 ? false : true}", true);
    }

    @Test
    public void elDivEqualPreCondTest() throws Exception {
        for (String d : DIVOPER) {
            this.testOrderPrecedence("{20 " + d + " 2 == 10 ? false : true}", false);
            this.testOrderPrecedence("{24 " + d + " 2 == 10 ? false : true}", true);
        }
    }

    @Test
    public void elModEqualPreCondTest() throws Exception {
        for (String m : MODOPER) {
            this.testOrderPrecedence("{21 " + m + " 2 == 1 ? false : true}", false);
            this.testOrderPrecedence("{15 " + m + " 3 == 3 ? false : true}", true);
        }
    }

    @Test
    public void elParenPreBinaryTest() throws Exception {
        this.testOrderPrecedence("{(2 + 3) - 10}", -5L);
        this.testOrderPrecedence("{10 - (2 + 3)}", 5L);
        this.testOrderPrecedence("{(1 - 5) + 2}", -2L);
        this.testOrderPrecedence("{2 + (5 - 1)}", 6L);
        this.testOrderPrecedence("{(1 + 5) * 2}", 12L);
        this.testOrderPrecedence("{2 * (1 + 5)}", 12L);
        this.testOrderPrecedence("{(4 + 4) / 2}", 4.0);
        this.testOrderPrecedence("{2 / (4 + 4)}", 0.25);
        this.testOrderPrecedence("{(2 + 7) % 2}", 1L);
        this.testOrderPrecedence("{18 % (8 + 7)}", 3L);
    }

    @Test
    public void functionPrecedenceTest() throws Exception {
        boolean pass = false;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        FuncMapperELContext context = new FuncMapperELContext();
        expFactory.createValueExpression((ELContext)context, "${Int:val(10)}", Object.class);
        try {
            expFactory.createValueExpression((ELContext)context, "${a?Int:val(10)}", Object.class);
        }
        catch (ELException ex) {
            pass = true;
        }
        if (!pass) {
            throw new Exception("function precedence failed");
        }
    }

    private void testOrderPrecedence(String testExpr, Object expectedResult) throws Exception {
        boolean pass = false;
        String[] symbol = new String[]{"$", "#"};
        try {
            for (String prefix : symbol) {
                String expr = prefix + testExpr;
                logger.log(System.Logger.Level.TRACE, "Expression to test: " + expr);
                Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                pass = ExprEval.compareValue(result, expectedResult);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

