/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.negdep.onmessage.client.textbigdecimal;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.negdep.EchoServerEndpoint;
import com.sun.ts.tests.websocket.negdep.NegativeDeploymentClient;
import com.sun.ts.tests.websocket.negdep.onmessage.client.textbigdecimal.OnMessageClientEndpoint;
import jakarta.websocket.DeploymentException;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends NegativeDeploymentClient {
    private static final System.Logger logger = System.getLogger(WSCClientIT.class.getName());
    private static final long serialVersionUID = 111L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_negdep_onmessage_client_textbigdecimal_web.war");
        archive.addClass(EchoServerEndpoint.class);
        archive.addClass(IOUtil.class);
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_negdep_onmessage_client_textbigdecimal_web");
    }

    @Test
    public void bigDecimalOnMessageTest() throws Exception {
        this.setEntity("anything");
        OnMessageClientEndpoint endpoint = new OnMessageClientEndpoint();
        this.setAnnotatedClientEndpoint(endpoint);
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("echo"));
        this.setProperty(WebSocketCommonClient.Property.STATUS_CODE, "-1");
        this.logExceptionOnInvocation(false);
        this.printClientCall(false);
        boolean thrown = true;
        try {
            this.invoke(false);
            thrown = false;
        }
        catch (Exception tfe) {
            WSCClientIT.assertCause(tfe, DeploymentException.class, "The DeploymentException has not been thrown!");
            tfe.printStackTrace();
            WSCClientIT.logMsg("--\n\n");
            WSCClientIT.logMsg("DeploymentException has been thrown as expected");
        }
        if (!thrown) {
            super.throwDeploymentDidNotFail();
        }
        boolean isSession = false;
        try {
            this.getSession();
            isSession = true;
        }
        catch (Exception f) {
            logger.log(System.Logger.Level.DEBUG, "The session is closed as expected");
        }
        if (isSession) {
            logger.log(System.Logger.Level.ERROR, "Session is not null!");
            throw new Exception("Session is not null! Deployment succeeded");
        }
    }
}

