/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;

public final class InnerDescr
extends MemberDescription {
    public static final InnerDescr[] EMPTY_ARRAY = new InnerDescr[0];

    public InnerDescr() {
        super(MemberType.INNER, '$');
    }

    public InnerDescr(String fullQualifiedName, String outerName, int modif) {
        this();
        this.setupClassName(fullQualifiedName, outerName);
        this.setModifiers(modif);
    }

    public boolean equals(Object o) {
        return o instanceof InnerDescr && this.name == ((InnerDescr)o).name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isCompatible(MemberDescription m) {
        if (!this.equals(m)) {
            throw new IllegalArgumentException("Only equal members can be checked for compatibility!");
        }
        return this.memberType.isCompatible(this.getModifiers(), m.getModifiers());
    }

    public boolean isInner() {
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.hasModifier(Modifier.STATIC)) {
            buf.append("nested");
        } else {
            buf.append("inner");
        }
        String modifiers = Modifier.toString(this.memberType, this.getModifiers(), true);
        if (modifiers.length() != 0) {
            buf.append(' ');
            buf.append(modifiers);
        }
        buf.append(' ');
        buf.append(this.declaringClass);
        buf.append(this.delimiter);
        buf.append(this.name);
        return buf.toString();
    }
}

