/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.core.ModuleDescriptionLoader;
import com.sun.tdk.signaturetest.core.PackageGroup;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.core.context.Options;
import com.sun.tdk.signaturetest.model.ModuleDescription;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ModBase
extends SigTest {
    protected static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ModBase.class);
    private final PackageGroup modIncl;
    private final PackageGroup modExcl;
    private final PackageGroup modExact;
    private final PackageGroup pkgIncl;
    private final PackageGroup pkgExcl;
    protected String apiVer = "";
    protected final SimpleErrorFormatter errorFormatter = new SimpleErrorFormatter();

    public ModBase() {
        this.modIncl = new PackageGroup(true);
        this.modExcl = new PackageGroup(true);
        this.modExact = new PackageGroup(false);
        this.pkgIncl = new PackageGroup(true);
        this.pkgExcl = new PackageGroup(true);
    }

    protected void setupModulesAndPackages(Options o) {
        String modPatt = o.getValue(Option.MODULES);
        if (modPatt != null) {
            for (String m : modPatt.split(",")) {
                if ((m = m.trim()).isEmpty()) continue;
                if (m.startsWith("!")) {
                    assert (m.length() > 1);
                    this.modExcl.addPackage(m.substring(1));
                    continue;
                }
                if (m.endsWith(".*")) {
                    this.modIncl.addPackage(m.substring(0, m.length() - 2));
                    continue;
                }
                this.modExact.addPackage(m);
            }
        }
        this.pkgIncl.addPackages(o.getValues(Option.PKG_INCLUDE));
        this.pkgExcl.addPackages(o.getValues(Option.PKG_EXCLUDE));
        if (this.modIncl.isEmpty() && this.modExact.isEmpty()) {
            this.modIncl.addPackage("");
        }
        if (this.pkgIncl.isEmpty()) {
            this.pkgIncl.addPackage("");
        }
    }

    public static ModuleDescriptionLoader getModuleLoader() {
        String lClassName = "com.sun.tdk.signaturetest.loaders.ModuleLoader";
        try {
            Class<?> c = Class.forName(lClassName);
            return (ModuleDescriptionLoader)c.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected Map<String, ModuleDescription> filterModuleSet(Map<String, ModuleDescription> model, boolean isReference, boolean verbose) {
        assert (model != null);
        Iterator<Map.Entry<String, ModuleDescription>> it = model.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ModuleDescription> en = it.next();
            if (!this.isAPiModule(en.getKey())) {
                if (verbose) {
                    System.out.printf("Module %s removed\n", en.getKey());
                }
                it.remove();
                continue;
            }
            if (verbose) {
                System.out.printf("Module %s \n", en.getKey());
            }
            this.filterModule(en.getValue(), isReference, verbose);
        }
        return model;
    }

    protected void filterModule(ModuleDescription md, boolean isReference, boolean verbose) {
        this.filterPackageSet(md.getPackages(), isReference, verbose, "Package");
        this.filterRequires(md.getRequires(), isReference, verbose);
        this.filterExports(md.getExports(), isReference, verbose);
        this.filterProvides(md.getProvides(), isReference, verbose);
        this.filterPackageSet(md.getUses(), isReference, verbose, "Uses");
    }

    private void filterProvides(Map<String, ModuleDescription.Provides> provides, boolean isReference, boolean verbose) {
        assert (provides != null);
        Iterator<Map.Entry<String, ModuleDescription.Provides>> it = provides.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ModuleDescription.Provides> en = it.next();
            if (!this.isApiPackage(en.getKey())) {
                if (verbose) {
                    System.out.printf(" - Service %s excluded\n", en.getKey());
                }
                it.remove();
            }
            Iterator<String> itp = en.getValue().providers.iterator();
            while (itp.hasNext()) {
                String prName = itp.next();
                if (this.isApiPackage(prName)) continue;
                if (verbose) {
                    System.out.printf(" - Service provider %s excluded\n", prName);
                }
                itp.remove();
            }
        }
    }

    private void filterRequires(Set<ModuleDescription.Requires> requires, boolean isReference, boolean verbose) {
    }

    protected boolean isAPiModule(String modName) {
        boolean excluded = this.modExcl.checkModuleName(modName);
        boolean included = this.modIncl.checkModuleName(modName) || this.modExact.checkModuleName(modName);
        return included && !excluded;
    }

    protected boolean isApiPackage(String packName) {
        return this.pkgIncl.checkName(packName) && !this.pkgExcl.checkName(packName);
    }

    private Set<String> filterPackageSet(Set<String> pkgSet, boolean isReference, boolean verbose, String object) {
        Iterator<String> it = pkgSet.iterator();
        while (it.hasNext()) {
            String pkgName = it.next();
            if (this.isApiPackage(pkgName)) continue;
            if (verbose) {
                System.out.printf(" - %s %s excluded\n", object, pkgName);
            }
            it.remove();
        }
        return pkgSet;
    }

    private Set<String> filterApiModuleSet(Set<String> pkgSet, boolean isReference, boolean verbose, String object) {
        Iterator<String> it = pkgSet.iterator();
        while (it.hasNext()) {
            String mName = it.next();
            if (this.isAPiModule(mName)) continue;
            if (verbose) {
                System.out.printf(" - %s %s excluded\n", object, mName);
            }
            it.remove();
        }
        return pkgSet;
    }

    private Set<ModuleDescription.Exports> filterExports(Set<ModuleDescription.Exports> exports, boolean isReference, boolean verbose) {
        ModuleDescription.Exports ex;
        Iterator<ModuleDescription.Exports> it = exports.iterator();
        while (it.hasNext()) {
            ex = it.next();
            if (this.isApiPackage(ex.source)) continue;
            if (verbose) {
                System.out.printf(" - Export %s excluded\n", ex.source);
            }
            it.remove();
        }
        it = exports.iterator();
        while (it.hasNext()) {
            ex = it.next();
            if (ex.targets.isEmpty()) continue;
            this.filterApiModuleSet(ex.targets, isReference, verbose, "Export target");
            if (!ex.targets.isEmpty()) continue;
            if (verbose) {
                System.out.printf(" - Export %s excluded because all targets were excluded\n", ex.source);
            }
            it.remove();
        }
        return exports;
    }

    class SimpleErrorFormatter {
        private final List<String> errors = new ArrayList<String>();

        SimpleErrorFormatter() {
        }

        void addError(String formatStr, Object ... args) {
            this.errors.add(String.format(formatStr, args));
        }

        void addError(String msg) {
            this.errors.add(msg);
        }

        void out(PrintWriter log) {
            for (String m : this.errors) {
                log.println(m);
            }
        }

        int getNunErrors() {
            return this.errors.size();
        }
    }
}

