/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.pde.internal.core.iproduct.IAboutInfo;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.ICSSInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationProperty;
import org.eclipse.pde.internal.core.iproduct.IIntroInfo;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.ILicenseInfo;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IPreferencesInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductObject;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.iproduct.IRepositoryInfo;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.iproduct.IWindowImages;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.eclipse.pde.internal.core.util.PDESchemaHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Product
extends ProductObject
implements IProduct {
    private static final long serialVersionUID = 1L;
    private String fCopyright;
    private String fId;
    private String fProductId;
    private String fName;
    private String fApplication;
    private String fVersion;
    private IAboutInfo fAboutInfo;
    private final TreeMap<String, IProductObject> fPlugins = new TreeMap();
    private final TreeMap<String, IProductObject> fPluginConfigurations = new TreeMap();
    private final Set<IConfigurationProperty> fConfigurationProperties = new LinkedHashSet<IConfigurationProperty>();
    private final List<IProductFeature> fFeatures = new ArrayList<IProductFeature>();
    private IConfigurationFileInfo fConfigIniInfo;
    private IJREInfo fJVMInfo;
    private IProduct.ProductType fType = IProduct.ProductType.BUNDLES;
    private boolean fIncludeLaunchers = true;
    private boolean fAutoIncludeRequirements = true;
    private IWindowImages fWindowImages;
    private ISplashInfo fSplashInfo;
    private ILauncherInfo fLauncherInfo;
    private IArgumentsInfo fLauncherArgs;
    private IIntroInfo fIntroInfo;
    private ILicenseInfo fLicenseInfo;
    private final Set<IProductObject> fRepositories = new LinkedHashSet<IProductObject>();
    private IPreferencesInfo fPreferencesInfo;
    private ICSSInfo fCSSInfo;

    public Product(IProductModel model) {
        super(model);
    }

    public String getCopyright() {
        return this.fCopyright;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getProductId() {
        return this.fProductId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getVersion() {
        return this.fVersion;
    }

    @Override
    public String getApplication() {
        return this.fApplication;
    }

    @Override
    public String getDefiningPluginId() {
        if (this.fProductId == null) {
            return null;
        }
        int dot = this.fProductId.lastIndexOf(46);
        return dot != -1 ? this.fProductId.substring(0, dot) : null;
    }

    public void setCopyright(String copyright) {
        this.fCopyright = copyright;
    }

    @Override
    public void setId(String id) {
        String old = this.fId;
        this.fId = id;
        if (this.isEditable()) {
            this.firePropertyChanged("uid", old, this.fId);
        }
    }

    @Override
    public void setProductId(String id) {
        String old = this.fProductId;
        this.fProductId = id;
        if (this.isEditable()) {
            this.firePropertyChanged("id", old, this.fProductId);
        }
    }

    @Override
    public void setVersion(String version) {
        String old = this.fVersion;
        this.fVersion = version;
        if (this.isEditable()) {
            this.firePropertyChanged("version", old, this.fVersion);
        }
    }

    @Override
    public void setName(String name) {
        String old = this.fName;
        this.fName = name;
        if (this.isEditable()) {
            this.firePropertyChanged("name", old, this.fName);
        }
    }

    @Override
    public void setAboutInfo(IAboutInfo info) {
        this.fAboutInfo = info;
    }

    @Override
    public void setApplication(String application) {
        String old = this.fApplication;
        this.fApplication = application;
        if (this.isEditable()) {
            this.firePropertyChanged("application", old, this.fApplication);
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        if (this.fCopyright != null) {
            writer.println("<!--" + this.fCopyright + "-->");
        }
        writer.print(indent + "<product");
        if (this.fName != null && this.fName.length() > 0) {
            writer.print(" name=\"" + this.getWritableString(this.fName) + "\"");
        }
        if (this.fId != null && this.fId.length() > 0) {
            writer.print(" uid=\"" + this.fId + "\"");
        }
        if (this.fProductId != null && this.fProductId.length() > 0) {
            writer.print(" id=\"" + this.fProductId + "\"");
        }
        if (this.fApplication != null && this.fApplication.length() > 0) {
            writer.print(" application=\"" + this.fApplication + "\"");
        }
        if (this.fVersion != null && this.fVersion.length() > 0) {
            writer.print(" version=\"" + this.fVersion + "\"");
        }
        writer.print(" type=\"" + String.valueOf((Object)this.fType) + "\"");
        writer.print(" includeLaunchers=\"" + this.fIncludeLaunchers + "\"");
        writer.print(" autoIncludeRequirements=\"" + this.fAutoIncludeRequirements + "\"");
        writer.println(">");
        if (this.fAboutInfo != null) {
            writer.println();
            this.fAboutInfo.write(indent + "   ", writer);
        }
        if (this.fConfigIniInfo != null) {
            writer.println();
            this.fConfigIniInfo.write(indent + "   ", writer);
        }
        if (this.fLauncherArgs != null) {
            writer.println();
            this.fLauncherArgs.write(indent + "   ", writer);
        }
        if (this.fWindowImages != null) {
            writer.println();
            this.fWindowImages.write(indent + "   ", writer);
        }
        if (this.fSplashInfo != null) {
            writer.println();
            this.fSplashInfo.write(indent + "   ", writer);
        }
        if (this.fLauncherInfo != null) {
            writer.println();
            this.fLauncherInfo.write(indent + "   ", writer);
        }
        if (this.fIntroInfo != null) {
            writer.println();
            this.fIntroInfo.write(indent + "   ", writer);
        }
        if (this.fJVMInfo != null) {
            writer.println();
            this.fJVMInfo.write(indent + "   ", writer);
        }
        if (this.fLicenseInfo != null) {
            writer.println();
            this.fLicenseInfo.write(indent + "   ", writer);
        }
        writer.println();
        writer.println(indent + "   <plugins>");
        for (IProductPlugin iProductPlugin : this.fPlugins.values()) {
            iProductPlugin.write(indent + "      ", writer);
        }
        writer.println(indent + "   </plugins>");
        if (!this.fFeatures.isEmpty()) {
            writer.println();
            writer.println(indent + "   <features>");
            for (IProductFeature iProductFeature : this.fFeatures) {
                iProductFeature.write(indent + "      ", writer);
            }
            writer.println(indent + "   </features>");
        }
        writer.println();
        if (!this.fConfigurationProperties.isEmpty() || !this.fPluginConfigurations.isEmpty()) {
            writer.println(indent + "   <configurations>");
            for (IPluginConfiguration iPluginConfiguration : this.fPluginConfigurations.values()) {
                iPluginConfiguration.write(indent + "      ", writer);
            }
            for (IConfigurationProperty iConfigurationProperty : this.fConfigurationProperties) {
                iConfigurationProperty.write(indent + "      ", writer);
            }
            writer.println(indent + "   </configurations>");
        }
        if (!this.fRepositories.isEmpty()) {
            writer.println();
            writer.println(indent + "   <repositories>");
            for (IRepositoryInfo iRepositoryInfo : this.fRepositories) {
                iRepositoryInfo.write(indent + "      ", writer);
            }
            writer.println(indent + "   </repositories>");
        }
        if (this.fPreferencesInfo != null) {
            writer.println();
            this.fPreferencesInfo.write(indent + "   ", writer);
        }
        if (this.fCSSInfo != null) {
            writer.println();
            this.fCSSInfo.write(indent + "   ", writer);
        }
        writer.println();
        writer.println("</product>");
    }

    @Override
    public IAboutInfo getAboutInfo() {
        return this.fAboutInfo;
    }

    @Override
    public void reset() {
        this.fApplication = null;
        this.fId = null;
        this.fProductId = null;
        this.fName = null;
        this.fType = IProduct.ProductType.BUNDLES;
        this.fIncludeLaunchers = true;
        this.fAutoIncludeRequirements = true;
        this.fAboutInfo = null;
        this.fPlugins.clear();
        this.fPluginConfigurations.clear();
        this.fConfigurationProperties.clear();
        this.fFeatures.clear();
        this.fConfigIniInfo = null;
        this.fWindowImages = null;
        this.fSplashInfo = null;
        this.fLauncherInfo = null;
        this.fLauncherArgs = null;
        this.fIntroInfo = null;
        this.fJVMInfo = null;
        this.fLicenseInfo = null;
    }

    @Override
    public void parse(Node node) {
        block52: {
            String launchers;
            String type;
            if (node.getNodeType() != 1 || !node.getNodeName().equals("product")) break block52;
            Element element = (Element)node;
            this.fApplication = element.getAttribute("application");
            this.fProductId = element.getAttribute("id");
            this.fId = element.getAttribute("uid");
            this.fName = element.getAttribute("name");
            this.fVersion = element.getAttribute("version");
            String useFeatures = element.getAttribute("useFeatures");
            if (!useFeatures.isBlank()) {
                IProduct.ProductType productType = this.fType = "true".equals(useFeatures) ? IProduct.ProductType.FEATURES : IProduct.ProductType.BUNDLES;
            }
            if (!(type = element.getAttribute("type")).isBlank()) {
                this.fType = IProduct.ProductType.parse(type);
            }
            this.fIncludeLaunchers = (launchers = element.getAttribute("includeLaunchers")).isBlank() || "true".equals(launchers);
            String autoAdd = element.getAttribute("autoIncludeRequirements");
            this.fAutoIncludeRequirements = autoAdd.isBlank() || "true".equals(autoAdd);
            NodeList children = node.getChildNodes();
            IProductModelFactory factory = this.getModel().getFactory();
            int i = 0;
            while (i < children.getLength()) {
                block53: {
                    String name;
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) break block53;
                    switch (name = child.getNodeName()) {
                        case "aboutInfo": {
                            this.fAboutInfo = factory.createAboutInfo();
                            this.fAboutInfo.parse(child);
                            break;
                        }
                        case "plugins": {
                            this.parsePlugins(child.getChildNodes());
                            break;
                        }
                        case "features": {
                            this.parseFeatures(child.getChildNodes());
                            break;
                        }
                        case "configurations": {
                            this.parseConfigations(child.getChildNodes());
                            break;
                        }
                        case "configIni": {
                            this.fConfigIniInfo = factory.createConfigFileInfo();
                            this.fConfigIniInfo.parse(child);
                            break;
                        }
                        case "windowImages": {
                            this.fWindowImages = factory.createWindowImages();
                            this.fWindowImages.parse(child);
                            break;
                        }
                        case "splash": {
                            this.fSplashInfo = factory.createSplashInfo();
                            this.fSplashInfo.parse(child);
                            break;
                        }
                        case "launcher": {
                            this.fLauncherInfo = factory.createLauncherInfo();
                            this.fLauncherInfo.parse(child);
                            break;
                        }
                        case "launcherArgs": {
                            this.fLauncherArgs = factory.createLauncherArguments();
                            this.fLauncherArgs.parse(child);
                            break;
                        }
                        case "intro": {
                            this.fIntroInfo = factory.createIntroInfo();
                            this.fIntroInfo.parse(child);
                            break;
                        }
                        case "vm": {
                            this.fJVMInfo = factory.createJVMInfo();
                            this.fJVMInfo.parse(child);
                            break;
                        }
                        case "license": {
                            this.fLicenseInfo = factory.createLicenseInfo();
                            this.fLicenseInfo.parse(child);
                            break;
                        }
                        case "repositories": {
                            this.parseRepositories(child.getChildNodes());
                            break;
                        }
                        case "preferencesInfo": {
                            this.fPreferencesInfo = factory.createPreferencesInfo();
                            this.fPreferencesInfo.parse(child);
                            break;
                        }
                        case "cssInfo": {
                            this.fCSSInfo = factory.createCSSInfo();
                            this.fCSSInfo.parse(child);
                            break;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void parsePlugins(NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("plugin")) {
                IProductPlugin plugin = this.getModel().getFactory().createPlugin();
                plugin.parse(child);
                this.fPlugins.put(plugin.getId(), plugin);
            }
            ++i;
        }
    }

    private void parseConfigations(NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("plugin")) {
                    IPluginConfiguration configuration = this.getModel().getFactory().createPluginConfiguration();
                    configuration.parse(child);
                    this.fPluginConfigurations.put(configuration.getId(), configuration);
                }
                if (child.getNodeName().equals("property")) {
                    IConfigurationProperty property = this.getModel().getFactory().createConfigurationProperty();
                    property.parse(child);
                    this.fConfigurationProperties.add(property);
                }
            }
            ++i;
        }
    }

    private void parseFeatures(NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("feature")) {
                IProductFeature feature = this.getModel().getFactory().createFeature();
                feature.parse(child);
                this.fFeatures.add(feature);
            }
            ++i;
        }
    }

    private void parseRepositories(NodeList children) {
        LinkedHashMap<IRepositoryInfo, Boolean> repo2enabled = new LinkedHashMap<IRepositoryInfo, Boolean>();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("repository")) {
                IRepositoryInfo repo = this.getModel().getFactory().createRepositoryInfo();
                repo.parse(child);
                repo2enabled.compute(repo, (r, e) -> e == null ? r.getEnabled() : e != false || r.getEnabled());
            }
            ++i;
        }
        repo2enabled.forEach(IRepositoryInfo::setEnabled);
        this.fRepositories.addAll(repo2enabled.keySet());
    }

    @Override
    public void addPlugins(IProductPlugin[] plugins) {
        boolean modified = false;
        int i = 0;
        while (i < plugins.length) {
            if (plugins[i] != null) {
                String id = plugins[i].getId();
                if (id == null || this.fPlugins.containsKey(id)) {
                    plugins[i] = null;
                } else {
                    plugins[i].setModel(this.getModel());
                    this.fPlugins.put(id, plugins[i]);
                    modified = true;
                }
            }
            ++i;
        }
        if (modified && this.isEditable()) {
            this.fireStructureChanged(plugins, 1);
        }
    }

    @Override
    public void addPluginConfigurations(IPluginConfiguration[] configuration) {
        boolean modified = false;
        int i = 0;
        while (i < configuration.length) {
            if (configuration[i] != null) {
                String id = configuration[i].getId();
                if (id == null || this.fPluginConfigurations.containsKey(id)) {
                    configuration[i] = null;
                } else {
                    configuration[i].setModel(this.getModel());
                    this.fPluginConfigurations.put(id, configuration[i]);
                    modified = true;
                }
            }
            ++i;
        }
        if (modified && this.isEditable()) {
            this.fireStructureChanged(configuration, 1);
        }
    }

    @Override
    public void addConfigurationProperties(IConfigurationProperty[] properties) {
        boolean modified = false;
        IConfigurationProperty[] iConfigurationPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IConfigurationProperty property = iConfigurationPropertyArray[n2];
            if (property != null && (name = property.getName()) != null && !PDESchemaHelper.containsMatchingProperty(this.fConfigurationProperties, name, property.getOs(), property.getArch())) {
                property.setModel(this.getModel());
                this.fConfigurationProperties.add(property);
                modified = true;
            }
            ++n2;
        }
        if (modified && this.isEditable()) {
            this.fireStructureChanged(properties, 1);
        }
    }

    @Override
    public void removePlugins(IProductPlugin[] plugins) {
        boolean modified = false;
        LinkedList<IProductObject> removedConfigurations = new LinkedList<IProductObject>();
        IProductPlugin[] iProductPluginArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IProductPlugin plugin = iProductPluginArray[n2];
            String id = plugin.getId();
            if (this.fPlugins.remove(id) != null) {
                modified = true;
                IProductObject configuration = this.fPluginConfigurations.remove(id);
                if (configuration != null) {
                    removedConfigurations.add(configuration);
                }
            }
            ++n2;
        }
        if (this.isEditable()) {
            if (modified) {
                this.fireStructureChanged(plugins, 2);
            }
            if (!removedConfigurations.isEmpty()) {
                this.fireStructureChanged(removedConfigurations.toArray(new IProductObject[removedConfigurations.size()]), 2);
            }
        }
    }

    @Override
    public void removePluginConfigurations(IPluginConfiguration[] configurations) {
        boolean modified = false;
        IPluginConfiguration[] iPluginConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginConfiguration configuration = iPluginConfigurationArray[n2];
            if (this.fPluginConfigurations.remove(configuration.getId()) != null) {
                modified = true;
            }
            ++n2;
        }
        if (this.isEditable() && modified) {
            this.fireStructureChanged(configurations, 2);
        }
    }

    @Override
    public void removeConfigurationProperties(IConfigurationProperty[] properties) {
        boolean modified = false;
        IConfigurationProperty[] iConfigurationPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationProperty property = iConfigurationPropertyArray[n2];
            if (this.fConfigurationProperties.remove(property)) {
                modified = true;
            }
            ++n2;
        }
        if (this.isEditable() && modified) {
            this.fireStructureChanged(properties, 2);
        }
    }

    @Override
    public IProductPlugin[] getPlugins() {
        return this.fPlugins.values().toArray(new IProductPlugin[this.fPlugins.size()]);
    }

    @Override
    public IPluginConfiguration[] getPluginConfigurations() {
        return this.fPluginConfigurations.values().toArray(new IPluginConfiguration[this.fPluginConfigurations.size()]);
    }

    @Override
    public IConfigurationProperty[] getConfigurationProperties() {
        return this.fConfigurationProperties.toArray(new IConfigurationProperty[this.fConfigurationProperties.size()]);
    }

    @Override
    public IRepositoryInfo[] getRepositories() {
        return this.fRepositories.toArray(new IRepositoryInfo[this.fRepositories.size()]);
    }

    @Override
    public void addRepositories(IRepositoryInfo[] repos) {
        boolean modified = false;
        IRepositoryInfo[] iRepositoryInfoArray = repos;
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryInfo repo = iRepositoryInfoArray[n2];
            modified = modified || this.fRepositories.add(repo);
            ++n2;
        }
        if (modified && this.isEditable()) {
            this.fireStructureChanged(repos, 1);
        }
    }

    @Override
    public void removeRepositories(IRepositoryInfo[] repos) {
        boolean modified = false;
        IRepositoryInfo[] iRepositoryInfoArray = repos;
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryInfo repo = iRepositoryInfoArray[n2];
            modified = this.fRepositories.remove(repo) || modified;
            ++n2;
        }
        if (modified && this.isEditable()) {
            this.fireStructureChanged(repos, 2);
        }
    }

    @Override
    public IPreferencesInfo getPreferencesInfo() {
        return this.fPreferencesInfo;
    }

    @Override
    public void setPreferencesInfo(IPreferencesInfo info) {
        this.fPreferencesInfo = info;
    }

    @Override
    public ICSSInfo getCSSInfo() {
        return this.fCSSInfo;
    }

    @Override
    public void setCSSInfo(ICSSInfo info) {
        this.fCSSInfo = info;
    }

    @Override
    public IConfigurationFileInfo getConfigurationFileInfo() {
        return this.fConfigIniInfo;
    }

    @Override
    public void setConfigurationFileInfo(IConfigurationFileInfo info) {
        this.fConfigIniInfo = info;
    }

    @Override
    public IProduct.ProductType getType() {
        return this.fType;
    }

    @Override
    public void setType(IProduct.ProductType type) {
        IProduct.ProductType old = this.fType;
        this.fType = type;
        if (this.isEditable()) {
            this.firePropertyChanged("type", (Object)old, (Object)this.fType);
        }
    }

    @Override
    public boolean includeRequirementsAutomatically() {
        return this.fAutoIncludeRequirements;
    }

    @Override
    public void setIncludeRequirementsAutomatically(boolean includeRequirements) {
        boolean old = this.fAutoIncludeRequirements;
        this.fAutoIncludeRequirements = includeRequirements;
        if (this.isEditable()) {
            this.firePropertyChanged("autoIncludeRequirements", Boolean.toString(old), Boolean.toString(this.fAutoIncludeRequirements));
        }
    }

    @Override
    public boolean containsPlugin(String id) {
        return this.fPlugins.containsKey(id);
    }

    @Override
    public boolean containsFeature(String id) {
        IProductFeature[] features;
        IProductFeature[] iProductFeatureArray = features = this.getFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IProductFeature feature = iProductFeatureArray[n2];
            if (feature.getId().equals(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IWindowImages getWindowImages() {
        return this.fWindowImages;
    }

    @Override
    public void setWindowImages(IWindowImages images) {
        this.fWindowImages = images;
    }

    @Override
    public ISplashInfo getSplashInfo() {
        return this.fSplashInfo;
    }

    @Override
    public void setSplashInfo(ISplashInfo info) {
        this.fSplashInfo = info;
    }

    @Override
    public ILauncherInfo getLauncherInfo() {
        return this.fLauncherInfo;
    }

    @Override
    public void setLauncherInfo(ILauncherInfo info) {
        this.fLauncherInfo = info;
    }

    @Override
    public void addFeatures(IProductFeature[] features) {
        boolean modified = false;
        HashSet<String> knownIds = new HashSet<String>(this.fFeatures.size());
        this.fFeatures.forEach(feat -> {
            boolean bl = knownIds.add(feat.getId());
        });
        int i = 0;
        while (i < features.length) {
            if (features[i] != null) {
                String id = features[i].getId();
                if (knownIds.contains(id)) {
                    features[i] = null;
                } else {
                    features[i].setModel(this.getModel());
                    this.fFeatures.add(features[i]);
                    knownIds.add(id);
                    modified = true;
                }
            }
            ++i;
        }
        if (modified && this.isEditable()) {
            this.fireStructureChanged(features, 1);
        }
    }

    @Override
    public void removeFeatures(IProductFeature[] features) {
        boolean modified = false;
        IProductFeature[] iProductFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IProductFeature feature = iProductFeatureArray[n2];
            if (feature.getId() != null) {
                this.fFeatures.remove(feature);
                modified = true;
            }
            ++n2;
        }
        if (modified && this.isEditable()) {
            this.fireStructureChanged(features, 2);
        }
    }

    @Override
    public IProductFeature[] getFeatures() {
        return this.fFeatures.toArray(new IProductFeature[this.fFeatures.size()]);
    }

    @Override
    public IArgumentsInfo getLauncherArguments() {
        return this.fLauncherArgs;
    }

    @Override
    public void setLauncherArguments(IArgumentsInfo info) {
        this.fLauncherArgs = info;
    }

    @Override
    public IIntroInfo getIntroInfo() {
        return this.fIntroInfo;
    }

    @Override
    public void setIntroInfo(IIntroInfo introInfo) {
        this.fIntroInfo = introInfo;
    }

    @Override
    public IJREInfo getJREInfo() {
        return this.fJVMInfo;
    }

    @Override
    public void setJREInfo(IJREInfo info) {
        this.fJVMInfo = info;
    }

    @Override
    public ILicenseInfo getLicenseInfo() {
        return this.fLicenseInfo;
    }

    @Override
    public void setLicenseInfo(ILicenseInfo info) {
        this.fLicenseInfo = info;
    }

    @Override
    public void swap(IProductFeature feature1, IProductFeature feature2) {
        int index1 = this.fFeatures.indexOf(feature1);
        int index2 = this.fFeatures.indexOf(feature2);
        if (index1 == -1 || index2 == -1) {
            return;
        }
        this.fFeatures.set(index2, feature1);
        this.fFeatures.set(index1, feature2);
        this.fireStructureChanged(feature1, 3);
    }

    @Override
    public IPluginConfiguration findPluginConfiguration(String id) {
        return (IPluginConfiguration)this.fPluginConfigurations.get(id);
    }

    @Override
    public boolean includeLaunchers() {
        return this.fIncludeLaunchers;
    }

    @Override
    public void setIncludeLaunchers(boolean include) {
        boolean old = this.fIncludeLaunchers;
        this.fIncludeLaunchers = include;
        if (this.isEditable()) {
            this.firePropertyChanged("includeLaunchers", Boolean.toString(old), Boolean.toString(this.fIncludeLaunchers));
        }
    }
}

