/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.PrintWriter;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.PathSchemaProvider;
import org.eclipse.pde.internal.core.schema.SchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaProvider;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;

public class SchemaInclude
extends SchemaObject
implements ISchemaInclude {
    private static final PathSchemaProvider DEFAULT_SCHEMA_PROVIDER = new PathSchemaProvider(null);
    private static final long serialVersionUID = 1L;
    private String fLocation;
    private ISchema fIncludedSchema;
    private final boolean fAbbreviated;
    private final SchemaProvider schemaProvider;

    public SchemaInclude(ISchemaObject parent, String location, boolean abbreviated) {
        this(parent, location, abbreviated, null);
    }

    public SchemaInclude(ISchemaObject parent, String location, boolean abbreviated, SchemaProvider schemaProvider) {
        super(parent, location);
        this.fLocation = location;
        this.fAbbreviated = abbreviated;
        this.schemaProvider = Objects.requireNonNullElse(schemaProvider, DEFAULT_SCHEMA_PROVIDER);
    }

    @Override
    public String getLocation() {
        return this.fLocation;
    }

    @Override
    public void setLocation(String location) throws CoreException {
        String oldValue = this.fLocation;
        this.fLocation = location;
        this.fIncludedSchema = null;
        this.getSchema().fireModelObjectChanged(this, "location", oldValue, location);
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.print(indent);
        writer.println("<include schemaLocation=\"" + this.fLocation + "\"/>");
    }

    @Override
    public ISchema getIncludedSchema() {
        if (this.fIncludedSchema != null) {
            return this.fIncludedSchema;
        }
        ISchemaDescriptor descriptor = this.getSchema().getSchemaDescriptor();
        if (this.fAbbreviated) {
            SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
            this.fIncludedSchema = registry.getIncludedSchema(descriptor, this.fLocation);
        } else if (this.fIncludedSchema == null) {
            this.fIncludedSchema = this.schemaProvider.createSchema(descriptor, this.fLocation);
        }
        return this.fIncludedSchema;
    }

    @Override
    public void dispose() {
        if (this.fIncludedSchema != null && !this.fIncludedSchema.isDisposed()) {
            this.fIncludedSchema.dispose();
            this.fIncludedSchema = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ISchemaInclude) {
            void other;
            ISchemaInclude iSchemaInclude = (ISchemaInclude)object;
            ISchemaInclude cfr_ignored_0 = (ISchemaInclude)object;
            if (this.fLocation != null) {
                return this.fLocation.equals(other.getLocation());
            }
            return other.getLocation() == null;
        }
        return false;
    }
}

