/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestBuilderWrapperImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletResponseWrapperImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.ResponseStateHandler;
import org.eclipse.equinox.http.servlet.internal.util.Params;

public class DispatchTargets {
    private final ContextController contextController;
    private final EndpointRegistration<?> endpointRegistration;
    private final List<FilterRegistration> matchingFilterRegistrations;
    private final String pathInfo;
    private final Map<String, String[]> parameterMap;
    private final String queryString;
    private final String requestURI;
    private final String servletPath;

    public DispatchTargets(ContextController contextController, EndpointRegistration<?> endpointRegistration, String requestURI, String servletPath, String pathInfo, String queryString) {
        this(contextController, endpointRegistration, Collections.emptyList(), requestURI, servletPath, pathInfo, queryString);
    }

    public DispatchTargets(ContextController contextController, EndpointRegistration<?> endpointRegistration, List<FilterRegistration> matchingFilterRegistrations, String requestURI, String servletPath, String pathInfo, String queryString) {
        this.contextController = contextController;
        this.endpointRegistration = endpointRegistration;
        this.matchingFilterRegistrations = matchingFilterRegistrations;
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.parameterMap = DispatchTargets.queryStringToParameterMap(queryString);
        this.queryString = queryString;
    }

    public boolean doDispatch(HttpServletRequest request, HttpServletResponse response, String path, DispatcherType dispatcherType) throws ServletException, IOException {
        if (dispatcherType == DispatcherType.INCLUDE) {
            request.setAttribute("javax.servlet.include.context_path", (Object)this.contextController.getContextPath());
            request.setAttribute("javax.servlet.include.path_info", (Object)this.getPathInfo());
            request.setAttribute("javax.servlet.include.query_string", (Object)this.getQueryString());
            request.setAttribute("javax.servlet.include.request_uri", (Object)this.getRequestURI());
            request.setAttribute("javax.servlet.include.servlet_path", (Object)this.getServletPath());
        } else if (dispatcherType == DispatcherType.FORWARD) {
            response.resetBuffer();
            request.setAttribute("javax.servlet.forward.context_path", (Object)request.getContextPath());
            request.setAttribute("javax.servlet.forward.path_info", (Object)request.getPathInfo());
            request.setAttribute("javax.servlet.forward.query_string", (Object)request.getQueryString());
            request.setAttribute("javax.servlet.forward.request_uri", (Object)request.getRequestURI());
            request.setAttribute("javax.servlet.forward.servlet_path", (Object)request.getServletPath());
        }
        HttpServletRequestBuilderWrapperImpl httpRuntimeRequest = HttpServletRequestBuilderWrapperImpl.findHttpRuntimeRequest(request);
        boolean pushedState = false;
        try {
            if (httpRuntimeRequest == null) {
                httpRuntimeRequest = new HttpServletRequestBuilderWrapperImpl((HttpServletRequest)request, this, dispatcherType);
                request = httpRuntimeRequest;
                response = new HttpServletResponseWrapperImpl((HttpServletResponse)response);
            } else {
                httpRuntimeRequest.push(this);
                pushedState = true;
            }
            ResponseStateHandler responseStateHandler = new ResponseStateHandler((HttpServletRequest)request, (HttpServletResponse)response, this, dispatcherType);
            responseStateHandler.processRequest();
            if (dispatcherType == DispatcherType.FORWARD && !response.isCommitted()) {
                response.flushBuffer();
                response.getWriter().close();
            }
            return true;
        }
        finally {
            if (pushedState) {
                httpRuntimeRequest.pop();
            }
        }
    }

    public ContextController getContextController() {
        return this.contextController;
    }

    public List<FilterRegistration> getMatchingFilterRegistrations() {
        return this.matchingFilterRegistrations;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public EndpointRegistration<?> getServletRegistration() {
        return this.endpointRegistration;
    }

    private static Map<String, String[]> queryStringToParameterMap(String queryString) {
        if (queryString == null || queryString.length() == 0) {
            return Collections.emptyMap();
        }
        try {
            String[] parameters;
            LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
            String[] stringArray = parameters = queryString.split("&");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                int index = parameter.indexOf(61);
                String name = index > 0 ? URLDecoder.decode(parameter.substring(0, index), "UTF-8") : parameter;
                String[] values = (String[])parameterMap.get(name);
                if (values == null) {
                    values = new String[]{};
                }
                String value = index > 0 && parameter.length() > index + 1 ? URLDecoder.decode(parameter.substring(index + 1), "UTF-8") : null;
                values = Params.append(values, value);
                parameterMap.put(name, values);
                ++n2;
            }
            return Collections.unmodifiableMap(parameterMap);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }
}

