/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.formatting2.debug.TextRegionAccessToString;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractTextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.SemanticRegionMatcher;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;

public abstract class AbstractHiddenRegion
extends AbstractTextSegment
implements IHiddenRegion {
    private final ITextRegionAccess access;
    private final List<IHiddenRegionPart> hiddens = Lists.newArrayList();
    private ISemanticRegion next;
    private ISemanticRegion previous;

    protected AbstractHiddenRegion(ITextRegionAccess access) {
        this.access = access;
    }

    protected void addPart(IHiddenRegionPart part) {
        this.hiddens.add(part);
    }

    protected List<ITextSegment> collectAlternatingSpaceAndComments(boolean includeComments) {
        List<IHiddenRegionPart> parts = this.getParts();
        if (parts.isEmpty()) {
            return Collections.singletonList(this);
        }
        ITextSegment last = null;
        ArrayList result = Lists.newArrayList();
        for (IHiddenRegionPart part : parts) {
            if (part instanceof IWhitespace) {
                if (last == null || last instanceof IComment) {
                    result.add(part);
                } else {
                    int mergedLength = last.getLength() + part.getLength();
                    result.set(result.size() - 1, new TextSegment(this.access, last.getOffset(), mergedLength));
                }
            } else if (part instanceof IComment) {
                if (last == null || last instanceof IComment) {
                    result.add(new TextSegment(this.access, part.getOffset(), 0));
                }
                if (includeComments) {
                    result.add(part);
                }
            }
            if (result.isEmpty()) continue;
            last = (ITextSegment)result.get(result.size() - 1);
        }
        if (last instanceof IComment) {
            result.add(new TextSegment(this.access, last.getOffset() + last.getLength(), 0));
        }
        return ImmutableList.copyOf((Collection)result);
    }

    @Override
    public boolean containsComment() {
        for (IHiddenRegionPart hidden : this.hiddens) {
            if (!(hidden instanceof IComment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ITextSegment> getAlternatingMergedSpaceAndComments() {
        return this.collectAlternatingSpaceAndComments(true);
    }

    public int getLength() {
        if (this.hiddens.isEmpty()) {
            return 0;
        }
        int start = this.hiddens.get(0).getOffset();
        int end = this.hiddens.get(this.hiddens.size() - 1).getEndOffset();
        return end - start;
    }

    @Override
    public IHiddenRegion getNextHiddenRegion() {
        return this.next == null ? null : this.next.getNextHiddenRegion();
    }

    @Override
    public ISemanticRegion getNextSemanticRegion() {
        return this.next;
    }

    public int getOffset() {
        if (this.hiddens.isEmpty()) {
            if (this.previous != null) {
                return this.previous.getOffset() + this.previous.getLength();
            }
            return 0;
        }
        return this.hiddens.get(0).getOffset();
    }

    @Override
    public List<IHiddenRegionPart> getParts() {
        return ImmutableList.copyOf(this.hiddens);
    }

    @Override
    public IHiddenRegion getPreviousHiddenRegion() {
        return this.previous == null ? null : this.previous.getPreviousHiddenRegion();
    }

    @Override
    public ISemanticRegion getPreviousSemanticRegion() {
        return this.previous;
    }

    @Override
    public List<ITextSegment> getMergedSpaces() {
        return this.collectAlternatingSpaceAndComments(false);
    }

    @Override
    public ITextRegionAccess getTextRegionAccess() {
        return this.access;
    }

    protected void setNext(ISemanticRegion next) {
        this.next = next;
    }

    protected void setPrevious(ISemanticRegion previous) {
        this.previous = previous;
    }

    public String toString() {
        return new TextRegionAccessToString().withOrigin(this).hightlightOrigin().toString();
    }

    @Override
    public ISemanticRegionFinder immediatelyFollowing() {
        return new SemanticRegionMatcher(this.getNextSemanticRegion());
    }

    @Override
    public ISemanticRegionFinder immediatelyPreceding() {
        return new SemanticRegionMatcher(this.getPreviousSemanticRegion());
    }
}

