/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.inject.ImplementedBy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.analysis.GrammarConstraintProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.Production;

@ImplementedBy(value=GrammarConstraintProvider.class)
public interface IGrammarConstraintProvider {
    public static final int MAX = Integer.MAX_VALUE;

    public Map<ISerializationContext, IConstraint> getConstraints(Grammar var1);

    public static class ConstraintElementProduction
    implements Production<IConstraintElement, AbstractElement> {
        protected IConstraint root;

        public ConstraintElementProduction(IConstraint root) {
            this.root = root;
        }

        public Iterable<IConstraintElement> getAlternativeChildren(IConstraintElement ele) {
            if (ele.getType() == ConstraintElementType.ALTERNATIVE) {
                return ele.getChildren();
            }
            return null;
        }

        public Iterable<IConstraintElement> getSequentialChildren(IConstraintElement ele) {
            if (ele.getType() == ConstraintElementType.GROUP) {
                return ele.getChildren();
            }
            return null;
        }

        public AbstractElement getToken(IConstraintElement ele) {
            if (ele.getType() != ConstraintElementType.ALTERNATIVE && ele.getType() != ConstraintElementType.GROUP) {
                return ele.getGrammarElement();
            }
            return null;
        }

        public Iterable<IConstraintElement> getUnorderedChildren(IConstraintElement ele) {
            return null;
        }

        public boolean isMany(IConstraintElement ele) {
            return ele.isMany();
        }

        public boolean isOptional(IConstraintElement ele) {
            return ele.isOptional();
        }

        public IConstraintElement getParent(IConstraintElement ele) {
            return ele.getContainer();
        }

        public IConstraintElement getRoot() {
            return this.root.getBody();
        }
    }

    public static enum ConstraintElementType {
        ALTERNATIVE,
        ASSIGNED_ACTION_CALL,
        ASSIGNED_CROSSREF_DATATYPE_RULE_CALL,
        ASSIGNED_CROSSREF_ENUM_RULE_CALL,
        ASSIGNED_CROSSREF_TERMINAL_RULE_CALL,
        ASSIGNED_CROSSREF_KEYWORD,
        ASSIGNED_DATATYPE_RULE_CALL,
        ASSIGNED_ENUM_RULE_CALL,
        ASSIGNED_KEYWORD,
        ASSIGNED_PARSER_RULE_CALL,
        ASSIGNED_TERMINAL_RULE_CALL,
        GROUP,
        UNORDERED_GROUP;


        public static ConstraintElementType getConstraintElementType(AbstractElement ele) {
            if (ele instanceof Action) {
                if (((Action)ele).getFeature() != null) {
                    return ASSIGNED_ACTION_CALL;
                }
            } else {
                if (ele instanceof Alternatives) {
                    return ALTERNATIVE;
                }
                if (ele instanceof Group) {
                    return GROUP;
                }
                if (ele instanceof UnorderedGroup) {
                    return UNORDERED_GROUP;
                }
                if (GrammarUtil.containingCrossReference(ele) != null) {
                    if (ele instanceof RuleCall) {
                        RuleCall rc = (RuleCall)ele;
                        if (rc.getRule() instanceof ParserRule) {
                            return ASSIGNED_CROSSREF_DATATYPE_RULE_CALL;
                        }
                        if (rc.getRule() instanceof TerminalRule) {
                            return ASSIGNED_CROSSREF_TERMINAL_RULE_CALL;
                        }
                        if (rc.getRule() instanceof EnumRule) {
                            return ASSIGNED_CROSSREF_ENUM_RULE_CALL;
                        }
                    } else if (ele instanceof Keyword) {
                        return ASSIGNED_CROSSREF_KEYWORD;
                    }
                } else if (GrammarUtil.containingAssignment(ele) != null) {
                    if (ele instanceof RuleCall) {
                        RuleCall rc = (RuleCall)ele;
                        if (rc.getRule() instanceof ParserRule) {
                            if (rc.getRule().getType().getClassifier() instanceof EClass) {
                                return ASSIGNED_PARSER_RULE_CALL;
                            }
                            return ASSIGNED_DATATYPE_RULE_CALL;
                        }
                        if (rc.getRule() instanceof TerminalRule) {
                            return ASSIGNED_TERMINAL_RULE_CALL;
                        }
                        if (rc.getRule() instanceof EnumRule) {
                            return ASSIGNED_ENUM_RULE_CALL;
                        }
                    } else if (ele instanceof Keyword) {
                        return ASSIGNED_KEYWORD;
                    }
                }
            }
            throw new RuntimeException("Unknown Grammar Element: " + EmfFormatter.objPath((EObject)ele));
        }
    }

    public static interface IConstraint
    extends Comparable<IConstraint> {
        public IConstraintElement getBody();

        public IFeatureInfo[] getFeatures();

        public String getName();

        public String getSimpleName();

        public EClass getType();

        public List<ISerializationContext> getContexts();

        public Nfa<ISemanticSequencerNfaProvider.ISemState> getNfa();
    }

    public static interface IConstraintElement {
        public Collection<IConstraintElement> getChildren();

        public IConstraintElement getContainer();

        public IConstraint getContainingConstraint();

        public AbstractElement getGrammarElement();

        public ConstraintElementType getType();

        public boolean isMany();

        public boolean isOptional();
    }

    public static interface IFeatureInfo {
        public List<IConstraintElement> getAssignments();

        public IConstraint getContainingConstraint();

        public EStructuralFeature getFeature();

        public int getUpperBound();

        public int getLowerBound();
    }
}

