/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.registration;

import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.registration.MatchableRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.runtime.dto.FilterDTO;

public class FilterRegistration
extends MatchableRegistration<javax.servlet.Filter, FilterDTO>
implements Comparable<FilterRegistration> {
    private final ContextController.ServiceHolder<javax.servlet.Filter> filterHolder;
    private final ClassLoader classLoader;
    private final int priority;
    private final ContextController contextController;
    private final boolean initDestoyWithContextController;
    private final Pattern[] compiledRegexs;

    public FilterRegistration(ContextController.ServiceHolder<javax.servlet.Filter> filterHolder, FilterDTO filterDTO, int priority, ContextController contextController, ClassLoader legacyTCCL) {
        super(filterHolder.get(), filterDTO);
        this.filterHolder = filterHolder;
        this.priority = priority;
        this.contextController = contextController;
        this.compiledRegexs = this.getCompiledRegex(filterDTO);
        this.classLoader = legacyTCCL != null ? legacyTCCL : ((BundleWiring)filterHolder.getBundle().adapt(BundleWiring.class)).getClassLoader();
        String legacyContextFilter = (String)filterHolder.getServiceReference().getProperty("equinox.context.select");
        if (legacyContextFilter != null) {
            Filter f = null;
            try {
                f = FrameworkUtil.createFilter((String)legacyContextFilter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.initDestoyWithContextController = f == null || contextController.matches(f);
        } else {
            this.initDestoyWithContextController = true;
        }
    }

    @Override
    public int compareTo(FilterRegistration otherFilterRegistration) {
        int priorityDifference = this.priority - otherFilterRegistration.priority;
        if (priorityDifference != 0) {
            return -priorityDifference;
        }
        return Math.abs(((FilterDTO)this.getD()).serviceId) > Math.abs(((FilterDTO)otherFilterRegistration.getD()).serviceId) ? 1 : -1;
    }

    @Override
    public void destroy() {
        if (!this.initDestoyWithContextController) {
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.contextController.getHttpServiceRuntime().getRegisteredObjects().remove(this.getT());
            this.contextController.getFilterRegistrations().remove(this);
            this.contextController.ungetServletContextHelper(this.filterHolder.getBundle());
            super.destroy();
            ((javax.servlet.Filter)this.getT()).destroy();
        }
        finally {
            this.destroyContextAttributes();
            Thread.currentThread().setContextClassLoader(original);
            this.filterHolder.release();
        }
    }

    public boolean appliesTo(FilterChainImpl filterChainImpl) {
        return Arrays.binarySearch(((FilterDTO)this.getD()).dispatcher, filterChainImpl.getDispatcherType().name()) >= 0;
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            ((javax.servlet.Filter)this.getT()).doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FilterRegistration)) {
            return false;
        }
        FilterRegistration filterRegistration = (FilterRegistration)obj;
        return ((javax.servlet.Filter)this.getT()).equals(filterRegistration.getT());
    }

    public int hashCode() {
        return Long.valueOf(((FilterDTO)this.getD()).serviceId).hashCode();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (!this.initDestoyWithContextController) {
            return;
        }
        boolean initialized = false;
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.createContextAttributes();
            ((javax.servlet.Filter)this.getT()).init(filterConfig);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.destroyContextAttributes();
            }
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public String match(String name, String requestURI, String extension, Match match) {
        int n;
        int n2;
        Object[] objectArray;
        if (name != null && ((FilterDTO)this.getD()).servletNames != null) {
            objectArray = ((FilterDTO)this.getD()).servletNames;
            n2 = ((FilterDTO)this.getD()).servletNames.length;
            n = 0;
            while (n < n2) {
                String servletName = objectArray[n];
                if (servletName.equals(name)) {
                    return name;
                }
                ++n;
            }
        }
        if (requestURI == null || requestURI.isEmpty()) {
            return null;
        }
        objectArray = ((FilterDTO)this.getD()).patterns;
        n2 = ((FilterDTO)this.getD()).patterns.length;
        n = 0;
        while (n < n2) {
            String pattern = objectArray[n];
            if (this.doPatternMatch(pattern, requestURI, extension)) {
                return pattern;
            }
            ++n;
        }
        objectArray = this.compiledRegexs;
        n2 = this.compiledRegexs.length;
        n = 0;
        while (n < n2) {
            Object regex = objectArray[n];
            if (((Pattern)regex).matcher(requestURI).matches()) {
                return ((Pattern)regex).toString();
            }
            ++n;
        }
        return null;
    }

    @Override
    public String match(String name, String servletPath, String pathInfo, String extension, Match match) {
        throw new UnsupportedOperationException("Should not be calling this method on FilterRegistration");
    }

    private void createContextAttributes() {
        this.contextController.getProxyContext().createContextAttributes(this.contextController);
    }

    private void destroyContextAttributes() {
        this.contextController.getProxyContext().destroyContextAttributes(this.contextController);
    }

    protected boolean isPathWildcardMatch(String pattern, String path) {
        if (path == null) {
            return false;
        }
        if (pattern.endsWith("/*")) {
            int pathPatternLength = pattern.length() - 2;
            if (path.regionMatches(0, pattern, 0, pathPatternLength)) {
                return path.length() <= pathPatternLength || path.charAt(pathPatternLength) == '/';
            }
            return false;
        }
        return pattern.equals(path);
    }

    protected boolean doPatternMatch(String pattern, String path, String extension) throws IllegalArgumentException {
        if (pattern.indexOf("/*.") == 0) {
            pattern = pattern.substring(1);
        }
        int extensionMatchIndex = pattern.indexOf("/*.");
        String extensionWithPrefixMatch = null;
        if (extensionMatchIndex >= 0 && pattern.lastIndexOf(47) == extensionMatchIndex) {
            extensionWithPrefixMatch = pattern.substring(extensionMatchIndex + 3);
            pattern = pattern.substring(0, extensionMatchIndex + 2);
        }
        if (pattern.charAt(0) == '/') {
            if (this.isPathWildcardMatch(pattern, path)) {
                if (extensionWithPrefixMatch != null) {
                    return extensionWithPrefixMatch.equals(extension);
                }
                return true;
            }
            return false;
        }
        if (pattern.charAt(0) == '*') {
            return pattern.substring(2).equals(extension);
        }
        return false;
    }

    private Pattern[] getCompiledRegex(FilterDTO filterDTO) {
        if (filterDTO.regexs == null) {
            return new Pattern[0];
        }
        Pattern[] patterns = new Pattern[filterDTO.regexs.length];
        int i = 0;
        while (i < filterDTO.regexs.length) {
            patterns[i] = Pattern.compile(filterDTO.regexs[i]);
            ++i;
        }
        return patterns;
    }
}

