/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.services;

import org.eclipse.fx.code.editor.services.ContextInformation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public interface CompletionProposal {
    public CharSequence getLabel();

    public void apply(IDocument var1);

    public TextSelection getSelection(IDocument var1);

    public ContextInformation getContextInformation();

    public static class BaseCompletetionProposal
    implements CompletionProposal {
        private final CharSequence label;
        private final String replacementString;
        private final int replacementOffset;
        private final int replacementLength;
        private final int cursorPosition;
        private final ContextInformation contextInformation;

        public BaseCompletetionProposal(String replacementString, int replacementOffset, int replacementLength, CharSequence label, ContextInformation contextInformation) {
            this.replacementString = replacementString;
            this.replacementOffset = replacementOffset;
            this.replacementLength = replacementLength;
            this.cursorPosition = replacementString.length();
            this.label = label;
            this.contextInformation = contextInformation;
        }

        @Override
        public CharSequence getLabel() {
            return this.label;
        }

        public int getReplacementOffset() {
            return this.replacementOffset;
        }

        public int getReplacementLength() {
            return this.replacementLength;
        }

        public String getReplacementString() {
            return this.replacementString;
        }

        public int getCursorPosition() {
            return this.cursorPosition;
        }

        @Override
        public void apply(IDocument document) {
            try {
                document.replace(this.replacementOffset, this.replacementLength, this.replacementString);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        @Override
        public TextSelection getSelection(IDocument document) {
            return new TextSelection(this.replacementOffset + this.cursorPosition, 0);
        }

        @Override
        public ContextInformation getContextInformation() {
            return this.contextInformation;
        }
    }

    public static final class TextSelection {
        public final int offset;
        public final int length;

        public TextSelection(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

