/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.hover.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import javafx.stage.PopupWindow;
import javafx.stage.Screen;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import org.eclipse.fx.text.hover.DefaultHoverInfoType;
import org.eclipse.fx.text.hover.HoverInfo;
import org.eclipse.fx.text.ui.hover.HoverPresenter;
import org.eclipse.fx.text.ui.hover.HoverWindowPresenter;

public class DefaultHoverWindowPresenter
implements HoverWindowPresenter {
    private List<HoverPresenter> presenters = new ArrayList<HoverPresenter>();
    private final Control parent;
    private final PopupWindow popup;
    private final VBox root;
    private List<HoverInfo> currentVisible;
    private boolean preventHide = false;
    private AtomicReference<Boolean> currentScheduledHide = new AtomicReference<Boolean>(true);

    private void scheduleHide(long delay) {
        this.currentScheduledHide.set(true);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), a -> {
            if (this.preventHide) {
                return;
            }
            if (this.currentScheduledHide.get().booleanValue()) {
                this.popup.hide();
            }
        }, new KeyValue[0])});
        t.play();
    }

    private void cancelScheduledHide() {
        this.currentScheduledHide.set(false);
    }

    public DefaultHoverWindowPresenter(Control parent) {
        this.parent = parent;
        this.popup = new PopupWindow(){};
        this.popup.setAutoFix(false);
        this.popup.setAutoHide(false);
        parent.sceneProperty().addListener(e -> {
            if (parent.getScene() != null) {
                this.popup.getScene().getStylesheets().setAll((Collection)parent.getScene().getStylesheets());
            } else {
                this.popup.getScene().getStylesheets().clear();
            }
        });
        this.root = new VBox();
        this.root.setSpacing(3.0);
        this.root.getStyleClass().add((Object)"styled-text-hover");
        this.popup.getScene().setRoot((Parent)this.root);
        this.popup.setOnShowing(this::onShowing);
        this.popup.setOnShown(this::onShown);
        this.root.setOnMouseEntered(this::onMouseEntered);
        this.root.setOnMouseExited(this::onMouseExited);
    }

    private void onMouseEntered(MouseEvent event) {
        this.cancelScheduledHide();
        this.preventHide = true;
        this.setDisableOnWebViews((Node)this.root, false);
    }

    private void onMouseExited(MouseEvent event) {
        this.preventHide = false;
        this.setDisableOnWebViews((Node)this.root, true);
    }

    private void onShowing(WindowEvent event) {
        Screen screen;
        boolean isOk;
        this.root.setPrefHeight(150.0);
        this.root.setPrefWidth(500.0);
        Rectangle2D popupBounds = new Rectangle2D(this.popup.getX(), this.popup.getY(), this.popup.getWidth(), this.popup.getHeight());
        ObservableList screens = Screen.getScreensForRectangle((double)this.popup.getX(), (double)this.popup.getY(), (double)this.popup.getWidth(), (double)this.popup.getHeight());
        System.err.println(popupBounds);
        System.err.println(screens);
        Optional<Screen> popupScreen = screens.stream().filter(s -> s.getBounds().contains(this.popup.getX(), this.popup.getY())).findFirst();
        if (popupScreen.isPresent() && !(isOk = (screen = popupScreen.get()).getBounds().contains(popupBounds))) {
            if (!screen.getBounds().contains(this.popup.getX(), this.popup.getY() + this.popup.getHeight())) {
                double adjustedHeight = screen.getBounds().getMaxY() - this.popup.getY();
                System.err.println("Popup: adjusted height = " + adjustedHeight);
                this.root.setPrefHeight(adjustedHeight);
            }
            if (!screen.getBounds().contains(this.popup.getX() + this.popup.getWidth(), this.popup.getY())) {
                double adjustedX = screen.getBounds().getMaxX() - this.popup.getWidth();
                this.popup.setX(adjustedX);
            }
        }
    }

    private void onShown(WindowEvent event) {
    }

    private Optional<HoverPresenter> findPresenter(HoverInfo hover) {
        return this.presenters.stream().filter(p -> p.isApplicable(hover)).sorted((a, b) -> b.getOrder() - a.getOrder()).findFirst();
    }

    private int compare(HoverInfo a, HoverInfo b) {
        return a.getHoverText().compareTo(b.getHoverText());
    }

    private void populate(List<HoverInfo> hovers) {
        if (this.currentVisible != null && this.currentVisible.equals(hovers)) {
            return;
        }
        this.root.getChildren().clear();
        List errors = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.ERROR).sorted(this::compare).collect(Collectors.toList());
        List warnings = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.WARNING).sorted(this::compare).collect(Collectors.toList());
        List infos = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.INFO).sorted(this::compare).collect(Collectors.toList());
        List docs = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.DOCUMENTATION).sorted(this::compare).collect(Collectors.toList());
        List others = hovers.stream().filter(h -> !errors.contains(h) && !warnings.contains(h) && !infos.contains(h) && !docs.contains(h)).sorted(this::compare).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            VBox errorNode = new VBox();
            errorNode.getStyleClass().add((Object)"errors");
            errorNode.getChildren().addAll((Collection)errors.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)errorNode);
        }
        if (!warnings.isEmpty()) {
            VBox warnNode = new VBox();
            warnNode.getStyleClass().add((Object)"warnings");
            warnNode.getChildren().addAll((Collection)warnings.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)warnNode);
        }
        if (!infos.isEmpty()) {
            VBox infoNode = new VBox();
            infoNode.getStyleClass().add((Object)"infos");
            infoNode.getChildren().addAll((Collection)infos.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)infoNode);
        }
        if (!docs.isEmpty()) {
            VBox docsNode = new VBox();
            docsNode.getStyleClass().add((Object)"docs");
            docsNode.getChildren().addAll((Collection)docs.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)docsNode);
        }
        if (!others.isEmpty()) {
            VBox othersNode = new VBox();
            othersNode.getStyleClass().add((Object)"others");
            othersNode.getChildren().addAll((Collection)others.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)othersNode);
        }
        this.currentVisible = hovers;
        this.setDisableOnWebViews((Node)this.root, true);
    }

    void setDisableOnWebViews(Node cur, boolean state) {
        if (cur instanceof WebView) {
            cur.setDisable(state);
        } else if (cur instanceof Parent) {
            ((Parent)cur).getChildrenUnmodifiable().forEach(n -> this.setDisableOnWebViews((Node)n, state));
        }
    }

    @Override
    public void show(Point2D screenAnchor, Bounds screenBounds, List<HoverInfo> hover) {
        this.cancelScheduledHide();
        this.populate(hover);
        this.popup.show(this.parent.getScene().getWindow(), screenAnchor.getX(), screenAnchor.getY());
    }

    @Override
    public void hide() {
        this.scheduleHide(300L);
    }

    public void setHoverPresenter(List<HoverPresenter> hoverPresenters) {
        this.presenters = hoverPresenters;
    }
}

