/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.manager;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.helper.BundleSessionHelper;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.IProductionContext;
import org.eclipse.egf.core.producer.context.ProductionContext;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.fcore.NamedModelElement;
import org.eclipse.egf.model.types.Type;
import org.eclipse.egf.model.types.TypeAbstractClass;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.l10n.ProducerMessages;
import org.eclipse.egf.producer.manager.IModelElementManager;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElementManager<P extends ModelElement, T extends ModelElement>
implements IModelElementManager<P, T> {
    private P _element;
    protected IModelElementManager<?, ?> _parent;
    protected IProductionContext<P, T> _productionContext;
    private Bundle _bundle;
    private ProjectBundleSession _session;
    private IPlatformFcore _fcore;

    protected static BasicDiagnostic getDiagnostic(ModelElement element, boolean runtime) {
        NamedModelElement namedElement;
        String message = null;
        if (element instanceof NamedModelElement && (namedElement = (NamedModelElement)element).getName() != null && namedElement.getName().trim().length() != 0) {
            message = runtime ? NLS.bind((String)ProducerMessages.RuntimeCanInvoke_Diagnosis_message, (Object)namedElement.getName()) : NLS.bind((String)ProducerMessages.CanInvoke_Diagnosis_message, (Object)namedElement.getName());
        }
        if (message == null) {
            message = runtime ? NLS.bind((String)ProducerMessages.RuntimeCanInvoke_Diagnosis_message, (Object)element.eClass().getName()) : NLS.bind((String)ProducerMessages.CanInvoke_Diagnosis_message, (Object)element.eClass().getName());
        }
        return new BasicDiagnostic(EGFProducerPlugin.getDefault().getPluginID(), 0, message, new Object[]{element});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static <M extends ModelElement> void populateContext(ProductionContext<?, M> context, Bundle bundle, M key, ContractMode mode, Type type, Object value) throws InvocationException {
        if (type instanceof TypeAbstractClass) {
            try {
                Object object = null;
                String fqcn = (String)value;
                if (fqcn != null && fqcn.trim().length() != 0 && (object = BundleHelper.instantiate((String)fqcn.trim(), (Bundle)bundle)) == null) {
                    throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_BundleClassInstantiationFailure, (Object)value, (Object)bundle.getSymbolicName()), null)));
                }
                if (mode == ContractMode.IN) {
                    context.addInputData(key, type.getType(), object, true);
                    return;
                }
                if (mode == ContractMode.OUT) {
                    context.addOutputData(key, type.getType(), null, true);
                    return;
                }
                if (mode != ContractMode.IN_OUT) return;
                context.addInputData(key, type.getType(), object, true);
                context.addOutputData(key, type.getType(), object, true);
                return;
            }
            catch (Throwable t) {
                throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_BundleClassInstantiationFailure, (Object)value), t)));
            }
        } else if (mode == ContractMode.IN) {
            context.addInputData(key, type.getType(), value, true);
            return;
        } else if (mode == ContractMode.OUT) {
            context.addOutputData(key, type.getType(), null, true);
            return;
        } else {
            if (mode != ContractMode.IN_OUT) return;
            context.addInputData(key, type.getType(), value, true);
            context.addOutputData(key, type.getType(), value, true);
        }
    }

    public ModelElementManager(P element) throws InvocationException {
        Assert.isNotNull(element);
        this._element = element;
        if (this._element.eResource() == null) {
            throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.EObject_no_Resource, (Object)EcoreUtil.getURI(this._element)), null)));
        }
        this._fcore = ((IPlatformFcoreProvider)this._element.eResource()).getIPlatformFcore();
        if (this._fcore == null) {
            throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.Fcore_not_found, (Object)EcoreUtil.getURI(this._element).trimFragment()), null)));
        }
    }

    public ModelElementManager(IModelElementManager<?, ?> parent, P element) throws InvocationException {
        Assert.isNotNull(parent);
        Assert.isNotNull(element);
        this._parent = parent;
        this._element = element;
        if (this._element.eResource() == null && parent.getBundle() == null) {
            throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.EObject_no_Resource, (Object)EcoreUtil.getURI(this._element)), null)));
        }
        if (this._element.eResource() != null) {
            this._fcore = ((IPlatformFcoreProvider)this._element.eResource()).getIPlatformFcore();
            if (this._fcore == null) {
                throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.Fcore_not_found, (Object)EcoreUtil.getURI(this._element).trimFragment()), null)));
            }
        } else {
            Assert.isNotNull((Object)parent.getBundle());
        }
    }

    public ModelElementManager(Bundle bundle, P element) {
        Assert.isNotNull((Object)bundle);
        Assert.isNotNull(element);
        this._bundle = bundle;
        this._element = element;
    }

    public P getElement() {
        return this._element;
    }

    public IProductionContext<P, T> getProductionContext() throws InvocationException {
        return this.getInternalProductionContext();
    }

    public IModelElementManager<?, ?> getParent() {
        return this._parent;
    }

    protected abstract ProductionContext<P, T> getInternalProductionContext() throws InvocationException;

    public String getName() {
        return EMFHelper.getText(this.getElement());
    }

    public Bundle getBundle() throws InvocationException {
        if (this._fcore != null) {
            try {
                return BundleSessionHelper.getBundle((ProjectBundleSession)this.getProjectBundleSession(), (IPlatformExtensionPoint)this._fcore);
            }
            catch (Throwable t) {
                throw new InvocationException(t);
            }
        }
        if (this.getParent() != null) {
            return this.getParent().getBundle();
        }
        return this._bundle;
    }

    public ProjectBundleSession getProjectBundleSession() {
        if (this.getParent() != null) {
            return this.getParent().getProjectBundleSession();
        }
        if (this._session == null) {
            this._session = new ProjectBundleSession(EGFProducerPlugin.getDefault().getBundle().getBundleContext());
        }
        return this._session;
    }

    protected BasicDiagnostic checkInputElement(boolean runtime) throws InvocationException {
        return ModelElementManager.getDiagnostic(this.getElement(), runtime);
    }

    protected BasicDiagnostic checkOutputElement(BasicDiagnostic diagnostic) throws InvocationException {
        return diagnostic;
    }

    public Diagnostic canInvoke() throws InvocationException {
        return this.checkInputElement(false);
    }

    public abstract void initializeContext() throws InvocationException;

    public void dispose() throws InvocationException {
        if (this._session != null) {
            try {
                this._session.dispose();
            }
            catch (Throwable t) {
                throw new InvocationException(t);
            }
        }
    }
}

