/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.commands.resource;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.model.fcore.util.FcoreResourceImpl;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.commands.PatternLibraryAddPatternCommand;
import org.eclipse.egf.model.pattern.commands.PatternLibraryRemovePatternCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreResourceAddCommand
extends AddCommand {
    protected Map<PatternLibrary, List<Pattern>> _patterns;
    protected Map<PatternMethod, URI[]> _methods;
    protected FcoreResourceImpl _resource = null;
    protected boolean _copy;

    public FcoreResourceAddCommand(EditingDomain domain, FcoreResourceImpl resource, Collection<?> collection) {
        this(domain, resource, collection, -1);
    }

    public FcoreResourceAddCommand(EditingDomain domain, FcoreResourceImpl resource, Collection<?> collection, int index) {
        super(domain, resource.getContents(), collection, index);
        this._resource = resource;
    }

    public FcoreResourceAddCommand(EditingDomain domain, FcoreResourceImpl resource, Object value) {
        this(domain, resource, value, -1);
    }

    public FcoreResourceAddCommand(EditingDomain domain, FcoreResourceImpl resource, Object value, int index) {
        super(domain, resource.getContents(), value, index);
        this._resource = resource;
    }

    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        if (this.domain.isReadOnly((Resource)this._resource)) {
            return false;
        }
        if (this._resource == null || EMFHelper.getProject((Resource)this._resource) == null) {
            return false;
        }
        this._patterns = new HashMap<PatternLibrary, List<Pattern>>();
        this._methods = new HashMap<PatternMethod, URI[]>();
        for (Object object : this.collection) {
            if (!(object instanceof EObject)) continue;
            Collection eObjects = EMFHelper.getAllProperContents((EClassifier)PatternPackage.eINSTANCE.getPattern(), (EObject)((EObject)object));
            for (EObject eObject : eObjects) {
                Pattern pattern = (Pattern)eObject;
                UniqueEList patterns = this._patterns.get(pattern.getContainer());
                if (patterns == null) {
                    patterns = new UniqueEList();
                    this._patterns.put(pattern.getContainer(), (List<Pattern>)patterns);
                }
                patterns.add((Pattern)pattern);
                try {
                    for (PatternMethod method : pattern.getMethods()) {
                        URI[] uRIArray = new URI[2];
                        uRIArray[0] = method.getPatternFilePath();
                        this._methods.put(method, uRIArray);
                    }
                }
                catch (Throwable t) {
                    return false;
                }
            }
        }
        return true;
    }

    public void doExecute() {
        super.doExecute();
        this._copy = PatternLibraryAddPatternCommand.performCreatePatternTemplates((Resource)this._resource, this._methods);
    }

    public void doUndo() {
        if (this._copy) {
            for (Map.Entry<PatternLibrary, List<Pattern>> entry : this._patterns.entrySet()) {
                PatternLibraryRemovePatternCommand.performDeletePatterns((Resource)this._resource, (Collection<Pattern>)entry.getValue());
            }
        }
        super.doUndo();
    }

    public void doRedo() {
        if (this._copy) {
            for (List<Pattern> patterns : this._patterns.values()) {
                PatternLibraryRemovePatternCommand.performRestorePatterns((Resource)this._resource, patterns);
            }
        }
        super.doRedo();
    }
}

