/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.activator.EGFAbstractPlugin;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.core.platform.internal.pde.PlatformManager;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointFactory;
import org.eclipse.egf.core.platform.pde.IPlatformManager;
import org.eclipse.egf.core.platform.uri.PlatformURIConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EGFPlatformPlugin
extends EGFAbstractPlugin {
    private static EGFPlatformPlugin __plugin;
    private static PlatformManager __platformManager;
    private static PlatformURIConverter __platformURIConverter;
    private static Map<String, IConfigurationElement> __managerExtensionPoints;
    private static Map<String, Class<? extends IPlatformExtensionPoint>> __platformExtensionPoints;
    private static Collection<Class<? extends IPlatformExtensionPoint>> __platformExtensionPointClasses;
    private static Map<Class<? extends IPlatformExtensionPoint>, IPlatformExtensionPointFactory<? extends IPlatformExtensionPoint>> __platformExtensionPointFactories;

    public static EGFPlatformPlugin getDefault() {
        return __plugin;
    }

    public static IPlatformManager getPlatformManager() {
        return __platformManager;
    }

    public static PlatformURIConverter getPlatformURIConverter() {
        return __platformURIConverter;
    }

    public Map<String, IConfigurationElement> getManagerExtensionPoints() {
        if (__managerExtensionPoints == null) {
            IConfigurationElement[] elements;
            HashMap<String, IConfigurationElement> platformManagers = new HashMap<String, IConfigurationElement>();
            HashMap<String, Class<? extends IPlatformExtensionPoint>> interfaces = new HashMap<String, Class<? extends IPlatformExtensionPoint>>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EGFPlatformPlugin.getDefault().getBundle().getSymbolicName(), "manager");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String extension = element.getAttribute("extension");
                if (extension != null && extension.trim().length() != 0) {
                    if (platformManagers.containsKey(extension = extension.trim())) {
                        EGFPlatformPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Duplicate_Element_Message, (Object)extension));
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)element.getContributor().getName()), 1);
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)element.getName()), 1);
                    } else {
                        long startTimeFactory = System.currentTimeMillis();
                        Object factory = null;
                        try {
                            factory = element.createExecutableExtension("class");
                        }
                        catch (Throwable t) {
                            EGFPlatformPlugin.getDefault().logError(t);
                        }
                        if (EGFPlatformPlugin.getDefault().isDebugging()) {
                            long endTime = System.currentTimeMillis();
                            long time = endTime - startTimeFactory;
                            EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"EGFPlatformPlugin _ create factory ''{0}'' in ''{1}'' ms", (Object)element.getAttribute("extension"), (Object)time));
                        }
                        if (factory != null) {
                            if (!(factory instanceof IPlatformExtensionPointFactory)) {
                                EGFPlatformPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)factory.getClass().getName()));
                                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Wrong_Class_Sub_Type_Message, (Object)IPlatformExtensionPointFactory.class.getName()), 1);
                                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)element.getContributor().getName()), 1);
                                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)element.getName()), 1);
                                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)extension), 1);
                            } else {
                                Class<? extends IPlatformExtensionPoint> clazz = EGFPlatformPlugin.fetchReturnedTypeFromFactory(factory.getClass());
                                if (clazz == null) {
                                    EGFPlatformPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)factory.getClass().getName()));
                                    EGFPlatformPlugin.getDefault().logInfo("Unable to find ''createExtensionPoint(IPlatformBundle platformBundle, IPluginElement pluginElement)'' method.");
                                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)element.getContributor().getName()), 1);
                                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)element.getName()), 1);
                                } else if (interfaces.get(factory.getClass().getName()) != null) {
                                    EGFPlatformPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Duplicate_Element_Message, (Object)factory.getClass().getName()));
                                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)element.getContributor().getName()), 1);
                                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)element.getName()), 1);
                                } else {
                                    platformManagers.put(extension, element);
                                    interfaces.put(factory.getClass().getName(), clazz);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
            __managerExtensionPoints = platformManagers;
        }
        return __managerExtensionPoints;
    }

    public static Map<String, Class<? extends IPlatformExtensionPoint>> getPlatformExtensionPoints() {
        if (__platformExtensionPoints == null) {
            Map<String, IConfigurationElement> platformManagers = EGFPlatformPlugin.getDefault().getManagerExtensionPoints();
            HashMap<String, Class<? extends IPlatformExtensionPoint>> extensionPoints = new HashMap<String, Class<? extends IPlatformExtensionPoint>>();
            for (Map.Entry<String, IConfigurationElement> entry : platformManagers.entrySet()) {
                IPlatformExtensionPointFactory clazz = null;
                try {
                    clazz = (IPlatformExtensionPointFactory)entry.getValue().createExecutableExtension("class");
                }
                catch (CoreException ce) {
                    EGFPlatformPlugin.getDefault().logError(ce);
                }
                if (clazz == null) continue;
                Class<? extends IPlatformExtensionPoint> key = EGFPlatformPlugin.fetchReturnedTypeFromFactory(clazz.getClass());
                extensionPoints.put(entry.getKey(), key);
            }
            __platformExtensionPoints = extensionPoints;
        }
        return __platformExtensionPoints;
    }

    public static Collection<Class<? extends IPlatformExtensionPoint>> getPlatformExtensionPointClasses() {
        if (__platformExtensionPointClasses == null) {
            __platformExtensionPointClasses = EGFPlatformPlugin.getPlatformExtensionPoints().values();
        }
        return __platformExtensionPointClasses;
    }

    public static Map<Class<? extends IPlatformExtensionPoint>, IPlatformExtensionPointFactory<? extends IPlatformExtensionPoint>> getPlatformExtensionPointFactories() {
        if (__platformExtensionPointFactories == null) {
            Map<String, IConfigurationElement> platformManagers = EGFPlatformPlugin.getDefault().getManagerExtensionPoints();
            HashMap<Class<? extends IPlatformExtensionPoint>, IPlatformExtensionPointFactory<? extends IPlatformExtensionPoint>> extensionPointFactories = new HashMap<Class<? extends IPlatformExtensionPoint>, IPlatformExtensionPointFactory<? extends IPlatformExtensionPoint>>();
            for (Map.Entry<String, IConfigurationElement> entry : platformManagers.entrySet()) {
                IPlatformExtensionPointFactory clazz = null;
                try {
                    clazz = (IPlatformExtensionPointFactory)entry.getValue().createExecutableExtension("class");
                }
                catch (CoreException ce) {
                    EGFPlatformPlugin.getDefault().logError(ce);
                }
                if (clazz == null) continue;
                Class<? extends IPlatformExtensionPoint> key = EGFPlatformPlugin.fetchReturnedTypeFromFactory(clazz.getClass());
                extensionPointFactories.put(key, clazz);
            }
            __platformExtensionPointFactories = extensionPointFactories;
        }
        return __platformExtensionPointFactories;
    }

    public static Class<? extends IPlatformExtensionPoint> fetchReturnedTypeFromFactory(Class<?> factory) {
        Method method = null;
        try {
            method = factory.getDeclaredMethod("createExtensionPoint", IPlatformBundle.class, IPluginElement.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            return null;
        }
        Type type = null;
        try {
            type = method.getGenericReturnType();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (type == null) {
            return null;
        }
        try {
            return (Class)type;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
        __platformURIConverter = new PlatformURIConverter();
        __platformManager = new PlatformManager();
    }

    public void stop(BundleContext context) throws Exception {
        __platformManager.dispose();
        __platformURIConverter.dispose();
        __platformManager = null;
        __platformURIConverter = null;
        __managerExtensionPoints = null;
        __platformExtensionPoints = null;
        __platformExtensionPointClasses = null;
        __platformExtensionPointFactories = null;
        __plugin = null;
        super.stop(context);
    }
}

