/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build.buildscm.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.provider.SCMLocationItemProvider;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.BuildscmPackage;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.SVNLocation;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.provider.BuildSCMEditPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNLocationItemProvider
extends SCMLocationItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public static final String copyright = "   Copyright (c) 2009-2010 Thales Corporate Services S.A.S.\r\n   All rights reserved. This program and the accompanying materials\r\n   are made available under the terms of the Eclipse Public License v1.0\r\n   which accompanies this distribution, and is available at\r\n   http://www.eclipse.org/legal/epl-v10.html\r\n  \r\n   Contributors:\r\n       Thales Corporate Services S.A.S - initial API and implementation";

    public SVNLocationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addProtocolPropertyDescriptor(object);
            this.addUrlPropertyDescriptor(object);
            this.addLocalPathPropertyDescriptor(object);
            this.addUsernamePropertyDescriptor(object);
            this.addPasswordPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addProtocolPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SVNLocation_protocol_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SVNLocation_protocol_feature", "_UI_SVNLocation_type"), (EStructuralFeature)BuildscmPackage.Literals.SVN_LOCATION__PROTOCOL, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addUrlPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SVNLocation_url_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SVNLocation_url_feature", "_UI_SVNLocation_type"), (EStructuralFeature)BuildscmPackage.Literals.SVN_LOCATION__URL, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addLocalPathPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SVNLocation_localPath_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SVNLocation_localPath_feature", "_UI_SVNLocation_type"), (EStructuralFeature)BuildscmPackage.Literals.SVN_LOCATION__LOCAL_PATH, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addUsernamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SVNLocation_username_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SVNLocation_username_feature", "_UI_SVNLocation_type"), (EStructuralFeature)BuildscmPackage.Literals.SVN_LOCATION__USERNAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addPasswordPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SVNLocation_password_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SVNLocation_password_feature", "_UI_SVNLocation_type"), (EStructuralFeature)BuildscmPackage.Literals.SVN_LOCATION__PASSWORD, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/SVNLocation"));
    }

    @Override
    public String getText(Object object) {
        String protocol = ((SVNLocation)object).getProtocol().getLiteral();
        String label = ((SVNLocation)object).getUrl();
        return label == null || label.length() == 0 || protocol == null || protocol.length() == 0 ? this.getString("_UI_SVNLocation_type") : String.valueOf(this.getString("_UI_SVNLocation_type")) + " " + protocol + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(SVNLocation.class)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return BuildSCMEditPlugin.INSTANCE;
    }
}

