/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.dialogs;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.RuntimePlatformResourceSet;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.dialogs.AbstractFilteredItemsSelectionDialog;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.editor.l10n.ModelEditorMessages;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.provider.FcoreItemProviderAdapterFactory;
import org.eclipse.egf.model.fcore.provider.FcoreResourceItemProviderAdapterFactory;
import org.eclipse.egf.model.fprod.provider.FprodItemProviderAdapterFactory;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivitySelectionDialog
extends AbstractFilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.egf.model.editor.dialogs.ActivitySelectionDialog";
    private Button _targetButton;
    private Button _runtimeButton;
    private boolean _hasRuntimeSupport;
    private boolean _isTargetPlatformVersion;
    private Activity _activity;
    private ResourceSet _resourceSet;
    private ComposedAdapterFactory _adapterFactory;
    private IPlatformFcore[] _content = null;
    private IPlatformFcore[] _targetFcores = EGFCorePlugin.getTargetPlatformFcores();
    private IPlatformFcore[] _runtimeFcores = EGFCorePlugin.getRuntimePlatformFcores();

    protected ILabelProvider getLabelProvider() {
        return new ActivityLabelProvider((AdapterFactory)this._adapterFactory);
    }

    protected ILabelDecorator getSelectionLabelProvider() {
        return new ActivitySelectionLabelProvider((AdapterFactory)this._adapterFactory);
    }

    protected ILabelProvider getDetailsLabelProvider() {
        return new ActivityDetailsLabelProvider((AdapterFactory)this._adapterFactory);
    }

    public ActivitySelectionDialog(Shell shell, boolean multipleSelection) {
        this(shell, (Activity)null, multipleSelection);
    }

    public ActivitySelectionDialog(Shell shell, IPlatformFcore fcore, boolean multipleSelection) {
        this(shell, multipleSelection);
        if (fcore != null) {
            this._targetFcores = new IPlatformFcore[]{fcore};
            this.setSeparatorLabel(NLS.bind((String)CoreUIMessages._UI_FilteredItemsSelectionDialog_separatorLabel, (Object)fcore.getPlatformBundle().getBundleId()));
        }
    }

    public ActivitySelectionDialog(Shell shell, Activity activity, boolean multipleSelection) {
        this(shell, activity, multipleSelection, false);
    }

    public ActivitySelectionDialog(Shell shell, Activity activity, boolean multipleSelection, boolean runtime) {
        super(shell, multipleSelection);
        this._resourceSet = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID).getResourceSet();
        this._content = this._targetFcores;
        if (activity != null) {
            this._activity = (Activity)this._resourceSet.getEObject(EcoreUtil.getURI((EObject)activity), true);
        }
        this._adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FcoreResourceItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FprodItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FcoreItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this._hasRuntimeSupport = runtime;
        this.setListLabelProvider(this.getLabelProvider());
        this.setListSelectionLabelDecorator(this.getSelectionLabelProvider());
        this.setDetailsLabelProvider(this.getDetailsLabelProvider());
        this.setSelectionHistory(new ActivitySelectionHistory());
        this.setTitle(NLS.bind((String)CoreUIMessages._UI_GenericSelectionDialog_dialogTitle, (Object)Activity.class.getSimpleName()));
        this.setMessage(NLS.bind((String)CoreUIMessages._UI_GenericSelectionDialog_dialogMessage, (Object)Activity.class.getSimpleName()));
        if (this._activity != null && this._activity.eResource() != null && this._activity.eResource() instanceof IPlatformFcoreProvider) {
            IPlatformFcore fcore = ((IPlatformFcoreProvider)this._activity.eResource()).getIPlatformFcore();
            this.setSeparatorLabel(NLS.bind((String)CoreUIMessages._UI_FilteredItemsSelectionDialog_separatorLabel, (Object)fcore.getPlatformBundle().getBundleId()));
        } else {
            this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_platformSeparatorLabel);
        }
    }

    protected void handleSelected(StructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        super.handleSelected(selection);
        if (selection.size() != 0) {
            UniqueEList activities = new UniqueEList();
            for (Object object : selection.toList()) {
                if (!(object instanceof Activity)) continue;
                activities.add((Activity)object);
            }
            this.notifySelectionListeners(activities.toArray());
        }
    }

    public Shell getShell() {
        return super.getShell() != null ? super.getShell() : this.getParentShell();
    }

    public Control createPage(Composite parent) {
        this.dialogArea = this.createDialogArea(parent);
        return this.dialogArea;
    }

    public Object[] getResult() {
        Object[] result = super.getResult();
        if (result == null) {
            return null;
        }
        ArrayList<Activity> resultToReturn = new ArrayList<Activity>();
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof Activity) {
                resultToReturn.add((Activity)result[i]);
            }
            ++i;
        }
        return resultToReturn.toArray();
    }

    protected Control createExtendedContentArea(Composite parent) {
        if (this._hasRuntimeSupport) {
            Composite buttonGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            buttonGroup.setLayout((Layout)layout);
            this._targetButton = new Button(buttonGroup, 16);
            this._targetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ActivitySelectionDialog.this._isTargetPlatformVersion = ActivitySelectionDialog.this._targetButton.getSelection();
                    ActivitySelectionDialog.this.updateMode();
                    FilteredItemsSelectionDialog.SelectionHistory history = ActivitySelectionDialog.this.getSelectionHistory();
                    if (history != null) {
                        Object[] objectArray = history.getHistoryItems();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            history.remove(object);
                            ++n2;
                        }
                    }
                    ActivitySelectionDialog.this.applyFilter();
                }
            });
            this._targetButton.setText(ModelEditorMessages._UI_TargetPlatformVersion_label);
            this._targetButton.setSelection(true);
            this._isTargetPlatformVersion = true;
            this._runtimeButton = new Button(buttonGroup, 16);
            this._runtimeButton.setText(ModelEditorMessages._UI_RuntimePlatformVersion_label);
            this._runtimeButton.setSelection(false);
        }
        return parent;
    }

    protected void updateMode() {
        if (this._isTargetPlatformVersion) {
            this._resourceSet = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID).getResourceSet();
            this._content = this._targetFcores;
            this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_platformSeparatorLabel);
        } else {
            this._resourceSet = new RuntimePlatformResourceSet();
            this._content = this._runtimeFcores;
            this.setSeparatorLabel(CoreUIMessages._UI_FilteredItemsSelectionDialog_runtimeSeparatorLabel);
        }
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ActivitySearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        SubMonitor innerMonitor = SubMonitor.convert((IProgressMonitor)monitor, null, (int)(this._content.length * 100));
        try {
            IPlatformFcore[] iPlatformFcoreArray = this._content;
            int n = this._content.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    IPlatformFcore fcore = iPlatformFcoreArray[n2];
                    Resource resource = null;
                    try {
                        resource = this._resourceSet.getResource(fcore.getURI(), true);
                    }
                    catch (OperationCanceledException e) {
                        return;
                    }
                    catch (Exception e) {
                        EGFModelEditorPlugin.getPlugin().logError(e);
                        break block11;
                    }
                    if (resource != null) {
                        for (EObject eObject : resource.getContents()) {
                            if (this._activity != null && EcoreUtil.getURI((EObject)this._activity).equals((Object)EcoreUtil.getURI((EObject)eObject))) continue;
                            try {
                                if (!this.selectElement(eObject)) continue;
                                contentProvider.add((Object)eObject, itemsFilter);
                            }
                            catch (OperationCanceledException e) {
                                return;
                            }
                            catch (ClassCastException classCastException) {
                                // empty catch block
                            }
                        }
                        innerMonitor.worked(100);
                    }
                }
                ++n2;
            }
        }
        catch (OperationCanceledException e) {
            return;
        }
    }

    protected boolean selectElement(EObject eObject) {
        return true;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = EGFModelEditorPlugin.getPlugin().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = EGFModelEditorPlugin.getPlugin().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IPlatformFcore) {
            IPlatformFcore fc = (IPlatformFcore)item;
            return fc.getURI().toString();
        }
        return null;
    }

    protected Comparator<Activity> getItemsComparator() {
        return new ActivitySearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, EGFModelEditorPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", null);
    }

    private class ActivityDetailsLabelProvider
    extends LabelProvider {
        ILabelProvider _adapterFactoryLabelProvider;

        public ActivityDetailsLabelProvider(AdapterFactory adapterFactory) {
            this._adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory);
        }

        public Image getImage(Object element) {
            if (!(element instanceof Activity)) {
                return this._adapterFactoryLabelProvider.getImage(element);
            }
            Activity activity = (Activity)element;
            if (activity.eResource() == null || !(activity.eResource() instanceof IPlatformFcoreProvider)) {
                return this._adapterFactoryLabelProvider.getImage((Object)activity);
            }
            IPlatformFcore fcore = ((IPlatformFcoreProvider)activity.eResource()).getIPlatformFcore();
            if (fcore == null) {
                return this._adapterFactoryLabelProvider.getImage((Object)activity);
            }
            File file = new File(fcore.getPlatformBundle().getInstallLocation());
            if (file.exists() && file.isDirectory()) {
                return EGFCoreUIPlugin.getDefault().getImage("obj16/directory.gif");
            }
            if (file.exists() && file.isFile()) {
                return EGFCoreUIPlugin.getDefault().getImage("obj16/jar.gif");
            }
            return EGFCoreUIPlugin.getDefault().getImage("obj16/fcore.gif");
        }

        public String getText(Object element) {
            if (!(element instanceof Activity)) {
                return this._adapterFactoryLabelProvider.getText(element);
            }
            Activity activity = (Activity)element;
            if (activity.eResource() == null || !(activity.eResource() instanceof IPlatformFcoreProvider)) {
                return this._adapterFactoryLabelProvider.getText((Object)activity);
            }
            IPlatformFcore fcore = ((IPlatformFcoreProvider)activity.eResource()).getIPlatformFcore();
            if (fcore == null) {
                return this._adapterFactoryLabelProvider.getText((Object)activity);
            }
            StringBuffer buffer = new StringBuffer();
            if (fcore.isTarget()) {
                buffer.append(" [Target]");
            } else if (fcore.isRuntime()) {
                buffer.append(" [Runtime]");
            } else {
                buffer.append(" [Workspace]");
            }
            buffer.append(" [");
            buffer.append(fcore.getPlatformBundle().getInstallLocation());
            buffer.append("]");
            return buffer.toString();
        }
    }

    private class ActivityLabelProvider
    extends AdapterFactoryLabelProvider
    implements ILabelDecorator {
        public ActivityLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getText(Object element) {
            if (!(element instanceof Activity)) {
                return super.getText(element);
            }
            return ((Activity)element).getName();
        }

        public String decorateText(String text, Object element) {
            return this.getText(element);
        }

        public Image decorateImage(Image image, Object element) {
            return this.getImage(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActivitySearchComparator
    implements Comparator<Activity>,
    Serializable {
        public static final long serialVersionUID = 1L;

        private ActivitySearchComparator() {
        }

        @Override
        public int compare(Activity a1, Activity a2) {
            if (a1.getName() == null && a2.getName() == null) {
                return 0;
            }
            if (a1.getName() != null && a2.getName() == null) {
                return -1;
            }
            if (a1.getName() == null && a2.getName() != null) {
                return 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }

    private class ActivitySearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private ActivitySearchItemsFilter() {
            super((FilteredItemsSelectionDialog)ActivitySelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof Activity)) {
                return false;
            }
            Activity activity = (Activity)item;
            if (activity.getName() == null) {
                return true;
            }
            return this.matches(activity.getName());
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof Activity;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            return filter instanceof ActivitySearchItemsFilter && filter == this;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.equalsFilter(filter)) {
                return false;
            }
            return filter instanceof ActivitySearchItemsFilter && filter == this;
        }
    }

    private class ActivitySelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private static final String TAG_TARGET_PLATFORM = "target";
        private static final String TAG_URI = "path";

        protected Object restoreItemFromMemento(IMemento memento) {
            String tagURI = memento.getString(TAG_URI);
            if (tagURI == null) {
                return null;
            }
            Boolean tagMode = memento.getBoolean(TAG_TARGET_PLATFORM);
            if (tagMode == null) {
                return null;
            }
            if (ActivitySelectionDialog.this._hasRuntimeSupport) {
                ActivitySelectionDialog.this._isTargetPlatformVersion = tagMode;
                ActivitySelectionDialog.this._targetButton.setSelection(ActivitySelectionDialog.this._isTargetPlatformVersion);
                ActivitySelectionDialog.this._runtimeButton.setSelection(!ActivitySelectionDialog.this._isTargetPlatformVersion);
                ActivitySelectionDialog.this.updateMode();
            }
            try {
                IPlatformFcore fcore;
                Activity activity = (Activity)ActivitySelectionDialog.this._resourceSet.getEObject(URI.createURI((String)tagURI), true);
                if (activity.eResource() instanceof IPlatformFcoreProvider && (fcore = ((IPlatformFcoreProvider)activity.eResource()).getIPlatformFcore()) != null) {
                    IPlatformFcore[] iPlatformFcoreArray = ActivitySelectionDialog.this._content;
                    int n = iPlatformFcoreArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPlatformFcore innerFcore = iPlatformFcoreArray[n2];
                        if (innerFcore.equals(fcore)) {
                            return activity;
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            if (ActivitySelectionDialog.this._hasRuntimeSupport) {
                element.putString(TAG_TARGET_PLATFORM, Boolean.toString(ActivitySelectionDialog.this._isTargetPlatformVersion));
            } else {
                element.putString(TAG_TARGET_PLATFORM, Boolean.toString(true));
            }
            if (ActivitySelectionDialog.this.getReturnCode() == 0) {
                Object[] items = this.getHistoryItems();
                int i = 0;
                while (i < items.length) {
                    element.putString(TAG_URI, EcoreUtil.getURI((EObject)((Activity)items[i])).toString());
                    ++i;
                }
            } else if (ActivitySelectionDialog.this._activity != null) {
                element.putString(TAG_URI, EcoreUtil.getURI((EObject)ActivitySelectionDialog.this._activity).toString());
            }
        }
    }

    private class ActivitySelectionLabelProvider
    extends AdapterFactoryLabelProvider
    implements ILabelDecorator {
        public ActivitySelectionLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String decorateText(String text, Object element) {
            if (!(element instanceof Activity)) {
                return this.getText(element);
            }
            return String.valueOf(this.getText(element)) + " -> " + EcoreUtil.getURI((EObject)((Activity)element)).trimFragment();
        }

        public Image decorateImage(Image image, Object element) {
            return this.getImage(element);
        }
    }
}

