/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.console.preferences;

import org.eclipse.egf.common.ui.fields.BooleanFieldEditor2;
import org.eclipse.egf.console.EGFConsolePlugin;
import org.eclipse.egf.console.l10n.ConsoleMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EGFPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor2 _wrapEditor = null;
    private ConsoleIntegerFieldEditor _widthEditor = null;
    private ColorFieldEditor _errorColorEditor;
    private ColorFieldEditor _infoColorEditor;
    private ColorFieldEditor _warningColorEditor;
    private ColorFieldEditor _backgroundColorEditor;
    private BooleanFieldEditor2 _showOnMessage;
    private BooleanFieldEditor2 _restrictOutput;
    private ConsoleIntegerFieldEditor _highWaterMark;

    public EGFPreferencePage() {
        super(1);
        this.setDescription(ConsoleMessages.ConsolePreferencePage_General);
        this.setPreferenceStore(EGFConsolePlugin.getDefault().getPreferenceStore());
    }

    protected boolean canClearErrorMessage() {
        return this._widthEditor.isValid() && this._highWaterMark.isValid();
    }

    private ColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        ColorFieldEditor editor = new ColorFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    protected void updateWidthEditor() {
        Button b = this._wrapEditor.getChangeControl(this.getFieldEditorParent());
        this._widthEditor.getTextControl(this.getFieldEditorParent()).setEnabled(b.getSelection());
        this._widthEditor.getLabelControl(this.getFieldEditorParent()).setEnabled(b.getSelection());
    }

    protected void updateBufferSizeEditor() {
        Button b = this._restrictOutput.getChangeControl(this.getFieldEditorParent());
        this._highWaterMark.getTextControl(this.getFieldEditorParent()).setEnabled(b.getSelection());
        this._highWaterMark.getLabelControl(this.getFieldEditorParent()).setEnabled(b.getSelection());
    }

    protected void createFieldEditors() {
        this._wrapEditor = new BooleanFieldEditor2("org.eclipse.egf.console.internal.wrap", ConsoleMessages.ConsolePreferencePage_Wrap_text, 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this._wrapEditor);
        this._widthEditor = new ConsoleIntegerFieldEditor("org.eclipse.egf.console.internal.width", ConsoleMessages.ConsolePreferencePage_Maximum_Console_width, this.getFieldEditorParent());
        this._widthEditor.setValidRange(80, 0x7FFFFFFE);
        this.addField((FieldEditor)this._widthEditor);
        this._widthEditor.setErrorMessage(ConsoleMessages.ConsolePreferencePage_Error_Console_width);
        this._wrapEditor.getChangeControl(this.getFieldEditorParent()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGFPreferencePage.this.updateWidthEditor();
            }
        });
        this._restrictOutput = new BooleanFieldEditor2("org.eclipse.egf.console.internal.limitOutput", ConsoleMessages.ConsolePreferencePage_limitOutput, 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this._restrictOutput);
        this._highWaterMark = new ConsoleIntegerFieldEditor("org.eclipse.egf.console.internal.highWaterMark", ConsoleMessages.ConsolePreferencePage_highWaterMark, this.getFieldEditorParent());
        this.addField((FieldEditor)this._highWaterMark);
        this._highWaterMark.setValidRange(1000, 0x7FFFFFFE);
        this._highWaterMark.setErrorMessage(ConsoleMessages.ConsolePreferencePage_Console_buffer_size);
        this._restrictOutput.getChangeControl(this.getFieldEditorParent()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGFPreferencePage.this.updateBufferSizeEditor();
            }
        });
        this._showOnMessage = new BooleanFieldEditor2("org.eclipse.egf.console.internal.showOnMessage", ConsoleMessages.ConsolePreferencePage_ShowOnMessage, 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this._showOnMessage);
        this._errorColorEditor = this.createColorFieldEditor("org.eclipse.egf.console.internal.errorColor", ConsoleMessages.ConsolePreferencePage_Error, this.getFieldEditorParent());
        this.addField((FieldEditor)this._errorColorEditor);
        this._infoColorEditor = this.createColorFieldEditor("org.eclipse.egf.console.internal.informationColor", ConsoleMessages.ConsolePreferencePage_Information, this.getFieldEditorParent());
        this.addField((FieldEditor)this._infoColorEditor);
        this._warningColorEditor = this.createColorFieldEditor("org.eclipse.egf.console.internal.warningColor", ConsoleMessages.ConsolePreferencePage_Warning, this.getFieldEditorParent());
        this.addField((FieldEditor)this._warningColorEditor);
        this._backgroundColorEditor = this.createColorFieldEditor("org.eclipse.egf.console.internal.backgroundColor", ConsoleMessages.ConsolePreferencePage_BackgroundColor, this.getFieldEditorParent());
        this.addField((FieldEditor)this._backgroundColorEditor);
        Dialog.applyDialogFont((Control)this.getFieldEditorParent());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.updateWidthEditor();
        this.updateBufferSizeEditor();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateWidthEditor();
        this.updateBufferSizeEditor();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                if (this._widthEditor != null && event.getSource() != this._widthEditor) {
                    this._widthEditor.refreshValidState();
                }
                if (this._highWaterMark != null && event.getSource() != this._highWaterMark) {
                    this._highWaterMark.refreshValidState();
                }
                this.checkState();
            } else {
                super.propertyChange(event);
            }
        } else {
            super.propertyChange(event);
        }
    }

    protected class ConsoleIntegerFieldEditor
    extends IntegerFieldEditor {
        public ConsoleIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (EGFPreferencePage.this.canClearErrorMessage()) {
                super.clearErrorMessage();
            }
        }
    }
}

