/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.usecase.pattern.uc3.m2treporting.reporter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;

public class OutputInOneFileReporter
implements PatternExecutionReporter {
    private static final String PROJECT_NAME = "test";
    private static final String FOLDER_NAME = "Pattern_UC3";
    private static final String FILE_NAME = "hello.txt";

    public void executionFinished(String output, PatternContext context) {
        this.writeContentsInFile(PROJECT_NAME, FOLDER_NAME, FILE_NAME, output);
    }

    public void loopFinished(String output, String outputWithCallBack, PatternContext context, Map<String, Object> parameterValues) {
    }

    protected void writeContentsInFile(String projectName, String folderName, String fileName, String contents) {
        ByteArrayInputStream contentsStream = new ByteArrayInputStream(contents.getBytes());
        try {
            IFile file = this.getFile(fileName, projectName, folderName);
            if (file.exists()) {
                file.setContents((InputStream)contentsStream, true, false, null);
            } else {
                file.create((InputStream)contentsStream, true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IFile getFile(String fileName, String projectName, String folderName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        Path path = new Path("");
        if (folderName != null && folderName.length() > 0) {
            String[] stringArray = folderName.split("\\.|/|\\\\");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String member = stringArray[n2];
                IFolder folder = project.getFolder((IPath)(path = path.append(member)));
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                ++n2;
            }
        }
        path = path.append(fileName);
        return project.getFile((IPath)path);
    }
}

