/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.internal.pde.AbstractPlatformExtensionPoint;
import org.eclipse.egf.core.platform.internal.pde.PlatformBundle;
import org.eclipse.egf.core.platform.internal.pde.PlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointListener;
import org.eclipse.egf.core.platform.pde.IPlatformManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IExtensionDeltaEvent;
import org.eclipse.pde.internal.core.IExtensionDeltaListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.osgi.framework.Bundle;

public abstract class BasePlatformManager
implements IPlatformManager {
    protected final Map<String, IPlatformBundle> workspaceRegistry = new HashMap<String, IPlatformBundle>();
    protected final Map<String, IPlatformBundle> runtimeRegistry = new HashMap<String, IPlatformBundle>();
    protected final Map<Class<?>, Set<Object>> runtimeExtensionPointRegistry = new HashMap();
    protected final Map<Class<?>, Set<Object>> workspaceExtensionPointRegistry = new HashMap();
    private final List<IPlatformExtensionPointListener> listeners = new ArrayList<IPlatformExtensionPointListener>();
    private final WorkspaceListener listener = new WorkspaceListener();

    public BasePlatformManager() {
        this.initializeRegistry();
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this.listener);
        PDECore.getDefault().getModelManager().addExtensionDeltaListener((IExtensionDeltaListener)this.listener);
        for (Map.Entry<String, Class<? extends IPlatformExtensionPoint>> entry : EGFPlatformPlugin.getPlatformExtensionPoints().entrySet()) {
            String point = entry.getKey().trim();
            RuntimeRegistryListener l = new RuntimeRegistryListener(point, entry.getValue());
            RegistryFactory.getRegistry().addListener((IRegistryEventListener)l, point);
        }
    }

    private void initializeRegistry() {
        for (Map.Entry<String, Class<? extends IPlatformExtensionPoint>> entry : EGFPlatformPlugin.getPlatformExtensionPoints().entrySet()) {
            IConfigurationElement[] elements = RegistryFactory.getRegistry().getConfigurationElementsFor(entry.getKey());
            if (elements == null) continue;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                this.addRuntimeElement(element, entry.getValue(), true);
                ++n2;
            }
        }
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
        int n = iPluginModelBaseArray.length;
        int n3 = 0;
        while (n3 < n) {
            IPluginModelBase base = iPluginModelBaseArray[n3];
            this.addWorkspaceElement(base);
            ++n3;
        }
    }

    private void addWorkspaceElement(IPluginModelBase base) {
        IPlatformBundle bundle = BasePlatformManager.createPlatformBundle(base);
        this.workspaceRegistry.put(bundle.getBundleId(), bundle);
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPoints().values()) {
            IPlatformExtensionPoint[] iPlatformExtensionPointArray = bundle.getPlatformExtensionPoints(clazz);
            int n = iPlatformExtensionPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n2];
                Set<Object> extensionPoints = this.workspaceExtensionPointRegistry.get(clazz);
                if (extensionPoints == null) {
                    extensionPoints = new HashSet<Object>();
                    this.workspaceExtensionPointRegistry.put(clazz, extensionPoints);
                }
                if (!extensionPoints.add(extensionPoint)) {
                    EGFPlatformPlugin.getDefault().logWarning(NLS.bind((String)"AbstractPlatformManager.addExtensionPoint(..) _ ''{0}'' already added Extension Point.", (Object)extensionPoint.getId()));
                }
                ++n2;
            }
        }
    }

    protected static IPlatformBundle createPlatformBundle(IPluginModelBase base) {
        PlatformBundle platformBundle = new PlatformBundle(base);
        IPluginExtension[] iPluginExtensionArray = base.getExtensions(false).getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            Class<? extends IPlatformExtensionPoint> clazz = EGFPlatformPlugin.getPlatformExtensionPoints().get(extension.getPoint());
            if (clazz != null) {
                IPluginObject[] iPluginObjectArray = extension.getChildren();
                int n3 = iPluginObjectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginObject pluginObject = iPluginObjectArray[n4];
                    if (pluginObject instanceof IPluginElement) {
                        platformBundle.createPlatformExtensionPoint(clazz, pluginObject);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return platformBundle;
    }

    private void addRuntimeElement(IConfigurationElement element, Class<? extends IPlatformExtensionPoint> clazz, boolean init) {
        IPlatformExtensionPoint extensionPoint;
        Bundle bundle = BundleHelper.getBundle((IContributor)element.getDeclaringExtension().getContributor());
        if (bundle == null || !element.isValid()) {
            return;
        }
        PlatformBundle platformBundle = (PlatformBundle)this.runtimeRegistry.get(bundle.getSymbolicName());
        if (platformBundle == null) {
            platformBundle = new PlatformBundle(bundle);
        }
        if ((extensionPoint = platformBundle.createPlatformExtensionPoint(clazz, element)) == null) {
            return;
        }
        if (!init && extensionPoint instanceof AbstractPlatformExtensionPoint) {
            ((AbstractPlatformExtensionPoint)((Object)extensionPoint)).setPlatformBundle(platformBundle);
        }
        this.runtimeRegistry.put(bundle.getSymbolicName(), platformBundle);
        Set<Object> objects = this.runtimeExtensionPointRegistry.get(clazz);
        if (objects == null) {
            objects = new HashSet<Object>();
            this.runtimeExtensionPointRegistry.put(clazz, objects);
        }
        objects.add(extensionPoint);
    }

    @Override
    public void addPlatformExtensionPointListener(IPlatformExtensionPointListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removePlatformExtensionPointListener(IPlatformExtensionPointListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePlatformExtensionPoint(IPlatformExtensionPointDelta delta) {
        for (IPlatformExtensionPointListener listener : this.listeners) {
            listener.platformExtensionPointChanged(delta);
        }
    }

    protected static void collectPlatformExtensionPoints(Map<Class<?>, Set<Object>> registry, Class<?> clazz, Collection<Object> collector) {
        if (clazz != null && registry.get(clazz) != null) {
            collector.addAll((Collection<Object>)registry.get(clazz));
        }
    }

    private class RuntimeRegistryListener
    implements IRegistryEventListener {
        private Class<? extends IPlatformExtensionPoint> _clazz;

        public RuntimeRegistryListener(String point, Class<? extends IPlatformExtensionPoint> clazz) {
            Assert.isNotNull((Object)point);
            Assert.isLegal((point.trim().length() != 0 ? 1 : 0) != 0);
            Assert.isNotNull(clazz);
            this._clazz = clazz;
        }

        public void removed(IExtension[] extensions) {
            PlatformExtensionPointDelta delta = new PlatformExtensionPointDelta();
            if (extensions == null) {
                return;
            }
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                Iterator<IPlatformBundle> it = BasePlatformManager.this.runtimeRegistry.values().iterator();
                while (it.hasNext()) {
                    PlatformBundle bundle = (PlatformBundle)it.next();
                    IPlatformExtensionPoint[] iPlatformExtensionPointArray = bundle.getPlatformExtensionPoints(this._clazz);
                    int n3 = iPlatformExtensionPointArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n4];
                        if (this.originatesFrom(extension, extensionPoint.getUniqueIdentifier(), extensionPoint.getHandleId())) {
                            if (!bundle.removePlatformExtensionPoint(this._clazz, extensionPoint)) {
                                EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"RuntimePlatformManager$RuntimeRegistryListener.removed(..) _ ''{0}'' unable to remove Extension Point from IPlatformBundle.", (Object)extensionPoint));
                            }
                            this.removeExtensionPoint(extensionPoint, this._clazz, BasePlatformManager.this.runtimeExtensionPointRegistry, delta);
                        }
                        ++n4;
                    }
                    if (!bundle.isEmpty()) continue;
                    it.remove();
                }
                ++n2;
            }
            if (!delta.isEmpty()) {
                BasePlatformManager.this.firePlatformExtensionPoint(delta);
            }
        }

        protected void removeExtensionPoint(IPlatformExtensionPoint extensionPoint, Class<? extends IPlatformExtensionPoint> clazz, Map<Class<?>, Set<Object>> extensions, PlatformExtensionPointDelta delta) {
            if (extensions.get(clazz).remove(extensionPoint)) {
                if (extensions.get(clazz).isEmpty()) {
                    extensions.remove(clazz);
                }
                if (delta != null) {
                    delta.storeRemovedPlatformExtensionPoint(clazz, extensionPoint);
                }
            }
        }

        public void added(IExtension[] extensions) {
            PlatformExtensionPointDelta delta = new PlatformExtensionPointDelta();
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    BasePlatformManager.this.addRuntimeElement(element, this._clazz, false);
                    ++n4;
                }
                ++n2;
            }
            if (!delta.isEmpty()) {
                BasePlatformManager.this.firePlatformExtensionPoint(delta);
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
            System.out.println();
        }

        public void removed(IExtensionPoint[] extensionPoints) {
            System.out.println();
        }

        public boolean originatesFrom(IExtension extension, String uniqueIdentifier, int handleId) {
            String id = extension.getUniqueIdentifier();
            if (id != null) {
                return id.equals(uniqueIdentifier);
            }
            if (!(extension instanceof Handle)) {
                return false;
            }
            return handleId == ((Handle)extension).getId();
        }
    }

    public class WorkspaceListener
    implements IExtensionDeltaListener,
    IPluginModelListener {
        private void reload() {
            BasePlatformManager.this.workspaceRegistry.clear();
            BasePlatformManager.this.runtimeRegistry.clear();
            BasePlatformManager.this.workspaceExtensionPointRegistry.clear();
            BasePlatformManager.this.runtimeExtensionPointRegistry.clear();
            BasePlatformManager.this.initializeRegistry();
        }

        public void extensionsChanged(IExtensionDeltaEvent event) {
            this.reload();
        }

        public void modelsChanged(PluginModelDelta delta) {
            this.reload();
        }
    }
}

