/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.providers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.databinding.internal.EMFObservableListDecorator;
import org.eclipse.jface.databinding.viewers.IViewerUpdater;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionContentProvider;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TableItem;

public class ObservableListContentProvider
implements IStructuredContentProvider {
    private ObservableCollectionContentProvider impl;
    private static int patternMethodsCount = 0;
    private static TableViewer tableViewer;

    public ObservableListContentProvider(int patternMethodsNum, TableViewer tableViewer) {
        this(null);
        patternMethodsCount = patternMethodsNum;
        ObservableListContentProvider.tableViewer = tableViewer;
    }

    public ObservableListContentProvider(IViewerUpdater viewerUpdater) {
        this.impl = new Impl(viewerUpdater);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet getKnownElements() {
        return this.impl.getKnownElements();
    }

    public IObservableSet getRealizedElements() {
        return this.impl.getRealizedElements();
    }

    protected static int getAddIndexInTable(int index) {
        return index - patternMethodsCount;
    }

    private static int getIndexInTable(Object element) {
        TableItem[] items = tableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            Object data = items[i].getData();
            if (element.equals(data)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private static int getMoveToIndexInTable(int index) {
        Object input = tableViewer.getInput();
        if (input instanceof EMFObservableListDecorator) {
            Object[] array = ((EMFObservableListDecorator)input).toArray();
            Object moveToItem = array[index - 1];
            int indexInTable = ObservableListContentProvider.getIndexInTable(moveToItem);
            return indexInTable;
        }
        return 0;
    }

    private static class Impl
    extends ObservableCollectionContentProvider
    implements IListChangeListener {
        private Viewer viewer;

        Impl(IViewerUpdater explicitViewerUpdater) {
            super(explicitViewerUpdater);
        }

        public void inputChanged(Viewer innerViewer, Object oldInput, Object newInput) {
            this.viewer = innerViewer;
            super.inputChanged(innerViewer, oldInput, newInput);
        }

        protected void checkInput(Object input) {
            Assert.isTrue((boolean)(input instanceof IObservableList), (String)"This content provider only works with input of type IObservableList");
        }

        protected void addCollectionChangeListener(IObservableCollection collection) {
            ((IObservableList)collection).addListChangeListener((IListChangeListener)this);
        }

        protected void removeCollectionChangeListener(IObservableCollection collection) {
            ((IObservableList)collection).removeListChangeListener((IListChangeListener)this);
        }

        public void handleListChange(ListChangeEvent event) {
            if (this.isViewerDisposed()) {
                return;
            }
            final Set knownElementAdditions = ViewerElementSet.withComparer((IElementComparer)this.comparer);
            final Set knownElementRemovals = ViewerElementSet.withComparer((IElementComparer)this.comparer);
            final boolean[] suspendRedraw = new boolean[1];
            event.diff.accept(new ListDiffVisitor(){

                public void handleAdd(int index, Object element) {
                    knownElementAdditions.add(element);
                }

                public void handleRemove(int index, Object element) {
                    knownElementRemovals.add(element);
                }

                public void handleMove(int oldIndex, int newIndex, Object element) {
                    suspendRedraw[0] = true;
                    super.handleMove(oldIndex, newIndex, element);
                }

                public void handleReplace(int index, Object oldElement, Object newElement) {
                    suspendRedraw[0] = true;
                    super.handleReplace(index, oldElement, newElement);
                }
            });
            knownElementAdditions.removeAll((Collection<?>)this.knownElements);
            knownElementRemovals.removeAll((Collection<?>)event.getObservableList());
            this.knownElements.addAll((Collection)knownElementAdditions);
            if (this.realizedElements != null) {
                this.realizedElements.removeAll((Collection)knownElementRemovals);
            }
            if (suspendRedraw[0]) {
                this.viewer.getControl().setRedraw(false);
            }
            try {
                event.diff.accept(new ListDiffVisitor(){

                    public void handleAdd(int index, Object element) {
                        int indexInTable = ObservableListContentProvider.getAddIndexInTable(index);
                        viewerUpdater.insert(element, indexInTable);
                    }

                    public void handleRemove(int index, Object element) {
                        int indexInTable = ObservableListContentProvider.getIndexInTable(element);
                        viewerUpdater.remove(element, indexInTable);
                    }

                    public void handleReplace(int index, Object oldElement, Object newElement) {
                        viewerUpdater.replace(oldElement, newElement, index);
                    }

                    public void handleMove(int oldIndex, int newIndex, Object element) {
                        int moveFormIndexInTable = ObservableListContentProvider.getIndexInTable(element);
                        int moveToIndexInTable = ObservableListContentProvider.getMoveToIndexInTable(newIndex);
                        viewerUpdater.move(element, moveFormIndexInTable, moveToIndexInTable);
                    }
                });
            }
            finally {
                if (suspendRedraw[0]) {
                    this.viewer.getControl().setRedraw(true);
                }
            }
            if (this.realizedElements != null) {
                this.realizedElements.addAll((Collection)knownElementAdditions);
            }
            this.knownElements.removeAll((Collection)knownElementRemovals);
        }
    }
}

