/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gymnast.runtime.core.ast;

import java.util.ArrayList;
import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.gymnast.runtime.core.ast.TokenInfo;

public abstract class ASTNodeImpl
implements ASTNode {
    private static final TokenInfo NO_TOKEN = new TokenInfo(null, -1, -1);
    private final TokenInfo _tokenInfo;

    public ASTNodeImpl() {
        this._tokenInfo = NO_TOKEN;
    }

    public ASTNodeImpl(TokenInfo tokenInfo) {
        this._tokenInfo = tokenInfo;
    }

    public ASTNodeImpl(int offset, int type, String text) {
        this._tokenInfo = new TokenInfo(text, offset, type);
    }

    @Override
    public final int getOffset() {
        return this._tokenInfo.getOffset();
    }

    @Override
    public int getTokenType() {
        return this._tokenInfo.getType();
    }

    @Override
    public String getText() {
        return this._tokenInfo.getText();
    }

    @Override
    public final int getTextLength() {
        if (this.getText() == null) {
            return 0;
        }
        return this.getText().length();
    }

    @Override
    public abstract int getChildCount();

    @Override
    public abstract ASTNode getChild(int var1);

    @Override
    public final boolean hasChildren() {
        return this.getChildCount() != 0;
    }

    @Override
    public final ASTNode getFirstChild() {
        if (this.getChildCount() == 0) {
            return null;
        }
        return this.getChild(0);
    }

    @Override
    public final ASTNode getLastChild() {
        if (this.getChildCount() == 0) {
            return null;
        }
        return this.getChild(this.getChildCount() - 1);
    }

    @Override
    public ASTNode[] getChildren() {
        ArrayList<ASTNode> list = new ArrayList<ASTNode>();
        int i = 0;
        while (i < this.getChildCount()) {
            list.add(this.getChild(i));
            ++i;
        }
        return list.toArray(new ASTNode[list.size()]);
    }

    @Override
    public abstract ASTNode getParent();

    @Override
    public final ASTNode getRoot() {
        ASTNode root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    @Override
    public final boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public final boolean isTokenNode() {
        return !this.hasChildren() && this.getText() != null;
    }

    @Override
    public final int getRangeStart() {
        ASTNode firstToken = this.getFirstToken();
        if (firstToken == null) {
            return -1;
        }
        return firstToken.getOffset();
    }

    @Override
    public final int getRangeLength() {
        ASTNode lastToken = this.getLastToken();
        if (lastToken == null) {
            return 0;
        }
        return lastToken.getOffset() + lastToken.getTextLength() - this.getRangeStart();
    }

    @Override
    public final int getRangeEnd() {
        return this.getRangeStart() + this.getRangeLength();
    }

    @Override
    public final ASTNode getFirstLeaf() {
        if (!this.hasChildren()) {
            return this;
        }
        ASTNode first = this.getFirstChild();
        return first.getFirstLeaf();
    }

    @Override
    public final ASTNode getLastLeaf() {
        if (!this.hasChildren()) {
            return this;
        }
        ASTNode last = this.getLastChild();
        return last.getLastLeaf();
    }

    @Override
    public final ASTNode getFirstToken() {
        if (!this.hasChildren()) {
            if (this.isTokenNode()) {
                return this;
            }
            return null;
        }
        int i = 0;
        while (i < this.getChildCount()) {
            ASTNode n = this.getChild(i);
            ASTNode temp = n.getFirstToken();
            if (temp != null) {
                return temp;
            }
            ++i;
        }
        return null;
    }

    @Override
    public final ASTNode getLastToken() {
        if (!this.hasChildren()) {
            if (this.isTokenNode()) {
                return this;
            }
            return null;
        }
        int i = this.getChildCount() - 1;
        while (i >= 0) {
            ASTNode n = this.getChild(i);
            ASTNode temp = n.getLastToken();
            if (temp != null) {
                return temp;
            }
            --i;
        }
        return null;
    }

    @Override
    public final ASTNode getNodeAt(int offset, int length, Class[] filter, boolean inclusionFilter) {
        boolean nodeTypeOk = true;
        if (filter != null) {
            boolean foundMatch = false;
            int i = 0;
            while (i < filter.length) {
                if (filter[i].isInstance(this)) {
                    foundMatch = true;
                }
                ++i;
            }
            boolean bl = nodeTypeOk = !(inclusionFilter ^ foundMatch);
        }
        if (offset >= this.getRangeStart() && offset + length < this.getRangeEnd()) {
            int i = 0;
            while (i < this.getChildCount()) {
                ASTNode child = this.getChild(i);
                ASTNode x = child.getNodeAt(offset, length, filter, inclusionFilter);
                if (x != null) {
                    return x;
                }
                ++i;
            }
            if (nodeTypeOk) {
                return this;
            }
        }
        return null;
    }

    @Override
    public final ASTNode getNodeAt(int offset, int length, Class filter, boolean inclusionFilter) {
        return this.getNodeAt(offset, length, new Class[]{filter}, inclusionFilter);
    }

    @Override
    public final ASTNode getNodeAt(int offset, Class filter, boolean inclusionFilter) {
        return this.getNodeAt(offset, 0, new Class[]{filter}, inclusionFilter);
    }

    @Override
    public final ASTNode getNodeAt(int offset, int length) {
        return this.getNodeAt(offset, length, new Class[0], false);
    }

    @Override
    public final void checkTokenOffsets(String input) {
        String tokenText;
        int offset = this.getOffset();
        if (offset != -1 && (tokenText = this.getText()) != null) {
            try {
                input.substring(offset, offset + tokenText.length());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int i = 0;
        while (i < this.getChildCount()) {
            ASTNode child = this.getChild(i);
            child.checkTokenOffsets(input);
            ++i;
        }
    }

    @Override
    public void dump(int level) {
        int i = 0;
        while (i < this.getChildCount()) {
            ASTNode child = this.getChild(i);
            child.dump(level + 1);
            ++i;
        }
    }

    @Override
    public String getTypeName() {
        String fullName = this.getClass().getName();
        int pos = fullName.lastIndexOf(".");
        if (pos == -1) {
            return fullName;
        }
        return fullName.substring(pos + 1);
    }
}

