/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.epsilon.emc.simulink.engine.MatlabClassLoader;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.types.AbstractType;
import org.eclipse.epsilon.emc.simulink.util.MatlabEngineUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class Struct
extends AbstractType {
    protected static final String STRUCT_MATLAB_CLASS = "com.mathworks.matlab.types.Struct";
    protected static final String CONTAINS_KEY_METHOD = "containsKey";
    protected static final String CONTAINS_VALUE_METHOD = "containsValue";
    protected static final String EQUALS_METHOD = "equals";
    protected static final String GET_METHOD = "get";
    protected static final String ENTRY_SET_METHOD = "entrySet";
    protected static final String HASH_CODE_METHOD = "hashCode";
    protected static final String IS_EMPTY_METHOD = "isEmpty";
    protected static final String KEY_SET_METHOD = "keySet";
    protected static final String SIZE_METHOD = "size";
    protected static final String VALUES_METHOD = "values";
    private static Class<?> struct_class;
    protected HashMap<String, Object> keyValues = null;
    protected Method containsKeyMethod;
    protected Method containsValueMethod;
    protected Method equalsMethod;
    protected Method getMethod;
    protected Method entrySetMethod;
    protected Method hashCodeMethod;
    protected Method isEmptyMethod;
    protected Method keySetMethod;
    protected Method sizeMethod;
    protected Method valuesMethod;

    public static boolean is(Object obj) {
        return Struct.getMatlabClass() == null ? false : Struct.getMatlabClass().isInstance(obj);
    }

    protected static Class<?> getMatlabClass() {
        if (struct_class == null) {
            try {
                struct_class = MatlabClassLoader.getInstance().loadMatlabClass(STRUCT_MATLAB_CLASS);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return struct_class;
    }

    public Struct(Object struct) {
        if (Struct.is(struct)) {
            this.object = struct;
            this.init();
        }
    }

    public Struct(MatlabEngine struct) {
        this.init();
        this.keyValues = new HashMap();
    }

    @Override
    protected void init() {
        Class<?> clazz = Struct.getMatlabClass();
        try {
            this.containsKeyMethod = this.containsKeyMethod == null ? clazz.getDeclaredMethod(CONTAINS_KEY_METHOD, Object.class) : null;
            this.containsValueMethod = this.containsValueMethod == null ? clazz.getDeclaredMethod(CONTAINS_VALUE_METHOD, Object.class) : null;
            this.equalsMethod = this.equalsMethod == null ? clazz.getDeclaredMethod(EQUALS_METHOD, Object.class) : null;
            this.getMethod = this.getMethod == null ? clazz.getDeclaredMethod(GET_METHOD, Object.class) : null;
            this.entrySetMethod = this.entrySetMethod == null ? clazz.getDeclaredMethod(ENTRY_SET_METHOD, new Class[0]) : null;
            this.hashCodeMethod = this.hashCodeMethod == null ? clazz.getDeclaredMethod(HASH_CODE_METHOD, new Class[0]) : null;
            this.isEmptyMethod = this.isEmptyMethod == null ? clazz.getDeclaredMethod(IS_EMPTY_METHOD, new Class[0]) : null;
            this.keySetMethod = this.keySetMethod == null ? clazz.getDeclaredMethod(KEY_SET_METHOD, new Class[0]) : null;
            this.sizeMethod = this.sizeMethod == null ? clazz.getDeclaredMethod(SIZE_METHOD, new Class[0]) : null;
            this.valuesMethod = this.valuesMethod == null ? clazz.getDeclaredMethod(VALUES_METHOD, new Class[0]) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Boolean containsKey(Object key) {
        try {
            return (Boolean)this.containsKeyMethod.invoke(this.getObject(), key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Boolean containsValue(Object value) {
        try {
            return (Boolean)this.containsValueMethod.invoke(this.getObject(), value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public boolean equals(Object obj) {
        try {
            return (Boolean)this.equalsMethod.invoke(this.getObject(), obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Object get(Object key) {
        try {
            Object val = this.getMethod.invoke(this.getObject(), key);
            return MatlabEngineUtil.parseMatlabEngineVariable(val);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Set<?> entrySet() {
        try {
            return (Set)this.entrySetMethod.invoke(this.getObject(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public int hashCode() {
        try {
            return (Integer)this.hashCodeMethod.invoke(this.getObject(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Boolean isEmpty() {
        try {
            return (Boolean)this.isEmptyMethod.invoke(this.getObject(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Set<?> keySet() {
        try {
            Set set = (Set)this.keySetMethod.invoke(this.getObject(), new Object[0]);
            return set.stream().map(e -> MatlabEngineUtil.parseMatlabEngineVariable(e)).collect(Collectors.toSet());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new IllegalStateException(e2.getMessage());
        }
    }

    public Integer size() {
        try {
            return (Integer)this.sizeMethod.invoke(this.getObject(), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Set<?> values() {
        try {
            HashSet set = new HashSet((Collection)this.valuesMethod.invoke(this.getObject(), new Object[0]));
            return set.stream().map(e -> MatlabEngineUtil.parseMatlabEngineVariable(e)).collect(Collectors.toSet());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new IllegalStateException(e2.getMessage());
        }
    }

    public String toString() {
        return "Struct: [" + this.keySet().toString() + "]";
    }

    @Override
    public Object getProperty(String property) throws EolRuntimeException {
        if (this.object != null) {
            return this.get(property);
        }
        return this.keyValues.get(property);
    }

    @Override
    public void setProperty(String property, Object value) throws EolRuntimeException {
        if (this.object != null) {
            throw new EolRuntimeException("Property " + property + " already set for object " + this.object.toString());
        }
        this.keyValues.put(property, value);
    }

    @Override
    protected Object getObject() {
        if (this.object == null) {
            List<Object> keyValueList = this.keyValues.entrySet().stream().flatMap(e -> {
                Object key = e.getKey();
                Object value = e.getValue();
                Object[] list = new Object[]{key, value};
                return Arrays.stream(list);
            }).collect(Collectors.toList());
            Object[] keyValueArray = keyValueList.toArray(new Object[0]);
            try {
                Constructor<?> constructor = struct_class.getConstructor(Object[].class);
                constructor.setAccessible(true);
                this.object = constructor.newInstance(new Object[]{keyValueArray});
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new IllegalStateException(e2.getMessage());
            }
        }
        return this.object;
    }
}

