/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.trace;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.gmf.internal.bridge.StatefulVisualIdentifierDispencer;
import org.eclipse.gmf.internal.bridge.trace.AbstractTrace;
import org.eclipse.gmf.internal.bridge.trace.GenChildNodeTrace;
import org.eclipse.gmf.internal.bridge.trace.GenCompartmentTrace;
import org.eclipse.gmf.internal.bridge.trace.GenLinkLabelTrace;
import org.eclipse.gmf.internal.bridge.trace.GenLinkTrace;
import org.eclipse.gmf.internal.bridge.trace.GenNodeLabelTrace;
import org.eclipse.gmf.internal.bridge.trace.GenNodeTrace;
import org.eclipse.gmf.internal.bridge.trace.GmfTracePlugin;
import org.eclipse.gmf.internal.bridge.trace.MatchingTrace;
import org.eclipse.gmf.internal.bridge.trace.ToolGroupTrace;
import org.eclipse.gmf.internal.bridge.trace.TraceFactory;
import org.eclipse.gmf.internal.bridge.trace.TraceModel;
import org.eclipse.ocl.ParserException;

public class MergingIdentifierDispenser
implements StatefulVisualIdentifierDispencer {
    private static final int CANVAS_COUNT_BASE = 1000;
    private static final int TOP_NODE_COUNT_BASE = 2000;
    private static final int CHILD_NODE_COUNT_BASE = 3000;
    private static final int LINK_COUNT_BASE = 4000;
    private static final int NODE_LABEL_COUNT_BASE = 5000;
    private static final int LINK_LABEL_COUNT_BASE = 6000;
    private static final int COMPARTMENT_COUNT_BASE = 7000;
    private static final int OVERFLOW_COUNT_BASE = 8000;
    private static final int TOOL_GROUP_COUNT_BASE = 0;
    private int myTopNodeCount = 2000;
    private int myChildNodeCount = 3000;
    private int myLinkCount = 4000;
    private int myNodeLabelCount = 5000;
    private int myLinkLabelCount = 6000;
    private int myCompartmentCount = 7000;
    private int myToolGroupCount = 0;
    private int myOverflowCount = 8000;
    private TraceModel myTraceModel;
    private Map<String, String> mySavingOptions;

    public void loadState(URI genModelFileURI) {
        this.loadTraceModel(genModelFileURI);
        this.initCounters();
    }

    public void saveState() {
        this.myTraceModel.purgeUnprocessedTraces();
        try {
            this.myTraceModel.eResource().save(this.getSavingOptions());
        }
        catch (IOException e) {
            GmfTracePlugin.getInstance().logError("Unable to save trace model", e);
        }
        this.myTraceModel = null;
    }

    private Map<?, ?> getSavingOptions() {
        if (this.mySavingOptions == null) {
            this.mySavingOptions = new HashMap<String, String>();
            this.mySavingOptions.put("ENCODING", "UTF-8");
            this.mySavingOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        }
        return this.mySavingOptions;
    }

    private void loadTraceModel(URI genModelFileURI) {
        Resource traceRes;
        URI traceModelURI = genModelFileURI.trimFileExtension().appendFileExtension("trace");
        ResourceSetImpl resSet = new ResourceSetImpl();
        try {
            traceRes = resSet.getResource(traceModelURI, true);
        }
        catch (RuntimeException runtimeException) {
            traceRes = resSet.createResource(traceModelURI, "");
        }
        if (traceRes.getContents().size() > 0 && traceRes.getContents().get(0) instanceof TraceModel) {
            this.myTraceModel = (TraceModel)traceRes.getContents().get(0);
        } else {
            this.myTraceModel = TraceFactory.eINSTANCE.createTraceModel();
            traceRes.getContents().add(0, (Object)this.myTraceModel);
        }
    }

    private void initCounters() {
        this.myTopNodeCount = Math.max(this.myTopNodeCount, this.getMaxVid((Collection<? extends AbstractTrace>)this.myTraceModel.getNodeTraces()));
        this.myChildNodeCount = Math.max(this.myChildNodeCount, this.getMaxVid((Collection<? extends AbstractTrace>)this.myTraceModel.getChildNodeTraces()));
        this.myLinkCount = Math.max(this.myLinkCount, this.getMaxVid((Collection<? extends AbstractTrace>)this.myTraceModel.getLinkTraces()));
        this.initNodeChildrenCounters((Collection<? extends GenNodeTrace>)this.myTraceModel.getNodeTraces());
        this.initNodeChildrenCounters((Collection<? extends GenNodeTrace>)this.myTraceModel.getChildNodeTraces());
        for (GenLinkTrace trace : this.myTraceModel.getLinkTraces()) {
            this.myLinkLabelCount = Math.max(this.myLinkLabelCount, this.getMaxVid((Collection<? extends AbstractTrace>)trace.getLinkLabelTraces()));
        }
        this.myToolGroupCount = Math.max(this.myToolGroupCount, this.getMaxVid((Collection<? extends AbstractTrace>)this.myTraceModel.getToolGroupTraces()));
    }

    private void initNodeChildrenCounters(Collection<? extends GenNodeTrace> nodeTraces) {
        for (GenNodeTrace genNodeTrace : nodeTraces) {
            this.myNodeLabelCount = Math.max(this.myNodeLabelCount, this.getMaxVid((Collection<? extends AbstractTrace>)genNodeTrace.getNodeLabelTraces()));
            this.myCompartmentCount = Math.max(this.myCompartmentCount, this.getMaxVid((Collection<? extends AbstractTrace>)genNodeTrace.getCompartmentTraces()));
        }
    }

    private int getMaxVid(Collection<? extends AbstractTrace> abstractTraces) {
        int id = -1;
        for (AbstractTrace abstractTrace : abstractTraces) {
            id = Math.max(id, abstractTrace.getVisualID());
            this.myOverflowCount = Math.max(this.myOverflowCount, abstractTrace.getVisualID());
        }
        return id;
    }

    public int get(GenDiagram diagram) {
        return 1000;
    }

    public int get(GenTopLevelNode node) {
        int visualID = this.getMatchingVID(node, (Collection<? extends MatchingTrace>)this.myTraceModel.getNodeTraces());
        if (visualID > -1) {
            return visualID;
        }
        visualID = this.getNextTopNodeVID();
        GenNodeTrace nodeTrace = TraceFactory.eINSTANCE.createGenNodeTrace();
        nodeTrace.setVisualID(visualID);
        nodeTrace.setContext((GenNode)node);
        nodeTrace.setProcessed(true);
        this.myTraceModel.getNodeTraces().add((Object)nodeTrace);
        return visualID;
    }

    public int get(GenNodeLabel nodeLabel) {
        GenNodeTrace nodeTrace = this.myTraceModel.getNodeTrace(nodeLabel.getNode().getVisualID());
        int visualID = this.getMatchingVID(nodeLabel, (Collection<? extends MatchingTrace>)nodeTrace.getNodeLabelTraces());
        if (visualID > -1) {
            return visualID;
        }
        visualID = this.getNextNodeLabelVID();
        GenNodeLabelTrace nodeLabelTrace = TraceFactory.eINSTANCE.createGenNodeLabelTrace();
        nodeLabelTrace.setVisualID(visualID);
        nodeTrace.getNodeLabelTraces().add((Object)nodeLabelTrace);
        nodeLabelTrace.setContext(nodeLabel);
        nodeLabelTrace.setProcessed(true);
        return visualID;
    }

    public int get(GenLink link) {
        int visualID = this.getMatchingVID(link, (Collection<? extends MatchingTrace>)this.myTraceModel.getLinkTraces());
        if (visualID > -1) {
            return visualID;
        }
        visualID = this.getNextLinkVID();
        GenLinkTrace nodeLabelTrace = TraceFactory.eINSTANCE.createGenLinkTrace();
        nodeLabelTrace.setVisualID(visualID);
        nodeLabelTrace.setContext(link);
        this.myTraceModel.getLinkTraces().add((Object)nodeLabelTrace);
        nodeLabelTrace.setProcessed(true);
        return visualID;
    }

    public int get(GenChildNode childNode) {
        int visualID = this.getMatchingVID(childNode, (Collection<? extends MatchingTrace>)this.myTraceModel.getChildNodeTraces());
        if (visualID > -1) {
            return visualID;
        }
        visualID = this.getNextChildNodeVID();
        GenChildNodeTrace childNodeTrace = TraceFactory.eINSTANCE.createGenChildNodeTrace();
        childNodeTrace.setVisualID(visualID);
        childNodeTrace.setContext((GenNode)childNode);
        this.myTraceModel.getChildNodeTraces().add((Object)childNodeTrace);
        childNodeTrace.setProcessed(true);
        return visualID;
    }

    public int get(GenCompartment compartment) {
        GenNodeTrace nodeTrace = this.myTraceModel.getNodeTrace(compartment.getNode().getVisualID());
        int visualID = this.getMatchingVID(compartment, (Collection<? extends MatchingTrace>)nodeTrace.getCompartmentTraces());
        if (visualID > -1) {
            return visualID;
        }
        visualID = this.getNextCompartmentVID();
        GenCompartmentTrace compartmentTrace = TraceFactory.eINSTANCE.createGenCompartmentTrace();
        compartmentTrace.setVisualID(visualID);
        nodeTrace.getCompartmentTraces().add((Object)compartmentTrace);
        compartmentTrace.setContext(compartment);
        compartmentTrace.setProcessed(true);
        return visualID;
    }

    public int get(GenLinkLabel label) {
        GenLinkTrace linkTrace = this.myTraceModel.getLinkTrace(label.getLink().getVisualID());
        int visualID = this.getMatchingVID(label, (Collection<? extends MatchingTrace>)linkTrace.getLinkLabelTraces());
        if (visualID > -1) {
            return visualID;
        }
        visualID = this.getNextLinkLabelVID();
        GenLinkLabelTrace linkLabelTrace = TraceFactory.eINSTANCE.createGenLinkLabelTrace();
        linkLabelTrace.setVisualID(visualID);
        linkTrace.getLinkLabelTraces().add((Object)linkLabelTrace);
        linkLabelTrace.setContext(label);
        linkLabelTrace.setProcessed(true);
        return visualID;
    }

    public int get(ToolGroup toolGroup) {
        int visualID = this.getMatchingVID(toolGroup, (Collection<? extends MatchingTrace>)this.myTraceModel.getToolGroupTraces());
        if (visualID > -1) {
            return visualID;
        }
        visualID = this.getNextToolVID();
        ToolGroupTrace toolGroupTrace = TraceFactory.eINSTANCE.createToolGroupTrace();
        toolGroupTrace.setVisualID(visualID);
        toolGroupTrace.setContext(toolGroup);
        this.myTraceModel.getToolGroupTraces().add((Object)toolGroupTrace);
        toolGroupTrace.setProcessed(true);
        return visualID;
    }

    private int getMatchingVID(Object context, Collection<? extends MatchingTrace> matchingTraces) {
        for (MatchingTrace matchingTrace : matchingTraces) {
            if (matchingTrace.isProcessed()) continue;
            try {
                Object result = matchingTrace.getQuery().evaluate(context);
                if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
                matchingTrace.setProcessed(true);
                return matchingTrace.getVisualID();
            }
            catch (ParserException e) {
                GmfTracePlugin.getInstance().logError("Error while parcing expression body from trace", e);
            }
        }
        return -1;
    }

    private int getNextToolVID() {
        if (++this.myToolGroupCount < 1000) {
            GmfTracePlugin.getInstance().logDebugInfo("New tool visualID issued: " + this.myToolGroupCount);
            return this.myToolGroupCount;
        }
        return ++this.myOverflowCount;
    }

    private int getNextTopNodeVID() {
        if (++this.myTopNodeCount < 3000) {
            GmfTracePlugin.getInstance().logDebugInfo("New top node visualID issued: " + this.myTopNodeCount);
            return this.myTopNodeCount;
        }
        return ++this.myOverflowCount;
    }

    private int getNextChildNodeVID() {
        if (++this.myChildNodeCount < 4000) {
            GmfTracePlugin.getInstance().logDebugInfo("New child node visualID issued: " + this.myChildNodeCount);
            return this.myChildNodeCount;
        }
        return ++this.myOverflowCount;
    }

    private int getNextLinkVID() {
        if (++this.myLinkCount < 5000) {
            GmfTracePlugin.getInstance().logDebugInfo("New link visualID issued: " + this.myLinkCount);
            return this.myLinkCount;
        }
        return ++this.myOverflowCount;
    }

    private int getNextNodeLabelVID() {
        if (++this.myNodeLabelCount < 6000) {
            GmfTracePlugin.getInstance().logDebugInfo("New node label visualID issued: " + this.myNodeLabelCount);
            return this.myNodeLabelCount;
        }
        return ++this.myOverflowCount;
    }

    private int getNextLinkLabelVID() {
        if (++this.myLinkLabelCount < 7000) {
            GmfTracePlugin.getInstance().logDebugInfo("New link label visualID issued: " + this.myLinkLabelCount);
            return this.myLinkLabelCount;
        }
        return ++this.myOverflowCount;
    }

    private int getNextCompartmentVID() {
        if (++this.myCompartmentCount < 8000) {
            GmfTracePlugin.getInstance().logDebugInfo("New compartment visualID issued: " + this.myCompartmentCount);
            return this.myCompartmentCount;
        }
        return ++this.myOverflowCount;
    }
}

