/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.trajdata;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.simulator.output.NullSimulatorOutputComponent;
import org.eclipse.escet.cif.simulator.output.trajdata.TrajDataFileOption;
import org.eclipse.escet.cif.simulator.output.trajdata.TrajDataFiltersOption;
import org.eclipse.escet.cif.simulator.output.trajdata.TrajDataOption;
import org.eclipse.escet.cif.simulator.output.trajdata.TrajDataSepOption;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateFilterer;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateObjectMeta;
import org.eclipse.escet.cif.simulator.runtime.meta.StateObjectType;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.ode.Trajectories;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public class TrajDataOutputComponent
extends NullSimulatorOutputComponent {
    private final PathPair pathPair = TrajDataFileOption.getPaths();
    private AppStream stream;
    private List<RuntimeStateObjectMeta> metas;
    private String header;
    private int[] widths;
    private final Integer sep = TrajDataSepOption.getSep();
    private boolean finished = false;

    public TrajDataOutputComponent() {
        this.open();
    }

    private void open() {
        Assert.check((this.stream == null ? 1 : 0) != 0);
        try {
            this.stream = new FileAppStream(this.pathPair);
        }
        catch (InputOutputException e) {
            String msg = Strings.fmt((String)"Failed to open trajectory data file \"%s\".", (Object[])new Object[]{this.pathPair.userPath});
            throw new InputOutputException(msg, (Throwable)e);
        }
    }

    private void close() {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    @Override
    public void initialState(RuntimeState state) {
        this.metas = Lists.list();
        for (RuntimeStateObjectMeta meta : state.spec.stateObjectsMeta) {
            Object value;
            if (meta.type == StateObjectType.AUTOMATON || !this.isSupportedType(value = state.getVarValue(meta))) continue;
            this.metas.add(meta);
        }
        String filtersTxt = TrajDataFiltersOption.getFilters();
        this.metas = RuntimeStateFilterer.filter(this.metas, filtersTxt, "Trajectory data", "included in the trajectory data file, except for variable \"time\"");
        if (this.metas.isEmpty() || ((RuntimeStateObjectMeta)Lists.first(this.metas)).type != StateObjectType.TIME) {
            this.metas.add(0, (RuntimeStateObjectMeta)Lists.first(state.spec.stateObjectsMeta));
        }
        List names = Lists.listc((int)this.metas.size());
        for (RuntimeStateObjectMeta meta : this.metas) {
            names.add(meta.name);
        }
        this.header = "# " + String.join((CharSequence)" ", names);
        if (this.sep != null) {
            this.widths = new int[this.metas.size()];
            int i = 0;
            while (i < this.metas.size()) {
                this.widths[i] = this.metas.get((int)i).name.length();
                ++i;
            }
            this.widths[0] = this.widths[0] + 2;
        }
    }

    private boolean isSupportedType(Object value) {
        return value instanceof Boolean || value instanceof Integer || value instanceof Double;
    }

    private String valueToText(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : "0";
        }
        if (value instanceof Integer) {
            return CifSimulatorMath.intToStr((Integer)value);
        }
        if (value instanceof Double) {
            return CifSimulatorMath.realToStr((Double)value);
        }
        throw new RuntimeException("Unexpected value: " + String.valueOf(value));
    }

    @Override
    public void transitionTaken(RuntimeState sourceState, Transition<?> transition, RuntimeState targetState, Boolean interrupted) {
        if (!(transition instanceof TimeTransition)) {
            return;
        }
        this.stream.println(this.header);
        TimeTransition ttrans = (TimeTransition)transition;
        Trajectories trajs = ttrans.getTrajectories();
        List<Double> times = trajs.getTimes();
        double sourceTime = sourceState.getTime();
        double targetTime = targetState.getTime();
        this.outputLine(sourceState);
        int idx = 0;
        while (idx < times.size()) {
            double time = times.get(idx);
            if (!(time <= sourceTime)) {
                if (time >= targetTime) break;
                Object state = ttrans.getTargetStateForIndex(idx);
                this.outputLine((RuntimeState)state);
            }
            ++idx;
        }
        this.outputLine(targetState);
    }

    private void outputLine(RuntimeState state) {
        StringBuilder line = new StringBuilder();
        int i = 0;
        while (i < this.metas.size()) {
            RuntimeStateObjectMeta meta = this.metas.get(i);
            Object value = state.getVarValue(meta);
            String txt = this.valueToText(value);
            if (i > 0) {
                line.append(" ");
            }
            line.append(txt);
            if (this.sep != null && txt.length() > this.widths[i]) {
                this.widths[i] = txt.length();
            }
            ++i;
        }
        this.stream.println(line.toString());
    }

    @Override
    public void simulationEnded(SimulationResult rslt, RuntimeState state) {
        this.finish();
    }

    public void cleanup() {
        this.finish();
    }

    private void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.close();
        if (this.sep != null) {
            this.prettify();
        }
    }

    private void prettify() {
        String pathTmp = this.pathPair.userPath + ".tmp";
        String absPathTmp = this.pathPair.systemPath + ".tmp";
        Path p = Paths.get(this.pathPair.systemPath, new String[0]);
        Path ptmp = Paths.get(absPathTmp, new String[0]);
        try {
            Files.move(p, ptmp, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Failed to rename trajectory data file \"%s\" to \"%s\".", (Object[])new Object[]{this.pathPair.userPath, pathTmp});
            throw new InputOutputException(msg, (Throwable)e);
        }
        BufferedReader input = null;
        try {
            this.open();
            try {
                input = new BufferedReader(new FileReader(absPathTmp));
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Failed to open trajectory data file \"%s\".", (Object[])new Object[]{pathTmp});
                throw new InputOutputException(msg, (Throwable)e);
            }
            while (true) {
                String line;
                try {
                    line = input.readLine();
                }
                catch (IOException e) {
                    String msg = Strings.fmt((String)"Failed to read from trajectory data file \"%s\".", (Object[])new Object[]{pathTmp});
                    throw new InputOutputException(msg, (Throwable)e);
                }
                if (line != null) {
                    StringBuilder prettyLine = new StringBuilder();
                    boolean commentLine = line.startsWith("#");
                    if (commentLine) {
                        line = line.substring(2);
                    }
                    String[] parts = StringUtils.split((String)line, (char)' ');
                    if (commentLine) {
                        parts[0] = "# " + parts[0];
                    }
                    int i = 0;
                    while (i < parts.length) {
                        int cnt;
                        if (i > 0) {
                            prettyLine.append(Strings.spaces((int)this.sep));
                        }
                        prettyLine.append(parts[i]);
                        if (i != parts.length - 1 && (cnt = this.widths[i] - parts[i].length()) > 0) {
                            prettyLine.append(Strings.spaces((int)cnt));
                        }
                        ++i;
                    }
                    this.stream.println(prettyLine.toString());
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.close();
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Failed to close trajectory data file \"%s\".", (Object[])new Object[]{pathTmp});
                throw new InputOutputException(msg, (Throwable)e);
            }
            try {
                Files.delete(ptmp);
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Failed to delete trajectory data file \"%s\".", (Object[])new Object[]{pathTmp});
                throw new InputOutputException(msg, (Throwable)e);
            }
            throw throwable;
        }
        this.close();
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Failed to close trajectory data file \"%s\".", (Object[])new Object[]{pathTmp});
            throw new InputOutputException(msg, (Throwable)e);
        }
        try {
            Files.delete(ptmp);
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Failed to delete trajectory data file \"%s\".", (Object[])new Object[]{pathTmp});
            throw new InputOutputException(msg, (Throwable)e);
        }
    }

    public static OptionCategory getOptions() {
        List subCats = Lists.list();
        List opts = Lists.list();
        opts.add(Options.getInstance(TrajDataOption.class));
        opts.add(Options.getInstance(TrajDataFileOption.class));
        opts.add(Options.getInstance(TrajDataFiltersOption.class));
        opts.add(Options.getInstance(TrajDataSepOption.class));
        return new OptionCategory("Trajectory data", "Trajectory data file output options.", subCats, opts);
    }
}

