/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.graph;

import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.bdd.varorder.graph.Node;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;

public class Graph {
    public final List<Node> nodes;

    public Graph(int nodeCount) {
        this.nodes = Lists.listc((int)nodeCount);
        int i = 0;
        while (i < nodeCount) {
            this.nodes.add(new Node(i));
            ++i;
        }
    }

    public Node node(int index) {
        return this.nodes.get(index);
    }

    public int size() {
        return this.nodes.size();
    }

    public long edgeCount() {
        return this.nodes.stream().flatMap(n -> n.neighbours().stream().map(m -> Pair.pair((Object)node.index, (Object)m.index))).map(p -> (Integer)p.left > (Integer)p.right ? Pair.pair((Object)((Integer)p.right), (Object)((Integer)p.left)) : p).distinct().count();
    }

    public List<List<Node>> partition() {
        List partitions = Lists.listc((int)1);
        BitSet unpartitionedNodes = BitSets.ones((int)this.nodes.size());
        while (!unpartitionedNodes.isEmpty()) {
            BitSet partition = BitSets.bitset();
            BitSet newNodes = BitSets.bitset();
            newNodes.set(unpartitionedNodes.nextSetBit(0));
            while (!newNodes.isEmpty()) {
                BitSet neighbours = BitSets.bitset();
                Iterator iterator = BitSets.iterateTrueBits((BitSet)newNodes).iterator();
                while (iterator.hasNext()) {
                    int i2 = (Integer)iterator.next();
                    for (Node neighbour : this.node(i2).neighbours()) {
                        neighbours.set(neighbour.index);
                    }
                }
                partition.or(newNodes);
                newNodes = neighbours;
                newNodes.andNot(partition);
            }
            partitions.add(partition.stream().mapToObj(i -> this.node(i)).collect(Collectors.toList()));
            unpartitionedNodes.andNot(partition);
        }
        return partitions;
    }

    public Graph reorder(List<Node> newOrder) {
        Assert.areEqual((Object)Sets.list2set(newOrder), (Object)Sets.list2set(this.nodes));
        Graph newGraph = new Graph(this.nodes.size());
        Map<Node, Node> nodeMap = IntStream.range(0, newOrder.size()).boxed().collect(Collectors.toMap(newOrder::get, i -> graph.nodes.get((int)i)));
        for (Node node : this.nodes) {
            Node newNode = nodeMap.get(node);
            for (Map.Entry<Node, Integer> edge : node.edges()) {
                Node newTarget = nodeMap.get(edge.getKey());
                newNode.addEdge(newTarget, edge.getValue());
            }
        }
        return newGraph;
    }

    public String toString() {
        int maxWeight = this.nodes.stream().flatMap(n -> n.edges().stream()).map(e -> (Integer)e.getValue()).max(Comparator.naturalOrder()).orElse(0);
        int separator = maxWeight <= 9 ? 0 : 1;
        return this.toString(separator);
    }

    String toString(int separation) {
        GridBox grid = new GridBox(this.nodes.size(), this.nodes.size(), 0, separation);
        for (Node node : this.nodes) {
            for (Map.Entry<Node, Integer> edge : node.edges()) {
                grid.set(node.index, edge.getKey().index, Integer.toString(edge.getValue()));
            }
        }
        int i = 0;
        while (i < this.nodes.size()) {
            int j = 0;
            while (j < this.nodes.size()) {
                if (grid.get(i, j) == null) {
                    grid.set(i, j, ".");
                }
                ++j;
            }
            ++i;
        }
        return String.join((CharSequence)"\n", grid.getLines());
    }
}

