//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2010, 2025 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

// Disable Eclipse Java formatter for generated code file:
// @formatter:off

package org.eclipse.escet.setext.parser;

import static org.eclipse.escet.common.java.Strings.fmt;

import java.io.IOException;
import java.util.List;

import org.eclipse.escet.setext.parser.ast.Decl;
import org.eclipse.escet.setext.parser.ast.HooksDecl;
import org.eclipse.escet.setext.parser.ast.Identifier;
import org.eclipse.escet.setext.parser.ast.Name;
import org.eclipse.escet.setext.parser.ast.Specification;
import org.eclipse.escet.setext.parser.ast.Symbol;
import org.eclipse.escet.setext.parser.ast.TerminalDescription;
import org.eclipse.escet.setext.parser.ast.parser.ImportDecl;
import org.eclipse.escet.setext.parser.ast.parser.JavaType;
import org.eclipse.escet.setext.parser.ast.parser.NonTerminal;
import org.eclipse.escet.setext.parser.ast.parser.ParserRule;
import org.eclipse.escet.setext.parser.ast.parser.StartSymbol;
import org.eclipse.escet.setext.parser.ast.regex.RegEx;
import org.eclipse.escet.setext.parser.ast.regex.RegExChar;
import org.eclipse.escet.setext.parser.ast.regex.RegExChars;
import org.eclipse.escet.setext.parser.ast.scanner.KeywordsIdentifier;
import org.eclipse.escet.setext.parser.ast.scanner.KeywordsTerminal;
import org.eclipse.escet.setext.parser.ast.scanner.ScannerDecl;
import org.eclipse.escet.setext.parser.ast.scanner.ShortcutDecl;
import org.eclipse.escet.setext.parser.ast.scanner.Terminal;
import org.eclipse.escet.setext.parser.ast.scanner.TerminalsDecl;
import org.eclipse.escet.setext.runtime.Parser;
import org.eclipse.escet.setext.runtime.ParserHooksBase;
import org.eclipse.escet.setext.runtime.Token;

/**
 * SeTextParser.
 *
 * <p>This parser is generated by SeText for main symbol
 * "Specification".</p>
 */
@SuppressWarnings("unchecked")
public final class SeTextParser extends Parser<Specification> {
    /** The names of the non-terminals, ordered by their unique ids. */
    private static final String[] NON_TERMINAL_NAMES = {
        "Specification",
        "Decls",
        "Decl",
        "TerminalsDecl",
        "Terminals",
        "Terminal",
        "KeywordsTerminal",
        "KeywordsIdentifiers",
        "RegExTerminal",
        "OptRegExId",
        "Identifier",
        "OptTermDescr",
        "OptFunc",
        "OptNewState",
        "ShortcutDecl",
        "MainDecl",
        "StartDecl",
        "HooksDecl",
        "ScannerDecl",
        "ImportDecl",
        "RuleDecl",
        "RuleAlts",
        "RuleAlt",
        "JavaTypes",
        "JavaType",
        "Name",
        "OptIdentifier",
        "RegExString",
        "RegEx",
        "RegExBranch",
        "RegExPiece",
        "RegExAtom",
        "RegExCharClass",
        "RegExCharsList",
        "RegExChars",
        "RegExChar",
    };

    /**
     * The entry symbol names for each of the parser states, and {@code null}
     * for the initial state.
     */
    private static final String[] ENTRY_SYMBOL_NAMES = new String[] {
        null,
        "ATTK",
        "CUROPENTK",
        "Decl",
        "Decls",
        "HooksDecl",
        "ImportDecl",
        "MainDecl",
        "RuleDecl",
        "ScannerDecl",
        "ShortcutDecl",
        "Specification",
        "StartDecl",
        "TerminalsDecl",
        "Decl",
        "IDENTIFIERTK",
        "NAMETK",
        "Identifier",
        "JavaType",
        "Name",
        "LTTK",
        "JavaType",
        "JavaTypes",
        "COMMATK",
        "GTTK",
        "JavaType",
        "CURCLOSETK",
        "Identifier",
        "COLONTK",
        "ATTK",
        "Identifier",
        "RuleAlt",
        "RuleAlts",
        "BARTK",
        "SEMICOLTK",
        "RuleAlt",
        "ATTK",
        "Identifier",
        "Identifier",
        "Identifier",
        "LTTK",
        "JavaTypes",
        "GTTK",
        "HOOKSKW",
        "IMPORTKW",
        "MAINKW",
        "SCANNERKW",
        "SHORTCUTKW",
        "STARTKW",
        "TERMINALSKW",
        "Identifier",
        "OptIdentifier",
        "COLONTK",
        "ATTK",
        "Identifier",
        "KeywordsTerminal",
        "OptRegExId",
        "RegExTerminal",
        "Terminal",
        "Terminals",
        "ENDKW",
        "Terminal",
        "REGEXSTARTTK",
        "RegExString",
        "CUROPENTK",
        "OptFunc",
        "ARROWTK",
        "OptNewState",
        "DESCRIPTIONTK",
        "OptTermDescr",
        "SEMICOLTK",
        "Identifier",
        "Identifier",
        "CURCLOSETK",
        "REGEXESCTK",
        "REGEXSHORTCUTTK",
        "PAROPENTK",
        "DOTTK",
        "SQOPENTK",
        "REGEXCHARTK",
        "RegEx",
        "RegExAtom",
        "RegExBranch",
        "RegExChar",
        "RegExCharClass",
        "RegExPiece",
        "ASTERISKTK",
        "PLUSTK",
        "QUESTIONTK",
        "RegExPiece",
        "REGEXENDTK",
        "REGEXBARTK",
        "RegExBranch",
        "CARETTK",
        "RegExChar",
        "RegExChars",
        "RegExCharsList",
        "SQCLOSETK",
        "RegExChars",
        "DASHTK",
        "RegExChar",
        "RegExCharsList",
        "SQCLOSETK",
        "RegEx",
        "PARCLOSETK",
        "EQTK",
        "EOFKW",
        "KEYWORDSKW",
        "Identifier",
        "EQTK",
        "Identifier",
        "KeywordsIdentifiers",
        "SEMICOLTK",
        "Identifier",
        "OptFunc",
        "OptTermDescr",
        "OptFunc",
        "OptTermDescr",
        "SEMICOLTK",
        "Identifier",
        "COLONTK",
        "JavaType",
        "SEMICOLTK",
        "Identifier",
        "EQTK",
        "RegExString",
        "SEMICOLTK",
        "JavaType",
        "SEMICOLTK",
        "Identifier",
        "COLONTK",
        "JavaType",
        "SEMICOLTK",
        "JavaType",
        "ASKW",
        "SEMICOLTK",
        "Identifier",
        "SEMICOLTK",
        "JavaType",
        "SEMICOLTK",
    };

    /** Parser call back hook methods. */
    private final SeTextHooks hooks;

    /** Whether parsing has completed (final result has been accepted). */
    private boolean accept;

    /** The parse result, but only if {@code #accept} is {@code true}. */
    private Specification acceptObject;

    /** The current scanner token to process, if any. */
    private Token token;

    /** Whether parsing has resulted in a reduce action. */
    private boolean reduce;

    /** The state from which to reduce, if {@code #reduce} is {@code true}. */
    private int reduceState;

    /** The non-terminal to reduce, if {@code #reduce} is {@code true}. */
    private int reduceNonTerminal;

    /** Constructor for the {@link SeTextParser} class. */
    public SeTextParser() {
        super(new SeTextScanner());
        entrySymbolNames = ENTRY_SYMBOL_NAMES;
        firstTerminals = FirstTerminals.FIRST_TERMINALS;
        firstTerminalsReduced = FirstTerminalsReduced.FIRST_TERMINALS_REDUCED;
        reducibleNonTerminals = ReducibleNonTerminals.REDUCIBLE_NON_TERMINALS;
        reducibleNonTerminalsReduced = ReducibleNonTerminalsReduced.REDUCIBLE_NON_TERMINALS_REDUCED;
        hooks = ((SeTextScanner)scanner).hooks;
    }

    @Override
    public ParserHooksBase getHooks() {
        return hooks;
    }

    @Override
    protected final Specification parse() throws IOException {
        token = nextToken();
        int state;

        accept = false;

        while (true) {
            // Perform action.
            state = getCurrentState();
            reduce = false;

            switch (state) {
                case 0:
                    action0();
                    break;
                case 1:
                    action1();
                    break;
                case 2:
                    action2();
                    break;
                case 3:
                    action3();
                    break;
                case 4:
                    action4();
                    break;
                case 5:
                    action5();
                    break;
                case 6:
                    action6();
                    break;
                case 7:
                    action7();
                    break;
                case 8:
                    action8();
                    break;
                case 9:
                    action9();
                    break;
                case 10:
                    action10();
                    break;
                case 11:
                    action11();
                    break;
                case 12:
                    action12();
                    break;
                case 13:
                    action13();
                    break;
                case 14:
                    action14();
                    break;
                case 15:
                    action15();
                    break;
                case 16:
                    action16();
                    break;
                case 17:
                    action17();
                    break;
                case 18:
                    action18();
                    break;
                case 19:
                    action19();
                    break;
                case 20:
                    action20();
                    break;
                case 21:
                    action21();
                    break;
                case 22:
                    action22();
                    break;
                case 23:
                    action23();
                    break;
                case 24:
                    action24();
                    break;
                case 25:
                    action25();
                    break;
                case 26:
                    action26();
                    break;
                case 27:
                    action27();
                    break;
                case 28:
                    action28();
                    break;
                case 29:
                    action29();
                    break;
                case 30:
                    action30();
                    break;
                case 31:
                    action31();
                    break;
                case 32:
                    action32();
                    break;
                case 33:
                    action33();
                    break;
                case 34:
                    action34();
                    break;
                case 35:
                    action35();
                    break;
                case 36:
                    action36();
                    break;
                case 37:
                    action37();
                    break;
                case 38:
                    action38();
                    break;
                case 39:
                    action39();
                    break;
                case 40:
                    action40();
                    break;
                case 41:
                    action41();
                    break;
                case 42:
                    action42();
                    break;
                case 43:
                    action43();
                    break;
                case 44:
                    action44();
                    break;
                case 45:
                    action45();
                    break;
                case 46:
                    action46();
                    break;
                case 47:
                    action47();
                    break;
                case 48:
                    action48();
                    break;
                case 49:
                    action49();
                    break;
                case 50:
                    action50();
                    break;
                case 51:
                    action51();
                    break;
                case 52:
                    action52();
                    break;
                case 53:
                    action53();
                    break;
                case 54:
                    action54();
                    break;
                case 55:
                    action55();
                    break;
                case 56:
                    action56();
                    break;
                case 57:
                    action57();
                    break;
                case 58:
                    action58();
                    break;
                case 59:
                    action59();
                    break;
                case 60:
                    action60();
                    break;
                case 61:
                    action61();
                    break;
                case 62:
                    action62();
                    break;
                case 63:
                    action63();
                    break;
                case 64:
                    action64();
                    break;
                case 65:
                    action65();
                    break;
                case 66:
                    action66();
                    break;
                case 67:
                    action67();
                    break;
                case 68:
                    action68();
                    break;
                case 69:
                    action69();
                    break;
                case 70:
                    action70();
                    break;
                case 71:
                    action71();
                    break;
                case 72:
                    action72();
                    break;
                case 73:
                    action73();
                    break;
                case 74:
                    action74();
                    break;
                case 75:
                    action75();
                    break;
                case 76:
                    action76();
                    break;
                case 77:
                    action77();
                    break;
                case 78:
                    action78();
                    break;
                case 79:
                    action79();
                    break;
                case 80:
                    action80();
                    break;
                case 81:
                    action81();
                    break;
                case 82:
                    action82();
                    break;
                case 83:
                    action83();
                    break;
                case 84:
                    action84();
                    break;
                case 85:
                    action85();
                    break;
                case 86:
                    action86();
                    break;
                case 87:
                    action87();
                    break;
                case 88:
                    action88();
                    break;
                case 89:
                    action89();
                    break;
                case 90:
                    action90();
                    break;
                case 91:
                    action91();
                    break;
                case 92:
                    action92();
                    break;
                case 93:
                    action93();
                    break;
                case 94:
                    action94();
                    break;
                case 95:
                    action95();
                    break;
                case 96:
                    action96();
                    break;
                case 97:
                    action97();
                    break;
                case 98:
                    action98();
                    break;
                case 99:
                    action99();
                    break;
                case 100:
                    action100();
                    break;
                case 101:
                    action101();
                    break;
                case 102:
                    action102();
                    break;
                case 103:
                    action103();
                    break;
                case 104:
                    action104();
                    break;
                case 105:
                    action105();
                    break;
                case 106:
                    action106();
                    break;
                case 107:
                    action107();
                    break;
                case 108:
                    action108();
                    break;
                case 109:
                    action109();
                    break;
                case 110:
                    action110();
                    break;
                case 111:
                    action111();
                    break;
                case 112:
                    action112();
                    break;
                case 113:
                    action113();
                    break;
                case 114:
                    action114();
                    break;
                case 115:
                    action115();
                    break;
                case 116:
                    action116();
                    break;
                case 117:
                    action117();
                    break;
                case 118:
                    action118();
                    break;
                case 119:
                    action119();
                    break;
                case 120:
                    action120();
                    break;
                case 121:
                    action121();
                    break;
                case 122:
                    action122();
                    break;
                case 123:
                    action123();
                    break;
                case 124:
                    action124();
                    break;
                case 125:
                    action125();
                    break;
                case 126:
                    action126();
                    break;
                case 127:
                    action127();
                    break;
                case 128:
                    action128();
                    break;
                case 129:
                    action129();
                    break;
                case 130:
                    action130();
                    break;
                case 131:
                    action131();
                    break;
                case 132:
                    action132();
                    break;
                case 133:
                    action133();
                    break;
                case 134:
                    action134();
                    break;
                case 135:
                    action135();
                    break;
                case 136:
                    action136();
                    break;
                case 137:
                    action137();
                    break;
                case 138:
                    action138();
                    break;
                case 139:
                    action139();
                    break;
                default:
                    String msg = "Unknown parser state: " + state;
                    throw new RuntimeException(msg);
            }

            // Accept action.
            if (accept) {
                return acceptObject;
            }

            // Shift action.
            if (!reduce) {
                continue;
            }

            // Perform goto (as part of a reduce action).
            switch (reduceState) {
                case 0:
                    goto0();
                    break;
                case 1:
                    goto1();
                    break;
                case 2:
                    goto2();
                    break;
                case 3:
                    goto3();
                    break;
                case 4:
                    goto4();
                    break;
                case 5:
                    goto5();
                    break;
                case 6:
                    goto6();
                    break;
                case 7:
                    goto7();
                    break;
                case 8:
                    goto8();
                    break;
                case 9:
                    goto9();
                    break;
                case 10:
                    goto10();
                    break;
                case 11:
                    goto11();
                    break;
                case 12:
                    goto12();
                    break;
                case 13:
                    goto13();
                    break;
                case 14:
                    goto14();
                    break;
                case 15:
                    goto15();
                    break;
                case 16:
                    goto16();
                    break;
                case 17:
                    goto17();
                    break;
                case 18:
                    goto18();
                    break;
                case 19:
                    goto19();
                    break;
                case 20:
                    goto20();
                    break;
                case 21:
                    goto21();
                    break;
                case 22:
                    goto22();
                    break;
                case 23:
                    goto23();
                    break;
                case 24:
                    goto24();
                    break;
                case 25:
                    goto25();
                    break;
                case 26:
                    goto26();
                    break;
                case 27:
                    goto27();
                    break;
                case 28:
                    goto28();
                    break;
                case 29:
                    goto29();
                    break;
                case 30:
                    goto30();
                    break;
                case 31:
                    goto31();
                    break;
                case 32:
                    goto32();
                    break;
                case 33:
                    goto33();
                    break;
                case 34:
                    goto34();
                    break;
                case 35:
                    goto35();
                    break;
                case 36:
                    goto36();
                    break;
                case 37:
                    goto37();
                    break;
                case 38:
                    goto38();
                    break;
                case 39:
                    goto39();
                    break;
                case 40:
                    goto40();
                    break;
                case 41:
                    goto41();
                    break;
                case 42:
                    goto42();
                    break;
                case 43:
                    goto43();
                    break;
                case 44:
                    goto44();
                    break;
                case 45:
                    goto45();
                    break;
                case 46:
                    goto46();
                    break;
                case 47:
                    goto47();
                    break;
                case 48:
                    goto48();
                    break;
                case 49:
                    goto49();
                    break;
                case 50:
                    goto50();
                    break;
                case 51:
                    goto51();
                    break;
                case 52:
                    goto52();
                    break;
                case 53:
                    goto53();
                    break;
                case 54:
                    goto54();
                    break;
                case 55:
                    goto55();
                    break;
                case 56:
                    goto56();
                    break;
                case 57:
                    goto57();
                    break;
                case 58:
                    goto58();
                    break;
                case 59:
                    goto59();
                    break;
                case 60:
                    goto60();
                    break;
                case 61:
                    goto61();
                    break;
                case 62:
                    goto62();
                    break;
                case 63:
                    goto63();
                    break;
                case 64:
                    goto64();
                    break;
                case 65:
                    goto65();
                    break;
                case 66:
                    goto66();
                    break;
                case 67:
                    goto67();
                    break;
                case 68:
                    goto68();
                    break;
                case 69:
                    goto69();
                    break;
                case 70:
                    goto70();
                    break;
                case 71:
                    goto71();
                    break;
                case 72:
                    goto72();
                    break;
                case 73:
                    goto73();
                    break;
                case 74:
                    goto74();
                    break;
                case 75:
                    goto75();
                    break;
                case 76:
                    goto76();
                    break;
                case 77:
                    goto77();
                    break;
                case 78:
                    goto78();
                    break;
                case 79:
                    goto79();
                    break;
                case 80:
                    goto80();
                    break;
                case 81:
                    goto81();
                    break;
                case 82:
                    goto82();
                    break;
                case 83:
                    goto83();
                    break;
                case 84:
                    goto84();
                    break;
                case 85:
                    goto85();
                    break;
                case 86:
                    goto86();
                    break;
                case 87:
                    goto87();
                    break;
                case 88:
                    goto88();
                    break;
                case 89:
                    goto89();
                    break;
                case 90:
                    goto90();
                    break;
                case 91:
                    goto91();
                    break;
                case 92:
                    goto92();
                    break;
                case 93:
                    goto93();
                    break;
                case 94:
                    goto94();
                    break;
                case 95:
                    goto95();
                    break;
                case 96:
                    goto96();
                    break;
                case 97:
                    goto97();
                    break;
                case 98:
                    goto98();
                    break;
                case 99:
                    goto99();
                    break;
                case 100:
                    goto100();
                    break;
                case 101:
                    goto101();
                    break;
                case 102:
                    goto102();
                    break;
                case 103:
                    goto103();
                    break;
                case 104:
                    goto104();
                    break;
                case 105:
                    goto105();
                    break;
                case 106:
                    goto106();
                    break;
                case 107:
                    goto107();
                    break;
                case 108:
                    goto108();
                    break;
                case 109:
                    goto109();
                    break;
                case 110:
                    goto110();
                    break;
                case 111:
                    goto111();
                    break;
                case 112:
                    goto112();
                    break;
                case 113:
                    goto113();
                    break;
                case 114:
                    goto114();
                    break;
                case 115:
                    goto115();
                    break;
                case 116:
                    goto116();
                    break;
                case 117:
                    goto117();
                    break;
                case 118:
                    goto118();
                    break;
                case 119:
                    goto119();
                    break;
                case 120:
                    goto120();
                    break;
                case 121:
                    goto121();
                    break;
                case 122:
                    goto122();
                    break;
                case 123:
                    goto123();
                    break;
                case 124:
                    goto124();
                    break;
                case 125:
                    goto125();
                    break;
                case 126:
                    goto126();
                    break;
                case 127:
                    goto127();
                    break;
                case 128:
                    goto128();
                    break;
                case 129:
                    goto129();
                    break;
                case 130:
                    goto130();
                    break;
                case 131:
                    goto131();
                    break;
                case 132:
                    goto132();
                    break;
                case 133:
                    goto133();
                    break;
                case 134:
                    goto134();
                    break;
                case 135:
                    goto135();
                    break;
                case 136:
                    goto136();
                    break;
                case 137:
                    goto137();
                    break;
                case 138:
                    goto138();
                    break;
                case 139:
                    goto139();
                    break;
                default:
                    String msg = fmt("Unknown reduce state %d.", reduceState);
                    throw new RuntimeException(msg);
            }
        }
    }

    /**
     * Parser action code for parser state 0.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action0() throws IOException {
        switch (token.id) {
            case 12: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 18: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            case 29: {
                // Reduce Specification : ;
                doReduce1(token, 0);
                Specification o = hooks.parseSpecification1();

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 1.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action1() throws IOException {
        switch (token.id) {
            case 3: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            case 4: {
                // Shift 44.
                token = doShift(token, 44);
                return;
            }

            case 6: {
                // Shift 45.
                token = doShift(token, 45);
                return;
            }

            case 7: {
                // Shift 46.
                token = doShift(token, 46);
                return;
            }

            case 8: {
                // Shift 47.
                token = doShift(token, 47);
                return;
            }

            case 9: {
                // Shift 48.
                token = doShift(token, 48);
                return;
            }

            case 10: {
                // Shift 49.
                token = doShift(token, 49);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 2.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action2() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 23: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 3.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action3() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce Decls : Decl;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                List<Decl> o = hooks.parseDecls1((Decl)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 4.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action4() throws IOException {
        switch (token.id) {
            case 12: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 18: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            case 29: {
                // Reduce Specification : Decls;
                doReduce1(token, 0);
                Object o1 = doReduce2();

                Specification o = hooks.parseSpecification2((List<Decl>)o1);

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 5.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action5() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce Decl : HooksDecl;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                Decl o = hooks.parseDecl5((HooksDecl)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 6.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action6() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce Decl : ImportDecl;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                Decl o = hooks.parseDecl7((ImportDecl)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 7.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action7() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce Decl : MainDecl;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                Decl o = hooks.parseDecl3((StartSymbol)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 8.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action8() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce Decl : RuleDecl;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                Decl o = hooks.parseDecl8((NonTerminal)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 9.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action9() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce Decl : ScannerDecl;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                Decl o = hooks.parseDecl6((ScannerDecl)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 10.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action10() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce Decl : ShortcutDecl;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                Decl o = hooks.parseDecl2((ShortcutDecl)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 11.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action11() throws IOException {
        switch (token.id) {
            case 29: {
                // Accept.
                Object rslt = doAccept(token);
                accept = true;
                acceptObject = (Specification)rslt;
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 12.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action12() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce Decl : StartDecl;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                Decl o = hooks.parseDecl4((StartSymbol)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 13.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action13() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce Decl : TerminalsDecl;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                Decl o = hooks.parseDecl1((TerminalsDecl)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 14.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action14() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce Decls : Decls Decl;
                doReduce1(token, 1);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<Decl> o = hooks.parseDecls2((List<Decl>)o1, (Decl)o2);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 15.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action15() throws IOException {
        switch (token.id) {
            case 0:
            case 12:
            case 13:
            case 14:
            case 15:
            case 16:
            case 17:
            case 18:
            case 19:
            case 20:
            case 21:
            case 22:
            case 24: {
                // Reduce Identifier : IDENTIFIERTK;
                doReduce1(token, 10);
                Object o1 = doReduce2();

                Identifier o = hooks.parseIdentifier1((Token)o1);

                reduce = true;
                reduceNonTerminal = 10;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 16.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action16() throws IOException {
        switch (token.id) {
            case 0:
            case 14:
            case 17:
            case 19:
            case 20:
            case 21: {
                // Reduce Name : NAMETK;
                doReduce1(token, 25);
                Object o1 = doReduce2();

                Name o = hooks.parseName1((Token)o1);

                reduce = true;
                reduceNonTerminal = 25;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 17.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action17() throws IOException {
        switch (token.id) {
            case 20: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 0:
            case 14:
            case 17:
            case 19:
            case 21: {
                // Reduce JavaType : Identifier;
                doReduce1(token, 24);
                Object o1 = doReduce2();

                JavaType o = hooks.parseJavaType1((Identifier)o1);

                reduce = true;
                reduceNonTerminal = 24;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 18.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action18() throws IOException {
        switch (token.id) {
            case 19: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 19.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action19() throws IOException {
        switch (token.id) {
            case 20: {
                // Shift 20.
                token = doShift(token, 20);
                return;
            }

            case 0:
            case 14:
            case 17:
            case 19:
            case 21: {
                // Reduce JavaType : Name;
                doReduce1(token, 24);
                Object o1 = doReduce2();

                JavaType o = hooks.parseJavaType3((Name)o1);

                reduce = true;
                reduceNonTerminal = 24;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 20.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action20() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 23: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 21.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action21() throws IOException {
        switch (token.id) {
            case 14:
            case 21: {
                // Reduce JavaTypes : JavaType;
                doReduce1(token, 23);
                Object o1 = doReduce2();

                List<JavaType> o = hooks.parseJavaTypes1((JavaType)o1);

                reduce = true;
                reduceNonTerminal = 23;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 22.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action22() throws IOException {
        switch (token.id) {
            case 14: {
                // Shift 23.
                token = doShift(token, 23);
                return;
            }

            case 21: {
                // Shift 24.
                token = doShift(token, 24);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 23.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action23() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 23: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 24.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action24() throws IOException {
        switch (token.id) {
            case 0:
            case 14:
            case 17:
            case 19:
            case 21: {
                // Reduce JavaType : Name LTTK JavaTypes GTTK;
                doReduce1(token, 24);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                JavaType o = hooks.parseJavaType4((Name)o1, (List<JavaType>)o3);

                reduce = true;
                reduceNonTerminal = 24;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 25.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action25() throws IOException {
        switch (token.id) {
            case 14:
            case 21: {
                // Reduce JavaTypes : JavaTypes COMMATK JavaType;
                doReduce1(token, 23);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<JavaType> o = hooks.parseJavaTypes2((List<JavaType>)o1, (JavaType)o3);

                reduce = true;
                reduceNonTerminal = 23;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 26.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action26() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 27.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action27() throws IOException {
        switch (token.id) {
            case 15: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 28.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action28() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 12: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 13:
            case 17: {
                // Reduce RuleAlts : ;
                doReduce1(token, 21);
                List<ParserRule> o = hooks.parseRuleAlts1();

                reduce = true;
                reduceNonTerminal = 21;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 29.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action29() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 30.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action30() throws IOException {
        switch (token.id) {
            case 12:
            case 13:
            case 17:
            case 22: {
                // Reduce RuleAlt : Identifier;
                doReduce1(token, 22);
                Object o1 = doReduce2();

                ParserRule o = hooks.parseRuleAlt1((Identifier)o1);

                reduce = true;
                reduceNonTerminal = 22;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 31.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action31() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 12: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 13:
            case 17: {
                // Reduce RuleAlts : RuleAlt;
                doReduce1(token, 21);
                Object o1 = doReduce2();

                List<ParserRule> o = hooks.parseRuleAlts2((ParserRule)o1);

                reduce = true;
                reduceNonTerminal = 21;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 32.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action32() throws IOException {
        switch (token.id) {
            case 13: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 17: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 33.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action33() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 12: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 34.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action34() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce RuleDecl : CUROPENTK JavaType CURCLOSETK Identifier COLONTK RuleAlts SEMICOLTK;
                doReduce1(token, 20);
                Object o7 = doReduce2();
                Object o6 = doReduce2();
                doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                doReduce2();

                NonTerminal o = hooks.parseRuleDecl1((JavaType)o2, (Identifier)o4, (List<ParserRule>)o6, (Token)o7);

                reduce = true;
                reduceNonTerminal = 20;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 35.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action35() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 12: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 13:
            case 17: {
                // Reduce RuleAlts : RuleAlts BARTK RuleAlt;
                doReduce1(token, 21);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<ParserRule> o = hooks.parseRuleAlts3((List<ParserRule>)o1, (ParserRule)o3);

                reduce = true;
                reduceNonTerminal = 21;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 36.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action36() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 37.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action37() throws IOException {
        switch (token.id) {
            case 12:
            case 13:
            case 17:
            case 22: {
                // Reduce RuleAlt : RuleAlt Identifier;
                doReduce1(token, 22);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                ParserRule o = hooks.parseRuleAlt3((ParserRule)o1, (Identifier)o2);

                reduce = true;
                reduceNonTerminal = 22;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 38.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action38() throws IOException {
        switch (token.id) {
            case 12:
            case 13:
            case 17:
            case 22: {
                // Reduce RuleAlt : RuleAlt ATTK Identifier;
                doReduce1(token, 22);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                ParserRule o = hooks.parseRuleAlt4((ParserRule)o1, (Identifier)o3);

                reduce = true;
                reduceNonTerminal = 22;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 39.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action39() throws IOException {
        switch (token.id) {
            case 12:
            case 13:
            case 17:
            case 22: {
                // Reduce RuleAlt : ATTK Identifier;
                doReduce1(token, 22);
                Object o2 = doReduce2();
                doReduce2();

                ParserRule o = hooks.parseRuleAlt2((Identifier)o2);

                reduce = true;
                reduceNonTerminal = 22;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 40.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action40() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 23: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 41.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action41() throws IOException {
        switch (token.id) {
            case 14: {
                // Shift 23.
                token = doShift(token, 23);
                return;
            }

            case 21: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 42.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action42() throws IOException {
        switch (token.id) {
            case 0:
            case 14:
            case 17:
            case 19:
            case 21: {
                // Reduce JavaType : Identifier LTTK JavaTypes GTTK;
                doReduce1(token, 24);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                JavaType o = hooks.parseJavaType2((Identifier)o1, (List<JavaType>)o3);

                reduce = true;
                reduceNonTerminal = 24;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 43.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action43() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 23: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 44.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action44() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 23: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 45.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action45() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 46.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action46() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 23: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 47.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action47() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 48.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action48() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 49.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action49() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 15: {
                // Reduce OptIdentifier : ;
                doReduce1(token, 26);
                Identifier o = hooks.parseOptIdentifier1();

                reduce = true;
                reduceNonTerminal = 26;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 50.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action50() throws IOException {
        switch (token.id) {
            case 15: {
                // Reduce OptIdentifier : Identifier;
                doReduce1(token, 26);
                Object o1 = doReduce2();

                Identifier o = hooks.parseOptIdentifier2((Identifier)o1);

                reduce = true;
                reduceNonTerminal = 26;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 51.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action51() throws IOException {
        switch (token.id) {
            case 15: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 52.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action52() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 12: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 25: {
                // Reduce OptRegExId : ;
                doReduce1(token, 9);
                Identifier o = hooks.parseOptRegExId1();

                reduce = true;
                reduceNonTerminal = 9;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 53.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action53() throws IOException {
        switch (token.id) {
            case 2: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 5: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 54.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action54() throws IOException {
        switch (token.id) {
            case 16: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 55.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action55() throws IOException {
        switch (token.id) {
            case 1:
            case 12:
            case 22:
            case 25: {
                // Reduce Terminal : KeywordsTerminal;
                doReduce1(token, 5);
                Object o1 = doReduce2();

                Symbol o = hooks.parseTerminal1((KeywordsTerminal)o1);

                reduce = true;
                reduceNonTerminal = 5;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 56.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action56() throws IOException {
        switch (token.id) {
            case 25: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 57.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action57() throws IOException {
        switch (token.id) {
            case 1:
            case 12:
            case 22:
            case 25: {
                // Reduce Terminal : RegExTerminal;
                doReduce1(token, 5);
                Object o1 = doReduce2();

                Symbol o = hooks.parseTerminal2((Terminal)o1);

                reduce = true;
                reduceNonTerminal = 5;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 58.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action58() throws IOException {
        switch (token.id) {
            case 1:
            case 12:
            case 22:
            case 25: {
                // Reduce Terminals : Terminal;
                doReduce1(token, 4);
                Object o1 = doReduce2();

                List<Symbol> o = hooks.parseTerminals1((Symbol)o1);

                reduce = true;
                reduceNonTerminal = 4;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 59.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action59() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 12: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 25: {
                // Reduce OptRegExId : ;
                doReduce1(token, 9);
                Identifier o = hooks.parseOptRegExId1();

                reduce = true;
                reduceNonTerminal = 9;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 60.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action60() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce TerminalsDecl : ATTK TERMINALSKW OptIdentifier COLONTK Terminals ENDKW;
                doReduce1(token, 3);
                Object o6 = doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                TerminalsDecl o = hooks.parseTerminalsDecl1((Token)o1, (Token)o2, (Identifier)o3, (List<Symbol>)o5, (Token)o6);

                reduce = true;
                reduceNonTerminal = 3;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 61.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action61() throws IOException {
        switch (token.id) {
            case 1:
            case 12:
            case 22:
            case 25: {
                // Reduce Terminals : Terminals Terminal;
                doReduce1(token, 4);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<Symbol> o = hooks.parseTerminals2((List<Symbol>)o1, (Symbol)o2);

                reduce = true;
                reduceNonTerminal = 4;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 62.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action62() throws IOException {
        switch (token.id) {
            case 34: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 35: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 36: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 41: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 42: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 47: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 63.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action63() throws IOException {
        switch (token.id) {
            case 18: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 11:
            case 17:
            case 24: {
                // Reduce OptFunc : ;
                doReduce1(token, 12);
                Identifier o = hooks.parseOptFunc1();

                reduce = true;
                reduceNonTerminal = 12;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 64.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action64() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 65.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action65() throws IOException {
        switch (token.id) {
            case 11: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 17:
            case 24: {
                // Reduce OptNewState : ;
                doReduce1(token, 13);
                Identifier o = hooks.parseOptNewState1();

                reduce = true;
                reduceNonTerminal = 13;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 66.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action66() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 17:
            case 24: {
                // Reduce OptNewState : ARROWTK;
                doReduce1(token, 13);
                Object o1 = doReduce2();

                Identifier o = hooks.parseOptNewState2((Token)o1);

                reduce = true;
                reduceNonTerminal = 13;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 67.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action67() throws IOException {
        switch (token.id) {
            case 24: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 17: {
                // Reduce OptTermDescr : ;
                doReduce1(token, 11);
                TerminalDescription o = hooks.parseOptTermDescr1();

                reduce = true;
                reduceNonTerminal = 11;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 68.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action68() throws IOException {
        switch (token.id) {
            case 17:
            case 22: {
                // Reduce OptTermDescr : DESCRIPTIONTK;
                doReduce1(token, 11);
                Object o1 = doReduce2();

                TerminalDescription o = hooks.parseOptTermDescr2((Token)o1);

                reduce = true;
                reduceNonTerminal = 11;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 69.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action69() throws IOException {
        switch (token.id) {
            case 17: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 70.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action70() throws IOException {
        switch (token.id) {
            case 1:
            case 12:
            case 22:
            case 25: {
                // Reduce RegExTerminal : OptRegExId RegExString OptFunc OptNewState OptTermDescr SEMICOLTK;
                doReduce1(token, 8);
                doReduce2();
                Object o5 = doReduce2();
                Object o4 = doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Terminal o = hooks.parseRegExTerminal1((Identifier)o1, (RegEx)o2, (Identifier)o3, (Identifier)o4, (TerminalDescription)o5);

                reduce = true;
                reduceNonTerminal = 8;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 71.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action71() throws IOException {
        switch (token.id) {
            case 17:
            case 24: {
                // Reduce OptNewState : ARROWTK Identifier;
                doReduce1(token, 13);
                Object o2 = doReduce2();
                doReduce2();

                Identifier o = hooks.parseOptNewState3((Identifier)o2);

                reduce = true;
                reduceNonTerminal = 13;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 72.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action72() throws IOException {
        switch (token.id) {
            case 19: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 73.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action73() throws IOException {
        switch (token.id) {
            case 11:
            case 17:
            case 22:
            case 24: {
                // Reduce OptFunc : CUROPENTK Identifier CURCLOSETK;
                doReduce1(token, 12);
                doReduce2();
                Object o2 = doReduce2();
                doReduce2();

                Identifier o = hooks.parseOptFunc2((Identifier)o2);

                reduce = true;
                reduceNonTerminal = 12;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 74.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action74() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 43:
            case 45:
            case 46:
            case 47: {
                // Reduce RegExChar : REGEXESCTK;
                doReduce1(token, 35);
                Object o1 = doReduce2();

                RegExChar o = hooks.parseRegExChar2((Token)o1);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 75.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action75() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExAtom : REGEXSHORTCUTTK;
                doReduce1(token, 31);
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExAtom2((Token)o1);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 76.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action76() throws IOException {
        switch (token.id) {
            case 34: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 35: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 36: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 41: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 42: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 47: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 77.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action77() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExAtom : DOTTK;
                doReduce1(token, 31);
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExAtom5((Token)o1);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 78.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action78() throws IOException {
        switch (token.id) {
            case 34: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 47: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 44: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 79.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action79() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 43:
            case 45:
            case 46:
            case 47: {
                // Reduce RegExChar : REGEXCHARTK;
                doReduce1(token, 35);
                Object o1 = doReduce2();

                RegExChar o = hooks.parseRegExChar1((Token)o1);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 80.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action80() throws IOException {
        switch (token.id) {
            case 33: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 46: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 81.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action81() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExPiece : RegExAtom;
                doReduce1(token, 30);
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExPiece1((RegEx)o1);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 82.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action82() throws IOException {
        switch (token.id) {
            case 34: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 35: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 36: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 41: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 42: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 47: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 33:
            case 37:
            case 46: {
                // Reduce RegEx : RegExBranch;
                doReduce1(token, 28);
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegEx1((RegEx)o1);

                reduce = true;
                reduceNonTerminal = 28;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 83.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action83() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExAtom : RegExChar;
                doReduce1(token, 31);
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExAtom4((RegExChar)o1);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 84.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action84() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExAtom : RegExCharClass;
                doReduce1(token, 31);
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExAtom3((RegEx)o1);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 85.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action85() throws IOException {
        switch (token.id) {
            case 38: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 39: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 40: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExBranch : RegExPiece;
                doReduce1(token, 29);
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExBranch1((RegEx)o1);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 86.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action86() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExPiece : RegExPiece ASTERISKTK;
                doReduce1(token, 30);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExPiece2((RegEx)o1, (Token)o2);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 87.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action87() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExPiece : RegExPiece PLUSTK;
                doReduce1(token, 30);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExPiece3((RegEx)o1, (Token)o2);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 88.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action88() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExPiece : RegExPiece QUESTIONTK;
                doReduce1(token, 30);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExPiece4((RegEx)o1, (Token)o2);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 89.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action89() throws IOException {
        switch (token.id) {
            case 38: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 39: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 40: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExBranch : RegExBranch RegExPiece;
                doReduce1(token, 29);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExBranch2((RegEx)o1, (RegEx)o2);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 90.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action90() throws IOException {
        switch (token.id) {
            case 11:
            case 17:
            case 18:
            case 24: {
                // Reduce RegExString : REGEXSTARTTK RegEx REGEXENDTK;
                doReduce1(token, 27);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExString1((Token)o1, (RegEx)o2, (Token)o3);

                reduce = true;
                reduceNonTerminal = 27;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 91.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action91() throws IOException {
        switch (token.id) {
            case 34: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 35: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 36: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 41: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 42: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 47: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 92.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action92() throws IOException {
        switch (token.id) {
            case 34: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 35: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 36: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 41: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 42: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 47: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 33:
            case 37:
            case 46: {
                // Reduce RegEx : RegEx REGEXBARTK RegExBranch;
                doReduce1(token, 28);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegEx2((RegEx)o1, (RegEx)o3);

                reduce = true;
                reduceNonTerminal = 28;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 93.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action93() throws IOException {
        switch (token.id) {
            case 34: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 47: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 94.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action94() throws IOException {
        switch (token.id) {
            case 45: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 34:
            case 43:
            case 47: {
                // Reduce RegExChars : RegExChar;
                doReduce1(token, 34);
                Object o1 = doReduce2();

                RegExChars o = hooks.parseRegExChars1((RegExChar)o1);

                reduce = true;
                reduceNonTerminal = 34;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 95.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action95() throws IOException {
        switch (token.id) {
            case 34:
            case 43:
            case 47: {
                // Reduce RegExCharsList : RegExChars;
                doReduce1(token, 33);
                Object o1 = doReduce2();

                List<RegExChars> o = hooks.parseRegExCharsList1((RegExChars)o1);

                reduce = true;
                reduceNonTerminal = 33;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 96.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action96() throws IOException {
        switch (token.id) {
            case 34: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 47: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 43: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 97.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action97() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExCharClass : SQOPENTK RegExCharsList SQCLOSETK;
                doReduce1(token, 32);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExCharClass1((Token)o1, (List<RegExChars>)o2);

                reduce = true;
                reduceNonTerminal = 32;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 98.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action98() throws IOException {
        switch (token.id) {
            case 34:
            case 43:
            case 47: {
                // Reduce RegExCharsList : RegExCharsList RegExChars;
                doReduce1(token, 33);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<RegExChars> o = hooks.parseRegExCharsList2((List<RegExChars>)o1, (RegExChars)o2);

                reduce = true;
                reduceNonTerminal = 33;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 99.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action99() throws IOException {
        switch (token.id) {
            case 34: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 47: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 100.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action100() throws IOException {
        switch (token.id) {
            case 34:
            case 43:
            case 47: {
                // Reduce RegExChars : RegExChar DASHTK RegExChar;
                doReduce1(token, 34);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                RegExChars o = hooks.parseRegExChars2((RegExChar)o1, (Token)o2, (RegExChar)o3);

                reduce = true;
                reduceNonTerminal = 34;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 101.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action101() throws IOException {
        switch (token.id) {
            case 34: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 47: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 102.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action102() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExCharClass : SQOPENTK CARETTK RegExCharsList SQCLOSETK;
                doReduce1(token, 32);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                RegEx o = hooks.parseRegExCharClass2((Token)o1, (List<RegExChars>)o3);

                reduce = true;
                reduceNonTerminal = 32;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 103.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action103() throws IOException {
        switch (token.id) {
            case 46: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 37: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 104.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action104() throws IOException {
        switch (token.id) {
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 41:
            case 42:
            case 46:
            case 47: {
                // Reduce RegExAtom : PAROPENTK RegEx PARCLOSETK;
                doReduce1(token, 31);
                doReduce2();
                Object o2 = doReduce2();
                doReduce2();

                RegEx o = hooks.parseRegExAtom1((RegEx)o2);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 105.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action105() throws IOException {
        switch (token.id) {
            case 25: {
                // Reduce OptRegExId : Identifier EQTK;
                doReduce1(token, 9);
                doReduce2();
                Object o1 = doReduce2();

                Identifier o = hooks.parseOptRegExId2((Identifier)o1);

                reduce = true;
                reduceNonTerminal = 9;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 106.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action106() throws IOException {
        switch (token.id) {
            case 17: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 107.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action107() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 108.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action108() throws IOException {
        switch (token.id) {
            case 16: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 109.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action109() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 110.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action110() throws IOException {
        switch (token.id) {
            case 18: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 17:
            case 22:
            case 24: {
                // Reduce OptFunc : ;
                doReduce1(token, 12);
                Identifier o = hooks.parseOptFunc1();

                reduce = true;
                reduceNonTerminal = 12;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 111.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action111() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 17: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 112.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action112() throws IOException {
        switch (token.id) {
            case 1:
            case 12:
            case 22:
            case 25: {
                // Reduce KeywordsTerminal : ATTK KEYWORDSKW Identifier EQTK KeywordsIdentifiers SEMICOLTK;
                doReduce1(token, 6);
                Object o6 = doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                KeywordsTerminal o = hooks.parseKeywordsTerminal1((Token)o1, (Identifier)o3, (List<KeywordsIdentifier>)o5, (Token)o6);

                reduce = true;
                reduceNonTerminal = 6;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 113.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action113() throws IOException {
        switch (token.id) {
            case 18: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 17:
            case 22:
            case 24: {
                // Reduce OptFunc : ;
                doReduce1(token, 12);
                Identifier o = hooks.parseOptFunc1();

                reduce = true;
                reduceNonTerminal = 12;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 114.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action114() throws IOException {
        switch (token.id) {
            case 24: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 17:
            case 22: {
                // Reduce OptTermDescr : ;
                doReduce1(token, 11);
                TerminalDescription o = hooks.parseOptTermDescr1();

                reduce = true;
                reduceNonTerminal = 11;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 115.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action115() throws IOException {
        switch (token.id) {
            case 17:
            case 22: {
                // Reduce KeywordsIdentifiers : KeywordsIdentifiers Identifier OptFunc OptTermDescr;
                doReduce1(token, 7);
                Object o4 = doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<KeywordsIdentifier> o = hooks.parseKeywordsIdentifiers2((List<KeywordsIdentifier>)o1, (Identifier)o2, (Identifier)o3, (TerminalDescription)o4);

                reduce = true;
                reduceNonTerminal = 7;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 116.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action116() throws IOException {
        switch (token.id) {
            case 24: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 17:
            case 22: {
                // Reduce OptTermDescr : ;
                doReduce1(token, 11);
                TerminalDescription o = hooks.parseOptTermDescr1();

                reduce = true;
                reduceNonTerminal = 11;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 117.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action117() throws IOException {
        switch (token.id) {
            case 17:
            case 22: {
                // Reduce KeywordsIdentifiers : Identifier OptFunc OptTermDescr;
                doReduce1(token, 7);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<KeywordsIdentifier> o = hooks.parseKeywordsIdentifiers1((Identifier)o1, (Identifier)o2, (TerminalDescription)o3);

                reduce = true;
                reduceNonTerminal = 7;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 118.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action118() throws IOException {
        switch (token.id) {
            case 1:
            case 12:
            case 22:
            case 25: {
                // Reduce Terminal : ATTK EOFKW SEMICOLTK;
                doReduce1(token, 5);
                doReduce2();
                Object o2 = doReduce2();
                doReduce2();

                Symbol o = hooks.parseTerminal3((Token)o2);

                reduce = true;
                reduceNonTerminal = 5;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 119.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action119() throws IOException {
        switch (token.id) {
            case 15: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 120.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action120() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 23: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 121.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action121() throws IOException {
        switch (token.id) {
            case 17: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 122.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action122() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce StartDecl : ATTK STARTKW Identifier COLONTK JavaType SEMICOLTK;
                doReduce1(token, 16);
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                doReduce2();

                StartSymbol o = hooks.parseStartDecl1((Identifier)o3, (JavaType)o5);

                reduce = true;
                reduceNonTerminal = 16;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 123.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action123() throws IOException {
        switch (token.id) {
            case 16: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 124.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action124() throws IOException {
        switch (token.id) {
            case 25: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 125.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action125() throws IOException {
        switch (token.id) {
            case 17: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 126.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action126() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce ShortcutDecl : ATTK SHORTCUTKW Identifier EQTK RegExString SEMICOLTK;
                doReduce1(token, 14);
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                doReduce2();

                ShortcutDecl o = hooks.parseShortcutDecl1((Identifier)o3, (RegEx)o5);

                reduce = true;
                reduceNonTerminal = 14;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 127.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action127() throws IOException {
        switch (token.id) {
            case 17: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 128.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action128() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce ScannerDecl : ATTK SCANNERKW JavaType SEMICOLTK;
                doReduce1(token, 18);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                doReduce2();

                ScannerDecl o = hooks.parseScannerDecl1((JavaType)o3);

                reduce = true;
                reduceNonTerminal = 18;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 129.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action129() throws IOException {
        switch (token.id) {
            case 15: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 130.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action130() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            case 23: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 131.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action131() throws IOException {
        switch (token.id) {
            case 17: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 132.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action132() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce MainDecl : ATTK MAINKW Identifier COLONTK JavaType SEMICOLTK;
                doReduce1(token, 15);
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                doReduce2();

                StartSymbol o = hooks.parseMainDecl1((Identifier)o3, (JavaType)o5);

                reduce = true;
                reduceNonTerminal = 15;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 133.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action133() throws IOException {
        switch (token.id) {
            case 0: {
                // Shift 134.
                token = doShift(token, 134);
                return;
            }

            case 17: {
                // Shift 135.
                token = doShift(token, 135);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 134.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action134() throws IOException {
        switch (token.id) {
            case 22: {
                // Shift 15.
                token = doShift(token, 15);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 135.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action135() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce ImportDecl : ATTK IMPORTKW JavaType SEMICOLTK;
                doReduce1(token, 19);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                doReduce2();

                ImportDecl o = hooks.parseImportDecl1((JavaType)o3);

                reduce = true;
                reduceNonTerminal = 19;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 136.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action136() throws IOException {
        switch (token.id) {
            case 17: {
                // Shift 137.
                token = doShift(token, 137);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 137.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action137() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce ImportDecl : ATTK IMPORTKW JavaType ASKW Identifier SEMICOLTK;
                doReduce1(token, 19);
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                doReduce2();

                ImportDecl o = hooks.parseImportDecl2((JavaType)o3, (Identifier)o5);

                reduce = true;
                reduceNonTerminal = 19;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 138.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action138() throws IOException {
        switch (token.id) {
            case 17: {
                // Shift 139.
                token = doShift(token, 139);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 139.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action139() throws IOException {
        switch (token.id) {
            case 12:
            case 18:
            case 29: {
                // Reduce HooksDecl : ATTK HOOKSKW JavaType SEMICOLTK;
                doReduce1(token, 17);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                doReduce2();

                HooksDecl o = hooks.parseHooksDecl1((JavaType)o3);

                reduce = true;
                reduceNonTerminal = 17;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /** Parser goto code for parser state 0. */
    private final void goto0() {
        switch (reduceNonTerminal) {
            case 0:
                // Specification
                doGoto(11);
                return;

            case 1:
                // Decls
                doGoto(4);
                return;

            case 2:
                // Decl
                doGoto(3);
                return;

            case 3:
                // TerminalsDecl
                doGoto(13);
                return;

            case 14:
                // ShortcutDecl
                doGoto(10);
                return;

            case 15:
                // MainDecl
                doGoto(7);
                return;

            case 16:
                // StartDecl
                doGoto(12);
                return;

            case 17:
                // HooksDecl
                doGoto(5);
                return;

            case 18:
                // ScannerDecl
                doGoto(9);
                return;

            case 19:
                // ImportDecl
                doGoto(6);
                return;

            case 20:
                // RuleDecl
                doGoto(8);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 1. */
    private final void goto1() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 2. */
    private final void goto2() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(17);
                return;

            case 24:
                // JavaType
                doGoto(18);
                return;

            case 25:
                // Name
                doGoto(19);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 3. */
    private final void goto3() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 4. */
    private final void goto4() {
        switch (reduceNonTerminal) {
            case 2:
                // Decl
                doGoto(14);
                return;

            case 3:
                // TerminalsDecl
                doGoto(13);
                return;

            case 14:
                // ShortcutDecl
                doGoto(10);
                return;

            case 15:
                // MainDecl
                doGoto(7);
                return;

            case 16:
                // StartDecl
                doGoto(12);
                return;

            case 17:
                // HooksDecl
                doGoto(5);
                return;

            case 18:
                // ScannerDecl
                doGoto(9);
                return;

            case 19:
                // ImportDecl
                doGoto(6);
                return;

            case 20:
                // RuleDecl
                doGoto(8);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 5. */
    private final void goto5() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 6. */
    private final void goto6() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 7. */
    private final void goto7() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 8. */
    private final void goto8() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 9. */
    private final void goto9() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 10. */
    private final void goto10() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 11. */
    private final void goto11() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 12. */
    private final void goto12() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 13. */
    private final void goto13() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 14. */
    private final void goto14() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 15. */
    private final void goto15() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 16. */
    private final void goto16() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 17. */
    private final void goto17() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 18. */
    private final void goto18() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 19. */
    private final void goto19() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 20. */
    private final void goto20() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(17);
                return;

            case 23:
                // JavaTypes
                doGoto(22);
                return;

            case 24:
                // JavaType
                doGoto(21);
                return;

            case 25:
                // Name
                doGoto(19);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 21. */
    private final void goto21() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 22. */
    private final void goto22() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 23. */
    private final void goto23() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(17);
                return;

            case 24:
                // JavaType
                doGoto(25);
                return;

            case 25:
                // Name
                doGoto(19);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 24. */
    private final void goto24() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 25. */
    private final void goto25() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 26. */
    private final void goto26() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(27);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 27. */
    private final void goto27() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 28. */
    private final void goto28() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(30);
                return;

            case 21:
                // RuleAlts
                doGoto(32);
                return;

            case 22:
                // RuleAlt
                doGoto(31);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 29. */
    private final void goto29() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(39);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 30. */
    private final void goto30() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 31. */
    private final void goto31() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(37);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 32. */
    private final void goto32() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 33. */
    private final void goto33() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(30);
                return;

            case 22:
                // RuleAlt
                doGoto(35);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 34. */
    private final void goto34() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 35. */
    private final void goto35() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(37);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 36. */
    private final void goto36() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(38);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 37. */
    private final void goto37() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 38. */
    private final void goto38() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 39. */
    private final void goto39() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 40. */
    private final void goto40() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(17);
                return;

            case 23:
                // JavaTypes
                doGoto(41);
                return;

            case 24:
                // JavaType
                doGoto(21);
                return;

            case 25:
                // Name
                doGoto(19);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 41. */
    private final void goto41() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 42. */
    private final void goto42() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 43. */
    private final void goto43() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(17);
                return;

            case 24:
                // JavaType
                doGoto(138);
                return;

            case 25:
                // Name
                doGoto(19);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 44. */
    private final void goto44() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(17);
                return;

            case 24:
                // JavaType
                doGoto(133);
                return;

            case 25:
                // Name
                doGoto(19);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 45. */
    private final void goto45() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(129);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 46. */
    private final void goto46() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(17);
                return;

            case 24:
                // JavaType
                doGoto(127);
                return;

            case 25:
                // Name
                doGoto(19);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 47. */
    private final void goto47() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(123);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 48. */
    private final void goto48() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(119);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 49. */
    private final void goto49() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(50);
                return;

            case 26:
                // OptIdentifier
                doGoto(51);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 50. */
    private final void goto50() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 51. */
    private final void goto51() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 52. */
    private final void goto52() {
        switch (reduceNonTerminal) {
            case 4:
                // Terminals
                doGoto(59);
                return;

            case 5:
                // Terminal
                doGoto(58);
                return;

            case 6:
                // KeywordsTerminal
                doGoto(55);
                return;

            case 8:
                // RegExTerminal
                doGoto(57);
                return;

            case 9:
                // OptRegExId
                doGoto(56);
                return;

            case 10:
                // Identifier
                doGoto(54);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 53. */
    private final void goto53() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 54. */
    private final void goto54() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 55. */
    private final void goto55() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 56. */
    private final void goto56() {
        switch (reduceNonTerminal) {
            case 27:
                // RegExString
                doGoto(63);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 57. */
    private final void goto57() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 58. */
    private final void goto58() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 59. */
    private final void goto59() {
        switch (reduceNonTerminal) {
            case 5:
                // Terminal
                doGoto(61);
                return;

            case 6:
                // KeywordsTerminal
                doGoto(55);
                return;

            case 8:
                // RegExTerminal
                doGoto(57);
                return;

            case 9:
                // OptRegExId
                doGoto(56);
                return;

            case 10:
                // Identifier
                doGoto(54);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 60. */
    private final void goto60() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 61. */
    private final void goto61() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 62. */
    private final void goto62() {
        switch (reduceNonTerminal) {
            case 28:
                // RegEx
                doGoto(80);
                return;

            case 29:
                // RegExBranch
                doGoto(82);
                return;

            case 30:
                // RegExPiece
                doGoto(85);
                return;

            case 31:
                // RegExAtom
                doGoto(81);
                return;

            case 32:
                // RegExCharClass
                doGoto(84);
                return;

            case 35:
                // RegExChar
                doGoto(83);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 63. */
    private final void goto63() {
        switch (reduceNonTerminal) {
            case 12:
                // OptFunc
                doGoto(65);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 64. */
    private final void goto64() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(72);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 65. */
    private final void goto65() {
        switch (reduceNonTerminal) {
            case 13:
                // OptNewState
                doGoto(67);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 66. */
    private final void goto66() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(71);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 67. */
    private final void goto67() {
        switch (reduceNonTerminal) {
            case 11:
                // OptTermDescr
                doGoto(69);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 68. */
    private final void goto68() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 69. */
    private final void goto69() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 70. */
    private final void goto70() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 71. */
    private final void goto71() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 72. */
    private final void goto72() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 73. */
    private final void goto73() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 74. */
    private final void goto74() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 75. */
    private final void goto75() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 76. */
    private final void goto76() {
        switch (reduceNonTerminal) {
            case 28:
                // RegEx
                doGoto(103);
                return;

            case 29:
                // RegExBranch
                doGoto(82);
                return;

            case 30:
                // RegExPiece
                doGoto(85);
                return;

            case 31:
                // RegExAtom
                doGoto(81);
                return;

            case 32:
                // RegExCharClass
                doGoto(84);
                return;

            case 35:
                // RegExChar
                doGoto(83);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 77. */
    private final void goto77() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 78. */
    private final void goto78() {
        switch (reduceNonTerminal) {
            case 33:
                // RegExCharsList
                doGoto(96);
                return;

            case 34:
                // RegExChars
                doGoto(95);
                return;

            case 35:
                // RegExChar
                doGoto(94);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 79. */
    private final void goto79() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 80. */
    private final void goto80() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 81. */
    private final void goto81() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 82. */
    private final void goto82() {
        switch (reduceNonTerminal) {
            case 30:
                // RegExPiece
                doGoto(89);
                return;

            case 31:
                // RegExAtom
                doGoto(81);
                return;

            case 32:
                // RegExCharClass
                doGoto(84);
                return;

            case 35:
                // RegExChar
                doGoto(83);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 83. */
    private final void goto83() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 84. */
    private final void goto84() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 85. */
    private final void goto85() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 86. */
    private final void goto86() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 87. */
    private final void goto87() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 88. */
    private final void goto88() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 89. */
    private final void goto89() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 90. */
    private final void goto90() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 91. */
    private final void goto91() {
        switch (reduceNonTerminal) {
            case 29:
                // RegExBranch
                doGoto(92);
                return;

            case 30:
                // RegExPiece
                doGoto(85);
                return;

            case 31:
                // RegExAtom
                doGoto(81);
                return;

            case 32:
                // RegExCharClass
                doGoto(84);
                return;

            case 35:
                // RegExChar
                doGoto(83);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 92. */
    private final void goto92() {
        switch (reduceNonTerminal) {
            case 30:
                // RegExPiece
                doGoto(89);
                return;

            case 31:
                // RegExAtom
                doGoto(81);
                return;

            case 32:
                // RegExCharClass
                doGoto(84);
                return;

            case 35:
                // RegExChar
                doGoto(83);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 93. */
    private final void goto93() {
        switch (reduceNonTerminal) {
            case 33:
                // RegExCharsList
                doGoto(101);
                return;

            case 34:
                // RegExChars
                doGoto(95);
                return;

            case 35:
                // RegExChar
                doGoto(94);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 94. */
    private final void goto94() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 95. */
    private final void goto95() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 96. */
    private final void goto96() {
        switch (reduceNonTerminal) {
            case 34:
                // RegExChars
                doGoto(98);
                return;

            case 35:
                // RegExChar
                doGoto(94);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 97. */
    private final void goto97() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 98. */
    private final void goto98() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 99. */
    private final void goto99() {
        switch (reduceNonTerminal) {
            case 35:
                // RegExChar
                doGoto(100);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 100. */
    private final void goto100() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 101. */
    private final void goto101() {
        switch (reduceNonTerminal) {
            case 34:
                // RegExChars
                doGoto(98);
                return;

            case 35:
                // RegExChar
                doGoto(94);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 102. */
    private final void goto102() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 103. */
    private final void goto103() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 104. */
    private final void goto104() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 105. */
    private final void goto105() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 106. */
    private final void goto106() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 107. */
    private final void goto107() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(108);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 108. */
    private final void goto108() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 109. */
    private final void goto109() {
        switch (reduceNonTerminal) {
            case 7:
                // KeywordsIdentifiers
                doGoto(111);
                return;

            case 10:
                // Identifier
                doGoto(110);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 110. */
    private final void goto110() {
        switch (reduceNonTerminal) {
            case 12:
                // OptFunc
                doGoto(116);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 111. */
    private final void goto111() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(113);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 112. */
    private final void goto112() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 113. */
    private final void goto113() {
        switch (reduceNonTerminal) {
            case 12:
                // OptFunc
                doGoto(114);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 114. */
    private final void goto114() {
        switch (reduceNonTerminal) {
            case 11:
                // OptTermDescr
                doGoto(115);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 115. */
    private final void goto115() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 116. */
    private final void goto116() {
        switch (reduceNonTerminal) {
            case 11:
                // OptTermDescr
                doGoto(117);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 117. */
    private final void goto117() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 118. */
    private final void goto118() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 119. */
    private final void goto119() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 120. */
    private final void goto120() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(17);
                return;

            case 24:
                // JavaType
                doGoto(121);
                return;

            case 25:
                // Name
                doGoto(19);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 121. */
    private final void goto121() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 122. */
    private final void goto122() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 123. */
    private final void goto123() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 124. */
    private final void goto124() {
        switch (reduceNonTerminal) {
            case 27:
                // RegExString
                doGoto(125);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 125. */
    private final void goto125() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 126. */
    private final void goto126() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 127. */
    private final void goto127() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 128. */
    private final void goto128() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 129. */
    private final void goto129() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 130. */
    private final void goto130() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(17);
                return;

            case 24:
                // JavaType
                doGoto(131);
                return;

            case 25:
                // Name
                doGoto(19);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 131. */
    private final void goto131() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 132. */
    private final void goto132() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 133. */
    private final void goto133() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 134. */
    private final void goto134() {
        switch (reduceNonTerminal) {
            case 10:
                // Identifier
                doGoto(136);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 135. */
    private final void goto135() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 136. */
    private final void goto136() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 137. */
    private final void goto137() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 138. */
    private final void goto138() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 139. */
    private final void goto139() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    @Override
    protected final String getNonTerminalName(int nonTerminalId) {
        return NON_TERMINAL_NAMES[nonTerminalId];
    }

    /** See {@code Parser.firstTerminals}. */
    private static final class FirstTerminals {
        /** See {@code Parser.firstTerminals}. */
        private static final int[][] FIRST_TERMINALS = new int[140][];

        static {
            init0();
            init1();
            init2();
            init3();
            init4();
            init5();
            init6();
            init7();
            init8();
            init9();
            init10();
            init11();
            init12();
            init13();
            init14();
            init15();
            init16();
            init17();
            init18();
            init19();
            init20();
            init21();
            init22();
            init23();
            init24();
            init25();
            init26();
            init27();
            init28();
            init29();
            init30();
            init31();
            init32();
            init33();
            init34();
            init35();
            init36();
            init37();
            init38();
            init39();
            init40();
            init41();
            init42();
            init43();
            init44();
            init45();
            init46();
            init47();
            init48();
            init49();
            init50();
            init51();
            init52();
            init53();
            init54();
            init55();
            init56();
            init57();
            init58();
            init59();
            init60();
            init61();
            init62();
            init63();
            init64();
            init65();
            init66();
            init67();
            init68();
            init69();
            init70();
            init71();
            init72();
            init73();
            init74();
            init75();
            init76();
            init77();
            init78();
            init79();
            init80();
            init81();
            init82();
            init83();
            init84();
            init85();
            init86();
            init87();
            init88();
            init89();
            init90();
            init91();
            init92();
            init93();
            init94();
            init95();
            init96();
            init97();
            init98();
            init99();
            init100();
            init101();
            init102();
            init103();
            init104();
            init105();
            init106();
            init107();
            init108();
            init109();
            init110();
            init111();
            init112();
            init113();
            init114();
            init115();
            init116();
            init117();
            init118();
            init119();
            init120();
            init121();
            init122();
            init123();
            init124();
            init125();
            init126();
            init127();
            init128();
            init129();
            init130();
            init131();
            init132();
            init133();
            init134();
            init135();
            init136();
            init137();
            init138();
            init139();
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [0]}. */
        private static void init0() {
            FIRST_TERMINALS[0] = new int[] {12, 18, 29};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [1]}. */
        private static void init1() {
            FIRST_TERMINALS[1] = new int[] {3, 4, 6, 7, 8, 9, 10};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [2]}. */
        private static void init2() {
            FIRST_TERMINALS[2] = new int[] {22, 23};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [3]}. */
        private static void init3() {
            FIRST_TERMINALS[3] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [4]}. */
        private static void init4() {
            FIRST_TERMINALS[4] = new int[] {12, 18};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [5]}. */
        private static void init5() {
            FIRST_TERMINALS[5] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [6]}. */
        private static void init6() {
            FIRST_TERMINALS[6] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [7]}. */
        private static void init7() {
            FIRST_TERMINALS[7] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [8]}. */
        private static void init8() {
            FIRST_TERMINALS[8] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [9]}. */
        private static void init9() {
            FIRST_TERMINALS[9] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [10]}. */
        private static void init10() {
            FIRST_TERMINALS[10] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [11]}. */
        private static void init11() {
            FIRST_TERMINALS[11] = new int[] {29};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [12]}. */
        private static void init12() {
            FIRST_TERMINALS[12] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [13]}. */
        private static void init13() {
            FIRST_TERMINALS[13] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [14]}. */
        private static void init14() {
            FIRST_TERMINALS[14] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [15]}. */
        private static void init15() {
            FIRST_TERMINALS[15] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [16]}. */
        private static void init16() {
            FIRST_TERMINALS[16] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [17]}. */
        private static void init17() {
            FIRST_TERMINALS[17] = new int[] {20};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [18]}. */
        private static void init18() {
            FIRST_TERMINALS[18] = new int[] {19};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [19]}. */
        private static void init19() {
            FIRST_TERMINALS[19] = new int[] {20};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [20]}. */
        private static void init20() {
            FIRST_TERMINALS[20] = new int[] {22, 23};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [21]}. */
        private static void init21() {
            FIRST_TERMINALS[21] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [22]}. */
        private static void init22() {
            FIRST_TERMINALS[22] = new int[] {14, 21};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [23]}. */
        private static void init23() {
            FIRST_TERMINALS[23] = new int[] {22, 23};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [24]}. */
        private static void init24() {
            FIRST_TERMINALS[24] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [25]}. */
        private static void init25() {
            FIRST_TERMINALS[25] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [26]}. */
        private static void init26() {
            FIRST_TERMINALS[26] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [27]}. */
        private static void init27() {
            FIRST_TERMINALS[27] = new int[] {15};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [28]}. */
        private static void init28() {
            FIRST_TERMINALS[28] = new int[] {12, 13, 17, 22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [29]}. */
        private static void init29() {
            FIRST_TERMINALS[29] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [30]}. */
        private static void init30() {
            FIRST_TERMINALS[30] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [31]}. */
        private static void init31() {
            FIRST_TERMINALS[31] = new int[] {12, 22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [32]}. */
        private static void init32() {
            FIRST_TERMINALS[32] = new int[] {13, 17};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [33]}. */
        private static void init33() {
            FIRST_TERMINALS[33] = new int[] {12, 22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [34]}. */
        private static void init34() {
            FIRST_TERMINALS[34] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [35]}. */
        private static void init35() {
            FIRST_TERMINALS[35] = new int[] {12, 22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [36]}. */
        private static void init36() {
            FIRST_TERMINALS[36] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [37]}. */
        private static void init37() {
            FIRST_TERMINALS[37] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [38]}. */
        private static void init38() {
            FIRST_TERMINALS[38] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [39]}. */
        private static void init39() {
            FIRST_TERMINALS[39] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [40]}. */
        private static void init40() {
            FIRST_TERMINALS[40] = new int[] {22, 23};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [41]}. */
        private static void init41() {
            FIRST_TERMINALS[41] = new int[] {14, 21};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [42]}. */
        private static void init42() {
            FIRST_TERMINALS[42] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [43]}. */
        private static void init43() {
            FIRST_TERMINALS[43] = new int[] {22, 23};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [44]}. */
        private static void init44() {
            FIRST_TERMINALS[44] = new int[] {22, 23};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [45]}. */
        private static void init45() {
            FIRST_TERMINALS[45] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [46]}. */
        private static void init46() {
            FIRST_TERMINALS[46] = new int[] {22, 23};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [47]}. */
        private static void init47() {
            FIRST_TERMINALS[47] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [48]}. */
        private static void init48() {
            FIRST_TERMINALS[48] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [49]}. */
        private static void init49() {
            FIRST_TERMINALS[49] = new int[] {15, 22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [50]}. */
        private static void init50() {
            FIRST_TERMINALS[50] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [51]}. */
        private static void init51() {
            FIRST_TERMINALS[51] = new int[] {15};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [52]}. */
        private static void init52() {
            FIRST_TERMINALS[52] = new int[] {12, 22, 25};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [53]}. */
        private static void init53() {
            FIRST_TERMINALS[53] = new int[] {2, 5};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [54]}. */
        private static void init54() {
            FIRST_TERMINALS[54] = new int[] {16};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [55]}. */
        private static void init55() {
            FIRST_TERMINALS[55] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [56]}. */
        private static void init56() {
            FIRST_TERMINALS[56] = new int[] {25};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [57]}. */
        private static void init57() {
            FIRST_TERMINALS[57] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [58]}. */
        private static void init58() {
            FIRST_TERMINALS[58] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [59]}. */
        private static void init59() {
            FIRST_TERMINALS[59] = new int[] {1, 12, 22, 25};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [60]}. */
        private static void init60() {
            FIRST_TERMINALS[60] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [61]}. */
        private static void init61() {
            FIRST_TERMINALS[61] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [62]}. */
        private static void init62() {
            FIRST_TERMINALS[62] = new int[] {34, 35, 36, 41, 42, 47};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [63]}. */
        private static void init63() {
            FIRST_TERMINALS[63] = new int[] {11, 17, 18, 24};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [64]}. */
        private static void init64() {
            FIRST_TERMINALS[64] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [65]}. */
        private static void init65() {
            FIRST_TERMINALS[65] = new int[] {11, 17, 24};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [66]}. */
        private static void init66() {
            FIRST_TERMINALS[66] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [67]}. */
        private static void init67() {
            FIRST_TERMINALS[67] = new int[] {17, 24};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [68]}. */
        private static void init68() {
            FIRST_TERMINALS[68] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [69]}. */
        private static void init69() {
            FIRST_TERMINALS[69] = new int[] {17};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [70]}. */
        private static void init70() {
            FIRST_TERMINALS[70] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [71]}. */
        private static void init71() {
            FIRST_TERMINALS[71] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [72]}. */
        private static void init72() {
            FIRST_TERMINALS[72] = new int[] {19};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [73]}. */
        private static void init73() {
            FIRST_TERMINALS[73] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [74]}. */
        private static void init74() {
            FIRST_TERMINALS[74] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [75]}. */
        private static void init75() {
            FIRST_TERMINALS[75] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [76]}. */
        private static void init76() {
            FIRST_TERMINALS[76] = new int[] {34, 35, 36, 41, 42, 47};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [77]}. */
        private static void init77() {
            FIRST_TERMINALS[77] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [78]}. */
        private static void init78() {
            FIRST_TERMINALS[78] = new int[] {34, 44, 47};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [79]}. */
        private static void init79() {
            FIRST_TERMINALS[79] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [80]}. */
        private static void init80() {
            FIRST_TERMINALS[80] = new int[] {33, 46};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [81]}. */
        private static void init81() {
            FIRST_TERMINALS[81] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [82]}. */
        private static void init82() {
            FIRST_TERMINALS[82] = new int[] {34, 35, 36, 41, 42, 47};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [83]}. */
        private static void init83() {
            FIRST_TERMINALS[83] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [84]}. */
        private static void init84() {
            FIRST_TERMINALS[84] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [85]}. */
        private static void init85() {
            FIRST_TERMINALS[85] = new int[] {38, 39, 40};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [86]}. */
        private static void init86() {
            FIRST_TERMINALS[86] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [87]}. */
        private static void init87() {
            FIRST_TERMINALS[87] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [88]}. */
        private static void init88() {
            FIRST_TERMINALS[88] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [89]}. */
        private static void init89() {
            FIRST_TERMINALS[89] = new int[] {38, 39, 40};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [90]}. */
        private static void init90() {
            FIRST_TERMINALS[90] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [91]}. */
        private static void init91() {
            FIRST_TERMINALS[91] = new int[] {34, 35, 36, 41, 42, 47};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [92]}. */
        private static void init92() {
            FIRST_TERMINALS[92] = new int[] {34, 35, 36, 41, 42, 47};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [93]}. */
        private static void init93() {
            FIRST_TERMINALS[93] = new int[] {34, 47};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [94]}. */
        private static void init94() {
            FIRST_TERMINALS[94] = new int[] {45};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [95]}. */
        private static void init95() {
            FIRST_TERMINALS[95] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [96]}. */
        private static void init96() {
            FIRST_TERMINALS[96] = new int[] {34, 43, 47};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [97]}. */
        private static void init97() {
            FIRST_TERMINALS[97] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [98]}. */
        private static void init98() {
            FIRST_TERMINALS[98] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [99]}. */
        private static void init99() {
            FIRST_TERMINALS[99] = new int[] {34, 47};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [100]}. */
        private static void init100() {
            FIRST_TERMINALS[100] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [101]}. */
        private static void init101() {
            FIRST_TERMINALS[101] = new int[] {34, 43, 47};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [102]}. */
        private static void init102() {
            FIRST_TERMINALS[102] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [103]}. */
        private static void init103() {
            FIRST_TERMINALS[103] = new int[] {37, 46};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [104]}. */
        private static void init104() {
            FIRST_TERMINALS[104] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [105]}. */
        private static void init105() {
            FIRST_TERMINALS[105] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [106]}. */
        private static void init106() {
            FIRST_TERMINALS[106] = new int[] {17};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [107]}. */
        private static void init107() {
            FIRST_TERMINALS[107] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [108]}. */
        private static void init108() {
            FIRST_TERMINALS[108] = new int[] {16};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [109]}. */
        private static void init109() {
            FIRST_TERMINALS[109] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [110]}. */
        private static void init110() {
            FIRST_TERMINALS[110] = new int[] {18, 24};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [111]}. */
        private static void init111() {
            FIRST_TERMINALS[111] = new int[] {17, 22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [112]}. */
        private static void init112() {
            FIRST_TERMINALS[112] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [113]}. */
        private static void init113() {
            FIRST_TERMINALS[113] = new int[] {18, 24};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [114]}. */
        private static void init114() {
            FIRST_TERMINALS[114] = new int[] {24};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [115]}. */
        private static void init115() {
            FIRST_TERMINALS[115] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [116]}. */
        private static void init116() {
            FIRST_TERMINALS[116] = new int[] {24};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [117]}. */
        private static void init117() {
            FIRST_TERMINALS[117] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [118]}. */
        private static void init118() {
            FIRST_TERMINALS[118] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [119]}. */
        private static void init119() {
            FIRST_TERMINALS[119] = new int[] {15};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [120]}. */
        private static void init120() {
            FIRST_TERMINALS[120] = new int[] {22, 23};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [121]}. */
        private static void init121() {
            FIRST_TERMINALS[121] = new int[] {17};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [122]}. */
        private static void init122() {
            FIRST_TERMINALS[122] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [123]}. */
        private static void init123() {
            FIRST_TERMINALS[123] = new int[] {16};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [124]}. */
        private static void init124() {
            FIRST_TERMINALS[124] = new int[] {25};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [125]}. */
        private static void init125() {
            FIRST_TERMINALS[125] = new int[] {17};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [126]}. */
        private static void init126() {
            FIRST_TERMINALS[126] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [127]}. */
        private static void init127() {
            FIRST_TERMINALS[127] = new int[] {17};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [128]}. */
        private static void init128() {
            FIRST_TERMINALS[128] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [129]}. */
        private static void init129() {
            FIRST_TERMINALS[129] = new int[] {15};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [130]}. */
        private static void init130() {
            FIRST_TERMINALS[130] = new int[] {22, 23};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [131]}. */
        private static void init131() {
            FIRST_TERMINALS[131] = new int[] {17};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [132]}. */
        private static void init132() {
            FIRST_TERMINALS[132] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [133]}. */
        private static void init133() {
            FIRST_TERMINALS[133] = new int[] {0, 17};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [134]}. */
        private static void init134() {
            FIRST_TERMINALS[134] = new int[] {22};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [135]}. */
        private static void init135() {
            FIRST_TERMINALS[135] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [136]}. */
        private static void init136() {
            FIRST_TERMINALS[136] = new int[] {17};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [137]}. */
        private static void init137() {
            FIRST_TERMINALS[137] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [138]}. */
        private static void init138() {
            FIRST_TERMINALS[138] = new int[] {17};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [139]}. */
        private static void init139() {
            FIRST_TERMINALS[139] = new int[] {};
        }
    }

    /** See {@code Parser.firstTerminalsReduced}. */
    private static final class FirstTerminalsReduced {
        /** See {@code Parser.firstTerminalsReduced}. */
        private static final int[][][] FIRST_TERMINALS_REDUCED = new int[140][][];

        static {
            init0();
            init1();
            init2();
            init3();
            init4();
            init5();
            init6();
            init7();
            init8();
            init9();
            init10();
            init11();
            init12();
            init13();
            init14();
            init15();
            init16();
            init17();
            init18();
            init19();
            init20();
            init21();
            init22();
            init23();
            init24();
            init25();
            init26();
            init27();
            init28();
            init29();
            init30();
            init31();
            init32();
            init33();
            init34();
            init35();
            init36();
            init37();
            init38();
            init39();
            init40();
            init41();
            init42();
            init43();
            init44();
            init45();
            init46();
            init47();
            init48();
            init49();
            init50();
            init51();
            init52();
            init53();
            init54();
            init55();
            init56();
            init57();
            init58();
            init59();
            init60();
            init61();
            init62();
            init63();
            init64();
            init65();
            init66();
            init67();
            init68();
            init69();
            init70();
            init71();
            init72();
            init73();
            init74();
            init75();
            init76();
            init77();
            init78();
            init79();
            init80();
            init81();
            init82();
            init83();
            init84();
            init85();
            init86();
            init87();
            init88();
            init89();
            init90();
            init91();
            init92();
            init93();
            init94();
            init95();
            init96();
            init97();
            init98();
            init99();
            init100();
            init101();
            init102();
            init103();
            init104();
            init105();
            init106();
            init107();
            init108();
            init109();
            init110();
            init111();
            init112();
            init113();
            init114();
            init115();
            init116();
            init117();
            init118();
            init119();
            init120();
            init121();
            init122();
            init123();
            init124();
            init125();
            init126();
            init127();
            init128();
            init129();
            init130();
            init131();
            init132();
            init133();
            init134();
            init135();
            init136();
            init137();
            init138();
            init139();
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [0]}. */
        private static void init0() {
            FIRST_TERMINALS_REDUCED[0] = new int[][] {
                {0, 29},
                {1, 12, 18},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [1]}. */
        private static void init1() {
            FIRST_TERMINALS_REDUCED[1] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [2]}. */
        private static void init2() {
            FIRST_TERMINALS_REDUCED[2] = new int[][] {
                {10, 20},
                {24, 19},
                {25, 20},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [3]}. */
        private static void init3() {
            FIRST_TERMINALS_REDUCED[3] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [4]}. */
        private static void init4() {
            FIRST_TERMINALS_REDUCED[4] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [5]}. */
        private static void init5() {
            FIRST_TERMINALS_REDUCED[5] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [6]}. */
        private static void init6() {
            FIRST_TERMINALS_REDUCED[6] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [7]}. */
        private static void init7() {
            FIRST_TERMINALS_REDUCED[7] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [8]}. */
        private static void init8() {
            FIRST_TERMINALS_REDUCED[8] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [9]}. */
        private static void init9() {
            FIRST_TERMINALS_REDUCED[9] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [10]}. */
        private static void init10() {
            FIRST_TERMINALS_REDUCED[10] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [11]}. */
        private static void init11() {
            FIRST_TERMINALS_REDUCED[11] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [12]}. */
        private static void init12() {
            FIRST_TERMINALS_REDUCED[12] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [13]}. */
        private static void init13() {
            FIRST_TERMINALS_REDUCED[13] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [14]}. */
        private static void init14() {
            FIRST_TERMINALS_REDUCED[14] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [15]}. */
        private static void init15() {
            FIRST_TERMINALS_REDUCED[15] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [16]}. */
        private static void init16() {
            FIRST_TERMINALS_REDUCED[16] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [17]}. */
        private static void init17() {
            FIRST_TERMINALS_REDUCED[17] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [18]}. */
        private static void init18() {
            FIRST_TERMINALS_REDUCED[18] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [19]}. */
        private static void init19() {
            FIRST_TERMINALS_REDUCED[19] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [20]}. */
        private static void init20() {
            FIRST_TERMINALS_REDUCED[20] = new int[][] {
                {10, 20},
                {23, 14, 21},
                {25, 20},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [21]}. */
        private static void init21() {
            FIRST_TERMINALS_REDUCED[21] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [22]}. */
        private static void init22() {
            FIRST_TERMINALS_REDUCED[22] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [23]}. */
        private static void init23() {
            FIRST_TERMINALS_REDUCED[23] = new int[][] {
                {10, 20},
                {25, 20},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [24]}. */
        private static void init24() {
            FIRST_TERMINALS_REDUCED[24] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [25]}. */
        private static void init25() {
            FIRST_TERMINALS_REDUCED[25] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [26]}. */
        private static void init26() {
            FIRST_TERMINALS_REDUCED[26] = new int[][] {
                {10, 15},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [27]}. */
        private static void init27() {
            FIRST_TERMINALS_REDUCED[27] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [28]}. */
        private static void init28() {
            FIRST_TERMINALS_REDUCED[28] = new int[][] {
                {21, 13, 17},
                {22, 12, 22},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [29]}. */
        private static void init29() {
            FIRST_TERMINALS_REDUCED[29] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [30]}. */
        private static void init30() {
            FIRST_TERMINALS_REDUCED[30] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [31]}. */
        private static void init31() {
            FIRST_TERMINALS_REDUCED[31] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [32]}. */
        private static void init32() {
            FIRST_TERMINALS_REDUCED[32] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [33]}. */
        private static void init33() {
            FIRST_TERMINALS_REDUCED[33] = new int[][] {
                {22, 12, 22},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [34]}. */
        private static void init34() {
            FIRST_TERMINALS_REDUCED[34] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [35]}. */
        private static void init35() {
            FIRST_TERMINALS_REDUCED[35] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [36]}. */
        private static void init36() {
            FIRST_TERMINALS_REDUCED[36] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [37]}. */
        private static void init37() {
            FIRST_TERMINALS_REDUCED[37] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [38]}. */
        private static void init38() {
            FIRST_TERMINALS_REDUCED[38] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [39]}. */
        private static void init39() {
            FIRST_TERMINALS_REDUCED[39] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [40]}. */
        private static void init40() {
            FIRST_TERMINALS_REDUCED[40] = new int[][] {
                {10, 20},
                {23, 14, 21},
                {25, 20},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [41]}. */
        private static void init41() {
            FIRST_TERMINALS_REDUCED[41] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [42]}. */
        private static void init42() {
            FIRST_TERMINALS_REDUCED[42] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [43]}. */
        private static void init43() {
            FIRST_TERMINALS_REDUCED[43] = new int[][] {
                {10, 20},
                {24, 17},
                {25, 20},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [44]}. */
        private static void init44() {
            FIRST_TERMINALS_REDUCED[44] = new int[][] {
                {10, 20},
                {24, 0, 17},
                {25, 20},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [45]}. */
        private static void init45() {
            FIRST_TERMINALS_REDUCED[45] = new int[][] {
                {10, 15},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [46]}. */
        private static void init46() {
            FIRST_TERMINALS_REDUCED[46] = new int[][] {
                {10, 20},
                {24, 17},
                {25, 20},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [47]}. */
        private static void init47() {
            FIRST_TERMINALS_REDUCED[47] = new int[][] {
                {10, 16},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [48]}. */
        private static void init48() {
            FIRST_TERMINALS_REDUCED[48] = new int[][] {
                {10, 15},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [49]}. */
        private static void init49() {
            FIRST_TERMINALS_REDUCED[49] = new int[][] {
                {26, 15},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [50]}. */
        private static void init50() {
            FIRST_TERMINALS_REDUCED[50] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [51]}. */
        private static void init51() {
            FIRST_TERMINALS_REDUCED[51] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [52]}. */
        private static void init52() {
            FIRST_TERMINALS_REDUCED[52] = new int[][] {
                {10, 16},
                {4, 1, 12, 22, 25},
                {9, 25},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [53]}. */
        private static void init53() {
            FIRST_TERMINALS_REDUCED[53] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [54]}. */
        private static void init54() {
            FIRST_TERMINALS_REDUCED[54] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [55]}. */
        private static void init55() {
            FIRST_TERMINALS_REDUCED[55] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [56]}. */
        private static void init56() {
            FIRST_TERMINALS_REDUCED[56] = new int[][] {
                {27, 11, 17, 18, 24},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [57]}. */
        private static void init57() {
            FIRST_TERMINALS_REDUCED[57] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [58]}. */
        private static void init58() {
            FIRST_TERMINALS_REDUCED[58] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [59]}. */
        private static void init59() {
            FIRST_TERMINALS_REDUCED[59] = new int[][] {
                {10, 16},
                {9, 25},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [60]}. */
        private static void init60() {
            FIRST_TERMINALS_REDUCED[60] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [61]}. */
        private static void init61() {
            FIRST_TERMINALS_REDUCED[61] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [62]}. */
        private static void init62() {
            FIRST_TERMINALS_REDUCED[62] = new int[][] {
                {28, 33, 46},
                {29, 34, 35, 36, 41, 42, 47},
                {30, 38, 39, 40},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [63]}. */
        private static void init63() {
            FIRST_TERMINALS_REDUCED[63] = new int[][] {
                {12, 11, 17, 24},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [64]}. */
        private static void init64() {
            FIRST_TERMINALS_REDUCED[64] = new int[][] {
                {10, 19},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [65]}. */
        private static void init65() {
            FIRST_TERMINALS_REDUCED[65] = new int[][] {
                {13, 17, 24},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [66]}. */
        private static void init66() {
            FIRST_TERMINALS_REDUCED[66] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [67]}. */
        private static void init67() {
            FIRST_TERMINALS_REDUCED[67] = new int[][] {
                {11, 17},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [68]}. */
        private static void init68() {
            FIRST_TERMINALS_REDUCED[68] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [69]}. */
        private static void init69() {
            FIRST_TERMINALS_REDUCED[69] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [70]}. */
        private static void init70() {
            FIRST_TERMINALS_REDUCED[70] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [71]}. */
        private static void init71() {
            FIRST_TERMINALS_REDUCED[71] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [72]}. */
        private static void init72() {
            FIRST_TERMINALS_REDUCED[72] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [73]}. */
        private static void init73() {
            FIRST_TERMINALS_REDUCED[73] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [74]}. */
        private static void init74() {
            FIRST_TERMINALS_REDUCED[74] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [75]}. */
        private static void init75() {
            FIRST_TERMINALS_REDUCED[75] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [76]}. */
        private static void init76() {
            FIRST_TERMINALS_REDUCED[76] = new int[][] {
                {28, 37, 46},
                {29, 34, 35, 36, 41, 42, 47},
                {30, 38, 39, 40},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [77]}. */
        private static void init77() {
            FIRST_TERMINALS_REDUCED[77] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [78]}. */
        private static void init78() {
            FIRST_TERMINALS_REDUCED[78] = new int[][] {
                {33, 34, 43, 47},
                {35, 45},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [79]}. */
        private static void init79() {
            FIRST_TERMINALS_REDUCED[79] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [80]}. */
        private static void init80() {
            FIRST_TERMINALS_REDUCED[80] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [81]}. */
        private static void init81() {
            FIRST_TERMINALS_REDUCED[81] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [82]}. */
        private static void init82() {
            FIRST_TERMINALS_REDUCED[82] = new int[][] {
                {30, 38, 39, 40},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [83]}. */
        private static void init83() {
            FIRST_TERMINALS_REDUCED[83] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [84]}. */
        private static void init84() {
            FIRST_TERMINALS_REDUCED[84] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [85]}. */
        private static void init85() {
            FIRST_TERMINALS_REDUCED[85] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [86]}. */
        private static void init86() {
            FIRST_TERMINALS_REDUCED[86] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [87]}. */
        private static void init87() {
            FIRST_TERMINALS_REDUCED[87] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [88]}. */
        private static void init88() {
            FIRST_TERMINALS_REDUCED[88] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [89]}. */
        private static void init89() {
            FIRST_TERMINALS_REDUCED[89] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [90]}. */
        private static void init90() {
            FIRST_TERMINALS_REDUCED[90] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [91]}. */
        private static void init91() {
            FIRST_TERMINALS_REDUCED[91] = new int[][] {
                {29, 34, 35, 36, 41, 42, 47},
                {30, 38, 39, 40},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [92]}. */
        private static void init92() {
            FIRST_TERMINALS_REDUCED[92] = new int[][] {
                {30, 38, 39, 40},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [93]}. */
        private static void init93() {
            FIRST_TERMINALS_REDUCED[93] = new int[][] {
                {33, 34, 43, 47},
                {35, 45},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [94]}. */
        private static void init94() {
            FIRST_TERMINALS_REDUCED[94] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [95]}. */
        private static void init95() {
            FIRST_TERMINALS_REDUCED[95] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [96]}. */
        private static void init96() {
            FIRST_TERMINALS_REDUCED[96] = new int[][] {
                {35, 45},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [97]}. */
        private static void init97() {
            FIRST_TERMINALS_REDUCED[97] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [98]}. */
        private static void init98() {
            FIRST_TERMINALS_REDUCED[98] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [99]}. */
        private static void init99() {
            FIRST_TERMINALS_REDUCED[99] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [100]}. */
        private static void init100() {
            FIRST_TERMINALS_REDUCED[100] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [101]}. */
        private static void init101() {
            FIRST_TERMINALS_REDUCED[101] = new int[][] {
                {35, 45},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [102]}. */
        private static void init102() {
            FIRST_TERMINALS_REDUCED[102] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [103]}. */
        private static void init103() {
            FIRST_TERMINALS_REDUCED[103] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [104]}. */
        private static void init104() {
            FIRST_TERMINALS_REDUCED[104] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [105]}. */
        private static void init105() {
            FIRST_TERMINALS_REDUCED[105] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [106]}. */
        private static void init106() {
            FIRST_TERMINALS_REDUCED[106] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [107]}. */
        private static void init107() {
            FIRST_TERMINALS_REDUCED[107] = new int[][] {
                {10, 16},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [108]}. */
        private static void init108() {
            FIRST_TERMINALS_REDUCED[108] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [109]}. */
        private static void init109() {
            FIRST_TERMINALS_REDUCED[109] = new int[][] {
                {10, 18, 24},
                {7, 17, 22},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [110]}. */
        private static void init110() {
            FIRST_TERMINALS_REDUCED[110] = new int[][] {
                {12, 24},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [111]}. */
        private static void init111() {
            FIRST_TERMINALS_REDUCED[111] = new int[][] {
                {10, 18, 24},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [112]}. */
        private static void init112() {
            FIRST_TERMINALS_REDUCED[112] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [113]}. */
        private static void init113() {
            FIRST_TERMINALS_REDUCED[113] = new int[][] {
                {12, 24},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [114]}. */
        private static void init114() {
            FIRST_TERMINALS_REDUCED[114] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [115]}. */
        private static void init115() {
            FIRST_TERMINALS_REDUCED[115] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [116]}. */
        private static void init116() {
            FIRST_TERMINALS_REDUCED[116] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [117]}. */
        private static void init117() {
            FIRST_TERMINALS_REDUCED[117] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [118]}. */
        private static void init118() {
            FIRST_TERMINALS_REDUCED[118] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [119]}. */
        private static void init119() {
            FIRST_TERMINALS_REDUCED[119] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [120]}. */
        private static void init120() {
            FIRST_TERMINALS_REDUCED[120] = new int[][] {
                {10, 20},
                {24, 17},
                {25, 20},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [121]}. */
        private static void init121() {
            FIRST_TERMINALS_REDUCED[121] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [122]}. */
        private static void init122() {
            FIRST_TERMINALS_REDUCED[122] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [123]}. */
        private static void init123() {
            FIRST_TERMINALS_REDUCED[123] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [124]}. */
        private static void init124() {
            FIRST_TERMINALS_REDUCED[124] = new int[][] {
                {27, 17},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [125]}. */
        private static void init125() {
            FIRST_TERMINALS_REDUCED[125] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [126]}. */
        private static void init126() {
            FIRST_TERMINALS_REDUCED[126] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [127]}. */
        private static void init127() {
            FIRST_TERMINALS_REDUCED[127] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [128]}. */
        private static void init128() {
            FIRST_TERMINALS_REDUCED[128] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [129]}. */
        private static void init129() {
            FIRST_TERMINALS_REDUCED[129] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [130]}. */
        private static void init130() {
            FIRST_TERMINALS_REDUCED[130] = new int[][] {
                {10, 20},
                {24, 17},
                {25, 20},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [131]}. */
        private static void init131() {
            FIRST_TERMINALS_REDUCED[131] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [132]}. */
        private static void init132() {
            FIRST_TERMINALS_REDUCED[132] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [133]}. */
        private static void init133() {
            FIRST_TERMINALS_REDUCED[133] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [134]}. */
        private static void init134() {
            FIRST_TERMINALS_REDUCED[134] = new int[][] {
                {10, 17},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [135]}. */
        private static void init135() {
            FIRST_TERMINALS_REDUCED[135] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [136]}. */
        private static void init136() {
            FIRST_TERMINALS_REDUCED[136] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [137]}. */
        private static void init137() {
            FIRST_TERMINALS_REDUCED[137] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [138]}. */
        private static void init138() {
            FIRST_TERMINALS_REDUCED[138] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [139]}. */
        private static void init139() {
            FIRST_TERMINALS_REDUCED[139] = new int[][] {};
        }
    }

    /** See {@code Parser.reducibleNonTerminals}. */
    private static final class ReducibleNonTerminals {
        /** See {@code Parser.reducibleNonTerminals}. */
        private static final int[][][] REDUCIBLE_NON_TERMINALS = new int[140][][];

        static {
            init0();
            init1();
            init2();
            init3();
            init4();
            init5();
            init6();
            init7();
            init8();
            init9();
            init10();
            init11();
            init12();
            init13();
            init14();
            init15();
            init16();
            init17();
            init18();
            init19();
            init20();
            init21();
            init22();
            init23();
            init24();
            init25();
            init26();
            init27();
            init28();
            init29();
            init30();
            init31();
            init32();
            init33();
            init34();
            init35();
            init36();
            init37();
            init38();
            init39();
            init40();
            init41();
            init42();
            init43();
            init44();
            init45();
            init46();
            init47();
            init48();
            init49();
            init50();
            init51();
            init52();
            init53();
            init54();
            init55();
            init56();
            init57();
            init58();
            init59();
            init60();
            init61();
            init62();
            init63();
            init64();
            init65();
            init66();
            init67();
            init68();
            init69();
            init70();
            init71();
            init72();
            init73();
            init74();
            init75();
            init76();
            init77();
            init78();
            init79();
            init80();
            init81();
            init82();
            init83();
            init84();
            init85();
            init86();
            init87();
            init88();
            init89();
            init90();
            init91();
            init92();
            init93();
            init94();
            init95();
            init96();
            init97();
            init98();
            init99();
            init100();
            init101();
            init102();
            init103();
            init104();
            init105();
            init106();
            init107();
            init108();
            init109();
            init110();
            init111();
            init112();
            init113();
            init114();
            init115();
            init116();
            init117();
            init118();
            init119();
            init120();
            init121();
            init122();
            init123();
            init124();
            init125();
            init126();
            init127();
            init128();
            init129();
            init130();
            init131();
            init132();
            init133();
            init134();
            init135();
            init136();
            init137();
            init138();
            init139();
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [0]}. */
        private static void init0() {
            REDUCIBLE_NON_TERMINALS[0] = new int[][] {
                {0, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [1]}. */
        private static void init1() {
            REDUCIBLE_NON_TERMINALS[1] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [2]}. */
        private static void init2() {
            REDUCIBLE_NON_TERMINALS[2] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [3]}. */
        private static void init3() {
            REDUCIBLE_NON_TERMINALS[3] = new int[][] {
                {1, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [4]}. */
        private static void init4() {
            REDUCIBLE_NON_TERMINALS[4] = new int[][] {
                {0, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [5]}. */
        private static void init5() {
            REDUCIBLE_NON_TERMINALS[5] = new int[][] {
                {2, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [6]}. */
        private static void init6() {
            REDUCIBLE_NON_TERMINALS[6] = new int[][] {
                {2, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [7]}. */
        private static void init7() {
            REDUCIBLE_NON_TERMINALS[7] = new int[][] {
                {2, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [8]}. */
        private static void init8() {
            REDUCIBLE_NON_TERMINALS[8] = new int[][] {
                {2, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [9]}. */
        private static void init9() {
            REDUCIBLE_NON_TERMINALS[9] = new int[][] {
                {2, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [10]}. */
        private static void init10() {
            REDUCIBLE_NON_TERMINALS[10] = new int[][] {
                {2, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [11]}. */
        private static void init11() {
            REDUCIBLE_NON_TERMINALS[11] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [12]}. */
        private static void init12() {
            REDUCIBLE_NON_TERMINALS[12] = new int[][] {
                {2, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [13]}. */
        private static void init13() {
            REDUCIBLE_NON_TERMINALS[13] = new int[][] {
                {2, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [14]}. */
        private static void init14() {
            REDUCIBLE_NON_TERMINALS[14] = new int[][] {
                {1, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [15]}. */
        private static void init15() {
            REDUCIBLE_NON_TERMINALS[15] = new int[][] {
                {10, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [16]}. */
        private static void init16() {
            REDUCIBLE_NON_TERMINALS[16] = new int[][] {
                {25, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [17]}. */
        private static void init17() {
            REDUCIBLE_NON_TERMINALS[17] = new int[][] {
                {24, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [18]}. */
        private static void init18() {
            REDUCIBLE_NON_TERMINALS[18] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [19]}. */
        private static void init19() {
            REDUCIBLE_NON_TERMINALS[19] = new int[][] {
                {24, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [20]}. */
        private static void init20() {
            REDUCIBLE_NON_TERMINALS[20] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [21]}. */
        private static void init21() {
            REDUCIBLE_NON_TERMINALS[21] = new int[][] {
                {23, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [22]}. */
        private static void init22() {
            REDUCIBLE_NON_TERMINALS[22] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [23]}. */
        private static void init23() {
            REDUCIBLE_NON_TERMINALS[23] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [24]}. */
        private static void init24() {
            REDUCIBLE_NON_TERMINALS[24] = new int[][] {
                {24, 4},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [25]}. */
        private static void init25() {
            REDUCIBLE_NON_TERMINALS[25] = new int[][] {
                {23, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [26]}. */
        private static void init26() {
            REDUCIBLE_NON_TERMINALS[26] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [27]}. */
        private static void init27() {
            REDUCIBLE_NON_TERMINALS[27] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [28]}. */
        private static void init28() {
            REDUCIBLE_NON_TERMINALS[28] = new int[][] {
                {21, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [29]}. */
        private static void init29() {
            REDUCIBLE_NON_TERMINALS[29] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [30]}. */
        private static void init30() {
            REDUCIBLE_NON_TERMINALS[30] = new int[][] {
                {22, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [31]}. */
        private static void init31() {
            REDUCIBLE_NON_TERMINALS[31] = new int[][] {
                {21, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [32]}. */
        private static void init32() {
            REDUCIBLE_NON_TERMINALS[32] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [33]}. */
        private static void init33() {
            REDUCIBLE_NON_TERMINALS[33] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [34]}. */
        private static void init34() {
            REDUCIBLE_NON_TERMINALS[34] = new int[][] {
                {20, 7},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [35]}. */
        private static void init35() {
            REDUCIBLE_NON_TERMINALS[35] = new int[][] {
                {21, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [36]}. */
        private static void init36() {
            REDUCIBLE_NON_TERMINALS[36] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [37]}. */
        private static void init37() {
            REDUCIBLE_NON_TERMINALS[37] = new int[][] {
                {22, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [38]}. */
        private static void init38() {
            REDUCIBLE_NON_TERMINALS[38] = new int[][] {
                {22, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [39]}. */
        private static void init39() {
            REDUCIBLE_NON_TERMINALS[39] = new int[][] {
                {22, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [40]}. */
        private static void init40() {
            REDUCIBLE_NON_TERMINALS[40] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [41]}. */
        private static void init41() {
            REDUCIBLE_NON_TERMINALS[41] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [42]}. */
        private static void init42() {
            REDUCIBLE_NON_TERMINALS[42] = new int[][] {
                {24, 4},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [43]}. */
        private static void init43() {
            REDUCIBLE_NON_TERMINALS[43] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [44]}. */
        private static void init44() {
            REDUCIBLE_NON_TERMINALS[44] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [45]}. */
        private static void init45() {
            REDUCIBLE_NON_TERMINALS[45] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [46]}. */
        private static void init46() {
            REDUCIBLE_NON_TERMINALS[46] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [47]}. */
        private static void init47() {
            REDUCIBLE_NON_TERMINALS[47] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [48]}. */
        private static void init48() {
            REDUCIBLE_NON_TERMINALS[48] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [49]}. */
        private static void init49() {
            REDUCIBLE_NON_TERMINALS[49] = new int[][] {
                {26, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [50]}. */
        private static void init50() {
            REDUCIBLE_NON_TERMINALS[50] = new int[][] {
                {26, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [51]}. */
        private static void init51() {
            REDUCIBLE_NON_TERMINALS[51] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [52]}. */
        private static void init52() {
            REDUCIBLE_NON_TERMINALS[52] = new int[][] {
                {9, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [53]}. */
        private static void init53() {
            REDUCIBLE_NON_TERMINALS[53] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [54]}. */
        private static void init54() {
            REDUCIBLE_NON_TERMINALS[54] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [55]}. */
        private static void init55() {
            REDUCIBLE_NON_TERMINALS[55] = new int[][] {
                {5, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [56]}. */
        private static void init56() {
            REDUCIBLE_NON_TERMINALS[56] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [57]}. */
        private static void init57() {
            REDUCIBLE_NON_TERMINALS[57] = new int[][] {
                {5, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [58]}. */
        private static void init58() {
            REDUCIBLE_NON_TERMINALS[58] = new int[][] {
                {4, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [59]}. */
        private static void init59() {
            REDUCIBLE_NON_TERMINALS[59] = new int[][] {
                {9, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [60]}. */
        private static void init60() {
            REDUCIBLE_NON_TERMINALS[60] = new int[][] {
                {3, 6},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [61]}. */
        private static void init61() {
            REDUCIBLE_NON_TERMINALS[61] = new int[][] {
                {4, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [62]}. */
        private static void init62() {
            REDUCIBLE_NON_TERMINALS[62] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [63]}. */
        private static void init63() {
            REDUCIBLE_NON_TERMINALS[63] = new int[][] {
                {12, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [64]}. */
        private static void init64() {
            REDUCIBLE_NON_TERMINALS[64] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [65]}. */
        private static void init65() {
            REDUCIBLE_NON_TERMINALS[65] = new int[][] {
                {13, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [66]}. */
        private static void init66() {
            REDUCIBLE_NON_TERMINALS[66] = new int[][] {
                {13, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [67]}. */
        private static void init67() {
            REDUCIBLE_NON_TERMINALS[67] = new int[][] {
                {11, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [68]}. */
        private static void init68() {
            REDUCIBLE_NON_TERMINALS[68] = new int[][] {
                {11, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [69]}. */
        private static void init69() {
            REDUCIBLE_NON_TERMINALS[69] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [70]}. */
        private static void init70() {
            REDUCIBLE_NON_TERMINALS[70] = new int[][] {
                {8, 6},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [71]}. */
        private static void init71() {
            REDUCIBLE_NON_TERMINALS[71] = new int[][] {
                {13, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [72]}. */
        private static void init72() {
            REDUCIBLE_NON_TERMINALS[72] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [73]}. */
        private static void init73() {
            REDUCIBLE_NON_TERMINALS[73] = new int[][] {
                {12, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [74]}. */
        private static void init74() {
            REDUCIBLE_NON_TERMINALS[74] = new int[][] {
                {35, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [75]}. */
        private static void init75() {
            REDUCIBLE_NON_TERMINALS[75] = new int[][] {
                {31, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [76]}. */
        private static void init76() {
            REDUCIBLE_NON_TERMINALS[76] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [77]}. */
        private static void init77() {
            REDUCIBLE_NON_TERMINALS[77] = new int[][] {
                {31, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [78]}. */
        private static void init78() {
            REDUCIBLE_NON_TERMINALS[78] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [79]}. */
        private static void init79() {
            REDUCIBLE_NON_TERMINALS[79] = new int[][] {
                {35, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [80]}. */
        private static void init80() {
            REDUCIBLE_NON_TERMINALS[80] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [81]}. */
        private static void init81() {
            REDUCIBLE_NON_TERMINALS[81] = new int[][] {
                {30, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [82]}. */
        private static void init82() {
            REDUCIBLE_NON_TERMINALS[82] = new int[][] {
                {28, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [83]}. */
        private static void init83() {
            REDUCIBLE_NON_TERMINALS[83] = new int[][] {
                {31, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [84]}. */
        private static void init84() {
            REDUCIBLE_NON_TERMINALS[84] = new int[][] {
                {31, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [85]}. */
        private static void init85() {
            REDUCIBLE_NON_TERMINALS[85] = new int[][] {
                {29, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [86]}. */
        private static void init86() {
            REDUCIBLE_NON_TERMINALS[86] = new int[][] {
                {30, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [87]}. */
        private static void init87() {
            REDUCIBLE_NON_TERMINALS[87] = new int[][] {
                {30, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [88]}. */
        private static void init88() {
            REDUCIBLE_NON_TERMINALS[88] = new int[][] {
                {30, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [89]}. */
        private static void init89() {
            REDUCIBLE_NON_TERMINALS[89] = new int[][] {
                {29, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [90]}. */
        private static void init90() {
            REDUCIBLE_NON_TERMINALS[90] = new int[][] {
                {27, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [91]}. */
        private static void init91() {
            REDUCIBLE_NON_TERMINALS[91] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [92]}. */
        private static void init92() {
            REDUCIBLE_NON_TERMINALS[92] = new int[][] {
                {28, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [93]}. */
        private static void init93() {
            REDUCIBLE_NON_TERMINALS[93] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [94]}. */
        private static void init94() {
            REDUCIBLE_NON_TERMINALS[94] = new int[][] {
                {34, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [95]}. */
        private static void init95() {
            REDUCIBLE_NON_TERMINALS[95] = new int[][] {
                {33, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [96]}. */
        private static void init96() {
            REDUCIBLE_NON_TERMINALS[96] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [97]}. */
        private static void init97() {
            REDUCIBLE_NON_TERMINALS[97] = new int[][] {
                {32, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [98]}. */
        private static void init98() {
            REDUCIBLE_NON_TERMINALS[98] = new int[][] {
                {33, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [99]}. */
        private static void init99() {
            REDUCIBLE_NON_TERMINALS[99] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [100]}. */
        private static void init100() {
            REDUCIBLE_NON_TERMINALS[100] = new int[][] {
                {34, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [101]}. */
        private static void init101() {
            REDUCIBLE_NON_TERMINALS[101] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [102]}. */
        private static void init102() {
            REDUCIBLE_NON_TERMINALS[102] = new int[][] {
                {32, 4},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [103]}. */
        private static void init103() {
            REDUCIBLE_NON_TERMINALS[103] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [104]}. */
        private static void init104() {
            REDUCIBLE_NON_TERMINALS[104] = new int[][] {
                {31, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [105]}. */
        private static void init105() {
            REDUCIBLE_NON_TERMINALS[105] = new int[][] {
                {9, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [106]}. */
        private static void init106() {
            REDUCIBLE_NON_TERMINALS[106] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [107]}. */
        private static void init107() {
            REDUCIBLE_NON_TERMINALS[107] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [108]}. */
        private static void init108() {
            REDUCIBLE_NON_TERMINALS[108] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [109]}. */
        private static void init109() {
            REDUCIBLE_NON_TERMINALS[109] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [110]}. */
        private static void init110() {
            REDUCIBLE_NON_TERMINALS[110] = new int[][] {
                {12, 0},
                {7, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [111]}. */
        private static void init111() {
            REDUCIBLE_NON_TERMINALS[111] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [112]}. */
        private static void init112() {
            REDUCIBLE_NON_TERMINALS[112] = new int[][] {
                {6, 6},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [113]}. */
        private static void init113() {
            REDUCIBLE_NON_TERMINALS[113] = new int[][] {
                {12, 0},
                {7, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [114]}. */
        private static void init114() {
            REDUCIBLE_NON_TERMINALS[114] = new int[][] {
                {11, 0},
                {7, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [115]}. */
        private static void init115() {
            REDUCIBLE_NON_TERMINALS[115] = new int[][] {
                {7, 4},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [116]}. */
        private static void init116() {
            REDUCIBLE_NON_TERMINALS[116] = new int[][] {
                {11, 0},
                {7, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [117]}. */
        private static void init117() {
            REDUCIBLE_NON_TERMINALS[117] = new int[][] {
                {7, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [118]}. */
        private static void init118() {
            REDUCIBLE_NON_TERMINALS[118] = new int[][] {
                {5, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [119]}. */
        private static void init119() {
            REDUCIBLE_NON_TERMINALS[119] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [120]}. */
        private static void init120() {
            REDUCIBLE_NON_TERMINALS[120] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [121]}. */
        private static void init121() {
            REDUCIBLE_NON_TERMINALS[121] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [122]}. */
        private static void init122() {
            REDUCIBLE_NON_TERMINALS[122] = new int[][] {
                {16, 6},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [123]}. */
        private static void init123() {
            REDUCIBLE_NON_TERMINALS[123] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [124]}. */
        private static void init124() {
            REDUCIBLE_NON_TERMINALS[124] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [125]}. */
        private static void init125() {
            REDUCIBLE_NON_TERMINALS[125] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [126]}. */
        private static void init126() {
            REDUCIBLE_NON_TERMINALS[126] = new int[][] {
                {14, 6},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [127]}. */
        private static void init127() {
            REDUCIBLE_NON_TERMINALS[127] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [128]}. */
        private static void init128() {
            REDUCIBLE_NON_TERMINALS[128] = new int[][] {
                {18, 4},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [129]}. */
        private static void init129() {
            REDUCIBLE_NON_TERMINALS[129] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [130]}. */
        private static void init130() {
            REDUCIBLE_NON_TERMINALS[130] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [131]}. */
        private static void init131() {
            REDUCIBLE_NON_TERMINALS[131] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [132]}. */
        private static void init132() {
            REDUCIBLE_NON_TERMINALS[132] = new int[][] {
                {15, 6},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [133]}. */
        private static void init133() {
            REDUCIBLE_NON_TERMINALS[133] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [134]}. */
        private static void init134() {
            REDUCIBLE_NON_TERMINALS[134] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [135]}. */
        private static void init135() {
            REDUCIBLE_NON_TERMINALS[135] = new int[][] {
                {19, 4},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [136]}. */
        private static void init136() {
            REDUCIBLE_NON_TERMINALS[136] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [137]}. */
        private static void init137() {
            REDUCIBLE_NON_TERMINALS[137] = new int[][] {
                {19, 6},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [138]}. */
        private static void init138() {
            REDUCIBLE_NON_TERMINALS[138] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [139]}. */
        private static void init139() {
            REDUCIBLE_NON_TERMINALS[139] = new int[][] {
                {17, 4},
            };
        }
    }

    /** See {@code Parser.reducibleNonTerminalsReduced}. */
    private static final class ReducibleNonTerminalsReduced {
        /** See {@code Parser.reducibleNonTerminalsReduced}. */
        private static final int[][][] REDUCIBLE_NON_TERMINALS_REDUCED = new int[140][][];

        static {
            init0();
            init1();
            init2();
            init3();
            init4();
            init5();
            init6();
            init7();
            init8();
            init9();
            init10();
            init11();
            init12();
            init13();
            init14();
            init15();
            init16();
            init17();
            init18();
            init19();
            init20();
            init21();
            init22();
            init23();
            init24();
            init25();
            init26();
            init27();
            init28();
            init29();
            init30();
            init31();
            init32();
            init33();
            init34();
            init35();
            init36();
            init37();
            init38();
            init39();
            init40();
            init41();
            init42();
            init43();
            init44();
            init45();
            init46();
            init47();
            init48();
            init49();
            init50();
            init51();
            init52();
            init53();
            init54();
            init55();
            init56();
            init57();
            init58();
            init59();
            init60();
            init61();
            init62();
            init63();
            init64();
            init65();
            init66();
            init67();
            init68();
            init69();
            init70();
            init71();
            init72();
            init73();
            init74();
            init75();
            init76();
            init77();
            init78();
            init79();
            init80();
            init81();
            init82();
            init83();
            init84();
            init85();
            init86();
            init87();
            init88();
            init89();
            init90();
            init91();
            init92();
            init93();
            init94();
            init95();
            init96();
            init97();
            init98();
            init99();
            init100();
            init101();
            init102();
            init103();
            init104();
            init105();
            init106();
            init107();
            init108();
            init109();
            init110();
            init111();
            init112();
            init113();
            init114();
            init115();
            init116();
            init117();
            init118();
            init119();
            init120();
            init121();
            init122();
            init123();
            init124();
            init125();
            init126();
            init127();
            init128();
            init129();
            init130();
            init131();
            init132();
            init133();
            init134();
            init135();
            init136();
            init137();
            init138();
            init139();
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [0]}. */
        private static void init0() {
            REDUCIBLE_NON_TERMINALS_REDUCED[0] = new int[][] {
                {1, 0, 0},
                {14, 2, 0},
                {15, 2, 0},
                {16, 2, 0},
                {17, 2, 0},
                {18, 2, 0},
                {19, 2, 0},
                {2, 1, 0},
                {20, 2, 0},
                {3, 2, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [1]}. */
        private static void init1() {
            REDUCIBLE_NON_TERMINALS_REDUCED[1] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [2]}. */
        private static void init2() {
            REDUCIBLE_NON_TERMINALS_REDUCED[2] = new int[][] {
                {10, 24, 0},
                {25, 24, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [3]}. */
        private static void init3() {
            REDUCIBLE_NON_TERMINALS_REDUCED[3] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [4]}. */
        private static void init4() {
            REDUCIBLE_NON_TERMINALS_REDUCED[4] = new int[][] {
                {14, 2, 0},
                {15, 2, 0},
                {16, 2, 0},
                {17, 2, 0},
                {18, 2, 0},
                {19, 2, 0},
                {2, 1, 1},
                {20, 2, 0},
                {3, 2, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [5]}. */
        private static void init5() {
            REDUCIBLE_NON_TERMINALS_REDUCED[5] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [6]}. */
        private static void init6() {
            REDUCIBLE_NON_TERMINALS_REDUCED[6] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [7]}. */
        private static void init7() {
            REDUCIBLE_NON_TERMINALS_REDUCED[7] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [8]}. */
        private static void init8() {
            REDUCIBLE_NON_TERMINALS_REDUCED[8] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [9]}. */
        private static void init9() {
            REDUCIBLE_NON_TERMINALS_REDUCED[9] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [10]}. */
        private static void init10() {
            REDUCIBLE_NON_TERMINALS_REDUCED[10] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [11]}. */
        private static void init11() {
            REDUCIBLE_NON_TERMINALS_REDUCED[11] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [12]}. */
        private static void init12() {
            REDUCIBLE_NON_TERMINALS_REDUCED[12] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [13]}. */
        private static void init13() {
            REDUCIBLE_NON_TERMINALS_REDUCED[13] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [14]}. */
        private static void init14() {
            REDUCIBLE_NON_TERMINALS_REDUCED[14] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [15]}. */
        private static void init15() {
            REDUCIBLE_NON_TERMINALS_REDUCED[15] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [16]}. */
        private static void init16() {
            REDUCIBLE_NON_TERMINALS_REDUCED[16] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [17]}. */
        private static void init17() {
            REDUCIBLE_NON_TERMINALS_REDUCED[17] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [18]}. */
        private static void init18() {
            REDUCIBLE_NON_TERMINALS_REDUCED[18] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [19]}. */
        private static void init19() {
            REDUCIBLE_NON_TERMINALS_REDUCED[19] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [20]}. */
        private static void init20() {
            REDUCIBLE_NON_TERMINALS_REDUCED[20] = new int[][] {
                {10, 24, 0},
                {24, 23, 0},
                {25, 24, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [21]}. */
        private static void init21() {
            REDUCIBLE_NON_TERMINALS_REDUCED[21] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [22]}. */
        private static void init22() {
            REDUCIBLE_NON_TERMINALS_REDUCED[22] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [23]}. */
        private static void init23() {
            REDUCIBLE_NON_TERMINALS_REDUCED[23] = new int[][] {
                {10, 24, 0},
                {24, 23, 2},
                {25, 24, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [24]}. */
        private static void init24() {
            REDUCIBLE_NON_TERMINALS_REDUCED[24] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [25]}. */
        private static void init25() {
            REDUCIBLE_NON_TERMINALS_REDUCED[25] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [26]}. */
        private static void init26() {
            REDUCIBLE_NON_TERMINALS_REDUCED[26] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [27]}. */
        private static void init27() {
            REDUCIBLE_NON_TERMINALS_REDUCED[27] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [28]}. */
        private static void init28() {
            REDUCIBLE_NON_TERMINALS_REDUCED[28] = new int[][] {
                {10, 22, 0},
                {22, 21, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [29]}. */
        private static void init29() {
            REDUCIBLE_NON_TERMINALS_REDUCED[29] = new int[][] {
                {10, 22, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [30]}. */
        private static void init30() {
            REDUCIBLE_NON_TERMINALS_REDUCED[30] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [31]}. */
        private static void init31() {
            REDUCIBLE_NON_TERMINALS_REDUCED[31] = new int[][] {
                {10, 22, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [32]}. */
        private static void init32() {
            REDUCIBLE_NON_TERMINALS_REDUCED[32] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [33]}. */
        private static void init33() {
            REDUCIBLE_NON_TERMINALS_REDUCED[33] = new int[][] {
                {10, 22, 0},
                {22, 21, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [34]}. */
        private static void init34() {
            REDUCIBLE_NON_TERMINALS_REDUCED[34] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [35]}. */
        private static void init35() {
            REDUCIBLE_NON_TERMINALS_REDUCED[35] = new int[][] {
                {10, 22, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [36]}. */
        private static void init36() {
            REDUCIBLE_NON_TERMINALS_REDUCED[36] = new int[][] {
                {10, 22, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [37]}. */
        private static void init37() {
            REDUCIBLE_NON_TERMINALS_REDUCED[37] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [38]}. */
        private static void init38() {
            REDUCIBLE_NON_TERMINALS_REDUCED[38] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [39]}. */
        private static void init39() {
            REDUCIBLE_NON_TERMINALS_REDUCED[39] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [40]}. */
        private static void init40() {
            REDUCIBLE_NON_TERMINALS_REDUCED[40] = new int[][] {
                {10, 24, 0},
                {24, 23, 0},
                {25, 24, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [41]}. */
        private static void init41() {
            REDUCIBLE_NON_TERMINALS_REDUCED[41] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [42]}. */
        private static void init42() {
            REDUCIBLE_NON_TERMINALS_REDUCED[42] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [43]}. */
        private static void init43() {
            REDUCIBLE_NON_TERMINALS_REDUCED[43] = new int[][] {
                {10, 24, 0},
                {25, 24, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [44]}. */
        private static void init44() {
            REDUCIBLE_NON_TERMINALS_REDUCED[44] = new int[][] {
                {10, 24, 0},
                {25, 24, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [45]}. */
        private static void init45() {
            REDUCIBLE_NON_TERMINALS_REDUCED[45] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [46]}. */
        private static void init46() {
            REDUCIBLE_NON_TERMINALS_REDUCED[46] = new int[][] {
                {10, 24, 0},
                {25, 24, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [47]}. */
        private static void init47() {
            REDUCIBLE_NON_TERMINALS_REDUCED[47] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [48]}. */
        private static void init48() {
            REDUCIBLE_NON_TERMINALS_REDUCED[48] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [49]}. */
        private static void init49() {
            REDUCIBLE_NON_TERMINALS_REDUCED[49] = new int[][] {
                {10, 26, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [50]}. */
        private static void init50() {
            REDUCIBLE_NON_TERMINALS_REDUCED[50] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [51]}. */
        private static void init51() {
            REDUCIBLE_NON_TERMINALS_REDUCED[51] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [52]}. */
        private static void init52() {
            REDUCIBLE_NON_TERMINALS_REDUCED[52] = new int[][] {
                {5, 4, 0},
                {6, 5, 0},
                {8, 5, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [53]}. */
        private static void init53() {
            REDUCIBLE_NON_TERMINALS_REDUCED[53] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [54]}. */
        private static void init54() {
            REDUCIBLE_NON_TERMINALS_REDUCED[54] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [55]}. */
        private static void init55() {
            REDUCIBLE_NON_TERMINALS_REDUCED[55] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [56]}. */
        private static void init56() {
            REDUCIBLE_NON_TERMINALS_REDUCED[56] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [57]}. */
        private static void init57() {
            REDUCIBLE_NON_TERMINALS_REDUCED[57] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [58]}. */
        private static void init58() {
            REDUCIBLE_NON_TERMINALS_REDUCED[58] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [59]}. */
        private static void init59() {
            REDUCIBLE_NON_TERMINALS_REDUCED[59] = new int[][] {
                {5, 4, 1},
                {6, 5, 0},
                {8, 5, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [60]}. */
        private static void init60() {
            REDUCIBLE_NON_TERMINALS_REDUCED[60] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [61]}. */
        private static void init61() {
            REDUCIBLE_NON_TERMINALS_REDUCED[61] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [62]}. */
        private static void init62() {
            REDUCIBLE_NON_TERMINALS_REDUCED[62] = new int[][] {
                {29, 28, 0},
                {30, 29, 0},
                {31, 30, 0},
                {32, 31, 0},
                {35, 31, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [63]}. */
        private static void init63() {
            REDUCIBLE_NON_TERMINALS_REDUCED[63] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [64]}. */
        private static void init64() {
            REDUCIBLE_NON_TERMINALS_REDUCED[64] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [65]}. */
        private static void init65() {
            REDUCIBLE_NON_TERMINALS_REDUCED[65] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [66]}. */
        private static void init66() {
            REDUCIBLE_NON_TERMINALS_REDUCED[66] = new int[][] {
                {10, 13, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [67]}. */
        private static void init67() {
            REDUCIBLE_NON_TERMINALS_REDUCED[67] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [68]}. */
        private static void init68() {
            REDUCIBLE_NON_TERMINALS_REDUCED[68] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [69]}. */
        private static void init69() {
            REDUCIBLE_NON_TERMINALS_REDUCED[69] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [70]}. */
        private static void init70() {
            REDUCIBLE_NON_TERMINALS_REDUCED[70] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [71]}. */
        private static void init71() {
            REDUCIBLE_NON_TERMINALS_REDUCED[71] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [72]}. */
        private static void init72() {
            REDUCIBLE_NON_TERMINALS_REDUCED[72] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [73]}. */
        private static void init73() {
            REDUCIBLE_NON_TERMINALS_REDUCED[73] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [74]}. */
        private static void init74() {
            REDUCIBLE_NON_TERMINALS_REDUCED[74] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [75]}. */
        private static void init75() {
            REDUCIBLE_NON_TERMINALS_REDUCED[75] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [76]}. */
        private static void init76() {
            REDUCIBLE_NON_TERMINALS_REDUCED[76] = new int[][] {
                {29, 28, 0},
                {30, 29, 0},
                {31, 30, 0},
                {32, 31, 0},
                {35, 31, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [77]}. */
        private static void init77() {
            REDUCIBLE_NON_TERMINALS_REDUCED[77] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [78]}. */
        private static void init78() {
            REDUCIBLE_NON_TERMINALS_REDUCED[78] = new int[][] {
                {34, 33, 0},
                {35, 34, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [79]}. */
        private static void init79() {
            REDUCIBLE_NON_TERMINALS_REDUCED[79] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [80]}. */
        private static void init80() {
            REDUCIBLE_NON_TERMINALS_REDUCED[80] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [81]}. */
        private static void init81() {
            REDUCIBLE_NON_TERMINALS_REDUCED[81] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [82]}. */
        private static void init82() {
            REDUCIBLE_NON_TERMINALS_REDUCED[82] = new int[][] {
                {30, 29, 1},
                {31, 30, 0},
                {32, 31, 0},
                {35, 31, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [83]}. */
        private static void init83() {
            REDUCIBLE_NON_TERMINALS_REDUCED[83] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [84]}. */
        private static void init84() {
            REDUCIBLE_NON_TERMINALS_REDUCED[84] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [85]}. */
        private static void init85() {
            REDUCIBLE_NON_TERMINALS_REDUCED[85] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [86]}. */
        private static void init86() {
            REDUCIBLE_NON_TERMINALS_REDUCED[86] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [87]}. */
        private static void init87() {
            REDUCIBLE_NON_TERMINALS_REDUCED[87] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [88]}. */
        private static void init88() {
            REDUCIBLE_NON_TERMINALS_REDUCED[88] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [89]}. */
        private static void init89() {
            REDUCIBLE_NON_TERMINALS_REDUCED[89] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [90]}. */
        private static void init90() {
            REDUCIBLE_NON_TERMINALS_REDUCED[90] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [91]}. */
        private static void init91() {
            REDUCIBLE_NON_TERMINALS_REDUCED[91] = new int[][] {
                {29, 28, 2},
                {30, 29, 0},
                {31, 30, 0},
                {32, 31, 0},
                {35, 31, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [92]}. */
        private static void init92() {
            REDUCIBLE_NON_TERMINALS_REDUCED[92] = new int[][] {
                {30, 29, 1},
                {31, 30, 0},
                {32, 31, 0},
                {35, 31, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [93]}. */
        private static void init93() {
            REDUCIBLE_NON_TERMINALS_REDUCED[93] = new int[][] {
                {34, 33, 0},
                {35, 34, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [94]}. */
        private static void init94() {
            REDUCIBLE_NON_TERMINALS_REDUCED[94] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [95]}. */
        private static void init95() {
            REDUCIBLE_NON_TERMINALS_REDUCED[95] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [96]}. */
        private static void init96() {
            REDUCIBLE_NON_TERMINALS_REDUCED[96] = new int[][] {
                {34, 33, 1},
                {35, 34, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [97]}. */
        private static void init97() {
            REDUCIBLE_NON_TERMINALS_REDUCED[97] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [98]}. */
        private static void init98() {
            REDUCIBLE_NON_TERMINALS_REDUCED[98] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [99]}. */
        private static void init99() {
            REDUCIBLE_NON_TERMINALS_REDUCED[99] = new int[][] {
                {35, 34, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [100]}. */
        private static void init100() {
            REDUCIBLE_NON_TERMINALS_REDUCED[100] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [101]}. */
        private static void init101() {
            REDUCIBLE_NON_TERMINALS_REDUCED[101] = new int[][] {
                {34, 33, 1},
                {35, 34, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [102]}. */
        private static void init102() {
            REDUCIBLE_NON_TERMINALS_REDUCED[102] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [103]}. */
        private static void init103() {
            REDUCIBLE_NON_TERMINALS_REDUCED[103] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [104]}. */
        private static void init104() {
            REDUCIBLE_NON_TERMINALS_REDUCED[104] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [105]}. */
        private static void init105() {
            REDUCIBLE_NON_TERMINALS_REDUCED[105] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [106]}. */
        private static void init106() {
            REDUCIBLE_NON_TERMINALS_REDUCED[106] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [107]}. */
        private static void init107() {
            REDUCIBLE_NON_TERMINALS_REDUCED[107] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [108]}. */
        private static void init108() {
            REDUCIBLE_NON_TERMINALS_REDUCED[108] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [109]}. */
        private static void init109() {
            REDUCIBLE_NON_TERMINALS_REDUCED[109] = new int[][] {
                {10, 7, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [110]}. */
        private static void init110() {
            REDUCIBLE_NON_TERMINALS_REDUCED[110] = new int[][] {
                {12, 7, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [111]}. */
        private static void init111() {
            REDUCIBLE_NON_TERMINALS_REDUCED[111] = new int[][] {
                {10, 7, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [112]}. */
        private static void init112() {
            REDUCIBLE_NON_TERMINALS_REDUCED[112] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [113]}. */
        private static void init113() {
            REDUCIBLE_NON_TERMINALS_REDUCED[113] = new int[][] {
                {12, 7, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [114]}. */
        private static void init114() {
            REDUCIBLE_NON_TERMINALS_REDUCED[114] = new int[][] {
                {11, 7, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [115]}. */
        private static void init115() {
            REDUCIBLE_NON_TERMINALS_REDUCED[115] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [116]}. */
        private static void init116() {
            REDUCIBLE_NON_TERMINALS_REDUCED[116] = new int[][] {
                {11, 7, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [117]}. */
        private static void init117() {
            REDUCIBLE_NON_TERMINALS_REDUCED[117] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [118]}. */
        private static void init118() {
            REDUCIBLE_NON_TERMINALS_REDUCED[118] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [119]}. */
        private static void init119() {
            REDUCIBLE_NON_TERMINALS_REDUCED[119] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [120]}. */
        private static void init120() {
            REDUCIBLE_NON_TERMINALS_REDUCED[120] = new int[][] {
                {10, 24, 0},
                {25, 24, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [121]}. */
        private static void init121() {
            REDUCIBLE_NON_TERMINALS_REDUCED[121] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [122]}. */
        private static void init122() {
            REDUCIBLE_NON_TERMINALS_REDUCED[122] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [123]}. */
        private static void init123() {
            REDUCIBLE_NON_TERMINALS_REDUCED[123] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [124]}. */
        private static void init124() {
            REDUCIBLE_NON_TERMINALS_REDUCED[124] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [125]}. */
        private static void init125() {
            REDUCIBLE_NON_TERMINALS_REDUCED[125] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [126]}. */
        private static void init126() {
            REDUCIBLE_NON_TERMINALS_REDUCED[126] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [127]}. */
        private static void init127() {
            REDUCIBLE_NON_TERMINALS_REDUCED[127] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [128]}. */
        private static void init128() {
            REDUCIBLE_NON_TERMINALS_REDUCED[128] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [129]}. */
        private static void init129() {
            REDUCIBLE_NON_TERMINALS_REDUCED[129] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [130]}. */
        private static void init130() {
            REDUCIBLE_NON_TERMINALS_REDUCED[130] = new int[][] {
                {10, 24, 0},
                {25, 24, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [131]}. */
        private static void init131() {
            REDUCIBLE_NON_TERMINALS_REDUCED[131] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [132]}. */
        private static void init132() {
            REDUCIBLE_NON_TERMINALS_REDUCED[132] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [133]}. */
        private static void init133() {
            REDUCIBLE_NON_TERMINALS_REDUCED[133] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [134]}. */
        private static void init134() {
            REDUCIBLE_NON_TERMINALS_REDUCED[134] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [135]}. */
        private static void init135() {
            REDUCIBLE_NON_TERMINALS_REDUCED[135] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [136]}. */
        private static void init136() {
            REDUCIBLE_NON_TERMINALS_REDUCED[136] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [137]}. */
        private static void init137() {
            REDUCIBLE_NON_TERMINALS_REDUCED[137] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [138]}. */
        private static void init138() {
            REDUCIBLE_NON_TERMINALS_REDUCED[138] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [139]}. */
        private static void init139() {
            REDUCIBLE_NON_TERMINALS_REDUCED[139] = new int[][] {};
        }
    }

    /** Parser call back hooks for {@link SeTextParser}. */
    public interface Hooks extends ParserHooksBase {
        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Specification : ;}</p>
         *
         * @return The parser call back hook result.
         */
        public Specification parseSpecification1();

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Specification : Decls;}</p>
         *
         * @param l1 {@code Decls}.
         * @return The parser call back hook result.
         */
        public Specification parseSpecification2(List<Decl> l1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Decls : Decl;}</p>
         *
         * @param d1 {@code Decl}.
         * @return The parser call back hook result.
         */
        public List<Decl> parseDecls1(Decl d1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Decls : Decls Decl;}</p>
         *
         * @param l1 {@code Decls}.
         * @param d2 {@code Decl}.
         * @return The parser call back hook result.
         */
        public List<Decl> parseDecls2(List<Decl> l1, Decl d2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Decl : TerminalsDecl;}</p>
         *
         * @param t1 {@code TerminalsDecl}.
         * @return The parser call back hook result.
         */
        public Decl parseDecl1(TerminalsDecl t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Decl : ShortcutDecl;}</p>
         *
         * @param s1 {@code ShortcutDecl}.
         * @return The parser call back hook result.
         */
        public Decl parseDecl2(ShortcutDecl s1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Decl : MainDecl;}</p>
         *
         * @param s1 {@code MainDecl}.
         * @return The parser call back hook result.
         */
        public Decl parseDecl3(StartSymbol s1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Decl : StartDecl;}</p>
         *
         * @param s1 {@code StartDecl}.
         * @return The parser call back hook result.
         */
        public Decl parseDecl4(StartSymbol s1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Decl : HooksDecl;}</p>
         *
         * @param h1 {@code HooksDecl}.
         * @return The parser call back hook result.
         */
        public Decl parseDecl5(HooksDecl h1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Decl : ScannerDecl;}</p>
         *
         * @param s1 {@code ScannerDecl}.
         * @return The parser call back hook result.
         */
        public Decl parseDecl6(ScannerDecl s1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Decl : ImportDecl;}</p>
         *
         * @param i1 {@code ImportDecl}.
         * @return The parser call back hook result.
         */
        public Decl parseDecl7(ImportDecl i1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Decl : RuleDecl;}</p>
         *
         * @param n1 {@code RuleDecl}.
         * @return The parser call back hook result.
         */
        public Decl parseDecl8(NonTerminal n1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code TerminalsDecl : @ATTK @TERMINALSKW OptIdentifier COLONTK Terminals @ENDKW;}</p>
         *
         * @param t1 {@code ATTK}.
         * @param t2 {@code TERMINALSKW}.
         * @param i3 {@code OptIdentifier}.
         * @param l5 {@code Terminals}.
         * @param t6 {@code ENDKW}.
         * @return The parser call back hook result.
         */
        public TerminalsDecl parseTerminalsDecl1(Token t1, Token t2, Identifier i3, List<Symbol> l5, Token t6);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Terminals : Terminal;}</p>
         *
         * @param s1 {@code Terminal}.
         * @return The parser call back hook result.
         */
        public List<Symbol> parseTerminals1(Symbol s1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Terminals : Terminals Terminal;}</p>
         *
         * @param l1 {@code Terminals}.
         * @param s2 {@code Terminal}.
         * @return The parser call back hook result.
         */
        public List<Symbol> parseTerminals2(List<Symbol> l1, Symbol s2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Terminal : KeywordsTerminal;}</p>
         *
         * @param k1 {@code KeywordsTerminal}.
         * @return The parser call back hook result.
         */
        public Symbol parseTerminal1(KeywordsTerminal k1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Terminal : RegExTerminal;}</p>
         *
         * @param t1 {@code RegExTerminal}.
         * @return The parser call back hook result.
         */
        public Symbol parseTerminal2(Terminal t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Terminal : ATTK @EOFKW SEMICOLTK;}</p>
         *
         * @param t2 {@code EOFKW}.
         * @return The parser call back hook result.
         */
        public Symbol parseTerminal3(Token t2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code KeywordsTerminal : @ATTK KEYWORDSKW Identifier EQTK KeywordsIdentifiers @SEMICOLTK;}</p>
         *
         * @param t1 {@code ATTK}.
         * @param i3 {@code Identifier}.
         * @param l5 {@code KeywordsIdentifiers}.
         * @param t6 {@code SEMICOLTK}.
         * @return The parser call back hook result.
         */
        public KeywordsTerminal parseKeywordsTerminal1(Token t1, Identifier i3, List<KeywordsIdentifier> l5, Token t6);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code KeywordsIdentifiers : Identifier OptFunc OptTermDescr;}</p>
         *
         * @param i1 {@code Identifier}.
         * @param i2 {@code OptFunc}.
         * @param t3 {@code OptTermDescr}.
         * @return The parser call back hook result.
         */
        public List<KeywordsIdentifier> parseKeywordsIdentifiers1(Identifier i1, Identifier i2, TerminalDescription t3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code KeywordsIdentifiers : KeywordsIdentifiers Identifier OptFunc OptTermDescr;}</p>
         *
         * @param l1 {@code KeywordsIdentifiers}.
         * @param i2 {@code Identifier}.
         * @param i3 {@code OptFunc}.
         * @param t4 {@code OptTermDescr}.
         * @return The parser call back hook result.
         */
        public List<KeywordsIdentifier> parseKeywordsIdentifiers2(List<KeywordsIdentifier> l1, Identifier i2, Identifier i3, TerminalDescription t4);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExTerminal : OptRegExId RegExString OptFunc OptNewState OptTermDescr SEMICOLTK;}</p>
         *
         * @param i1 {@code OptRegExId}.
         * @param r2 {@code RegExString}.
         * @param i3 {@code OptFunc}.
         * @param i4 {@code OptNewState}.
         * @param t5 {@code OptTermDescr}.
         * @return The parser call back hook result.
         */
        public Terminal parseRegExTerminal1(Identifier i1, RegEx r2, Identifier i3, Identifier i4, TerminalDescription t5);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptRegExId : ;}</p>
         *
         * @return The parser call back hook result.
         */
        public Identifier parseOptRegExId1();

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptRegExId : Identifier EQTK;}</p>
         *
         * @param i1 {@code Identifier}.
         * @return The parser call back hook result.
         */
        public Identifier parseOptRegExId2(Identifier i1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Identifier : @IDENTIFIERTK;}</p>
         *
         * @param t1 {@code IDENTIFIERTK}.
         * @return The parser call back hook result.
         */
        public Identifier parseIdentifier1(Token t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptTermDescr : ;}</p>
         *
         * @return The parser call back hook result.
         */
        public TerminalDescription parseOptTermDescr1();

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptTermDescr : @DESCRIPTIONTK;}</p>
         *
         * @param t1 {@code DESCRIPTIONTK}.
         * @return The parser call back hook result.
         */
        public TerminalDescription parseOptTermDescr2(Token t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptFunc : ;}</p>
         *
         * @return The parser call back hook result.
         */
        public Identifier parseOptFunc1();

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptFunc : CUROPENTK Identifier CURCLOSETK;}</p>
         *
         * @param i2 {@code Identifier}.
         * @return The parser call back hook result.
         */
        public Identifier parseOptFunc2(Identifier i2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptNewState : ;}</p>
         *
         * @return The parser call back hook result.
         */
        public Identifier parseOptNewState1();

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptNewState : @ARROWTK;}</p>
         *
         * @param t1 {@code ARROWTK}.
         * @return The parser call back hook result.
         */
        public Identifier parseOptNewState2(Token t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptNewState : ARROWTK Identifier;}</p>
         *
         * @param i2 {@code Identifier}.
         * @return The parser call back hook result.
         */
        public Identifier parseOptNewState3(Identifier i2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code ShortcutDecl : ATTK SHORTCUTKW Identifier EQTK RegExString SEMICOLTK;}</p>
         *
         * @param i3 {@code Identifier}.
         * @param r5 {@code RegExString}.
         * @return The parser call back hook result.
         */
        public ShortcutDecl parseShortcutDecl1(Identifier i3, RegEx r5);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code MainDecl : ATTK MAINKW Identifier COLONTK JavaType SEMICOLTK;}</p>
         *
         * @param i3 {@code Identifier}.
         * @param j5 {@code JavaType}.
         * @return The parser call back hook result.
         */
        public StartSymbol parseMainDecl1(Identifier i3, JavaType j5);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code StartDecl : ATTK STARTKW Identifier COLONTK JavaType SEMICOLTK;}</p>
         *
         * @param i3 {@code Identifier}.
         * @param j5 {@code JavaType}.
         * @return The parser call back hook result.
         */
        public StartSymbol parseStartDecl1(Identifier i3, JavaType j5);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code HooksDecl : ATTK HOOKSKW JavaType SEMICOLTK;}</p>
         *
         * @param j3 {@code JavaType}.
         * @return The parser call back hook result.
         */
        public HooksDecl parseHooksDecl1(JavaType j3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code ScannerDecl : ATTK SCANNERKW JavaType SEMICOLTK;}</p>
         *
         * @param j3 {@code JavaType}.
         * @return The parser call back hook result.
         */
        public ScannerDecl parseScannerDecl1(JavaType j3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code ImportDecl : ATTK IMPORTKW JavaType SEMICOLTK;}</p>
         *
         * @param j3 {@code JavaType}.
         * @return The parser call back hook result.
         */
        public ImportDecl parseImportDecl1(JavaType j3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code ImportDecl : ATTK IMPORTKW JavaType ASKW Identifier SEMICOLTK;}</p>
         *
         * @param j3 {@code JavaType}.
         * @param i5 {@code Identifier}.
         * @return The parser call back hook result.
         */
        public ImportDecl parseImportDecl2(JavaType j3, Identifier i5);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RuleDecl : CUROPENTK JavaType CURCLOSETK Identifier COLONTK RuleAlts @SEMICOLTK;}</p>
         *
         * @param j2 {@code JavaType}.
         * @param i4 {@code Identifier}.
         * @param l6 {@code RuleAlts}.
         * @param t7 {@code SEMICOLTK}.
         * @return The parser call back hook result.
         */
        public NonTerminal parseRuleDecl1(JavaType j2, Identifier i4, List<ParserRule> l6, Token t7);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RuleAlts : ;}</p>
         *
         * @return The parser call back hook result.
         */
        public List<ParserRule> parseRuleAlts1();

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RuleAlts : RuleAlt;}</p>
         *
         * @param p1 {@code RuleAlt}.
         * @return The parser call back hook result.
         */
        public List<ParserRule> parseRuleAlts2(ParserRule p1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RuleAlts : RuleAlts BARTK RuleAlt;}</p>
         *
         * @param l1 {@code RuleAlts}.
         * @param p3 {@code RuleAlt}.
         * @return The parser call back hook result.
         */
        public List<ParserRule> parseRuleAlts3(List<ParserRule> l1, ParserRule p3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RuleAlt : Identifier;}</p>
         *
         * @param i1 {@code Identifier}.
         * @return The parser call back hook result.
         */
        public ParserRule parseRuleAlt1(Identifier i1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RuleAlt : ATTK Identifier;}</p>
         *
         * @param i2 {@code Identifier}.
         * @return The parser call back hook result.
         */
        public ParserRule parseRuleAlt2(Identifier i2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RuleAlt : RuleAlt Identifier;}</p>
         *
         * @param p1 {@code RuleAlt}.
         * @param i2 {@code Identifier}.
         * @return The parser call back hook result.
         */
        public ParserRule parseRuleAlt3(ParserRule p1, Identifier i2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RuleAlt : RuleAlt ATTK Identifier;}</p>
         *
         * @param p1 {@code RuleAlt}.
         * @param i3 {@code Identifier}.
         * @return The parser call back hook result.
         */
        public ParserRule parseRuleAlt4(ParserRule p1, Identifier i3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code JavaTypes : JavaType;}</p>
         *
         * @param j1 {@code JavaType}.
         * @return The parser call back hook result.
         */
        public List<JavaType> parseJavaTypes1(JavaType j1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code JavaTypes : JavaTypes COMMATK JavaType;}</p>
         *
         * @param l1 {@code JavaTypes}.
         * @param j3 {@code JavaType}.
         * @return The parser call back hook result.
         */
        public List<JavaType> parseJavaTypes2(List<JavaType> l1, JavaType j3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code JavaType : Identifier;}</p>
         *
         * @param i1 {@code Identifier}.
         * @return The parser call back hook result.
         */
        public JavaType parseJavaType1(Identifier i1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code JavaType : Identifier LTTK JavaTypes GTTK;}</p>
         *
         * @param i1 {@code Identifier}.
         * @param l3 {@code JavaTypes}.
         * @return The parser call back hook result.
         */
        public JavaType parseJavaType2(Identifier i1, List<JavaType> l3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code JavaType : Name;}</p>
         *
         * @param n1 {@code Name}.
         * @return The parser call back hook result.
         */
        public JavaType parseJavaType3(Name n1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code JavaType : Name LTTK JavaTypes GTTK;}</p>
         *
         * @param n1 {@code Name}.
         * @param l3 {@code JavaTypes}.
         * @return The parser call back hook result.
         */
        public JavaType parseJavaType4(Name n1, List<JavaType> l3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code Name : @NAMETK;}</p>
         *
         * @param t1 {@code NAMETK}.
         * @return The parser call back hook result.
         */
        public Name parseName1(Token t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptIdentifier : ;}</p>
         *
         * @return The parser call back hook result.
         */
        public Identifier parseOptIdentifier1();

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptIdentifier : Identifier;}</p>
         *
         * @param i1 {@code Identifier}.
         * @return The parser call back hook result.
         */
        public Identifier parseOptIdentifier2(Identifier i1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExString : @REGEXSTARTTK RegEx @REGEXENDTK;}</p>
         *
         * @param t1 {@code REGEXSTARTTK}.
         * @param r2 {@code RegEx}.
         * @param t3 {@code REGEXENDTK}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExString1(Token t1, RegEx r2, Token t3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegEx : RegExBranch;}</p>
         *
         * @param r1 {@code RegExBranch}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegEx1(RegEx r1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegEx : RegEx REGEXBARTK RegExBranch;}</p>
         *
         * @param r1 {@code RegEx}.
         * @param r3 {@code RegExBranch}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegEx2(RegEx r1, RegEx r3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExBranch : RegExPiece;}</p>
         *
         * @param r1 {@code RegExPiece}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExBranch1(RegEx r1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExBranch : RegExBranch RegExPiece;}</p>
         *
         * @param r1 {@code RegExBranch}.
         * @param r2 {@code RegExPiece}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExBranch2(RegEx r1, RegEx r2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExPiece : RegExAtom;}</p>
         *
         * @param r1 {@code RegExAtom}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExPiece1(RegEx r1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExPiece : RegExPiece @ASTERISKTK;}</p>
         *
         * @param r1 {@code RegExPiece}.
         * @param t2 {@code ASTERISKTK}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExPiece2(RegEx r1, Token t2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExPiece : RegExPiece @PLUSTK;}</p>
         *
         * @param r1 {@code RegExPiece}.
         * @param t2 {@code PLUSTK}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExPiece3(RegEx r1, Token t2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExPiece : RegExPiece @QUESTIONTK;}</p>
         *
         * @param r1 {@code RegExPiece}.
         * @param t2 {@code QUESTIONTK}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExPiece4(RegEx r1, Token t2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExAtom : PAROPENTK RegEx PARCLOSETK;}</p>
         *
         * @param r2 {@code RegEx}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExAtom1(RegEx r2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExAtom : @REGEXSHORTCUTTK;}</p>
         *
         * @param t1 {@code REGEXSHORTCUTTK}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExAtom2(Token t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExAtom : RegExCharClass;}</p>
         *
         * @param r1 {@code RegExCharClass}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExAtom3(RegEx r1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExAtom : RegExChar;}</p>
         *
         * @param r1 {@code RegExChar}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExAtom4(RegExChar r1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExAtom : @DOTTK;}</p>
         *
         * @param t1 {@code DOTTK}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExAtom5(Token t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExCharClass : @SQOPENTK RegExCharsList SQCLOSETK;}</p>
         *
         * @param t1 {@code SQOPENTK}.
         * @param l2 {@code RegExCharsList}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExCharClass1(Token t1, List<RegExChars> l2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExCharClass : @SQOPENTK CARETTK RegExCharsList SQCLOSETK;}</p>
         *
         * @param t1 {@code SQOPENTK}.
         * @param l3 {@code RegExCharsList}.
         * @return The parser call back hook result.
         */
        public RegEx parseRegExCharClass2(Token t1, List<RegExChars> l3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExCharsList : RegExChars;}</p>
         *
         * @param r1 {@code RegExChars}.
         * @return The parser call back hook result.
         */
        public List<RegExChars> parseRegExCharsList1(RegExChars r1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExCharsList : RegExCharsList RegExChars;}</p>
         *
         * @param l1 {@code RegExCharsList}.
         * @param r2 {@code RegExChars}.
         * @return The parser call back hook result.
         */
        public List<RegExChars> parseRegExCharsList2(List<RegExChars> l1, RegExChars r2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExChars : RegExChar;}</p>
         *
         * @param r1 {@code RegExChar}.
         * @return The parser call back hook result.
         */
        public RegExChars parseRegExChars1(RegExChar r1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExChars : RegExChar @DASHTK RegExChar;}</p>
         *
         * @param r1 {@code RegExChar}.
         * @param t2 {@code DASHTK}.
         * @param r3 {@code RegExChar}.
         * @return The parser call back hook result.
         */
        public RegExChars parseRegExChars2(RegExChar r1, Token t2, RegExChar r3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExChar : @REGEXCHARTK;}</p>
         *
         * @param t1 {@code REGEXCHARTK}.
         * @return The parser call back hook result.
         */
        public RegExChar parseRegExChar1(Token t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code RegExChar : @REGEXESCTK;}</p>
         *
         * @param t1 {@code REGEXESCTK}.
         * @return The parser call back hook result.
         */
        public RegExChar parseRegExChar2(Token t1);
    }
}
