/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.odt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gendoc.documents.AbstractImageService;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.ImageDimension;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.AdditionalResourceException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;

public class ODTImageService
extends AbstractImageService {
    public String manageImage(ITag tag, String imageId, String imagePath, boolean keepH, boolean keepW, boolean maxH, boolean maxW) {
        String widthUnit = "cm";
        String heightUnit = "cm";
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        IAdditionalResourceService resourceService = documentService.getAdditionalResourceService();
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        StringBuffer height = new StringBuffer();
        StringBuffer newTagContent = new StringBuffer(tag.getRawText());
        double frameWidth = 0.0;
        double frameHeight = 0.0;
        Pattern p = Pattern.compile("svg:width=\"[^\"]*\"");
        Matcher m = p.matcher(newTagContent);
        if (m.find()) {
            if (m.group().endsWith("cm\"")) {
                widthUnit = "cm";
            } else if (m.group().endsWith("in\"")) {
                widthUnit = "in";
            }
            frameWidth = Double.valueOf(m.group().replaceAll("(in|cm|svg:width=|\")", ""));
        }
        if ((m = (p = Pattern.compile("svg:height=\"[^\"]*\"")).matcher(newTagContent)).find()) {
            if (m.group().endsWith("cm\"")) {
                heightUnit = "cm";
            } else if (m.group().endsWith("in\"")) {
                heightUnit = "in";
            }
            frameHeight = Double.valueOf(m.group().replaceAll("(in|cm|svg:height=|\")", ""));
        } else {
            p = Pattern.compile("<draw:text-box[^>]*fo:min-height=\"");
            m = p.matcher(newTagContent);
            if (m.find()) {
                int index = m.end();
                String s = newTagContent.substring(index);
                height.append(" svg:height=\"");
                String heightAndUnit = s.substring(0, s.indexOf("\""));
                height.append(heightAndUnit);
                if (heightAndUnit.endsWith("cm")) {
                    heightUnit = "cm";
                } else if (heightAndUnit.endsWith("in")) {
                    heightUnit = "in";
                }
                frameHeight = Double.valueOf(heightAndUnit.replaceAll("in|cm", ""));
                height.append("\" ");
            }
        }
        logger.log("ODT image to insert : " + newTagContent.toString(), 16);
        try {
            double widthInPixels = 0.0;
            double heightInPixels = 0.0;
            if ("cm".equals(widthUnit)) {
                widthInPixels = this.cmToPixels(frameWidth);
            } else if ("in".equals(widthUnit)) {
                widthInPixels = this.inchesToPixels(frameWidth);
            }
            if ("cm".equals(heightUnit)) {
                heightInPixels = this.cmToPixels(frameHeight);
            } else if ("in".equals(heightUnit)) {
                heightInPixels = this.inchesToPixels(frameHeight);
            }
            ImageDimension d = this.resizeImage(imagePath, widthInPixels, heightInPixels, keepH, keepW, maxH, maxW);
            d = this.pixelToCm(d);
            newTagContent = new StringBuffer(this.modifyHeight(newTagContent, d.getHeight()));
            newTagContent = new StringBuffer(this.modifyWidth(newTagContent, d.getWidth()));
            p = Pattern.compile("<draw:text-box[^<>]*>");
            m = p.matcher(newTagContent);
            if (m.find()) {
                String toInsert = "<draw:frame xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" text:anchor-type=\"frame\" svg:width=\"" + d.getWidth() + "cm\" style:rel-width=\"100%\" svg:height=\"" + d.getHeight() + "cm\" style:rel-height=\"scale\" >" + "<draw:image xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:href=\"" + resourceService.getImageRelativePath(imageId) + "\" xlink:type=\"simple\" xlink:show=\"embed\" xlink:actuate=\"onLoad\"/></draw:frame>";
                int endIndex = m.end();
                newTagContent = newTagContent.insert(endIndex, toInsert);
                newTagContent = newTagContent.insert(endIndex - 1, height.toString());
            }
        }
        catch (AdditionalResourceException additionalResourceException) {
            IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
            String tagIdOdt = (String)tag.getAttributes().get(RegisteredTags.ID);
            if (tagIdOdt == null) {
                diagnostician.addDiagnostic(2, "Image cannot not be resized", null);
            }
            diagnostician.addDiagnostic(2, "The execution of tag with id '" + tagIdOdt + "' failed : Image cannot not be resized", null);
        }
        return newTagContent.toString();
    }

    protected String modifyHeight(StringBuffer tagContent, double height) {
        return this.modifyDimension(tagContent, "svg:height=\"[^\"]*\"", "svg:height=\"" + height + "cm\"");
    }

    protected String modifyWidth(StringBuffer tagContent, double width) {
        return this.modifyDimension(tagContent, "svg:width=\"[^\"]*\"", "svg:width=\"" + width + "cm\"");
    }

    private String modifyDimension(StringBuffer tagContent, String patternToMatch, String ToInsert) {
        Pattern p = Pattern.compile(patternToMatch);
        Matcher m = p.matcher(tagContent);
        boolean found = m.find();
        if (!found) {
            p = Pattern.compile("<draw:frame [^<>]*>");
            m = p.matcher(tagContent);
            if (m.find()) {
                int endIndex = m.end();
                tagContent = tagContent.insert(endIndex - 1, " " + ToInsert);
            }
        } else {
            tagContent = tagContent.replace(m.start(), m.end(), ToInsert);
            found = m.find();
        }
        return tagContent.toString();
    }

    public void clear() {
    }
}

