/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.docx;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.docx.DocxDocument;
import org.eclipse.gendoc.document.parser.documents.docx.DocxNamespaceContext;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IMimeHtmlService;
import org.eclipse.gendoc.documents.ITableService;
import org.eclipse.gendoc.documents.XMLDocumentService;
import org.eclipse.gendoc.documents.metadata.IDocumentMetadataService;
import org.eclipse.gendoc.services.docx.DOCXAdditionalResourceService;
import org.eclipse.gendoc.services.docx.DOCXMimeHtmlService;
import org.eclipse.gendoc.services.docx.DOCXTableService;
import org.eclipse.gendoc.services.exception.DocumentServiceException;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOCXDocumentService
extends XMLDocumentService
implements IDocumentMetadataService {
    IAdditionalResourceService additionalResourceService = new DOCXAdditionalResourceService();
    IMimeHtmlService mimehtmlservice = new DOCXMimeHtmlService();
    private final String TAG_TABLE = "w:tbl";
    private String serviceId;
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private ITableService tableService = new DOCXTableService();
    protected static Pattern NOBR_REPLACE_PATTERN = Pattern.compile("(?:&lt;\\s*" + RegisteredTags.NOBR + "\\s*/\\s*&gt;)(?:.*?)(?:</w:t>)(?:.*?)(?:<w:t[^>]*>)", 40);

    public DOCXDocumentService() {
    }

    public DOCXDocumentService(Document document) {
        super(document);
    }

    public String getListLabel() {
        return null;
    }

    public boolean isList(String label) {
        return false;
    }

    public boolean isListItem(String label) {
        return false;
    }

    public boolean isPara(String label) {
        return "w:p".equals(label) || "w:bookmarkEnd".equals(label);
    }

    public boolean isTable(String label) {
        return "w:tbl".equals(label);
    }

    public boolean isRow(String label) {
        return "w:tr".equals(label);
    }

    public String getRowLabel() {
        return "w:tr";
    }

    public String getCellLabel() {
        return "w:tc";
    }

    public boolean isCell(String label) {
        return "w:tc".equals(label);
    }

    public String getTextStyle() {
        return "w:t";
    }

    public String[] getTextTagLabels() {
        return new String[]{"w:p", "w:tbl"};
    }

    public String getNamingSpaceURL() {
        return "xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"";
    }

    public NamespaceContext getNameSpaceContext() {
        return new DocxNamespaceContext();
    }

    public void saveDocument(Document document, String path) throws DocumentServiceException {
        if (!(document instanceof DocxDocument)) {
            throw new DocumentServiceException("Document is not a valid DOCX document.");
        }
        this.insertDocumentInFile((DocxDocument)document);
        ((DocxDocument)document).zipToLocation(path);
    }

    public IAdditionalResourceService getAdditionalResourceService() {
        return this.additionalResourceService;
    }

    public IMimeHtmlService getMimeHtmlService() {
        return this.mimehtmlservice;
    }

    private void insertDocumentInFile(DocxDocument document) {
        try {
            document.jumpToStart();
            do {
                DOMSource domSource = new DOMSource(document.getXMLParser().getDocument());
                StreamResult fluxDestination = new StreamResult(new File(String.valueOf(document.getUnzipLocationDocumentFile().getAbsolutePath()) + "/word/" + document.getXMLParser().getXmlFile().getName()));
                TransformerFactory fabrique = TransformerFactory.newInstance();
                Transformer transformationIdentite = fabrique.newTransformer();
                transformationIdentite.setOutputProperty("encoding", "UTF-8");
                transformationIdentite.transform(domSource, fluxDestination);
            } while (document.jumpToNextFile());
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e2) {
            e2.printStackTrace();
        }
    }

    protected Node cleanTags(Node currentNode, List<String> tagLabels, Node baseNode) throws InvalidContentException {
        String[] separated;
        if (baseNode == null) {
            return null;
        }
        StringBuffer newNodeContent = new StringBuffer(this.extractNodeTextValue(baseNode));
        while (baseNode != null && !this.containsOneOf(tagLabels, newNodeContent.toString())) {
            if ((baseNode = this.findNodeWithStartTag(baseNode, currentNode)) == null) continue;
            newNodeContent = new StringBuffer(this.extractNodeTextValue(baseNode));
        }
        if (baseNode == null) {
            return null;
        }
        boolean isCompleteTag = this.containsFullTags(newNodeContent.toString(), tagLabels);
        if (!isCompleteTag) {
            NodeList followingNodes = this.getNextNodes(baseNode, baseNode.getNodeName());
            ArrayList<Node> nodesToRemove = new ArrayList<Node>();
            if (followingNodes != null) {
                int i = 0;
                while (i < followingNodes.getLength()) {
                    Node followingNode = followingNodes.item(i);
                    String textValue = this.extractNodeTextValue(followingNode);
                    newNodeContent.append(textValue);
                    Node nodeToRemove = this.getBestAscendantUntil(currentNode, followingNode);
                    if (nodeToRemove == null && followingNode != baseNode) {
                        nodeToRemove = followingNode;
                    }
                    if (!nodesToRemove.contains(nodeToRemove)) {
                        nodesToRemove.add(nodeToRemove);
                    }
                    if (this.containsFullTags(newNodeContent.toString(), tagLabels)) {
                        isCompleteTag = true;
                        break;
                    }
                    ++i;
                }
                for (Node nodeToRemove : nodesToRemove) {
                    if (nodeToRemove == null) continue;
                    nodeToRemove.getParentNode().removeChild(nodeToRemove);
                }
            }
        }
        if ((separated = this.asText(baseNode).split(String.valueOf(XML_TAG_START) + "|" + XML_TAG_END)) != null && separated.length > 1) {
            newNodeContent.insert(0, String.valueOf(XML_TAG_START) + separated[1] + XML_TAG_END);
            newNodeContent.append(String.valueOf(XML_TAG_START) + separated[separated.length - 1] + XML_TAG_END);
        } else {
            newNodeContent.append(this.asText(baseNode));
        }
        String nodeContent = this.cleanXMLContent(newNodeContent.toString());
        Node result = this.injectNode(baseNode, nodeContent);
        baseNode.getParentNode().removeChild(baseNode);
        return result;
    }

    protected boolean areSimilarTags(String tagName1, String tagName2) {
        return false;
    }

    protected String containsSimilarTag(Stack<String> tagStack, String tagName) {
        return null;
    }

    public String getTableLabel() {
        return "w:tbl";
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public Pattern getNobrReplacePattern() {
        return NOBR_REPLACE_PATTERN;
    }

    public String getListId(Node n) {
        return null;
    }

    public String getContinueList(Node currentNode, String idList) throws InvalidContentException {
        return null;
    }

    public String format(String input) {
        String LINE_BREAK = "</w:t><w:br/><w:t>";
        String TAB = "</w:t><w:tab/><w:t>";
        String formatted = input.replace("&#xD;\n", LINE_BREAK).replace("\r\n", LINE_BREAK).replace("&#xD;", LINE_BREAK).replace("\r", LINE_BREAK).replace("&#xA;", LINE_BREAK).replace("\n", LINE_BREAK).replace("&#x9;", TAB).replace("\t", TAB);
        return formatted;
    }

    public List<String> getMetadataProperties(Document doc) {
        ArrayList<String> res;
        block4: {
            String docName;
            block3: {
                if (this.getDocument() == null) {
                    this.setDocument(doc);
                }
                docName = doc.getXMLParser().getXmlFile().getName();
                res = new ArrayList<String>();
                if (!docName.equals("custom.xml")) break block3;
                NodeList nl = doc.getXMLParser().getNodesFromXPathExpression("//vt:lpwstr", (NamespaceContext)new DocxNamespaceContextEx(new String[]{"def", "http://schemas.openxmlformats.org/officeDocument/2006/custom-properties", "vt", "http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes"}));
                int i = 0;
                while (i < nl.getLength()) {
                    Element e = (Element)nl.item(i);
                    res.add(((Element)e.getParentNode()).getAttribute("name"));
                    ++i;
                }
                break block4;
            }
            if (!docName.equals("core.xml")) break block4;
            NodeList nl = doc.getXMLParser().getNodesFromXPathExpression("/cp:coreProperties/*", (NamespaceContext)new DocxNamespaceContextEx(new String[]{"cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties", "dc", "http://purl.org/dc/elements/1.1/", "dcterms", "http://purl.org/dc/terms/", "dcmitype", "http://purl.org/dc/dcmitype/"}));
            int i = 0;
            while (i < nl.getLength()) {
                Element e = (Element)nl.item(i);
                res.add(String.valueOf(e.getPrefix()) + ":" + e.getLocalName());
                ++i;
            }
        }
        return res;
    }

    public String getMetadataValue(Document doc, String propertyId) {
        Node n = this.getPropertyNode(doc, propertyId);
        if (n instanceof Element) {
            return n.getTextContent();
        }
        if (n instanceof Attr) {
            return ((Attr)n).getValue();
        }
        return null;
    }

    public void setMetadataValue(Document doc, String propertyId, String value) {
        Node n = this.getPropertyNode(doc, propertyId);
        if (n instanceof Element) {
            n.setTextContent(value);
        } else if (n instanceof Attr) {
            ((Attr)n).setValue(value);
        }
    }

    public void saveMetadata(Document doc) {
        try {
            if (doc.getXMLParser().getKind() != Document.CONFIGURATION.metadata) {
                return;
            }
            File f = doc.getXMLParser().getXmlFile();
            Transformer t = TRANSFORMER_FACTORY.newTransformer();
            t.setOutputProperty("standalone", "no");
            t.setOutputProperty("omit-xml-declaration", "no");
            t.transform(new DOMSource(doc.getXMLParser().getDocument()), new StreamResult(f));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private Node getPropertyNode(Document doc, String propertyId) {
        NodeList nl;
        String docName = doc.getXMLParser().getXmlFile().getName();
        if (docName.equals("custom.xml")) {
            NodeList nl2 = doc.getXMLParser().getNodesFromXPathExpression("//def:property[@name='" + propertyId + "']/vt:lpwstr", (NamespaceContext)new DocxNamespaceContextEx(new String[]{"def", "http://schemas.openxmlformats.org/officeDocument/2006/custom-properties", "vt", "http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes"}));
            if (nl2.getLength() > 0) {
                return nl2.item(0);
            }
        } else if (docName.equals("core.xml") && (nl = doc.getXMLParser().getNodesFromXPathExpression("/cp:coreProperties/" + propertyId, (NamespaceContext)new DocxNamespaceContextEx(new String[]{"cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties", "dc", "http://purl.org/dc/elements/1.1/", "dcterms", "http://purl.org/dc/terms/", "dcmitype", "http://purl.org/dc/dcmitype/"}))).getLength() > 0) {
            return nl.item(0);
        }
        return null;
    }

    public ITableService getTableService() {
        return this.tableService;
    }

    private static class DocxNamespaceContextEx
    implements NamespaceContext {
        private Map<String, String> mapping = new HashMap<String, String>(2);

        public DocxNamespaceContextEx(String[] mapping) {
            int i = 0;
            while (i < mapping.length) {
                this.mapping.put(mapping[i], mapping[i + 1]);
                i += 2;
            }
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String uri = this.mapping.get(prefix);
            if (uri == null) {
                uri = "";
            }
            return uri;
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

