/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.impl;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gendoc.tags.TagsExtensionPoint;
import org.eclipse.gendoc.tags.impl.AbstractExtension;
import org.eclipse.gendoc.tags.impl.CategoryExtension;
import org.eclipse.gendoc.tags.impl.TagExtension;
import org.eclipse.gendoc.tags.impl.TagExtensionService;
import org.eclipse.gendoc.tags.impl.TagRef;

public abstract class AbstractContainerExtension
extends AbstractExtension {
    protected final TagExtensionService tagExtensionService;
    protected final Set<String> childCategoryNames = new HashSet<String>();
    protected final Set<String> childTagNames = new HashSet<String>();
    private Set<CategoryExtension> childCategories;
    private Set<TagExtension> childTags;
    private Set<TagExtension> subTags;
    private List<String> subTagNames;

    protected AbstractContainerExtension(TagExtensionService tagExtensionService, IConfigurationElement configElement) {
        super(configElement);
        this.tagExtensionService = tagExtensionService;
        this.loadChildren(configElement);
    }

    public List<String> getSubTagNames() {
        if (this.subTagNames == null) {
            this.subTagNames = new LinkedList<String>();
            for (TagExtension tagExtension : this.getSubTags()) {
                this.subTagNames.add(tagExtension.getName());
            }
        }
        return this.subTagNames;
    }

    public Set<TagExtension> getSubTags() {
        if (this.subTags == null) {
            this.subTags = new HashSet<TagExtension>();
            this.subTags.addAll(this.getChildTags());
            this.subTags.addAll(this.expand(this.getChildCategories(), new HashSet<CategoryExtension>()));
        }
        return this.subTags;
    }

    protected Set<TagExtension> expand(Set<CategoryExtension> categories, Set<CategoryExtension> exclude) {
        HashSet<TagExtension> tags = new HashSet<TagExtension>();
        for (CategoryExtension category : categories) {
            if (exclude.contains(category)) continue;
            exclude.add(category);
            tags.addAll(category.getChildTags());
            tags.addAll(this.expand(category.getChildCategories(), exclude));
        }
        return tags;
    }

    protected Set<CategoryExtension> getChildCategories() {
        if (this.childCategories == null) {
            this.childCategories = new HashSet<CategoryExtension>();
            for (String name : this.childCategoryNames) {
                this.childCategories.add(this.getTagExtensionService().getCategoryExtension(name));
            }
        }
        return this.childCategories;
    }

    protected Set<TagExtension> getChildTags() {
        if (this.childTags == null) {
            this.childTags = new HashSet<TagExtension>();
            for (String name : this.childTagNames) {
                this.childTags.add(this.getTagExtensionService().getTagExtension(name));
            }
        }
        return this.childTags;
    }

    protected TagExtensionService getTagExtensionService() {
        return this.tagExtensionService;
    }

    protected List<String> loadCategories(IConfigurationElement configElement) {
        IConfigurationElement[] elements;
        LinkedList<String> names = new LinkedList<String>();
        IConfigurationElement[] iConfigurationElementArray = elements = configElement.getChildren(TagsExtensionPoint.CATEGORY);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            CategoryExtension categoryExtension = CategoryExtension.load(this.tagExtensionService, element);
            if (categoryExtension != null) {
                names.add(categoryExtension.getName());
            }
            ++n2;
        }
        return names;
    }

    protected void loadChildren(IConfigurationElement configElement) {
        this.childCategoryNames.addAll(this.loadCategories(configElement));
        this.childTagNames.addAll(this.loadTags(configElement));
        this.childTagNames.addAll(this.loadTagRefs(configElement));
    }

    protected List<String> loadTagRefs(IConfigurationElement configElement) {
        IConfigurationElement[] elements;
        LinkedList<String> names = new LinkedList<String>();
        IConfigurationElement[] iConfigurationElementArray = elements = configElement.getChildren(TagsExtensionPoint.TAGREF);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = TagRef.load(this.tagExtensionService, element);
            if (name != null) {
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    protected List<String> loadTags(IConfigurationElement configElement) {
        IConfigurationElement[] elements;
        LinkedList<String> names = new LinkedList<String>();
        IConfigurationElement[] iConfigurationElementArray = elements = configElement.getChildren(TagsExtensionPoint.TAG);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            TagExtension tagExtension = TagExtension.load(this.tagExtensionService, element);
            if (tagExtension != null) {
                names.add(tagExtension.getName());
            }
            ++n2;
        }
        return names;
    }
}

