/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.marker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.glsp.example.workflow.wfgraph.ActivityNode;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.server.features.validation.Marker;
import org.eclipse.glsp.server.features.validation.ModelValidator;
import org.eclipse.glsp.server.model.GModelState;

public class WorkflowModelValidator
implements ModelValidator {
    public List<Marker> validate(GModelState modelState, GModelElement ... elements) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        GModelElement[] gModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            GModelElement element = gModelElementArray[n2];
            if (element instanceof TaskNode) {
                markers.addAll(WorkflowModelValidator.validateTaskNode(modelState, element));
            } else if (element instanceof ActivityNode) {
                ActivityNode activityNode = (ActivityNode)element;
                if ("decisionNode".equals(activityNode.getNodeType())) {
                    markers.addAll(WorkflowModelValidator.validateDecisionNode(modelState, element));
                } else if ("mergeNode".equals(activityNode.getNodeType())) {
                    markers.addAll(WorkflowModelValidator.validateMergeNode(modelState, element));
                }
            }
            if (element.getChildren() != null) {
                markers.addAll(this.validate(modelState, (GModelElement[])element.getChildren().toArray((Object[])new GModelElement[element.getChildren().size()])));
            }
            ++n2;
        }
        return markers;
    }

    private static List<Marker> validateTaskNode(GModelState modelState, GModelElement taskNode) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        WorkflowModelValidator.validateTaskNode_isAutomated(modelState, taskNode).ifPresent(m -> {
            boolean bl = markers.add((Marker)m);
        });
        WorkflowModelValidator.validateTaskNode_nameStartsUpperCase(modelState, taskNode).ifPresent(m -> {
            boolean bl = markers.add((Marker)m);
        });
        return markers;
    }

    private static Optional<Marker> validateTaskNode_isAutomated(GModelState modelState, GModelElement element) {
        TaskNode taskNode = (TaskNode)element;
        if ("automated".equals(taskNode.getTaskType())) {
            return Optional.of(new Marker("Automated task", "This is an automated task", element.getId(), "info"));
        }
        return Optional.empty();
    }

    private static Optional<Marker> validateTaskNode_nameStartsUpperCase(GModelState modelState, GModelElement element) {
        TaskNode taskNode = (TaskNode)element;
        if (!Character.isUpperCase(taskNode.getName().charAt(0))) {
            return Optional.of(new Marker("Task node name in upper case", "Task node names should start with upper case letters", element.getId(), "warning"));
        }
        return Optional.empty();
    }

    private static List<Marker> validateDecisionNode(GModelState modelState, GModelElement decisionNode) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        WorkflowModelValidator.validateDecisionNode_hasOneIncomingEdge(modelState, decisionNode).ifPresent(m -> {
            boolean bl = markers.add((Marker)m);
        });
        return markers;
    }

    private static Optional<Marker> validateDecisionNode_hasOneIncomingEdge(GModelState modelState, GModelElement decisionNode) {
        Collection incomingEdges = modelState.getIndex().getIncomingEdges(decisionNode);
        if (incomingEdges.size() > 1) {
            return Optional.of(new Marker("Too many incoming edges", "Decision node may only have one incoming edge.", decisionNode.getId(), "error"));
        }
        if (incomingEdges.size() == 0) {
            return Optional.of(new Marker("Missing incoming edge", "Decision node must have one incoming edge.", decisionNode.getId(), "error"));
        }
        return Optional.empty();
    }

    private static List<Marker> validateMergeNode(GModelState modelState, GModelElement mergeNode) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        WorkflowModelValidator.validateMergeNode_hasOneOutgoingEdge(modelState, mergeNode).ifPresent(m -> {
            boolean bl = markers.add((Marker)m);
        });
        return markers;
    }

    private static Optional<Marker> validateMergeNode_hasOneOutgoingEdge(GModelState modelState, GModelElement mergeNode) {
        Collection outgoingEdges = modelState.getIndex().getOutgoingEdges(mergeNode);
        if (outgoingEdges.size() > 1) {
            return Optional.of(new Marker("Too many outgoing edges", "Merge node may only have one outgoing edge.", mergeNode.getId(), "error"));
        }
        if (outgoingEdges.size() == 0) {
            return Optional.of(new Marker("Missing outgoing edge", "Merge node must have one incoming edge.", mergeNode.getId(), "error"));
        }
        return Optional.empty();
    }
}

