/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.launch;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.server.di.ServerModule;
import org.eclipse.glsp.server.launch.DefaultCLIParser;
import org.eclipse.glsp.server.utils.LaunchUtil;

public abstract class GLSPServerLauncher {
    protected static Logger LOGGER = LogManager.getLogger(GLSPServerLauncher.class);
    protected final List<Module> modules = new ArrayList<Module>();

    public GLSPServerLauncher(ServerModule serverModule, Module ... additionalModules) {
        this.modules.add((Module)serverModule);
        Stream.of(additionalModules).forEach(this.modules::add);
    }

    public Injector createInjector() {
        return Guice.createInjector(this.modules);
    }

    public abstract void start(String var1, int var2);

    public void start(String hostname, int port, boolean consoleLogging, String logDir, Level logLevel) {
        LaunchUtil.configureLogger(consoleLogging, logDir, logLevel);
        this.start(hostname, port);
    }

    public void start(String hostname, int port, DefaultCLIParser parser) {
        try {
            LaunchUtil.configure(parser);
        }
        catch (ParseException e) {
            LOGGER.error("Error during log configuration!", (Throwable)e);
        }
        this.start(hostname, port);
    }

    public abstract void shutdown();
}

