/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.DistantLight;
import org.apache.batik.ext.awt.image.Light;
import org.apache.batik.ext.awt.image.PointLight;
import org.apache.batik.ext.awt.image.SpotLight;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractSVGLightingElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    protected AbstractSVGLightingElementBridge() {
    }

    protected static Light extractLight(Element element, BridgeContext bridgeContext) {
        Color color = CSSUtilities.convertLightingColor(element, bridgeContext);
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            Bridge bridge;
            if (node.getNodeType() == 1 && (bridge = bridgeContext.getBridge(element2 = (Element)node)) != null && bridge instanceof AbstractSVGLightElementBridge) {
                return ((AbstractSVGLightElementBridge)bridge).createLight(bridgeContext, element, element2, color);
            }
            node = node.getNextSibling();
        }
        return null;
    }

    protected static double[] convertKernelUnitLength(Element element) {
        String string = element.getAttributeNS(null, "kernelUnitLength");
        if (string.length() == 0) {
            return null;
        }
        double[] dArray = new double[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            dArray[0] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
            dArray[1] = stringTokenizer.hasMoreTokens() ? (double)SVGUtilities.convertSVGNumber(stringTokenizer.nextToken()) : dArray[0];
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"kernelUnitLength", string});
        }
        if (stringTokenizer.hasMoreTokens() || dArray[0] <= 0.0 || dArray[1] <= 0.0) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{"kernelUnitLength", string});
        }
        return dArray;
    }

    protected static abstract class AbstractSVGLightElementBridge
    extends AbstractSVGBridge {
        protected AbstractSVGLightElementBridge() {
        }

        public abstract Light createLight(BridgeContext var1, Element var2, Element var3, Color var4);
    }

    public static class SVGFeDistantLightElementBridge
    extends AbstractSVGLightElementBridge {
        public String getLocalName() {
            return "feDistantLight";
        }

        public Light createLight(BridgeContext bridgeContext, Element element, Element element2, Color color) {
            double d = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "azimuth", 0.0f);
            double d2 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "elevation", 0.0f);
            return new DistantLight(d, d2, color);
        }
    }

    public static class SVGFePointLightElementBridge
    extends AbstractSVGLightElementBridge {
        public String getLocalName() {
            return "fePointLight";
        }

        public Light createLight(BridgeContext bridgeContext, Element element, Element element2, Color color) {
            double d = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "x", 0.0f);
            double d2 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "y", 0.0f);
            double d3 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "z", 0.0f);
            return new PointLight(d, d2, d3, color);
        }
    }

    public static class SVGFeSpotLightElementBridge
    extends AbstractSVGLightElementBridge {
        public String getLocalName() {
            return "feSpotLight";
        }

        public Light createLight(BridgeContext bridgeContext, Element element, Element element2, Color color) {
            double d = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "x", 0.0f);
            double d2 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "y", 0.0f);
            double d3 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "z", 0.0f);
            double d4 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "pointsAtX", 0.0f);
            double d5 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "pointsAtY", 0.0f);
            double d6 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "pointsAtZ", 0.0f);
            double d7 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "specularExponent", 1.0f);
            double d8 = AbstractSVGFilterPrimitiveElementBridge.convertNumber(element2, "limitingConeAngle", 90.0f);
            return new SpotLight(d, d2, d3, d4, d5, d6, d7, d8, color);
        }
    }
}

