/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.NoRepaintRunnable;
import org.apache.batik.bridge.RepaintManager;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.gvt.UpdateTracker;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.util.EventDispatcher;
import org.apache.batik.util.RunnableQueue;
import org.w3c.dom.Document;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class UpdateManager {
    static final long MIN_REPAINT_TIME;
    protected BridgeContext bridgeContext;
    protected Document document;
    protected RunnableQueue updateRunnableQueue;
    protected RunnableQueue.RunHandler runHandler;
    protected boolean running;
    protected boolean suspendCalled;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected ScriptingEnvironment scriptingEnvironment;
    protected RepaintManager repaintManager;
    protected UpdateTracker updateTracker;
    protected GraphicsNode graphicsNode;
    protected boolean started;
    long outOfDateTime = 0L;
    static EventDispatcher.Dispatcher startedDispatcher;
    static EventDispatcher.Dispatcher stoppedDispatcher;
    static EventDispatcher.Dispatcher suspendedDispatcher;
    static EventDispatcher.Dispatcher resumedDispatcher;
    static EventDispatcher.Dispatcher updateStartedDispatcher;
    static EventDispatcher.Dispatcher updateCompletedDispatcher;
    static EventDispatcher.Dispatcher updateFailedDispatcher;

    public UpdateManager(BridgeContext bridgeContext, GraphicsNode graphicsNode, Document document) {
        this.bridgeContext = bridgeContext;
        this.bridgeContext.setUpdateManager(this);
        this.document = document;
        this.updateRunnableQueue = RunnableQueue.createRunnableQueue();
        this.runHandler = this.createRunHandler();
        this.updateRunnableQueue.setRunHandler(this.runHandler);
        this.graphicsNode = graphicsNode;
        this.scriptingEnvironment = new ScriptingEnvironment(bridgeContext);
    }

    public synchronized void dispatchSVGLoadEvent() throws InterruptedException {
        this.scriptingEnvironment.loadScripts();
        this.scriptingEnvironment.dispatchSVGLoadEvent();
    }

    public void dispatchSVGZoomEvent() throws InterruptedException {
        this.scriptingEnvironment.dispatchSVGZoomEvent();
    }

    public void dispatchSVGScrollEvent() throws InterruptedException {
        this.scriptingEnvironment.dispatchSVGScrollEvent();
    }

    public void dispatchSVGResizeEvent() throws InterruptedException {
        this.scriptingEnvironment.dispatchSVGResizeEvent();
    }

    public void manageUpdates(final ImageRenderer imageRenderer) {
        this.updateRunnableQueue.preemptLater(new Runnable(){

            public void run() {
                UpdateManager updateManager = UpdateManager.this;
                synchronized (updateManager) {
                    UpdateManager.this.running = true;
                    UpdateManager.this.updateTracker = new UpdateTracker();
                    RootGraphicsNode rootGraphicsNode = UpdateManager.this.graphicsNode.getRoot();
                    if (rootGraphicsNode != null) {
                        rootGraphicsNode.addTreeGraphicsNodeChangeListener(UpdateManager.this.updateTracker);
                    }
                    UpdateManager.this.repaintManager = new RepaintManager(imageRenderer);
                    UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent(UpdateManager.this, null, null);
                    UpdateManager.this.fireEvent(startedDispatcher, updateManagerEvent);
                    UpdateManager.this.started = true;
                }
            }
        });
        this.resume();
    }

    public BridgeContext getBridgeContext() {
        return this.bridgeContext;
    }

    public RunnableQueue getUpdateRunnableQueue() {
        return this.updateRunnableQueue;
    }

    public RepaintManager getRepaintManager() {
        return this.repaintManager;
    }

    public UpdateTracker getUpdateTracker() {
        return this.updateTracker;
    }

    public Document getDocument() {
        return this.document;
    }

    public ScriptingEnvironment getScriptingEnvironment() {
        return this.scriptingEnvironment;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void suspend() {
        if (this.updateRunnableQueue.getQueueState() == RunnableQueue.RUNNING) {
            this.updateRunnableQueue.suspendExecution(false);
        }
        this.suspendCalled = true;
    }

    public synchronized void resume() {
        if (this.updateRunnableQueue.getQueueState() != RunnableQueue.RUNNING) {
            this.updateRunnableQueue.resumeExecution();
        }
    }

    public synchronized void interrupt() {
        if (this.updateRunnableQueue.getThread() == null) {
            return;
        }
        this.updateRunnableQueue.preemptLater(new Runnable(){

            public void run() {
                UpdateManager updateManager = UpdateManager.this;
                synchronized (updateManager) {
                    if (UpdateManager.this.started) {
                        UpdateManager.this.dispatchSVGUnLoadEvent();
                    } else {
                        UpdateManager.this.running = false;
                        UpdateManager.this.scriptingEnvironment.interrupt();
                        UpdateManager.this.updateRunnableQueue.getThread().halt();
                    }
                }
            }
        });
        this.resume();
    }

    public void dispatchSVGUnLoadEvent() {
        if (!this.started) {
            throw new IllegalStateException("UpdateManager not started.");
        }
        this.updateRunnableQueue.preemptLater(new Runnable(){

            public void run() {
                UpdateManager updateManager = UpdateManager.this;
                synchronized (updateManager) {
                    Event event = ((DocumentEvent)((Object)UpdateManager.this.document)).createEvent("SVGEvents");
                    event.initEvent("SVGUnload", false, false);
                    ((EventTarget)((Object)UpdateManager.this.document.getDocumentElement())).dispatchEvent(event);
                    UpdateManager.this.running = false;
                    UpdateManager.this.scriptingEnvironment.interrupt();
                    UpdateManager.this.updateRunnableQueue.getThread().halt();
                    UpdateManager.this.bridgeContext.dispose();
                    UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent(UpdateManager.this, null, null);
                    UpdateManager.this.fireEvent(stoppedDispatcher, updateManagerEvent);
                }
            }
        });
        this.resume();
    }

    public void updateRendering(AffineTransform affineTransform, boolean bl, Shape shape, int n, int n2) {
        this.repaintManager.setupRenderer(affineTransform, bl, shape, n, n2);
        ArrayList<Shape> arrayList = new ArrayList<Shape>(1);
        arrayList.add(shape);
        this.updateRendering(arrayList, false);
    }

    public void updateRendering(AffineTransform affineTransform, boolean bl, boolean bl2, Shape shape, int n, int n2) {
        this.repaintManager.setupRenderer(affineTransform, bl, shape, n, n2);
        ArrayList<Shape> arrayList = new ArrayList<Shape>(1);
        arrayList.add(shape);
        this.updateRendering(arrayList, bl2);
    }

    protected void updateRendering(List list, boolean bl) {
        try {
            UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent(this, this.repaintManager.getOffScreen(), null);
            this.fireEvent(updateStartedDispatcher, updateManagerEvent);
            Collection collection = this.repaintManager.updateRendering(list);
            ArrayList arrayList = new ArrayList(collection);
            updateManagerEvent = new UpdateManagerEvent(this, this.repaintManager.getOffScreen(), arrayList, bl);
            this.fireEvent(updateCompletedDispatcher, updateManagerEvent);
        }
        catch (ThreadDeath threadDeath) {
            UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent(this, null, null);
            this.fireEvent(updateFailedDispatcher, updateManagerEvent);
            throw threadDeath;
        }
        catch (Throwable throwable) {
            UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent(this, null, null);
            this.fireEvent(updateFailedDispatcher, updateManagerEvent);
        }
    }

    protected void repaint() {
        Object object;
        if (!this.updateTracker.hasChanged()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.outOfDateTime < MIN_REPAINT_TIME) {
            object = this.updateRunnableQueue.getIteratorLock();
            synchronized (object) {
                Iterator iterator = this.updateRunnableQueue.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() instanceof NoRepaintRunnable) continue;
                    return;
                }
            }
        }
        object = this.updateTracker.getDirtyAreas();
        this.updateTracker.clear();
        if (object != null) {
            this.updateRendering((List)object, false);
        }
        this.outOfDateTime = 0L;
    }

    public void addUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.listeners.add(updateManagerListener);
    }

    public void removeUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.listeners.remove(updateManagerListener);
    }

    protected void fireEvent(EventDispatcher.Dispatcher dispatcher, Object object) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, (List)this.listeners, (Object)object, (boolean)false);
    }

    protected RunnableQueue.RunHandler createRunHandler() {
        return new UpdateManagerRunHander();
    }

    static {
        block5: {
            long l = 20L;
            try {
                try {
                    String string = System.getProperty("org.apache.batik.min_repaint_time", "20");
                    l = Long.parseLong(string);
                }
                catch (SecurityException securityException) {
                    Object var5_4 = null;
                    MIN_REPAINT_TIME = l;
                    break block5;
                }
                catch (NumberFormatException numberFormatException) {
                    Object var5_5 = null;
                    MIN_REPAINT_TIME = l;
                }
                Object var5_3 = null;
                MIN_REPAINT_TIME = l;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                MIN_REPAINT_TIME = l;
                throw throwable;
            }
        }
        startedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerStarted((UpdateManagerEvent)object2);
            }
        };
        stoppedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerStopped((UpdateManagerEvent)object2);
            }
        };
        suspendedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerSuspended((UpdateManagerEvent)object2);
            }
        };
        resumedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerResumed((UpdateManagerEvent)object2);
            }
        };
        updateStartedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).updateStarted((UpdateManagerEvent)object2);
            }
        };
        updateCompletedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).updateCompleted((UpdateManagerEvent)object2);
            }
        };
        updateFailedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).updateFailed((UpdateManagerEvent)object2);
            }
        };
    }

    protected class UpdateManagerRunHander
    extends RunnableQueue.RunHandlerAdapter {
        protected UpdateManagerRunHander() {
        }

        public void runnableStart(RunnableQueue runnableQueue, Runnable runnable) {
            if (UpdateManager.this.running && !(runnable instanceof NoRepaintRunnable) && UpdateManager.this.outOfDateTime == 0L) {
                UpdateManager.this.outOfDateTime = System.currentTimeMillis();
            }
        }

        public void runnableInvoked(RunnableQueue runnableQueue, Runnable runnable) {
            if (UpdateManager.this.running && !(runnable instanceof NoRepaintRunnable)) {
                UpdateManager.this.repaint();
            }
        }

        public void executionSuspended(RunnableQueue runnableQueue) {
            UpdateManager updateManager = UpdateManager.this;
            synchronized (updateManager) {
                if (UpdateManager.this.suspendCalled) {
                    UpdateManager.this.running = false;
                    UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent((Object)this, null, null);
                    UpdateManager.this.fireEvent(suspendedDispatcher, updateManagerEvent);
                }
            }
        }

        public void executionResumed(RunnableQueue runnableQueue) {
            UpdateManager updateManager = UpdateManager.this;
            synchronized (updateManager) {
                if (UpdateManager.this.suspendCalled && !UpdateManager.this.running) {
                    UpdateManager.this.running = true;
                    UpdateManager.this.suspendCalled = false;
                    UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent((Object)this, null, null);
                    UpdateManager.this.fireEvent(resumedDispatcher, updateManagerEvent);
                }
            }
        }
    }
}

