/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class MergeEmptyResourceFix
implements ICompletionProposal {
    private IntentAnnotation syncAnnotation;

    public MergeEmptyResourceFix(Annotation annotation) {
        this.syncAnnotation = (IntentAnnotation)annotation;
    }

    public void apply(IDocument document) {
        String workingCopyResourceURI = ((String)this.syncAnnotation.getAdditionalInformations().toArray()[1]).replace("\"", "");
        String generatedResourceURI = ((String)this.syncAnnotation.getAdditionalInformations().toArray()[2]).replace("\"", "");
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource generatedResource = rs.getResource(URI.createURI((String)generatedResourceURI), true);
        Resource workingCopyResource = rs.getResource(URI.createURI((String)workingCopyResourceURI), true);
        workingCopyResource.getContents().addAll(EcoreUtil.copyAll((Collection)generatedResource.getContents()));
        try {
            workingCopyResource.save(null);
        }
        catch (IOException e) {
            IntentUiLogger.logError(e);
        }
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return "";
    }

    public String getDisplayString() {
        return "Fill the working copy with the document content";
    }

    public Image getImage() {
        return IntentEditorActivator.getDefault().getImage("icon/annotation/sync-warning.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

