/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.query;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.common.query.AbstractIntentQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndex;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexerFactory;

public class IndexQuery
extends AbstractIntentQuery {
    private IntentIndex intentIndex;

    public IndexQuery(RepositoryAdapter repositoryAdapter) {
        super(repositoryAdapter);
    }

    public IntentIndex getOrCreateIntentIndex() {
        if (this.intentIndex == null) {
            final Resource indexResource = this.repositoryAdapter.getResource("/IntentIndex");
            if (indexResource.getContents().isEmpty()) {
                this.repositoryAdapter.execute(new IntentCommand(){

                    public void execute() {
                        indexResource.getContents().add((Object)IntentIndexerFactory.eINSTANCE.createIntentIndex());
                    }
                });
            }
            this.intentIndex = (IntentIndex)indexResource.getContents().get(0);
        }
        return this.intentIndex;
    }

    public IntentIndexEntry getIndexEntryAtLevel(String level) throws NumberFormatException {
        IntentIndexEntry entryAtLevel = null;
        IntentIndexEntry currentCandidate = null;
        String[] levels = level.split(".");
        try {
            if (this.getOrCreateIntentIndex().getEntries().size() > Integer.valueOf(levels[0]) - 1) {
                currentCandidate = (IntentIndexEntry)this.getOrCreateIntentIndex().getEntries().get(Integer.valueOf(levels[0]) - 1);
            }
            int i = 1;
            while (i < levels.length && entryAtLevel == null && currentCandidate != null) {
                if (currentCandidate.getName().startsWith(level)) {
                    entryAtLevel = currentCandidate;
                    continue;
                }
                EList entries = currentCandidate.getSubEntries();
                int currentSearchedLevel = Integer.valueOf(levels[i]) - 1;
                if (entries.size() <= currentSearchedLevel) continue;
                currentCandidate = (IntentIndexEntry)entries.get(currentSearchedLevel);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Invalid level for search '" + level + "'");
        }
        return entryAtLevel;
    }
}

