/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.datastructures.weights;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.SingleWeightFunction;

public class SingleWeightFunctionDouble<E>
implements SingleWeightFunction<Double, E> {
    private final Map<E, Double> weightMap = new HashMap<E, Double>();
    private Double sumNegativeWeights = 0.0;
    private Double minValue = Double.POSITIVE_INFINITY;
    private Double maxValue = Double.NEGATIVE_INFINITY;
    private Double maxAbsValue = 0.0;

    public void addWeight(E edge, Double weight) {
        this.weightMap.put(edge, weight);
        this.sumNegativeWeights = this.sumNegativeWeights + Math.max(0.0, -weight.doubleValue());
        this.minValue = Math.min(this.minValue, weight);
        this.maxValue = Math.max(this.maxValue, weight);
        this.maxAbsValue = Math.max(this.maxAbsValue, Math.abs(weight));
    }

    @Override
    public Double getWeight(E edge) {
        return this.weightMap.get(edge);
    }

    public Double getSumNegWeights() {
        return this.sumNegativeWeights;
    }

    public Map<E, Double> getWeightMap() {
        return this.weightMap;
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Double getMaxAbsValue() {
        return this.maxAbsValue;
    }
}

