/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.mpt.presentation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsat.common.mpt.MaxPlusSpecification;
import org.eclipse.lsat.common.mpt.api.MaxPlusAlgorithms;
import org.eclipse.lsat.common.mpt.api.MaxPlusException;
import org.eclipse.lsat.common.mpt.api.MaximumMakespanResult;
import org.eclipse.lsat.common.mpt.api.MaximumThroughputResult;
import org.eclipse.lsat.common.mpt.api.MinimumMakespanResult;
import org.eclipse.lsat.common.mpt.api.MinimumThroughputResult;
import org.eclipse.lsat.common.mpt.presentation.MaxPlusEditorPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class MPTActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(MaxPlusEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                MPTActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                MaxPlusEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(MaxPlusEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return MPTActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (MPTActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)MPTActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected IAction calculateMinimumThroughputAction = new Action("Calculate minimum throughput"){

        public boolean isEnabled() {
            return MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider;
        }

        public void run() {
            if (MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)MPTActionBarContributor.this.activeEditorPart).getEditingDomain();
                for (Resource resource : editingDomain.getResourceSet().getResources()) {
                    for (EObject eObject : resource.getContents()) {
                        if (!(eObject instanceof MaxPlusSpecification)) continue;
                        try {
                            MinimumThroughputResult result = MaxPlusAlgorithms.calculateMinimumThroughput((MaxPlusSpecification)((MaxPlusSpecification)eObject));
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(1, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Max plus result: " + result));
                        }
                        catch (MaxPlusException e) {
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Max plus algorithm failed: " + e.getLocalizedMessage(), (Throwable)e));
                        }
                    }
                }
            }
        }
    };
    protected IAction calculateMaximumThroughputAction = new Action("Calculate maximum throughput"){

        public boolean isEnabled() {
            return MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider;
        }

        public void run() {
            if (MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)MPTActionBarContributor.this.activeEditorPart).getEditingDomain();
                for (Resource resource : editingDomain.getResourceSet().getResources()) {
                    for (EObject eObject : resource.getContents()) {
                        if (!(eObject instanceof MaxPlusSpecification)) continue;
                        try {
                            MaximumThroughputResult result = MaxPlusAlgorithms.calculateMaximumThroughput((MaxPlusSpecification)((MaxPlusSpecification)eObject));
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(1, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Max plus result: " + result));
                        }
                        catch (MaxPlusException e) {
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Max plus algorithm failed: " + e.getLocalizedMessage(), (Throwable)e));
                        }
                    }
                }
            }
        }
    };
    protected IAction calculateMinimumMakespanAction = new Action("Calculate minimum makespan"){

        public boolean isEnabled() {
            return MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider;
        }

        public void run() {
            if (MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)MPTActionBarContributor.this.activeEditorPart).getEditingDomain();
                for (Resource resource : editingDomain.getResourceSet().getResources()) {
                    for (EObject eObject : resource.getContents()) {
                        if (!(eObject instanceof MaxPlusSpecification)) continue;
                        try {
                            MinimumMakespanResult result = MaxPlusAlgorithms.calculateMinimumMakespan((MaxPlusSpecification)((MaxPlusSpecification)eObject));
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(1, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Max plus result: " + result));
                        }
                        catch (MaxPlusException e) {
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Max plus algorithm failed: " + e.getLocalizedMessage(), (Throwable)e));
                        }
                    }
                }
            }
        }
    };
    protected IAction calculateMaximumMakespanAction = new Action("Calculate maximum makespan"){

        public boolean isEnabled() {
            return MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider;
        }

        public void run() {
            if (MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)MPTActionBarContributor.this.activeEditorPart).getEditingDomain();
                for (Resource resource : editingDomain.getResourceSet().getResources()) {
                    for (EObject eObject : resource.getContents()) {
                        if (!(eObject instanceof MaxPlusSpecification)) continue;
                        try {
                            MaximumMakespanResult result = MaxPlusAlgorithms.calculateMaximumMakespan((MaxPlusSpecification)((MaxPlusSpecification)eObject));
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(1, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Max plus result: " + result));
                        }
                        catch (MaxPlusException e) {
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Max plus algorithm failed: " + e.getLocalizedMessage(), (Throwable)e));
                        }
                    }
                }
            }
        }
    };
    protected IAction calculateClusterReductionPerformanceAction = new Action("Calculate cluster reduction (performance)"){

        public boolean isEnabled() {
            return MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider;
        }

        public void run() {
            if (MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)MPTActionBarContributor.this.activeEditorPart).getEditingDomain();
                for (Resource resource : editingDomain.getResourceSet().getResources()) {
                    for (EObject eObject : resource.getContents()) {
                        if (!(eObject instanceof MaxPlusSpecification)) continue;
                        try {
                            String specificationName = resource.getURI().trimFileExtension().lastSegment();
                            String result = MaxPlusAlgorithms.applyClusterReductionPerformance((MaxPlusSpecification)((MaxPlusSpecification)eObject), (String)(String.valueOf(specificationName) + "_composition"));
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(1, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Reduced state space computed"));
                            String workspaceURI = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toString()) + "/";
                            String projectOutputFolderURI = String.valueOf(resource.getURI().segment(1)) + "/result/";
                            String outputFile = specificationName.concat("_por.cif");
                            File cifFile = new File(new URI(String.valueOf(workspaceURI) + projectOutputFolderURI + outputFile));
                            Files.createDirectories(Paths.get(cifFile.toURI()).getParent(), new FileAttribute[0]);
                            cifFile.createNewFile();
                            FileWriter writer = new FileWriter(cifFile);
                            writer.write(result);
                            writer.close();
                        }
                        catch (MaxPlusException e) {
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Max plus algorithm failed: " + e.getLocalizedMessage(), (Throwable)e));
                        }
                        catch (IOException | URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    };
    protected IAction calculateClusterReductionPerformanceFunctionalAction = new Action("Calculate cluster reduction (performance, functional)"){

        public boolean isEnabled() {
            return MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider;
        }

        public void run() {
            if (MPTActionBarContributor.this.activeEditorPart instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)MPTActionBarContributor.this.activeEditorPart).getEditingDomain();
                for (Resource resource : editingDomain.getResourceSet().getResources()) {
                    for (EObject eObject : resource.getContents()) {
                        if (!(eObject instanceof MaxPlusSpecification)) continue;
                        try {
                            String specificationName = resource.getURI().trimFileExtension().lastSegment();
                            String result = MaxPlusAlgorithms.applyClusterReductionPerformanceFunctional((MaxPlusSpecification)((MaxPlusSpecification)eObject), (String)(String.valueOf(specificationName) + "_composition"));
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(1, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Reduced state space computed"));
                            String workspaceURI = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toString()) + "/";
                            String projectOutputFolderURI = String.valueOf(resource.getURI().segment(1)) + "/result/";
                            String outputFile = specificationName.concat("_por.cif");
                            File cifFile = new File(new URI(String.valueOf(workspaceURI) + projectOutputFolderURI + outputFile));
                            Files.createDirectories(Paths.get(cifFile.toURI()).getParent(), new FileAttribute[0]);
                            cifFile.createNewFile();
                            FileWriter writer = new FileWriter(cifFile);
                            writer.write(result);
                            writer.close();
                        }
                        catch (MaxPlusException e) {
                            MaxPlusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, MaxPlusEditorPlugin.getPlugin().getSymbolicName(), "Max plus algorithm failed: " + e.getLocalizedMessage(), (Throwable)e));
                        }
                        catch (IOException | URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;

    public MPTActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator("mpt-settings"));
        toolBarManager.add((IContributionItem)new Separator("mpt-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(MaxPlusEditorPlugin.INSTANCE.getString("_UI_MPTEditor_menu"), "org.eclipse.lsat.common.mptMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(MaxPlusEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(MaxPlusEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(MaxPlusEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(MaxPlusEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.calculateMinimumMakespanAction.setEnabled(this.calculateMinimumMakespanAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.calculateMinimumMakespanAction);
        this.calculateMaximumMakespanAction.setEnabled(this.calculateMaximumMakespanAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.calculateMaximumMakespanAction);
        this.calculateMinimumThroughputAction.setEnabled(this.calculateMinimumThroughputAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.calculateMinimumThroughputAction);
        this.calculateMaximumThroughputAction.setEnabled(this.calculateMaximumThroughputAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.calculateMaximumThroughputAction);
        this.calculateClusterReductionPerformanceAction.setEnabled(this.calculateClusterReductionPerformanceAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.calculateClusterReductionPerformanceAction);
        this.calculateClusterReductionPerformanceFunctionalAction.setEnabled(this.calculateClusterReductionPerformanceFunctionalAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.calculateClusterReductionPerformanceFunctionalAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }
}

