/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.machine.teditor.serializer;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import machine.ActionType;
import machine.Axis;
import machine.BidirectionalPath;
import machine.Distance;
import machine.FullMeshPath;
import machine.Import;
import machine.Machine;
import machine.MachinePackage;
import machine.PathAnnotation;
import machine.PathTargetReference;
import machine.Peripheral;
import machine.PeripheralType;
import machine.Position;
import machine.Profile;
import machine.Resource;
import machine.ResourceItem;
import machine.SetPoint;
import machine.SymbolicPosition;
import machine.UnidirectionalPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.lsat.machine.teditor.services.MachineGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public abstract class AbstractMachineSemanticSequencer extends AbstractDelegatingSemanticSequencer {

    @Inject
    private MachineGrammarAccess grammarAccess;
    
    @Override
    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set<Parameter> parameters = context.getEnabledBooleanParameters();
        if (epackage == MachinePackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case MachinePackage.ACTION_TYPE:
                sequence_ActionType(context, (ActionType) semanticObject); 
                return; 
            case MachinePackage.AXIS:
                sequence_Axis(context, (Axis) semanticObject); 
                return; 
            case MachinePackage.AXIS_POSITION_MAP_ENTRY:
                sequence_AxisPositionMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case MachinePackage.AXIS_POSITIONS_MAP_ENTRY:
                sequence_AxisPositionsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case MachinePackage.BIDIRECTIONAL_PATH:
                sequence_BidirectionalPath(context, (BidirectionalPath) semanticObject); 
                return; 
            case MachinePackage.DISTANCE:
                sequence_Distance(context, (Distance) semanticObject); 
                return; 
            case MachinePackage.FULL_MESH_PATH:
                sequence_FullMeshPath(context, (FullMeshPath) semanticObject); 
                return; 
            case MachinePackage.IMPORT:
                sequence_Import(context, (Import) semanticObject); 
                return; 
            case MachinePackage.MACHINE:
                sequence_Machine(context, (Machine) semanticObject); 
                return; 
            case MachinePackage.PATH_ANNOTATION:
                sequence_PathAnnotation(context, (PathAnnotation) semanticObject); 
                return; 
            case MachinePackage.PATH_TARGET_REFERENCE:
                sequence_PathTargetReference(context, (PathTargetReference) semanticObject); 
                return; 
            case MachinePackage.PERIPHERAL:
                sequence_Peripheral(context, (Peripheral) semanticObject); 
                return; 
            case MachinePackage.PERIPHERAL_TYPE:
                sequence_PeripheralType(context, (PeripheralType) semanticObject); 
                return; 
            case MachinePackage.POSITION:
                sequence_Position(context, (Position) semanticObject); 
                return; 
            case MachinePackage.PROFILE:
                sequence_Profile(context, (Profile) semanticObject); 
                return; 
            case MachinePackage.RESOURCE:
                sequence_Resource(context, (Resource) semanticObject); 
                return; 
            case MachinePackage.RESOURCE_ITEM:
                sequence_ResourceItem(context, (ResourceItem) semanticObject); 
                return; 
            case MachinePackage.SET_POINT:
                sequence_SetPoint(context, (SetPoint) semanticObject); 
                return; 
            case MachinePackage.SYMBOLIC_POSITION:
                sequence_SymbolicPosition(context, (SymbolicPosition) semanticObject); 
                return; 
            case MachinePackage.UNIDIRECTIONAL_PATH:
                sequence_UnidirectionalPath(context, (UnidirectionalPath) semanticObject); 
                return; 
            }
        if (errorAcceptor != null)
            errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
    }
    
    /**
     * Contexts:
     *     ActionType returns ActionType
     *
     * Constraint:
     *     name=ID
     */
    			protected void sequence_ActionType(ISerializationContext context, ActionType semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MachinePackage.Literals.ACTION_TYPE__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MachinePackage.Literals.ACTION_TYPE__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getActionTypeAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     AxisPositionMapEntry returns AxisPositionMapEntry
     *
     * Constraint:
     *     (key=[Axis|ID] value=[Position|ID])
     */
    			protected <T extends Map.Entry & EObject> void sequence_AxisPositionMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, MachinePackage.Literals.AXIS_POSITION_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, MachinePackage.Literals.AXIS_POSITION_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, MachinePackage.Literals.AXIS_POSITION_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, MachinePackage.Literals.AXIS_POSITION_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getAxisPositionMapEntryAccess().getKeyAxisIDTerminalRuleCall_1_0_1(), semanticObject.eGet(MachinePackage.Literals.AXIS_POSITION_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getAxisPositionMapEntryAccess().getValuePositionIDTerminalRuleCall_3_0_1(), semanticObject.eGet(MachinePackage.Literals.AXIS_POSITION_MAP_ENTRY__VALUE, false));
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     AxisPositionsMapEntry returns AxisPositionsMapEntry
     *
     * Constraint:
     *     (key=[Axis|ID] (value+=Position value+=Position*)?)
     */
    			protected <T extends Map.Entry & EObject> void sequence_AxisPositionsMapEntry(ISerializationContext context, T semanticObject) {
    genericSequencer.createSequence(context, (EObject) semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Axis returns Axis
     *
     * Constraint:
     *     (name=ID unit=ID? (setPoints+=[SetPoint|ID] setPoints+=[SetPoint|ID]*)?)
     */
    			protected void sequence_Axis(ISerializationContext context, Axis semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Path returns BidirectionalPath
     *     BidirectionalPath returns BidirectionalPath
     *
     * Constraint:
     *     (
     *         endPoints+=PathTargetReference 
     *         endPoints+=PathTargetReference 
     *         ((profiles+=[Profile|ID] profiles+=[Profile|ID]*) | profiles+=[Profile|ID]) 
     *         annotations+=[PathAnnotation|ID]*
     *     )
     */
    			protected void sequence_BidirectionalPath(ISerializationContext context, BidirectionalPath semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Distance returns Distance
     *
     * Constraint:
     *     (name=ID (settling+=[Axis|ID] settling+=[Axis|ID]*)?)
     */
    			protected void sequence_Distance(ISerializationContext context, Distance semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Path returns FullMeshPath
     *     FullMeshPath returns FullMeshPath
     *
     * Constraint:
     *     (((profiles+=[Profile|ID] profiles+=[Profile|ID]*) | profiles+=[Profile|ID]) annotations+=[PathAnnotation|ID]* endPoints+=PathTargetReference*)
     */
    			protected void sequence_FullMeshPath(ISerializationContext context, FullMeshPath semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Import returns Import
     *
     * Constraint:
     *     importURI=STRING
     */
    			protected void sequence_Import(ISerializationContext context, Import semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MachinePackage.Literals.IMPORT__IMPORT_URI) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MachinePackage.Literals.IMPORT__IMPORT_URI));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0(), semanticObject.getImportURI());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Machine returns Machine
     *
     * Constraint:
     *     (imports+=Import* type=ID? pathAnnotations+=PathAnnotation* (peripheralTypes+=PeripheralType | resources+=Resource)*)
     */
    			protected void sequence_Machine(ISerializationContext context, Machine semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     PathAnnotation returns PathAnnotation
     *
     * Constraint:
     *     name=ID
     */
    			protected void sequence_PathAnnotation(ISerializationContext context, PathAnnotation semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MachinePackage.Literals.PATH_ANNOTATION__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MachinePackage.Literals.PATH_ANNOTATION__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getPathAnnotationAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     PathTargetReference returns PathTargetReference
     *
     * Constraint:
     *     (position=[SymbolicPosition|ID] (settling+=[Axis|ID] settling+=[Axis|ID]*)?)
     */
    			protected void sequence_PathTargetReference(ISerializationContext context, PathTargetReference semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     PeripheralType returns PeripheralType
     *
     * Constraint:
     *     (name=ID actions+=ActionType* setPoints+=SetPoint* axes+=Axis* conversion=STRING?)
     */
    			protected void sequence_PeripheralType(ISerializationContext context, PeripheralType semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Peripheral returns Peripheral
     *
     * Constraint:
     *     (
     *         name=ID 
     *         type=[PeripheralType|ID] 
     *         (
     *             axisPositions+=AxisPositionsMapEntry* 
     *             positions+=SymbolicPosition* 
     *             profiles+=Profile 
     *             profiles+=Profile* 
     *             distances+=Distance* 
     *             paths+=Path*
     *         )?
     *     )
     */
    			protected void sequence_Peripheral(ISerializationContext context, Peripheral semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Position returns Position
     *
     * Constraint:
     *     name=ID
     */
    			protected void sequence_Position(ISerializationContext context, Position semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MachinePackage.Literals.POSITION__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MachinePackage.Literals.POSITION__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getPositionAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Profile returns Profile
     *
     * Constraint:
     *     name=ID
     */
    			protected void sequence_Profile(ISerializationContext context, Profile semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MachinePackage.Literals.PROFILE__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MachinePackage.Literals.PROFILE__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getProfileAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     ResourceItem returns ResourceItem
     *
     * Constraint:
     *     name=IID
     */
    			protected void sequence_ResourceItem(ISerializationContext context, ResourceItem semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MachinePackage.Literals.IRESOURCE__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MachinePackage.Literals.IRESOURCE__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getResourceItemAccess().getNameIIDParserRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Resource returns Resource
     *
     * Constraint:
     *     (name=ID (items+=ResourceItem items+=ResourceItem*)? peripherals+=Peripheral*)
     */
    			protected void sequence_Resource(ISerializationContext context, Resource semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     SetPoint returns SetPoint
     *
     * Constraint:
     *     (name=ID unit=ID?)
     */
    			protected void sequence_SetPoint(ISerializationContext context, SetPoint semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     SymbolicPosition returns SymbolicPosition
     *
     * Constraint:
     *     (name=ID (axisPosition+=AxisPositionMapEntry axisPosition+=AxisPositionMapEntry*)?)
     */
    			protected void sequence_SymbolicPosition(ISerializationContext context, SymbolicPosition semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Path returns UnidirectionalPath
     *     UnidirectionalPath returns UnidirectionalPath
     *
     * Constraint:
     *     (
     *         source=[SymbolicPosition|ID] 
     *         target=PathTargetReference 
     *         ((profiles+=[Profile|ID] profiles+=[Profile|ID]*) | profiles+=[Profile|ID]) 
     *         annotations+=[PathAnnotation|ID]*
     *     )
     */
    			protected void sequence_UnidirectionalPath(ISerializationContext context, UnidirectionalPath semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
}
