/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ecore.resource;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsat.common.emf.ecore.resource.ResourceDiagnosticInfo;

public class ResourceDiagnosticException
extends DiagnosticException
implements Resource.Diagnostic {
    private static final long serialVersionUID = 5590745978712337960L;
    protected static final int UNKNOWN_LINE = -1;
    protected static final int UNKNOWN_COLUMN = -1;

    public ResourceDiagnosticException(String message) {
        this(message, null);
    }

    public ResourceDiagnosticException(String message, Throwable cause) {
        this(Severity.ERROR, message, cause);
    }

    public ResourceDiagnosticException(Severity severity, String message) {
        this(severity, message, null);
    }

    public ResourceDiagnosticException(Severity severity, String message, Throwable cause) {
        this(severity, null, -1, -1, message, cause);
    }

    public ResourceDiagnosticException(Severity severity, URI location, int column, int line, String message, Throwable cause) {
        this(severity, null, 0, location, column, line, message, cause);
    }

    public ResourceDiagnosticException(Severity severity, String source, int code, URI location, int column, int line, String message, Throwable cause) {
        this(new ResourceDiagnosticInfo(severity, source, code, message, cause, location, line, column));
    }

    protected ResourceDiagnosticException(ResourceDiagnosticInfo info) {
        super((Diagnostic)info);
    }

    protected ResourceDiagnosticInfo getInfo() {
        return (ResourceDiagnosticInfo)super.getDiagnostic();
    }

    public Severity getSeverity() {
        return this.getInfo().getSeverityEnum();
    }

    public String getMessage() {
        return this.getInfo().toString();
    }

    public String getLocation() {
        return this.getInfo().getLocation();
    }

    public void setLocation(URI location) {
        this.getInfo().setLocationURI(location);
    }

    public int getLine() {
        return this.getInfo().getLine();
    }

    public void setLine(int line) {
        this.getInfo().setLine(line);
    }

    public int getColumn() {
        return this.getInfo().getColumn();
    }

    public void setColumn(int column) {
        this.getInfo().setColumn(column);
    }

    public void addDetail(String key, Object value) {
        this.getInfo().addDetail(key, value);
    }

    public void getDetail(String key, Object value) {
        this.getInfo().getDetail(key, value);
    }

    public String toString() {
        return this.getInfo().toString();
    }

    public static enum Severity {
        ERROR(4),
        WARNING(2);

        private final int severity;

        private Severity(int severity) {
            this.severity = severity;
        }

        public int getSeverity() {
            return this.severity;
        }

        public static Severity toSeverity(int severity) {
            switch (severity) {
                case 4: {
                    return ERROR;
                }
                case 2: {
                    return WARNING;
                }
            }
            throw new IllegalArgumentException("Unknown severity: " + severity);
        }
    }
}

