/*
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.lsat.activity.diagram.design;

import org.eclipse.jface.wizard.Wizard;

import activity.Event;

public class AddEventActionWizard extends Wizard {
    private final AddEventActionPage eventActionPage;

    private Event eventAction;

    public AddEventActionWizard(String initialActionName) {
        eventActionPage = new AddEventActionPage(initialActionName);
    }

    @Override
    public void addPages() {
        addPage(eventActionPage);
    }

    @Override
    public boolean performFinish() {
        eventAction = eventActionPage.createEventAction();
        return true;
    }

    public Event getEventAction() {
        return eventAction;
    }
}
