/*
 * Decompiled with CFR 0.152.
 */
package machine.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import machine.Import;
import machine.ImportContainer;
import machine.MachineFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ImportsFlattener {
    private ImportsFlattener() {
    }

    public static ResourceSet flatten(URI baseURI, ImportContainer ... importContainers) {
        Flattener flattener = new Flattener(baseURI);
        ImportContainer[] importContainerArray = importContainers;
        int n = importContainers.length;
        int n2 = 0;
        while (n2 < n) {
            ImportContainer importContainer = importContainerArray[n2];
            flattener.result.put(importContainer.eClass(), null);
            String rootExtension = EcoreUtil.getURI((EObject)importContainer).fileExtension();
            flattener.extensions.put(importContainer.eClass(), rootExtension);
            ++n2;
        }
        flattener.flatten(importContainers);
        return flattener.resourceSet;
    }

    private static String extension(Import imp) {
        URI uri = URI.createURI((String)imp.getImportURI());
        return uri.fileExtension();
    }

    private static ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setURIResourceMap(new HashMap());
        return resourceSet;
    }

    static /* synthetic */ ResourceSet access$0() {
        return ImportsFlattener.createResourceSet();
    }

    private static final class Flattener {
        private final EcoreUtil.Copier copier = new EcoreUtil.Copier();
        private final Map<EClass, ImportContainer> result = new LinkedHashMap<EClass, ImportContainer>();
        private final Map<EClass, String> extensions = new LinkedHashMap<EClass, String>();
        private final Collection<ImportContainer> seen = new LinkedHashSet<ImportContainer>();
        private final ResourceSet resourceSet = ImportsFlattener.access$0();
        private final URI baseURI;

        public Flattener(URI baseURI) {
            this.baseURI = baseURI;
        }

        private void flatten(ImportContainer ... importContainers) {
            ImportContainer[] importContainerArray = importContainers;
            int n = importContainers.length;
            int n2 = 0;
            while (n2 < n) {
                ImportContainer importContainer = importContainerArray[n2];
                this.flatten(importContainer);
                ++n2;
            }
            this.copier.copyReferences();
            this.result.values().forEach(ic -> this.replaceImports((ImportContainer)ic));
        }

        private void flatten(ImportContainer importContainer) {
            if (!this.seen.add(importContainer)) {
                return;
            }
            EClass eClass = importContainer.eClass();
            EObject copy = this.copier.copy((EObject)importContainer);
            ImportContainer container = this.result.get(eClass);
            if (container == null) {
                container = (ImportContainer)copy;
                Resource childResource = this.resourceSet.createResource(this.createReference(this.extensions.get(container.eClass())));
                childResource.getContents().add((Object)container);
                this.result.put(eClass, container);
            } else {
                int i = 0;
                int size = eClass.getFeatureCount();
                while (i < size) {
                    EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
                    Object v = copy.eGet(eStructuralFeature);
                    if (v instanceof Collection) {
                        ((Collection)container.eGet(eStructuralFeature)).addAll((Collection)v);
                    } else {
                        container.eSet(eStructuralFeature, v);
                    }
                    ++i;
                }
            }
            for (Import imp : importContainer.getImports()) {
                this.flatten(this.findChild(imp));
            }
        }

        private ImportContainer findChild(Import imp) {
            ImportContainer result = (ImportContainer)imp.load().get(0);
            this.extensions.put(result.eClass(), ImportsFlattener.extension(imp));
            return result;
        }

        private void replaceImports(ImportContainer container) {
            if (this.baseURI == null || container == null) {
                return;
            }
            String myExtension = this.extensions.get(container.eClass());
            URI myURI = container.eResource().getURI();
            List<URI> uris = container.getImports().stream().map(ImportsFlattener::access$1).filter(e -> !e.equals(myExtension)).map(extension -> this.createReference((String)extension).deresolve(myURI)).distinct().collect(Collectors.toList());
            container.getImports().clear();
            uris.forEach(uri -> {
                Import imp = MachineFactory.eINSTANCE.createImport();
                imp.setImportURI(uri.toString());
                container.getImports().add((Object)imp);
            });
        }

        private URI createReference(String extension) {
            return this.baseURI.appendFileExtension(extension);
        }
    }
}

