/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.eclipse.lsat.common.util.AppendableIterator;
import org.eclipse.lsat.common.util.BufferedIterator;
import org.eclipse.lsat.common.util.CollectionUtil;
import org.eclipse.lsat.common.util.CompoundIterator;
import org.eclipse.lsat.common.util.IterableIterator;
import org.eclipse.lsat.common.util.NullSkippingIterator;
import org.eclipse.lsat.common.util.ObjIntFunction;
import org.eclipse.lsat.common.util.PeekingIterator;
import org.eclipse.lsat.common.util.ProcessingIterator;
import org.eclipse.lsat.common.util.UniqueIterator;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static <E> Iterator<E> singletonIterator(final E element) {
        return new Iterator<E>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return element;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public static <E, T> Iterator<E> iterate(final T owner, final ObjIntFunction<? super T, E> getter, final ToIntFunction<? super T> size) {
        return new Iterator<E>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < size.applyAsInt(owner);
            }

            @Override
            public E next() {
                return getter.apply(owner, this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public static <E> E safeNext(Iterator<E> source) {
        return source.hasNext() ? (E)source.next() : null;
    }

    public static <E> Iterator<E> unique(Iterator<E> source) {
        return new UniqueIterator<E>(source);
    }

    public static <E> Iterator<E> notNull(Iterator<E> source) {
        return new NullSkippingIterator<E>(source);
    }

    public static <Input, Output> Iterator<Output> map(final Iterator<? extends Input> iterator, final Function<Input, Output> functor) {
        return new Iterator<Output>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Output next() {
                return functor.apply(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static final <T> Iterator<T> flatten(Iterator<? extends Iterator<? extends T>> iterator) {
        return new CompoundIterator(iterator);
    }

    public static final <Input, Output> Iterator<Output> flatMap(Iterator<? extends Input> iterator, Function<Input, Iterator<? extends Output>> functor) {
        return IteratorUtil.flatten(IteratorUtil.notNull(IteratorUtil.map(iterator, functor)));
    }

    public static <Input> Iterator<Input> filter(final Iterator<Input> iterator, final Predicate<? super Input> predicate) {
        return new ProcessingIterator<Input>(){

            @Override
            protected boolean toNext() {
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (!predicate.test(next)) continue;
                    return this.setNext(next);
                }
                return this.done();
            }
        };
    }

    @SafeVarargs
    public static final <T> Iterator<T> join(Iterator<? extends T> ... iterators) {
        return new CompoundIterator<T>(iterators);
    }

    public static final boolean contains(Iterator<?> iterator, Object o) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(o == null ? e == null : o.equals(e))) continue;
            return true;
        }
        return false;
    }

    public static final <T extends Comparable<? super T>> T min(Iterator<? extends T> iterator, T _default) {
        if (iterator == null) {
            return _default;
        }
        if (!iterator.hasNext()) {
            return _default;
        }
        Comparable candidate = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable next = (Comparable)iterator.next();
            if (next.compareTo(candidate) >= 0) continue;
            candidate = next;
        }
        return (T)candidate;
    }

    public static final <T extends Comparable<? super T>> T max(Iterator<? extends T> iterator, T _default) {
        if (iterator == null) {
            return _default;
        }
        if (!iterator.hasNext()) {
            return _default;
        }
        Comparable candidate = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable next = (Comparable)iterator.next();
            if (next.compareTo(candidate) <= 0) continue;
            candidate = next;
        }
        return (T)candidate;
    }

    public static final <T> Iterator<T> drop(final Iterator<? extends T> iterator, final int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("amount should be positive");
        }
        return new ProcessingIterator<T>(){
            private int dropped = 0;

            @Override
            protected boolean toNext() {
                while (this.dropped++ < amount && iterator.hasNext()) {
                    iterator.next();
                }
                return iterator.hasNext() ? this.setNext(iterator.next()) : this.done();
            }
        };
    }

    public static Object[] toArray(Iterator<?> iterator) {
        return IteratorUtil.asList(iterator).toArray();
    }

    public static <T> T[] toArray(Iterator<?> iterator, Class<T> type) {
        LinkedList<?> list = IteratorUtil.asList(iterator);
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    public static <T> LinkedList<T> asList(Iterator<T> iterator) {
        LinkedList list = new LinkedList();
        CollectionUtil.addAll(list, iterator);
        return list;
    }

    public static <T> ArrayList<T> asList(Iterator<T> iterator, int initialCapacity) {
        ArrayList list = new ArrayList(initialCapacity);
        CollectionUtil.addAll(list, iterator);
        return list;
    }

    public static <T> Set<T> asSet(Iterator<T> iterator) {
        HashSet set = new HashSet();
        CollectionUtil.addAll(set, iterator);
        return set;
    }

    public static <T> LinkedHashSet<T> asOrderedSet(Iterator<T> iterator) {
        LinkedHashSet set = new LinkedHashSet();
        CollectionUtil.addAll(set, iterator);
        return set;
    }

    public static <E> Iterable<E> toIterable(Iterator<E> source) {
        return new IterableIterator<E>(source);
    }

    public static <E> AppendableIterator<E> toAppendable(Iterator<E> source) {
        return new AppendableIterator<E>(source);
    }

    public static <E> BufferedIterator<E> toBuffered(Iterator<E> source) {
        return new BufferedIterator<E>(source);
    }

    public static <E> PeekingIterator<E> toPeeking(Iterator<E> source) {
        return new PeekingIterator<E>(source);
    }
}

