/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.automaton;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.automaton.MPAState;
import org.eclipse.lsat.common.ludus.backend.automaton.MPATransition;
import org.eclipse.lsat.common.ludus.backend.automaton.MPGA;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;

public class ComputeMPGA {
    private static final Value DEFAULT_REWARD = new Value(1.0);

    private ComputeMPGA() {
    }

    public static <V, E> MPGA<V> computeMaxPlusAutomaton(FSM<V, E> fsm, Integer vectorSize, Map<String, Matrix> matrices) {
        return ComputeMPGA.computeMaxPlusAutomaton(fsm, vectorSize, matrices, new HashMap<String, Value>());
    }

    public static <V, E> MPGA<V> computeMaxPlusAutomaton(FSM<V, E> fsm, Integer vectorSize, Map<String, Matrix> matrices, Map<String, Value> rewardMap) {
        MPGA mpa = new MPGA();
        for (Object v : fsm.getVertices()) {
            int index = 0;
            while (index < vectorSize) {
                mpa.addState(new MPAState(v, index));
                ++index;
            }
        }
        for (Object e : fsm.getEdges()) {
            String event = fsm.getEvent(e);
            Matrix m = matrices.get(event);
            int row = 0;
            while (row < m.getRows()) {
                int col = 0;
                while (col < m.getColumns()) {
                    Value reward = rewardMap.getOrDefault(event, DEFAULT_REWARD);
                    Value duration = m.get(row, col);
                    MPAState source = mpa.getState(fsm.getEdgeSource(e), row);
                    MPAState target = mpa.getState(fsm.getEdgeTarget(e), col);
                    MPAState intermediateState = mpa.getState(fsm.getEdgeTarget(e), ComputeMPGA.getMirrorIndex(row));
                    if (intermediateState == null) {
                        intermediateState = new MPAState(fsm.getEdgeTarget(e), ComputeMPGA.getMirrorIndex(row));
                        mpa.addState(intermediateState);
                    }
                    if (!duration.equals(Value.NEGATIVE_INFINITY)) {
                        mpa.addTransition(new MPATransition(source, event, new Value(0.0), new Value(0.0), intermediateState));
                        mpa.addTransition(new MPATransition(intermediateState, event, reward, duration, target));
                    }
                    ++col;
                }
                ++row;
            }
        }
        return mpa;
    }

    public static Integer getMirrorIndex(Integer index) {
        return index * -1 - 1;
    }
}

