/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.utils;

import java.util.function.Supplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.ConnectDocumentToLanguageServerSetupParticipant;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.tests.mock.MockConnectionProvider;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroPart;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AllCleanExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final Supplier<ServerCapabilities> serverConfigurer;

    public AllCleanExtension() {
        this.serverConfigurer = MockLanguageServer::defaultServerCapabilities;
    }

    public AllCleanExtension(Supplier<ServerCapabilities> serverConfigurer) {
        this.serverConfigurer = serverConfigurer;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        IIntroPart intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
        if (intro != null) {
            PlatformUI.getWorkbench().getIntroManager().closeIntro(intro);
        }
        this.clear();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.clear();
    }

    private void clear() {
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(0L);
        int i = 3;
        while (i > 0 && !UI.getActivePage().closeAllEditors(false)) {
            --i;
        }
        ConnectDocumentToLanguageServerSetupParticipant.waitForAll();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.delete(1, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        MockLanguageServer.INSTANCE.waitBeforeTearDown();
        LanguageServiceAccessor.clearStartedServers();
        MockLanguageServer.reset(this.serverConfigurer);
        MockConnectionProvider.cancellations.clear();
    }
}

