/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.functionservice.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.internal.function.impl.FunctionProviderImpl;
import org.eclipse.birt.core.script.functionservice.IScriptFunction;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionArgument;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionCategory;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionFactory;
import org.eclipse.birt.core.script.functionservice.impl.Argument;
import org.eclipse.birt.core.script.functionservice.impl.Category;
import org.eclipse.birt.core.script.functionservice.impl.CategoryWrapper;
import org.eclipse.birt.core.script.functionservice.impl.IFunctionProvider;
import org.eclipse.birt.core.script.functionservice.impl.ScriptFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class FunctionProviderBaseImpl
implements IFunctionProvider {
    public static final String EXTENSION_POINT = "org.eclipse.birt.core.ScriptFunctionService";
    protected static final String ELEMENT_CATEGORY = "Category";
    protected static final String ELEMENT_FUNCTION = "Function";
    protected static final String ELEMENT_ARGUMENT = "Argument";
    protected static final String ELEMENT_JSLIB = "JSLib";
    protected static final String ELEMENT_DATATYPE = "DataType";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_DESC = "desc";
    protected static final String ATTRIBUTE_FACTORYCLASS = "factoryclass";
    protected static final String ATTRIBUTE_VALUE = "value";
    protected static final String ATTRIBUTE_ISOPTIONAL = "isOptional";
    protected static final String ATTRIBUTE_ALLOWVARARGUMENT = "variableArguments";
    protected static final String ATTRIBUTE_ISSTATIC = "isStatic";
    protected static final String ATTRIBUTE_ISCONSTRUCTOR = "isConstructor";
    protected static final String ATTRIBUTE_LOCATION = "location";
    protected static final String ATTRIBUTE_ISVISIBLE = "isVisible";
    protected static final String DEFAULT_CATEGORYNAME = null;
    protected Map<String, Category> categories;
    protected List<URL> jsLibs = new ArrayList<URL>();
    protected List<URL> jarLibs = new ArrayList<URL>();
    protected final IExtensionPoint extPoint;

    public FunctionProviderBaseImpl(IExtensionPoint extPoint) {
        this.extPoint = extPoint;
    }

    @Override
    public IScriptFunctionCategory[] getCategories() throws BirtException {
        return this.getCategoryMap().values().toArray(new IScriptFunctionCategory[0]);
    }

    @Override
    public IScriptFunction[] getFunctions(String categoryName) throws BirtException {
        if (this.getCategoryMap().containsKey(categoryName)) {
            Category category = this.getCategoryMap().get(categoryName);
            return category.getFunctions();
        }
        return new IScriptFunction[0];
    }

    @Override
    public void registerScriptFunction(Context cx, Scriptable scope) throws BirtException {
        List<CategoryWrapper> wrapperedCategories = this.getWrapperedCategories();
        for (CategoryWrapper category : wrapperedCategories) {
            ScriptableObject.putProperty((Scriptable)scope, (String)category.getClassName(), (Object)((Object)category));
        }
        if (!this.jarLibs.isEmpty()) {
            ClassLoader classLoader = cx.getApplicationClassLoader();
            URLClassLoader scriptClassLoader = this.createScriptClassLoader(this.jarLibs, classLoader);
            this.setApplicationClassLoader(scriptClassLoader, cx);
        }
        for (URL url : this.jsLibs) {
            try {
                Script script = cx.compileReader((Reader)new BufferedReader(new InputStreamReader(url.openStream())), null, 0, null);
                script.exec(cx, scope);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setApplicationClassLoader(final ClassLoader appLoader, Context context) {
        if (appLoader == null) {
            return;
        }
        ClassLoader loader = appLoader;
        try {
            appLoader.loadClass("org.mozilla.javascript.Context");
        }
        catch (ClassNotFoundException e) {
            loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new RhinoClassLoaderDecoration(appLoader, FunctionProviderImpl.class.getClassLoader());
                }
            });
        }
        context.setApplicationClassLoader(loader);
    }

    private synchronized URLClassLoader createScriptClassLoader(List urls, ClassLoader parent) {
        final URL[] jarUrls = urls.toArray(new URL[0]);
        final ClassLoader parentClassLoader = parent;
        URLClassLoader scriptClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(jarUrls, parentClassLoader);
            }
        });
        return scriptClassLoader;
    }

    private synchronized Map<String, Category> getCategoryMap() {
        if (this.categories != null) {
            return this.categories;
        }
        this.categories = new HashMap<String, Category>();
        if (this.extPoint == null) {
            return this.categories;
        }
        IExtension[] exts = this.extPoint.getExtensions();
        if (exts == null) {
            return this.categories;
        }
        int e = 0;
        while (e < exts.length) {
            try {
                IConfigurationElement[] configElems = exts[e].getConfigurationElements();
                if (configElems != null) {
                    int i = 0;
                    while (i < configElems.length) {
                        boolean isVisible = FunctionProviderBaseImpl.extractBoolean(configElems[i].getAttribute(ATTRIBUTE_ISVISIBLE), true);
                        if (configElems[i].getName().equals(ELEMENT_CATEGORY)) {
                            Category category = new Category(configElems[i].getAttribute(ATTRIBUTE_NAME), configElems[i].getAttribute(ATTRIBUTE_DESC), isVisible);
                            this.categories.put(category.getName(), category);
                            IScriptFunctionFactory factory = null;
                            if (configElems[i].getAttribute(ATTRIBUTE_FACTORYCLASS) != null) {
                                factory = (IScriptFunctionFactory)configElems[i].createExecutableExtension(ATTRIBUTE_FACTORYCLASS);
                            }
                            IConfigurationElement[] functions = configElems[i].getChildren(ELEMENT_FUNCTION);
                            int j = 0;
                            while (j < functions.length) {
                                IScriptFunction function = FunctionProviderBaseImpl.getScriptFunction(category, factory, functions[j]);
                                if (function != null) {
                                    category.addFunction(function);
                                }
                                ++j;
                            }
                        } else if (configElems[i].getName().equals(ELEMENT_FUNCTION)) {
                            IScriptFunction function;
                            if (this.categories.get(DEFAULT_CATEGORYNAME) == null) {
                                this.categories.put(DEFAULT_CATEGORYNAME, new Category(DEFAULT_CATEGORYNAME, null, isVisible));
                            }
                            if ((function = FunctionProviderBaseImpl.getScriptFunction(this.categories.get(DEFAULT_CATEGORYNAME), null, configElems[i])) != null) {
                                this.categories.get(DEFAULT_CATEGORYNAME).addFunction(function);
                            }
                        } else if (configElems[i].getName().equals(ELEMENT_JSLIB)) {
                            this.populateResources(this.jsLibs, ".js", configElems[i]);
                            this.populateResources(this.jarLibs, ".jar", configElems[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (BirtException ex) {
                ex.printStackTrace();
            }
            ++e;
        }
        return this.categories;
    }

    protected void populateResources(List<URL> libs, String suffix, IConfigurationElement confElement) {
    }

    private static IScriptFunction getScriptFunction(Category category, IScriptFunctionFactory factory, IConfigurationElement function) {
        try {
            String name = function.getAttribute(ATTRIBUTE_NAME);
            String desc = function.getAttribute(ATTRIBUTE_DESC);
            String varArgs = function.getAttribute(ATTRIBUTE_ALLOWVARARGUMENT);
            boolean allowVarArgs = FunctionProviderBaseImpl.extractBoolean(varArgs, false);
            boolean isConstructor = FunctionProviderBaseImpl.extractBoolean(function.getAttribute(ATTRIBUTE_ISCONSTRUCTOR), false);
            boolean isStatic = FunctionProviderBaseImpl.extractBoolean(function.getAttribute(ATTRIBUTE_ISSTATIC), true);
            boolean isVisible = FunctionProviderBaseImpl.extractBoolean(function.getAttribute(ATTRIBUTE_ISVISIBLE), true);
            String dataType = null;
            ArrayList<IScriptFunctionArgument> arguments = new ArrayList<IScriptFunctionArgument>();
            if (FunctionProviderBaseImpl.hasChildren(ELEMENT_DATATYPE, function)) {
                dataType = function.getChildren(ELEMENT_DATATYPE)[0].getAttribute(ATTRIBUTE_VALUE);
            }
            if (FunctionProviderBaseImpl.hasChildren(ELEMENT_ARGUMENT, function)) {
                int i = 0;
                while (i < function.getChildren(ELEMENT_ARGUMENT).length) {
                    arguments.add(FunctionProviderBaseImpl.getScriptFunctionArgument(function.getChildren(ELEMENT_ARGUMENT)[i]));
                    ++i;
                }
            }
            return new ScriptFunction(name, category, arguments.toArray(new IScriptFunctionArgument[0]), dataType, desc, factory == null ? null : factory.getFunctionExecutor(name), allowVarArgs, isStatic, isConstructor, isVisible);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean extractBoolean(String strValue, boolean ifNull) throws BirtException {
        boolean booleanValue = strValue == null ? ifNull : DataTypeUtil.toBoolean(strValue);
        return booleanValue;
    }

    private static IScriptFunctionArgument getScriptFunctionArgument(IConfigurationElement argument) throws BirtException {
        String name = argument.getAttribute(ATTRIBUTE_NAME);
        String desc = argument.getAttribute(ATTRIBUTE_DESC);
        String optional = argument.getAttribute(ATTRIBUTE_ISOPTIONAL);
        boolean isOptional = FunctionProviderBaseImpl.extractBoolean(optional, false);
        String dataType = null;
        if (FunctionProviderBaseImpl.hasChildren(ELEMENT_DATATYPE, argument)) {
            dataType = argument.getChildren(ELEMENT_DATATYPE)[0].getAttribute(ATTRIBUTE_VALUE);
        }
        return new Argument(name, dataType, desc, isOptional);
    }

    private static boolean hasChildren(String name, IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren(name);
        return children != null && children.length > 0;
    }

    private List<CategoryWrapper> getWrapperedCategories() throws BirtException {
        ArrayList<CategoryWrapper> result = new ArrayList<CategoryWrapper>();
        for (Category category : this.getCategoryMap().values()) {
            if (category.getName() == DEFAULT_CATEGORYNAME) continue;
            result.add(new CategoryWrapper(category));
        }
        return result;
    }

    private static class RhinoClassLoaderDecoration
    extends ClassLoader {
        private ClassLoader applicationClassLoader;
        private ClassLoader rhinoClassLoader;

        public RhinoClassLoaderDecoration(ClassLoader applicationClassLoader, ClassLoader rhinoClassLoader) {
            this.applicationClassLoader = applicationClassLoader;
            this.rhinoClassLoader = rhinoClassLoader;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.applicationClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.rhinoClassLoader.loadClass(name);
            }
        }
    }
}

