/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class SingletonCollectionExtractor
implements ICollectionExtractor {
    private final String field;

    public SingletonCollectionExtractor(String field) {
        this.field = field;
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        return 1;
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        return 1;
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        int id = ((IObject)coll.resolveValue(this.field)).getObjectId();
        return new int[]{id};
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return coll.resolveValue(this.field) != null ? 1 : 0;
    }

    @Override
    public boolean hasFillRatio() {
        return true;
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        return this.getNumberOfNotNullElements(coll).doubleValue();
    }
}

