/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.comparator.ComparatorMatcherBuilder;

public final class TCKMatchers {
    private static final Comparator<Number> NUMERIC_COMPARATOR = (value1, value2) -> {
        BigDecimal decimal1 = BigDecimal.valueOf(value1.doubleValue());
        BigDecimal decimal2 = BigDecimal.valueOf(value2.doubleValue());
        return decimal1.compareTo(decimal2);
    };

    private TCKMatchers() {
    }

    public static Matcher<Number> comparesEqualToNumber(Number expected) {
        return ComparatorMatcherBuilder.comparedBy(NUMERIC_COMPARATOR).comparesEqualTo((Object)expected);
    }

    public static Matcher<Object> itemOrSingleton(Matcher<?> itemMatcher) {
        return new ItemOrSingletonMatcher(itemMatcher);
    }

    public static Matcher<Object> itemOrSingleton(Object item) {
        return TCKMatchers.itemOrSingleton(Matchers.equalTo((Object)item));
    }

    public static Matcher<Number> number(Number number) {
        return new NumericEqualityMatcher(number);
    }

    public static <T> Matcher<T> hasOptionalEntry(String entryName, Object value) {
        Matcher hasEntry = Matchers.hasEntry((Object)entryName, (Object)value);
        Matcher entryMissing = Matchers.not((Matcher)Matchers.hasKey((Object)entryName));
        return Matchers.allOf((Matcher)Matchers.isA(Map.class), (Matcher)Matchers.either((Matcher)hasEntry).or(entryMissing));
    }

    public static class ItemOrSingletonMatcher
    extends TypeSafeDiagnosingMatcher<Object> {
        private Matcher<?> baseMatcher;

        public ItemOrSingletonMatcher(Matcher<?> baseMatcher) {
            super(Object.class);
            this.baseMatcher = baseMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("An item or singleton list containing ").appendDescriptionOf(this.baseMatcher);
        }

        protected boolean matchesSafely(Object item, Description mismatchDescription) {
            boolean result;
            if (item instanceof Collection) {
                Collection collection = (Collection)item;
                if (collection.size() != 1) {
                    mismatchDescription.appendText("object is a collection of size ").appendValue((Object)collection.size());
                    return false;
                }
                item = collection.iterator().next();
            }
            if (!(result = this.baseMatcher.matches(item))) {
                this.baseMatcher.describeMismatch(item, mismatchDescription);
            }
            return result;
        }
    }

    public static class NumericEqualityMatcher
    extends TypeSafeDiagnosingMatcher<Number> {
        private BigDecimal expected;

        public NumericEqualityMatcher(Number expected) {
            this.expected = NumericEqualityMatcher.toBigDecimal(expected);
        }

        public void describeTo(Description desc) {
            desc.appendText("A number equal to ").appendValue((Object)this.expected);
        }

        protected boolean matchesSafely(Number item, Description mismatchDescription) {
            BigDecimal actual = NumericEqualityMatcher.toBigDecimal(item);
            mismatchDescription.appendText("was: ").appendValue((Object)item);
            return this.expected.compareTo(actual) == 0;
        }

        private static BigDecimal toBigDecimal(Number number) {
            if (number instanceof Integer) {
                return new BigDecimal((Integer)number);
            }
            if (number instanceof Short) {
                return new BigDecimal(((Short)number).shortValue());
            }
            if (number instanceof Long) {
                return new BigDecimal((Long)number);
            }
            if (number instanceof Float) {
                return new BigDecimal(((Float)number).floatValue());
            }
            if (number instanceof Double) {
                return new BigDecimal((Double)number);
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }
    }
}

